/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.p6.q2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.cw;
import com.aspose.slides.ms.System.q7;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import java.util.Arrays;

@tt
public class Queue<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] fx;
    private int jz;
    private int ny;
    private int wr;
    private int y4;
    private final Object k5;

    public Queue() {
        this.fx = new Object[0];
        this.k5 = this;
    }

    public Queue(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.fx = new Object[capacity];
        this.k5 = this;
    }

    public Queue(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        IGenericCollection iGenericCollection = collection instanceof IGenericCollection ? (IGenericCollection)collection : null;
        int n = iGenericCollection != null ? iGenericCollection.size() : 0;
        this.fx = new Object[n];
        for (Object t : collection) {
            this.enqueue(t);
        }
        this.k5 = this;
    }

    public void clear() {
        com.aspose.slides.ms.System.wr.fx(this.fx, 0, this.fx.length);
        this.wr = 0;
        this.ny = 0;
        this.jz = 0;
        ++this.y4;
    }

    public boolean contains(T item) {
        if (item == null) {
            for (Object t : this) {
                if (t != null) continue;
                return true;
            }
        } else {
            for (Object t : this) {
                if (!item.equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(wr array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException();
        }
        if (((long)arrayIndex & 0xFFFFFFFFL) > ((long)array.y4() & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.y4() - arrayIndex < this.wr) {
            throw new ArgumentException();
        }
        if (this.wr == 0) {
            return;
        }
        try {
            int n = this.fx.length;
            int n10 = n - this.jz;
            com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx), this.jz, array, arrayIndex, cw.jz(this.wr, n10));
            if (this.wr > n10) {
                com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx), 0, array, arrayIndex + n10, this.wr - n10);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    public T dequeue() {
        T t = this.peek();
        this.fx[this.jz] = null;
        if (++this.jz == this.fx.length) {
            this.jz = 0;
        }
        --this.wr;
        ++this.y4;
        return t;
    }

    public T peek() {
        if (this.wr == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.fx[this.jz];
    }

    public void enqueue(T item) {
        if (this.wr == this.fx.length || this.ny == this.fx.length) {
            this.fx(cw.fx(cw.fx(this.wr, this.ny) * 2, 4));
        }
        this.fx[this.ny] = item;
        if (++this.ny == this.fx.length) {
            this.ny = 0;
        }
        ++this.wr;
        ++this.y4;
    }

    public T[] toArray(T[] a) {
        if (a.length < this.wr) {
            return Arrays.copyOf(this.fx, this.wr, a.getClass());
        }
        System.arraycopy(this.fx, 0, a, 0, this.wr);
        if (a.length > this.wr) {
            a[this.wr] = null;
        }
        return a;
    }

    public void trimExcess() {
        if ((double)this.wr < (double)this.fx.length * 0.9) {
            this.fx(this.wr);
        }
    }

    private void fx(int n) {
        if (n == this.fx.length) {
            return;
        }
        if (n < this.wr) {
            throw new InvalidOperationException("shouldnt happen");
        }
        Object[] objectArray = new Object[n];
        if (this.wr > 0) {
            this.copyTo(com.aspose.slides.ms.System.wr.fx(objectArray), 0);
        }
        this.fx = objectArray;
        this.ny = this.wr;
        this.jz = 0;
        ++this.y4;
    }

    @Override
    public int size() {
        return this.wr;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.k5;
    }

    public Enumerator iterator() {
        return new Enumerator(this);
    }

    @tt
    public static class Enumerator<T>
    extends q2<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Queue<T> jz;
        private int ny;
        private int wr;

        public Enumerator() {
        }

        Enumerator(Queue<T> q) {
            this.jz = q;
            this.ny = -2;
            this.wr = ((Queue)q).y4;
        }

        @Override
        public void dispose() {
            this.ny = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.wr != ((Queue)this.jz).y4) {
                throw new InvalidOperationException();
            }
            if (this.ny == -2) {
                this.ny = ((Queue)this.jz).wr;
            }
            return this.ny != -1 && --this.ny != -1;
        }

        @Override
        public T next() {
            if (this.ny < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Queue)this.jz).fx[(((Queue)this.jz).wr - 1 - this.ny + ((Queue)this.jz).jz) % ((Queue)this.jz).fx.length];
        }

        @Override
        public void reset() {
            if (this.wr != ((Queue)this.jz).y4) {
                throw new InvalidOperationException();
            }
            this.ny = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.jz = this.jz;
            that.ny = this.ny;
            that.wr = this.wr;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean fx(Enumerator enumerator) {
            return q7.fx(enumerator.jz, this.jz) && enumerator.ny == this.ny && enumerator.wr == this.wr;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (q7.jz(null, obj)) {
                return false;
            }
            if (q7.jz(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.fx((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.jz != null ? this.jz.hashCode() : 0;
            n = 31 * n + this.ny;
            n = 31 * n + this.wr;
            return n;
        }
    }
}

