/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.p6.q2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.a2;
import com.aspose.slides.ms.System.fx;
import com.aspose.slides.ms.System.gt;
import com.aspose.slides.ms.System.n6;
import com.aspose.slides.ms.System.op;
import com.aspose.slides.ms.System.q7;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@tt
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] fx;
    private int jz;
    private int ny;
    private final Object wr = new Object();
    static Object[] k5 = new Object[0];

    public List() {
        this.fx = k5;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.fx = k5;
        this.fx(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.fx = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.fx = data;
        this.jz = size;
    }

    protected int getVersion() {
        return this.ny;
    }

    @Override
    public void addItem(T item) {
        if (this.jz == this.fx.length) {
            this.fx(1);
        }
        this.fx[this.jz++] = item;
        ++this.ny;
    }

    private void fx(int n) {
        int n10 = this.jz + n;
        if (n10 > this.fx.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void fx(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.jz & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void fx(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.fx(new List<T>(collection));
        ++this.ny;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.ny;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return a2.fx(this.fx, 0, this.jz, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return a2.fx(this.fx, 0, this.jz, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.fx(index, count);
        return a2.fx(this.fx, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.wr.fx(this.fx, 0, this.fx.length);
        this.jz = 0;
        ++this.ny;
    }

    public <TOutput> List<TOutput> convertAll(op<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.jz);
        for (int i = 0; i < this.jz; ++i) {
            list.fx[i] = converter.fx(this.fx[i]);
        }
        list.jz = this.jz;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.wr.fx(this.fx, 0, array, 0, this.jz);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.wr.fx(this.fx, 0, array, arrayIndex, this.jz);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.fx(index, count);
        com.aspose.slides.ms.System.wr.fx(this.fx, index, array, arrayIndex, count);
    }

    public boolean exists(gt<T> match) {
        List.fx(match);
        return this.fx(0, this.jz, match) != -1;
    }

    public T find(gt<T> match) {
        List.fx(match);
        int n = this.fx(0, this.jz, match);
        return (T)(n != -1 ? this.fx[n] : null);
    }

    static <T> void fx(gt<T> gt2) {
        if (gt2 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(gt<T> match) {
        List.fx(match);
        return this.jz(match);
    }

    private List<T> jz(gt<T> gt2) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.jz; ++i) {
            if (!gt2.invoke(this.fx[i])) continue;
            list.addItem(this.fx[i]);
        }
        return list;
    }

    public int findIndex(gt<T> match) {
        List.fx(match);
        return this.fx(0, this.jz, match);
    }

    public int findIndex(int startIndex, gt<T> match) {
        List.fx(match);
        this.jz(startIndex);
        return this.fx(startIndex, this.jz - startIndex, match);
    }

    public int findIndex(int startIndex, int count, gt<T> match) {
        List.fx(match);
        this.fx(startIndex, count);
        return this.fx(startIndex, count, match);
    }

    private int fx(int n, int n10, gt<T> gt2) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!gt2.invoke(this.fx[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(gt<T> match) {
        List.fx(match);
        int n = this.jz(0, this.jz, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(gt<T> match) {
        List.fx(match);
        return this.jz(0, this.jz, match);
    }

    public int findLastIndex(int startIndex, gt<T> match) {
        List.fx(match);
        this.jz(startIndex);
        return this.jz(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, gt<T> match) {
        List.fx(match);
        int n = startIndex - count + 1;
        this.fx(n, count);
        return this.jz(n, count, match);
    }

    private int jz(int n, int n10, gt<T> gt2) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!gt2.invoke(this.fx[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(fx<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.jz; ++i) {
            action.invoke(this.fx[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.fx(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.wr.fx(this.fx, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.wr.fx(this.fx, item, 0, this.jz);
    }

    public int indexOf(T item, int index) {
        this.jz(index);
        return com.aspose.slides.ms.System.wr.fx(this.fx, item, index, this.jz - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.jz & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.wr.fx(this.fx, item, index, count);
    }

    private void jz(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.jz) {
            com.aspose.slides.ms.System.wr.fx(this.fx, n, this.fx, n + n10, this.jz - n);
        }
        this.jz += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.wr.fx(this.fx, this.jz, -n10);
        }
    }

    private void jz(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.jz & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.jz(index);
        if (this.jz == this.fx.length) {
            this.fx(1);
        }
        this.jz(index, 1);
        this.fx[index] = item;
        ++this.ny;
    }

    void ny(int n) {
        Object[] objectArray = new Object[this.jz];
        this.copyToTArray(objectArray, 0);
        this.fx(this.jz);
        this.jz(n, objectArray.length);
        com.aspose.slides.ms.System.wr.fx(objectArray, 0, this.fx, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.jz(index);
        if (collection == this) {
            this.ny(index);
        } else {
            this.fx(index, collection);
        }
        ++this.ny;
    }

    private void fx(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.jz == 0) {
            return -1;
        }
        return a2.fx(this.fx, item, this.jz - 1, this.jz);
    }

    public int lastIndexOf(T item, int index) {
        this.jz(index);
        return a2.fx(this.fx, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return a2.fx(this.fx, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(gt<T> match) {
        List.fx(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.jz && !match.invoke(this.fx[n]); ++n) {
        }
        if (n == this.jz) {
            return 0;
        }
        ++this.ny;
        for (n10 = n + 1; n10 < this.jz; ++n10) {
            if (match.invoke(this.fx[n10])) continue;
            this.fx[n++] = this.fx[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.wr.fx(this.fx, n, n10 - n);
        }
        this.jz = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.jz & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.jz(index, -1);
        com.aspose.slides.ms.System.wr.fx(this.fx, this.jz, 1);
        ++this.ny;
    }

    public void removeRange(int index, int count) {
        this.fx(index, count);
        if (count > 0) {
            this.jz(index, -count);
            com.aspose.slides.ms.System.wr.fx(this.fx, this.jz, count);
            ++this.ny;
        }
    }

    public void reverse() {
        a2.fx(this.fx, 0, this.jz);
        ++this.ny;
    }

    public void reverse(int index, int count) {
        this.fx(index, count);
        a2.fx(this.fx, index, count);
        ++this.ny;
    }

    public void sort() {
        Arrays.sort(this.fx, 0, this.jz);
        ++this.ny;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.fx, 0, this.jz, comparer);
        ++this.ny;
    }

    @Override
    public void sort(n6<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.fx, 0, this.jz, new a2.fx<T>(comparison));
        ++this.ny;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.fx(index, count);
        Arrays.sort(this.fx, index, index + count, comparer);
        ++this.ny;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.jz) {
            return Arrays.copyOf(this.fx, this.jz, a.getClass());
        }
        System.arraycopy(this.fx, 0, a, 0, this.jz);
        if (a.length > this.jz) {
            a[this.jz] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.jz);
    }

    public boolean trueForAll(gt<T> match) {
        List.fx(match);
        for (int i = 0; i < this.jz; ++i) {
            if (match.invoke(this.fx[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.fx.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.jz & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.fx = Arrays.copyOf(this.fx, value);
    }

    @Override
    public int size() {
        return this.jz;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.jz & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.fx[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.jz(index);
        if ((long)index == (long)this.jz) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.fx[index] = value;
        ++this.ny;
    }

    public void copyTo(wr array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.wr() > 1 || array.jz(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx), 0, array, arrayIndex, this.jz);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.wr;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.jz == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.jz; ++i) {
                if (this.fx[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.jz; ++i) {
            if (!this.fx[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.jz; ++i) {
                if (this.fx[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.jz; ++i) {
            if (!this.fx[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.jz];
        System.arraycopy(this.fx, 0, objectArray, 0, this.jz);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.jz;
        this.addItem(t);
        return n != this.jz;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.jz;
        this.removeItem(o);
        return n != this.jz;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.jz; ++i) {
                if (this.fx[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.jz; ++i) {
            if (!o.equals(this.fx[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> fx;
        private int jz;

        public ListInternalized() {
            this.fx = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.fx = list;
        }

        @Override
        protected int getVersion() {
            return this.jz;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.fx(collection);
            ++this.jz;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.jz;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return a2.fx(this.fx.toArray(), 0, this.fx.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return a2.fx(this.fx.toArray(), 0, this.fx.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.fx(index, count);
            return a2.fx(this.fx.toArray(), index, count, item, comparer);
        }

        @Override
        private void fx(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.fx.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(op<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.fx.size());
            for (int i = 0; i < this.fx.size(); ++i) {
                list.fx[i] = converter.fx(this.get_Item(i));
            }
            list.jz = this.fx.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.wr.fx(this.fx.toArray(), 0, array, 0, this.fx.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.wr.fx(this.fx.toArray(), 0, array, arrayIndex, this.fx.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.fx(index, count);
            com.aspose.slides.ms.System.wr.fx(this.fx.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(gt<T> match) {
            ListInternalized.jz(match);
            return this.fx(0, this.fx.size(), match) != -1;
        }

        @Override
        private int fx(int n, int n10, gt<T> gt2) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!gt2.invoke(this.fx.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void jz(gt<T> gt2) {
            if (gt2 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(gt<T> match) {
            ListInternalized.jz(match);
            int n = this.fx(0, this.fx.size(), match);
            return n != -1 ? (T)this.fx.get(n) : null;
        }

        @Override
        public List<T> findAll(gt<T> match) {
            ListInternalized.jz(match);
            return this.ny(match);
        }

        private List<T> ny(gt<T> gt2) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!gt2.invoke(this.fx.get(i))) continue;
                list.addItem(this.fx.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(gt<T> match) {
            ListInternalized.jz(match);
            return this.fx(0, this.fx.size(), match);
        }

        @Override
        public int findIndex(int startIndex, gt<T> match) {
            ListInternalized.jz(match);
            this.fx(startIndex);
            return this.fx(startIndex, this.fx.size() - startIndex, match);
        }

        @Override
        private void fx(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.fx.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, gt<T> match) {
            ListInternalized.jz(match);
            this.fx(startIndex, count);
            return this.fx(startIndex, count, match);
        }

        @Override
        public T findLast(gt<T> match) {
            ListInternalized.jz(match);
            int n = this.jz(0, this.fx.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int jz(int n, int n10, gt<T> gt2) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!gt2.invoke(this.fx.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(gt<T> match) {
            ListInternalized.jz(match);
            return this.jz(0, this.fx.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, gt<T> match) {
            ListInternalized.jz(match);
            this.fx(startIndex);
            return this.jz(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, gt<T> match) {
            ListInternalized.jz(match);
            int n = startIndex - count + 1;
            this.fx(n, count);
            return this.jz(n, count, match);
        }

        @Override
        public void forEach(fx<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.fx.size(); ++i) {
                action.invoke(this.fx.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.fx(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.wr.fx(this.fx.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.fx.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.fx(index);
            return com.aspose.slides.ms.System.wr.fx(this.fx.toArray(), item, index, this.fx.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.fx.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.wr.fx(this.fx.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.fx.size() == 0) {
                return -1;
            }
            return a2.fx(this.fx.toArray(), item, this.fx.size() - 1, this.fx.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.fx(index);
            return a2.fx(this.fx.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return a2.fx(this.fx.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.fx.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.fx.size());
        }

        @Override
        public boolean trueForAll(gt<T> match) {
            ListInternalized.jz(match);
            for (int i = 0; i < this.fx.size(); ++i) {
                if (match.invoke(this.fx.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.fx.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.fx.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.fx.size(); ++i) {
                this.fx.add(null);
            }
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public T get_Item(int index) {
            return this.fx.get(index);
        }

        @Override
        public void copyTo(wr array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.wr() > 1 || array.jz(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx.toArray()), 0, array, arrayIndex, this.fx.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.fx.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.fx.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.fx.size(); ++i) {
                    if (this.fx.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.fx.size(); ++i) {
                if (!this.fx.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.fx.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.jz;
            return this.fx.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.jz;
            return this.fx.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.fx.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.jz;
            return this.fx.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.jz;
            return this.fx.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.jz;
            return this.fx.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.jz;
            return this.fx.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.fx.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.jz;
            return this.fx.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.jz;
            this.fx.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.jz;
            return this.fx.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.fx.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.fx.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.fx.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.fx.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.fx.add(item);
            ++this.jz;
        }

        @Override
        public void clear() {
            this.fx.clear();
            ++this.jz;
        }

        @Override
        public void insertItem(int index, T item) {
            this.fx.add(index, item);
            ++this.jz;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.fx.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.fx.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.fx.add(n++, e);
                }
            }
            ++this.jz;
        }

        @Override
        public int removeAll(gt<T> match) {
            ListInternalized.jz(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.fx.size() && !match.invoke(this.fx.get(n)); ++n) {
            }
            if (n == this.fx.size()) {
                return 0;
            }
            ++this.jz;
            for (n10 = n + 1; n10 < this.fx.size(); ++n10) {
                if (match.invoke(this.fx.get(n10))) continue;
                this.fx.set(n++, this.fx.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.fx.remove(this.fx.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.fx.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.fx.remove(index);
            ++this.jz;
        }

        @Override
        public void removeRange(int index, int count) {
            this.fx(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.fx.remove(index);
                }
                ++this.jz;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.fx(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.fx.get(n);
                this.fx.set(n, this.fx.get(i));
                this.fx.set(i, t);
            }
            ++this.jz;
        }

        @Override
        public void sort() {
            Collections.sort(this.fx, null);
            ++this.jz;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.fx, comparer);
            ++this.jz;
        }

        @Override
        public void sort(final n6<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.fx, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.fx(o12, o22);
                }
            });
            ++this.jz;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.fx(index, count);
            java.util.List<T> list = this.fx.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.fx.set(index + i, list.get(i));
            }
            ++this.jz;
        }

        @Override
        public void set_Item(int index, T value) {
            this.fx(index);
            if ((long)index == (long)this.fx.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.fx.set(index, value);
            ++this.jz;
        }

        @Override
        private void fx(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @tt
    public static class EnumeratorJava<T>
    extends q2<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> jz = new List();
        private int ny;
        private int wr;
        private T y4;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.jz = l;
            this.wr = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void fx() {
            if (this.wr != this.jz.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.ny < 0 || this.ny >= this.jz.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.wr != this.jz.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.y4 = this.jz.get_Item(this.ny++);
            return this.y4;
        }

        @Override
        public boolean hasNext() {
            if (this.wr == this.jz.getVersion()) {
                if (this.ny < 0) {
                    return false;
                }
                return this.ny < this.jz.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.fx();
            this.ny = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.jz = this.jz;
            that.ny = this.ny;
            that.wr = this.wr;
            that.y4 = this.y4;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean fx(EnumeratorJava enumeratorJava) {
            return q7.fx(enumeratorJava.jz, this.jz) && enumeratorJava.ny == this.ny && enumeratorJava.wr == this.wr && q7.fx(enumeratorJava.y4, this.y4);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (q7.jz(null, obj)) {
                return false;
            }
            if (q7.jz(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.fx((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.jz != null ? this.jz.hashCode() : 0;
            n = 31 * n + this.ny;
            n = 31 * n + this.wr;
            n = 31 * n + (this.y4 != null ? this.y4.hashCode() : 0);
            return n;
        }
    }

    @tt
    public static class Enumerator<T>
    extends q2<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> jz = new List();
        private int ny;
        private int wr;
        private T y4;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.jz = l;
            this.wr = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void fx() {
            if (this.wr != this.jz.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.wr == this.jz.getVersion()) {
                if (this.ny < 0) {
                    return false;
                }
                if (this.ny < this.jz.size()) {
                    this.y4 = this.jz.get_Item(this.ny++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.ny = this.jz.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.fx();
            this.ny = 0;
        }

        @Override
        public T next() {
            if (this.ny < 0 || this.ny >= this.jz.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.y4;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.jz = this.jz;
            that.ny = this.ny;
            that.wr = this.wr;
            that.y4 = this.y4;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean fx(Enumerator enumerator) {
            return q7.fx(enumerator.jz, this.jz) && enumerator.ny == this.ny && enumerator.wr == this.wr && q7.fx(enumerator.y4, this.y4);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (q7.jz(null, obj)) {
                return false;
            }
            if (q7.jz(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.fx((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.jz != null ? this.jz.hashCode() : 0;
            n = 31 * n + this.ny;
            n = 31 * n + this.wr;
            n = 31 * n + (this.y4 != null ? this.y4.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.fx = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.fx != 0;
        }

        @Override
        public int nextIndex() {
            return this.fx;
        }

        @Override
        public int previousIndex() {
            return this.fx - 1;
        }

        public T previous() {
            int n = this.fx - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.fx;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.fx = n;
            this.jz = n;
            return objectArray[this.jz];
        }

        public void set(T e) {
            if (this.jz < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.jz, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.fx;
                List.this.add(n, e);
                this.fx = n + 1;
                this.jz = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int fx;
        int jz = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.fx != List.this.jz;
        }

        @Override
        public T next() {
            int n = this.fx;
            if (n >= List.this.jz) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.fx;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.fx = n + 1;
            this.jz = n;
            return (T)objectArray[this.jz];
        }

        @Override
        public void remove() {
            if (this.jz < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.jz);
                this.fx = this.jz;
                this.jz = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

