/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import com.aspose.slides.ms.System.wt;

@tt
public final class BitArray
implements ICollection,
wt {
    private int[] fx;
    private int jz;
    private int ny = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.jz = bits.jz;
        this.fx = new int[(this.jz + 31) / 32];
        if (this.fx.length == 1) {
            this.fx[0] = bits.fx[0];
        } else {
            wr.fx(bits.fx, 0, this.fx, 0, this.fx.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.jz = values.length;
        this.fx = new int[(this.jz + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.jz = bytes.length * 8;
        this.fx = new int[(this.jz + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.fx(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.jz = n * 32;
        this.fx = new int[n];
        wr.fx(values, 0, this.fx, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.jz = length;
        this.fx = new int[(this.jz + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.fx.length; ++i) {
                this.fx[i] = -1;
            }
        }
    }

    private byte fx(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.fx[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void fx(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.fx[n12] = this.fx[n12] & ~(255 << n11);
        int n13 = n10;
        this.fx[n13] = this.fx[n13] | (by2 & 0xFF) << n11;
        ++this.ny;
    }

    private void jz(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.jz != this.jz) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.jz;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.jz;
    }

    public void setLength(int value) {
        if (this.jz == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.jz) {
            int n = (value + 31) / 32;
            int n10 = (this.jz + 31) / 32;
            if (n > this.fx.length) {
                int[] nArray = new int[n];
                wr.fx(this.fx, 0, nArray, 0, this.fx.length);
                this.fx = nArray;
            } else {
                wr.fx(wr.fx((Object)this.fx), n10, n - n10);
            }
            int n11 = this.jz % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.fx[n12] = this.fx[n12] & (1 << n11) - 1;
            }
        }
        this.jz = value;
        ++this.ny;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(wr array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.wr() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.y4() && this.jz > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = wr.fx(array);
        if (object instanceof Boolean[]) {
            if (array.y4() - index < this.jz) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.jz; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.y4() - index < this.jz) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.jz; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.jz + 7) / 8;
            if (array.y4() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.fx(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.jz + 7) / 8;
            if (array.y4() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.fx(i);
            }
        } else if (object instanceof Integer[]) {
            wr.fx(wr.fx((Object)this.fx), 0, array, index, (this.jz + 31) / 32);
        } else if (object instanceof int[]) {
            wr.fx(wr.fx((Object)this.fx), 0, array, index, (this.jz + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.jz + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.fx[i] = ~this.fx[i];
        }
        ++this.ny;
        return this;
    }

    public BitArray and(BitArray value) {
        this.jz(value);
        int n = (this.jz + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.fx[n10] = this.fx[n10] & value.fx[i];
        }
        ++this.ny;
        return this;
    }

    public BitArray or(BitArray value) {
        this.jz(value);
        int n = (this.jz + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.fx[n10] = this.fx[n10] | value.fx[i];
        }
        ++this.ny;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.jz(value);
        int n = (this.jz + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.fx[n10] = this.fx[n10] ^ value.fx[i];
        }
        ++this.ny;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.jz) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.fx[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.jz) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.fx[n] = this.fx[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.fx[n] = this.fx[n] & ~(1 << (index & 0x1F));
        }
        ++this.ny;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.fx.length; ++i) {
                this.fx[i] = -1;
            }
        } else {
            wr.fx(wr.fx((Object)this.fx), 0, this.fx.length);
        }
        ++this.ny;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @tt
    private static class BitArrayEnumerator
    implements IEnumerator,
    wt,
    Cloneable {
        private BitArray fx;
        private boolean jz;
        private int ny;
        private int wr;

        @Override
        public Object deepClone() {
            return this.fx();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.ny = -1;
            this.fx = ba2;
            this.wr = ba2.ny;
        }

        @Override
        public Object next() {
            if (this.ny == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.ny >= this.fx.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.jz;
        }

        @Override
        public boolean hasNext() {
            this.jz();
            if (this.ny < this.fx.size() - 1) {
                this.jz = this.fx.get_Item(++this.ny);
                return true;
            }
            this.ny = this.fx.size();
            return false;
        }

        @Override
        public void reset() {
            this.jz();
            this.ny = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void jz() {
            if (this.wr != this.fx.ny) {
                throw new InvalidOperationException();
            }
        }

        protected Object fx() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.fx = this.fx;
            bitArrayEnumerator.jz = this.jz;
            bitArrayEnumerator.ny = this.ny;
            bitArrayEnumerator.wr = this.wr;
            return bitArrayEnumerator;
        }
    }
}

