/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.a2;
import com.aspose.slides.ms.System.a7;
import com.aspose.slides.ms.System.tt;
import com.aspose.slides.ms.System.wr;
import com.aspose.slides.ms.System.wt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@tt
public class ArrayList
implements IList,
List {
    private Object[] fx;
    private int jz;
    private int ny;
    private static Object[] wr = new Object[0];

    protected int getVersion() {
        return this.ny;
    }

    public ArrayList() {
        this.fx = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.fx = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.fx("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.fx = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.fx = null;
    }

    private ArrayList(wr array, int index, int count) {
        this.fx = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.wr.fx(array, index, com.aspose.slides.ms.System.wr.fx(this.fx), 0, count);
        this.jz = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.jz) {
            ArrayList.fx("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.fx[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.jz) {
            ArrayList.fx("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.fx[index] = value;
        ++this.ny;
    }

    @Override
    public int size() {
        return this.jz;
    }

    public int getCapacity() {
        return this.fx.length;
    }

    public void setCapacity(int value) {
        if (value < this.jz) {
            ArrayList.fx("Capacity", (Object)value, "Must be more than count.");
        }
        this.fx = value > 0 ? Arrays.copyOf(this.fx, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void fx(int n) {
        int n10;
        if (n <= this.fx.length) {
            return;
        }
        int n11 = n10 = this.fx.length == 0 ? 4 : this.fx.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void fx(int n, int n10) {
        if (n10 > 0) {
            if (this.jz + n10 > this.fx.length) {
                int n11;
                int n12 = n11 = this.fx.length > 0 ? this.fx.length << 1 : 1;
                while (n11 < this.jz + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.wr.fx(this.fx, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.wr.fx(this.fx, n, objectArray, n + n10, this.jz - n);
                this.fx = objectArray;
            } else {
                com.aspose.slides.ms.System.wr.fx(this.fx, n, this.fx, n + n10, this.jz - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.wr.fx(this.fx, n13, this.fx, n, this.jz - n13);
            com.aspose.slides.ms.System.wr.fx(this.fx, this.jz + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.fx.length <= this.jz) {
            this.fx(this.jz + 1);
        }
        this.fx[this.jz] = value;
        ++this.ny;
        return this.jz++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.wr.fx(this.fx, 0, this.jz);
        this.jz = 0;
        ++this.ny;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.jz) > -1;
    }

    boolean fx(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.jz - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.jz) {
            ArrayList.fx("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.fx("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.jz - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.wr.fx(this.fx, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.jz - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return a2.fx(this.fx, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.jz) {
            ArrayList.fx("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.fx(index, 1);
        this.fx[index] = value;
        ++this.jz;
        ++this.ny;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.jz) {
            ArrayList.fx("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.fx.length < this.jz + n) {
                this.fx(this.jz + n);
            }
            if (index < this.jz) {
                com.aspose.slides.ms.System.wr.fx(this.fx, index, this.fx, index + n, this.jz - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.wr.fx(this.fx, 0, this.fx, index, index);
                com.aspose.slides.ms.System.wr.fx(this.fx, index + n, this.fx, index << 1, this.jz - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.wr.fx(this.fx), index);
            }
            this.jz += c.size();
            ++this.ny;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.jz) {
            ArrayList.fx("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.fx.length < this.jz + n) {
                this.fx(this.jz + n);
            }
            if (index < this.jz) {
                com.aspose.slides.ms.System.wr.fx(this.fx, index, this.fx, index + n, this.jz - index);
            }
            com.aspose.slides.ms.System.wr.fx(c).copyTo(com.aspose.slides.ms.System.wr.fx(this.fx), index);
            this.jz += c.length;
            ++this.ny;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.ny;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.jz) {
            ArrayList.fx("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.fx(index, -1);
        --this.jz;
        ++this.ny;
    }

    public void removeRange(int index, int count) {
        ArrayList.fx(index, count, this.jz);
        this.fx(index, -count);
        this.jz -= count;
        ++this.ny;
    }

    public void reverse() {
        a2.fx(this.fx, 0, this.jz);
        ++this.ny;
    }

    public void reverse(int index, int count) {
        ArrayList.fx(index, count, this.jz);
        a2.fx(this.fx, index, count);
        ++this.ny;
    }

    public void copyTo(wr array) {
        com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx), 0, array, 0, this.jz);
    }

    @Override
    public void copyTo(wr array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.jz);
    }

    public void copyTo(int index, wr array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.wr() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.fx(index, count, this.jz);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.jz, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.jz, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return a2.fx(this.fx, 0, this.jz, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return a2.fx(this.fx, 0, this.jz, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return a2.fx(this.fx, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.fx(index, count, this.jz);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.jz) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.wr.fx(this.fx), index);
        ++this.ny;
    }

    public void trimToSize() {
        this.setCapacity(this.jz);
    }

    public void sort() {
        Arrays.sort(this.fx, 0, this.jz, Comparer.Default);
        ++this.ny;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.fx, 0, this.jz, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.fx(index, count, this.jz);
        Arrays.sort(this.fx, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.jz];
        this.copyTo(com.aspose.slides.ms.System.wr.fx(objectArray));
        return objectArray;
    }

    public wr toArray(a7 type) {
        wr wr2 = com.aspose.slides.ms.System.wr.fx(type, this.jz);
        this.copyTo(wr2);
        return wr2;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.wr.fx(this.fx), 0, this.jz);
    }

    static void fx(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.fx("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.fx("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void fx(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.wr.fx(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.jz, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List fx;
        private int jz;

        @Override
        protected int getVersion() {
            return this.fx instanceof ArrayList ? ((ArrayList)this.fx).getVersion() : this.jz;
        }

        public ArrayListInternalized(List internal) {
            this.fx = internal;
            if (internal instanceof ArrayList) {
                this.jz = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.fx.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.fx.set(index, value);
            ++this.jz;
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.fx.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.fx.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.fx.size(); ++i) {
                this.fx.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.fx.size();
            this.fx.add(value);
            ++this.jz;
            return n;
        }

        @Override
        public void clear() {
            this.fx.clear();
            ++this.jz;
        }

        @Override
        public boolean contains(Object item) {
            return this.fx.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.fx.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.fx.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.fx.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.fx.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.wr.fx(this.fx.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.fx.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return a2.fx(this.fx.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.fx.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.fx.add(index, value);
            ++this.jz;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.fx.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.fx.add(index++, e);
            }
            ++this.jz;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.fx.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.fx.add(index++, object);
            }
            ++this.jz;
        }

        @Override
        public void removeItem(Object obj) {
            this.fx.remove(obj);
            ++this.jz;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.fx.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.fx.remove(index);
            ++this.jz;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.fx.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.fx.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.fx.remove(index);
            }
            ++this.jz;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.fx.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.fx.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.fx.size() - 1; n < i; ++n, --i) {
                Object e = this.fx.get(n);
                this.fx.set(n, this.fx.get(i));
                this.fx.set(i, e);
            }
            ++this.jz;
        }

        @Override
        public void copyTo(wr array) {
            com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx.toArray()), 0, array, 0, this.fx.size());
        }

        @Override
        public void copyTo(wr array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.fx.size());
        }

        @Override
        public void copyTo(int index, wr array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.wr() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.wr.fx(com.aspose.slides.ms.System.wr.fx(this.fx.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.fx(index, count, this.fx.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.fx.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return a2.fx(this.fx.toArray(), 0, this.fx.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return a2.fx(this.fx.toArray(), 0, this.fx.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return a2.fx(this.fx.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.fx(index, count, this.fx.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.fx.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.fx.set(index++, e);
            }
            ++this.jz;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.fx, null);
            ++this.jz;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.fx, comparer);
            ++this.jz;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.fx.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.fx.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.fx.set(i, list.get(i - index));
            }
            ++this.jz;
        }

        @Override
        public Object[] toArray() {
            return this.fx.toArray();
        }

        @Override
        public wr toArray(a7 type) {
            wr wr2 = com.aspose.slides.ms.System.wr.fx(type, this.fx.size());
            this.copyTo(wr2);
            return wr2;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.fx.size()];
            com.aspose.slides.ms.System.wr.fx(this.fx.toArray(), 0, objectArray, 0, this.fx.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            arrayList.addAll(arrayList);
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.fx.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.fx.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.jz;
            return this.fx.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.jz;
            return this.fx.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.fx.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.jz;
            return this.fx.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.jz;
            return this.fx.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.jz;
            return this.fx.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.jz;
            return this.fx.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.fx.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.jz;
            return this.fx.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.fx.add(index, element);
            ++this.jz;
        }

        @Override
        public Object remove(int index) {
            ++this.jz;
            return this.fx.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.fx.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.fx.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.fx.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.fx = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.fx != 0;
        }

        @Override
        public int nextIndex() {
            return this.fx;
        }

        @Override
        public int previousIndex() {
            return this.fx - 1;
        }

        public Object previous() {
            int n = this.fx - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.fx;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.fx = n;
            this.jz = n;
            return objectArray[this.jz];
        }

        public void set(Object e) {
            if (this.jz < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).fx[this.jz] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.fx;
                ArrayList.this.add(n, e);
                this.fx = n + 1;
                this.jz = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int fx;
        int jz = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.fx != ArrayList.this.size();
        }

        public Object next() {
            int n = this.fx;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.fx;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.fx = n + 1;
            this.jz = n;
            return objectArray[this.jz];
        }

        @Override
        public void remove() {
            if (this.jz < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.jz);
                this.fx = this.jz;
                this.jz = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @tt
    private static class ListWrapper
    implements IList {
        protected IList fx;

        public ListWrapper(IList innerList) {
            this.fx = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.fx.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.fx.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.fx.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.fx.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.fx.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.fx.addItem(value);
        }

        @Override
        public void clear() {
            this.fx.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.fx.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.fx.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.fx.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.fx.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.fx.removeAt(index);
        }

        @Override
        public void copyTo(wr array, int index) {
            this.fx.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.fx.iterator();
        }
    }

    @tt
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String fx() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.fx.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.fx());
        }
    }

    @tt
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String fx() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.fx());
        }
    }

    @tt
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object jz;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.jz = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.jz;
            synchronized (object) {
                this.fx.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(wr array, int index) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.iterator();
            }
        }
    }

    @tt
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int jz;
        private int ny;
        private int wr;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.jz = index;
            this.ny = count;
            this.wr = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.ny) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.fx.get_Item(this.jz + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.ny) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.fx.set_Item(this.jz + index, value);
        }

        @Override
        public int size() {
            this.fx();
            return this.ny;
        }

        @Override
        public int getCapacity() {
            return this.fx.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.ny) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void fx() {
            if (this.wr != this.fx.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.fx();
            this.fx.insertItem(this.jz + this.ny, value);
            this.wr = this.fx.getVersion();
            return ++this.ny;
        }

        @Override
        public void clear() {
            this.fx();
            this.fx.removeRange(this.jz, this.ny);
            this.ny = 0;
            this.wr = this.fx.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.fx.fx(value, this.jz, this.ny);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.ny - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.ny) {
                RangedArrayList.fx("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.fx("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.ny - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.fx.indexOf(value, this.jz + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.jz;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.ny - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.fx("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.fx("count", (Object)count, "count is negative.");
            }
            if ((n = this.fx.lastIndexOf(value, this.jz + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.jz;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.fx();
            if (index < 0 || index > this.ny) {
                RangedArrayList.fx("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.fx.insertItem(this.jz + index, value);
            ++this.ny;
            this.wr = this.fx.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.fx();
            if (index < 0 || index > this.ny) {
                RangedArrayList.fx("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.fx.insertRange(this.jz + index, c);
            this.ny += c.size();
            this.wr = this.fx.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.fx();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.wr = this.fx.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.fx();
            if (index < 0 || index > this.ny) {
                RangedArrayList.fx("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.fx.removeAt(this.jz + index);
            --this.ny;
            this.wr = this.fx.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.fx();
            RangedArrayList.fx(index, count, this.ny);
            this.fx.removeRange(this.jz + index, count);
            this.ny -= count;
            this.wr = this.fx.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.ny);
        }

        @Override
        public void reverse(int index, int count) {
            this.fx();
            RangedArrayList.fx(index, count, this.ny);
            this.fx.reverse(this.jz + index, count);
            this.wr = this.fx.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.fx();
            if (index < 0 || index > this.ny) {
                RangedArrayList.fx("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.fx.setRange(this.jz + index, c);
            this.wr = this.fx.getVersion();
        }

        @Override
        public void copyTo(wr array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(wr array, int index) {
            this.copyTo(0, array, index, this.ny);
        }

        @Override
        public void copyTo(int index, wr array, int arrayIndex, int count) {
            RangedArrayList.fx(index, count, this.ny);
            this.fx.copyTo(this.jz + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.ny);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.fx(index, count, this.ny);
            return this.fx.iterator(this.jz + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.fx();
            this.fx.insertRange(this.ny, c);
            this.ny += c.size();
            this.wr = this.fx.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.ny, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.ny, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.fx(index, count, this.ny);
            return this.fx.binarySearch(this.jz + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.fx.deepClone(), this.jz, this.ny);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.fx(index, count, this.ny);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.ny, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.fx();
            RangedArrayList.fx(index, count, this.ny);
            this.fx.sort(this.jz + index, count, comparer);
            this.wr = this.fx.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.ny];
            this.fx.copyTo(this.jz, com.aspose.slides.ms.System.wr.fx(objectArray), 0, this.ny);
            return objectArray;
        }

        @Override
        public wr toArray(a7 elementType) {
            wr wr2 = com.aspose.slides.ms.System.wr.fx(elementType, this.ny);
            this.fx.copyTo(this.jz, wr2, 0, this.ny);
            return wr2;
        }
    }

    @tt
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String fx() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.fx.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.fx());
        }
    }

    @tt
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String fx() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.fx());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.fx());
        }
    }

    @tt
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object jz;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.jz = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.jz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.jz;
            synchronized (object) {
                this.fx.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.jz;
            synchronized (object) {
                this.fx.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(wr array) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(wr array, int index) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, wr array, int arrayIndex, int count) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.jz;
            synchronized (object) {
                this.fx.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.jz;
            synchronized (object) {
                this.fx.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.jz;
            synchronized (object) {
                this.fx.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public wr toArray(a7 elementType) {
            Object object = this.jz;
            synchronized (object) {
                return this.fx.toArray(elementType);
            }
        }
    }

    @tt
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList fx;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.fx = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.fx.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.fx.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public int getCapacity() {
            return this.fx.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.fx.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.fx.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.fx.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.fx.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.fx.addItem(value);
        }

        @Override
        public void clear() {
            this.fx.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.fx.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.fx.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.fx.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.fx.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.fx.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.fx.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.fx.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.fx.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.fx.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.fx.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.fx.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.fx.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.fx.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.fx.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.fx.setRange(index, c);
        }

        @Override
        public void copyTo(wr array) {
            this.fx.copyTo(array);
        }

        @Override
        public void copyTo(wr array, int index) {
            this.fx.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, wr array, int arrayIndex, int count) {
            this.fx.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.fx.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.fx.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.fx.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.fx.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.fx.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.fx.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.fx.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.fx.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.fx.trimToSize();
        }

        @Override
        public void sort() {
            this.fx.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.fx.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.fx.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.fx.toArray();
        }

        @Override
        public wr toArray(a7 elementType) {
            return this.fx.toArray(elementType);
        }
    }

    @tt
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList fx;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.fx = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.fx.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.fx.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.fx.size();
        }

        @Override
        public int getCapacity() {
            return this.fx.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.fx.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.fx.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.fx.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.fx.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.fx.addItem(value);
        }

        @Override
        public void clear() {
            this.fx.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.fx.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.fx.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.fx.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.fx.size()) {
                ArrayListAdapter.fx("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.fx("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.fx.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.fx.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.fx.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.fx.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.fx("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.fx("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.fx("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.fx.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.fx.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.fx.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.fx.size()) {
                ArrayListAdapter.fx("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.fx.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.fx.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.fx.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.fx(index, count, this.fx.size());
            for (int i = 0; i < count; ++i) {
                this.fx.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.fx.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.fx(index, count, this.fx.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.fx.get_Item(i + index);
                this.fx.set_Item(i + index, this.fx.get_Item(index + count - i + index - 1));
                this.fx.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.fx.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.fx.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(wr array) {
            this.fx.copyTo(array, 0);
        }

        @Override
        public void copyTo(wr array, int index) {
            this.fx.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, wr array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.fx("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.fx("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.fx("index", (Object)index, "Can't be less than zero.");
            }
            if (array.wr() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.y4() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.fx.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.ny(this.fx.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.fx.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.fx.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.fx(index, count, this.fx.size());
            return new EnumeratorWithRange(this.fx.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.fx.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.fx.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.fx(index, count, this.fx.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.fx.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.fx);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.fx(index, count, this.fx.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.fx.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.fx(index, count, this.fx.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.fx(this.fx, index, index + count - 1, comparer);
        }

        private static void fx(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void fx(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.fx(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.fx(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.fx(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.fx(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.fx(iList, n12, n13);
            }
            ArrayListAdapter.fx(iList, n10 - 1, n12);
            ArrayListAdapter.fx(iList, n, n12 - 1, comparator);
            ArrayListAdapter.fx(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.fx.size()];
            this.fx.copyTo(com.aspose.slides.ms.System.wr.fx(objectArray), 0);
            return objectArray;
        }

        @Override
        public wr toArray(a7 elementType) {
            wr wr2 = com.aspose.slides.ms.System.wr.fx(elementType, this.fx.size());
            this.fx.copyTo(wr2, 0);
            return wr2;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        wt,
        Cloneable {
            private int fx;
            private int jz;
            private int ny;
            private IEnumerator wr;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.jz = 0;
                this.fx = index;
                this.ny = count;
                this.wr = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.fx();
            }

            @Override
            public Object next() {
                return this.wr.next();
            }

            @Override
            public boolean hasNext() {
                if (this.jz >= this.ny) {
                    return false;
                }
                ++this.jz;
                return this.wr.hasNext();
            }

            @Override
            public void reset() {
                this.jz = 0;
                this.wr.reset();
                for (int i = 0; i < this.fx; ++i) {
                    this.wr.hasNext();
                }
            }

            protected Object fx() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.fx = this.fx;
                enumeratorWithRange.jz = this.jz;
                enumeratorWithRange.ny = this.ny;
                enumeratorWithRange.wr = this.wr;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    wt,
    Cloneable {
        private ArrayList jz;
        private Object ny;
        private int wr;
        private int y4;
        static Object fx = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.jz = list;
            this.wr = -1;
            this.y4 = list.getVersion();
            this.ny = fx;
        }

        @Override
        public Object deepClone() {
            return this.fx();
        }

        @Override
        public boolean hasNext() {
            if (this.y4 != this.jz.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.wr < this.jz.size()) {
                this.ny = this.jz.get_Item(this.wr);
                return true;
            }
            this.ny = fx;
            return false;
        }

        @Override
        public Object next() {
            if (this.ny == fx) {
                if (this.wr == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.ny;
        }

        @Override
        public void reset() {
            if (this.y4 != this.jz.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.ny = fx;
            this.wr = -1;
        }

        protected Object fx() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.jz = this.jz;
            simpleEnumerator.ny = this.ny;
            simpleEnumerator.wr = this.wr;
            simpleEnumerator.y4 = this.y4;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    wt,
    Cloneable {
        private Object fx;
        private ArrayList jz;
        private int ny;
        private int wr;
        private int y4;
        private int k5;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.fx();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.jz = list;
            this.wr = index;
            this.y4 = count;
            this.ny = this.wr - 1;
            this.fx = null;
            this.k5 = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.ny == this.wr - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.fx;
        }

        @Override
        public boolean hasNext() {
            if (this.jz.getVersion() != this.k5) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.ny;
            if (this.ny - this.wr < this.y4) {
                this.fx = this.jz.get_Item(this.ny);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.fx = null;
            this.ny = this.wr - 1;
        }

        protected Object fx() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.fx = this.fx;
            arrayListEnumerator.jz = this.jz;
            arrayListEnumerator.ny = this.ny;
            arrayListEnumerator.wr = this.wr;
            arrayListEnumerator.y4 = this.y4;
            arrayListEnumerator.k5 = this.k5;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

