/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.Border;
import com.aspose.pdf.Color;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LineEndingConverter;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.ms.System.Collections.Generic.z2;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z172;
import com.aspose.pdf.internal.ms.System.z61;
import com.aspose.pdf.internal.ms.System.z72;
import com.aspose.pdf.internal.ms.System.z85;
import com.aspose.pdf.internal.p24.z5;
import com.aspose.pdf.internal.p681.z400;
import com.aspose.pdf.internal.p681.z585;
import com.aspose.pdf.internal.p76.z14;
import com.aspose.pdf.internal.p76.z16;
import com.aspose.pdf.internal.p76.z23;
import com.aspose.pdf.internal.p76.z28;
import com.aspose.pdf.internal.p76.z30;
import com.aspose.pdf.z167;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PolyAnnotation
extends MarkupAnnotation {
    private static final Logger m5 = Logger.getLogger(PolyAnnotation.class.getName());

    PolyAnnotation(z14 annotation, IDocument document) {
        super(annotation, document);
    }

    protected PolyAnnotation(IDocument document, Point[] vertices) {
        super(document);
        this.setVertices(vertices);
    }

    protected PolyAnnotation(Page page, Rectangle rect, Point[] vertices) {
        super(page, rect);
        this.setVertices(vertices);
    }

    @Override
    protected void m2(z585 z5852) {
        super.m2(z5852);
        if (this.getEngineDict().m4("AP") && !this.getEngineDict().m4("BS")) {
            this.getBorder().m2(z5852);
        }
        if (this.getEngineDict().m4("BS")) {
            this.getBorder().m1(z5852);
        }
        if (this.getEngineDict().m4("IC")) {
            z5852.m3("interior-color", this.getInteriorColor().toString());
        }
        if (this.getEngineDict().m4("LE")) {
            z5852.m3("head", LineEndingConverter.toString(this.getStartingStyle()));
            z5852.m3("tail", LineEndingConverter.toString(this.getEndingStyle()));
        }
        if (this.getEngineDict().m4("IT")) {
            z5852.m3("intent", z167.m2(this.getIntent()));
        }
    }

    @Override
    protected void m3(z585 z5852) {
        StringBuilder stringBuilder;
        if (this.getEngineDict().m4("Vertices")) {
            z5852.m16("vertices");
            stringBuilder = new StringBuilder();
            for (Point point : this.getVertices()) {
                stringBuilder.append(z133.m1(this.m2, "{0},{1};", point.getX(), point.getY()));
            }
        } else {
            throw new IllegalStateException("Required entry is absent in annotation dictionary");
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        z5852.m5(stringBuilder.toString());
        z5852.m10();
        super.m3(z5852);
    }

    @Override
    protected void m2(z400 z4002) {
        super.m2(z4002);
        this.setBorder(new Border(this));
        this.getBorder().m1(z4002);
        if (z4002.m4("interior-color")) {
            this.setInteriorColor(Color.parse(z4002.m1("interior-color")));
        }
        if (z4002.m4("head")) {
            this.setStartingStyle(LineEndingConverter.toEnum(z4002.m1("head")));
        }
        if (z4002.m4("tail")) {
            this.setEndingStyle(LineEndingConverter.toEnum(z4002.m1("tail")));
        }
        if (z4002.m4("intent")) {
            this.setIntent(z167.m1(z4002.m1("intent")));
        }
    }

    @Override
    protected void m1(z2<String, String> z2100) {
        Point[] pointArray;
        if (z2100.containsKey("vertices")) {
            String[] stringArray = z133.m6(z2100.get_Item("vertices"), ';');
            int n = stringArray.length;
            pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = z133.m6(stringArray[i], ',');
                double d = z61.m1(stringArray2[0], (z85)this.m2);
                double d2 = z61.m1(stringArray2[1], (z85)this.m2);
                pointArray[i] = new Point(d, d2);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setVertices(pointArray);
        super.m1(z2100);
    }

    @Override
    void m1(z400 z4002) {
        this.m2(z4002);
        this.m1(XfdfReader.m1(z4002));
    }

    public Point[] getVertices() {
        try {
            com.aspose.pdf.internal.p76.z5 z5100 = this.getEngineDict().m3("Vertices").m65();
            int n = z5100.m10() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(z5100.m1(2 * i).m70().m8(), z5100.m1(2 * i + 1).m70().m8());
            }
            return pointArray;
        }
        catch (z72 z7210) {
            m5.log(Level.INFO, "Exception occur", z7210);
            return null;
        }
    }

    public void setVertices(Point[] value) {
        if (value != null) {
            z23 z2310 = new z23(this.getEngineDict());
            for (Point point : value) {
                z2310.m1((z16)new z30(point.getX()));
                z2310.m1((z16)new z30(point.getY()));
            }
            this.getEngineDict().m1("Vertices", (z16)z2310);
        }
    }

    public Color getInteriorColor() {
        if (this.getEngineDict().m4("IC")) {
            com.aspose.pdf.internal.p76.z5 z5100 = this.getEngineDict().m3("IC").m65();
            double[] dArray = new double[z5100.m10()];
            for (int i = 0; i < z5100.m10(); ++i) {
                dArray[i] = z5100.m1(i).m70().m8();
            }
            return new Color(dArray);
        }
        return null;
    }

    public void setInteriorColor(Color value) {
        z23 z2310 = new z23(this.getEngineDict());
        for (double d : value.getData()) {
            z2310.m1((z16)new z30(d));
        }
        this.getEngineDict().m1("IC", (z16)z2310);
    }

    public int getStartingStyle() {
        try {
            com.aspose.pdf.internal.p76.z5 z5100 = this.getEngineDict().m3("LE").m65();
            return LineEndingConverter.toEnum(z5100.m1(0).m63().toString());
        }
        catch (z72 z7210) {
            m5.log(Level.INFO, "Exception occur", z7210);
            return 0;
        }
    }

    public void setStartingStyle(int value) {
        com.aspose.pdf.internal.p76.z5 z5100 = null;
        if (this.getEngineDict().m4("LE") && (z5100 = this.getEngineDict().m3("LE").m65()).m10() != 2) {
            z5100 = null;
        }
        if (z5100 == null) {
            z5100 = new z23(this.getEngineDict());
            z5100.m1((z16)new z28("None"));
            z5100.m1((z16)new z28("None"));
            this.getEngineDict().m1("LE", (z16)z5100);
        }
        z5100.m2(0);
        z5100.m1((z16)new z28(LineEndingConverter.toString(value)), 0);
    }

    public int getEndingStyle() {
        try {
            com.aspose.pdf.internal.p76.z5 z5100 = this.getEngineDict().m3("LE").m65();
            return LineEndingConverter.toEnum(z5100.m1(1).m63().toString());
        }
        catch (z72 z7210) {
            m5.log(Level.INFO, "Exception occur", z7210);
            return 0;
        }
    }

    public void setEndingStyle(int value) {
        com.aspose.pdf.internal.p76.z5 z5100 = null;
        if (this.getEngineDict().m4("LE") && (z5100 = this.getEngineDict().m3("LE").m65()).m10() != 2) {
            z5100 = null;
        }
        if (z5100 == null) {
            z5100 = new z23(this.getEngineDict());
            z5100.m1((z16)new z28("None"));
            z5100.m1((z16)new z28("None"));
            this.getEngineDict().m1("LE", (z16)z5100);
        }
        z5100.m2(1);
        z5100.m1((z16)new z28(LineEndingConverter.toString(value)), 1);
    }

    public int getIntent() {
        return z167.m1(z5.m2(this.getEngineDict(), "IT"));
    }

    public void setIntent(int value) {
        if (value != 0) {
            this.getEngineDict().m1("IT", (z16)new z28(z167.m1(value)));
        }
    }

    @Override
    boolean m5() {
        return this.m4;
    }

    com.aspose.pdf.internal.ms.System.Collections.Generic.z16<Operator> m3(Annotation.z1 z1100, Annotation annotation) {
        com.aspose.pdf.internal.ms.System.Collections.Generic.z16<Operator> z1610 = new com.aspose.pdf.internal.ms.System.Collections.Generic.z16<Operator>();
        z1610.addItem(new Operator.GSave());
        z1610.addItem(new Operator.SetRGBColor(this.getColor().toRgb()));
        z1610.addItem(new Operator.SetRGBColorStroke(this.getColor().toRgb()));
        int n = 0;
        for (Point point : this.getVertices()) {
            if (n == 0) {
                z1610.addItem(new Operator.MoveTo(point.getX(), point.getY()));
            } else {
                z1610.addItem(new Operator.LineTo(point.getX(), point.getY()));
            }
            ++n;
        }
        z1610.addItem(new Operator.ClosePathStroke());
        z1610.addItem(new Operator.GRestore());
        return z1610;
    }

    @Override
    XForm m1(String string, Annotation annotation) {
        XForm xForm = super.m1(string, annotation);
        Rectangle rectangle = null;
        for (Point point : this.getVertices()) {
            if (rectangle == null) {
                rectangle = new Rectangle(point.getX(), point.getY(), point.getX(), point.getY());
                continue;
            }
            double d = z172.m4(rectangle.getLLX(), point.getX());
            double d2 = z172.m4(rectangle.getLLY(), point.getY());
            double d3 = z172.m3(rectangle.getURX(), point.getX());
            double d4 = z172.m3(rectangle.getURY(), point.getY());
            rectangle.setLLX(d);
            rectangle.setLLY(d2);
            rectangle.setURX(d3);
            rectangle.setURY(d4);
        }
        xForm.setBBox(rectangle);
        this.setRect(rectangle);
        xForm.setMatrix(new Matrix(1.0, 0.0, 0.0, 1.0, -rectangle.getLLX(), -rectangle.getLLY()));
        return xForm;
    }

    @Override
    /* synthetic */ List m2(Annotation.z1 z1100, Annotation annotation) {
        return this.m3(z1100, annotation);
    }

    static {
        m5.setUseParentHandlers(false);
    }
}

