/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler;

import com.arellomobile.mvp.compiler.ClassGeneratingParams;
import com.arellomobile.mvp.compiler.ClassGenerator;
import com.arellomobile.mvp.compiler.MvpCompiler;
import com.arellomobile.mvp.compiler.Util;
import com.arellomobile.mvp.viewstate.strategy.AddToEndStrategy;
import com.arellomobile.mvp.viewstate.strategy.StateStrategyType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

final class ViewStateClassGenerator
extends ClassGenerator<TypeElement> {
    public static final String STATE_STRATEGY_TYPE_ANNOTATION = StateStrategyType.class.getName();
    public static final String DEFAULT_STATE_STRATEGY = AddToEndStrategy.class.getName() + ".class";
    private static final String DEFAULT_STATE_STRATEGY_OPTION = "defaultStateStrategy";
    private String mViewClassName;
    private Set<String> mStrategyClasses = new HashSet<String>();

    @Override
    public boolean generate(TypeElement typeElement, List<ClassGeneratingParams> classGeneratingParamsList) {
        String generic = Util.getClassGenerics(typeElement);
        String interfaceGeneric = "";
        if (!typeElement.getTypeParameters().isEmpty()) {
            interfaceGeneric = "<" + ViewStateClassGenerator.join(",", typeElement.getTypeParameters()) + ">";
        }
        String fullClassName = Util.getFullClassName(typeElement);
        ClassGeneratingParams classGeneratingParams = new ClassGeneratingParams();
        classGeneratingParams.setName(fullClassName + "$$State");
        this.mViewClassName = this.getClassName(typeElement) + interfaceGeneric;
        String builder = "package " + fullClassName.substring(0, fullClassName.lastIndexOf(".")) + ";\n" + "\n" + "import java.util.Set;\n" + "\n" + "import com.arellomobile.mvp.viewstate.MvpViewState;\n" + "import com.arellomobile.mvp.viewstate.ViewCommand;\n" + "import com.arellomobile.mvp.viewstate.ViewCommands;\n" + "import com.arellomobile.mvp.viewstate.strategy.AddToEndSingleStrategy;\n" + "import com.arellomobile.mvp.viewstate.strategy.AddToEndStrategy;\n" + "import com.arellomobile.mvp.viewstate.strategy.StateStrategy;\n" + "\n" + "public class " + fullClassName.substring(fullClassName.lastIndexOf(".") + 1) + "$$State" + generic + " extends MvpViewState<" + this.mViewClassName + "> implements " + this.mViewClassName + " {\n" + "\n";
        ArrayList<Method> methods = new ArrayList<Method>();
        String stateStrategyType = this.getStateStrategyType(typeElement);
        HashMap<String, String> types = new HashMap<String, String>();
        if (!typeElement.getTypeParameters().isEmpty()) {
            for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                types.put(typeParameterElement.toString(), typeParameterElement.toString());
            }
        }
        this.getMethods(types, typeElement, stateStrategyType, new ArrayList<Method>(), methods);
        methods.addAll(this.iterateInterfaces(0, typeElement, stateStrategyType, new HashMap<String, String>(), methods, new ArrayList<Method>()));
        HashMap<String, Integer> methodsCounter = new HashMap<String, Integer>();
        for (Method method : methods) {
            Integer counter = (Integer)methodsCounter.get(method.name);
            if (counter == null || counter == 0) {
                counter = 0;
                method.uniqueName = method.name;
            } else {
                method.uniqueName = method.name + counter;
            }
            method.commandClassName = method.uniqueName.substring(0, 1).toUpperCase() + method.uniqueName.substring(1) + "Command";
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            methodsCounter.put(method.name, counter);
        }
        for (Method method : methods) {
            String throwTypesString = ViewStateClassGenerator.join(", ", method.thrownTypes);
            if (throwTypesString.length() > 0) {
                throwTypesString = " throws " + throwTypesString;
            }
            String fieldName = "params";
            String argumentsString = "";
            ArrayList<String> argumentNames = new ArrayList<String>();
            int index = 0;
            for (Argument argument : method.arguments) {
                if (argument.name.equals(fieldName)) {
                    fieldName = "params" + index;
                }
                if (argumentsString.length() > 0) {
                    argumentsString = argumentsString + ", ";
                }
                argumentsString = argumentsString + argument.name;
                argumentNames.add(argument.name);
                ++index;
            }
            String commandFieldName = ViewStateClassGenerator.decapitalizeString(method.commandClassName);
            String commandClassName = method.commandClassName;
            String commandWrapperNewInstance = "new " + method.commandClassName + "(" + argumentsString + ");\n";
            Random random = new Random();
            while (argumentNames.contains(commandFieldName)) {
                commandFieldName = commandFieldName + random.nextInt(10);
            }
            builder = builder + "\t@Override\n\tpublic " + method.genericType + " void " + method.name + "(" + ViewStateClassGenerator.join(", ", method.arguments) + ")" + throwTypesString + " {\n" + "\t\t" + commandClassName + " " + commandFieldName + " = " + commandWrapperNewInstance + "\t\tmViewCommands.beforeApply(" + commandFieldName + ");\n" + "\n" + "\t\tif (mViews == null || mViews.isEmpty()) {\n" + "\t\t\treturn;\n" + "\t\t}\n" + "\n" + "\t\tfor(" + this.mViewClassName + " view : mViews) {\n" + "\t\t\tview." + method.name + "(" + argumentsString + ");\n" + "\t\t}\n" + "\n" + "\t\tmViewCommands.afterApply(" + commandFieldName + ");\n" + "\t}\n" + "\n";
        }
        if (!methods.isEmpty()) {
            builder = this.generateLocalViewCommand(this.mViewClassName, builder, methods);
        }
        builder = builder + "}\n";
        classGeneratingParams.setBody(builder);
        classGeneratingParamsList.add(classGeneratingParams);
        return true;
    }

    private List<Method> iterateInterfaces(int level, TypeElement parentElement, String parentDefaultStrategy, Map<String, String> parentTypes, List<Method> rootMethods, List<Method> superinterfacesMethods) {
        for (TypeMirror typeMirror : parentElement.getInterfaces()) {
            int i;
            TypeElement anInterface = (TypeElement)((DeclaredType)typeMirror).asElement();
            List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            List<? extends TypeParameterElement> typeParameters = anInterface.getTypeParameters();
            if (typeArguments.size() > typeParameters.size()) {
                throw new IllegalArgumentException("Code generation for interface " + anInterface.getSimpleName() + " failed. Simplify your generics.");
            }
            HashMap<String, String> types = new HashMap<String, String>();
            for (int i2 = 0; i2 < typeArguments.size(); ++i2) {
                types.put(typeParameters.get(i2).toString(), typeArguments.get(i2).toString());
            }
            HashMap<String, String> totalInterfaceTypes = new HashMap<String, String>(typeParameters.size());
            for (i = 0; i < typeArguments.size(); ++i) {
                totalInterfaceTypes.put(typeParameters.get(i).toString(), Util.fillGenerics(parentTypes, typeArguments.get(i)));
            }
            for (i = typeArguments.size(); i < typeParameters.size(); ++i) {
                if (typeParameters.get(i).getBounds().size() != 1) {
                    throw new IllegalArgumentException("Code generation for interface " + anInterface.getSimpleName() + " failed. Simplify your generics.");
                }
                totalInterfaceTypes.put(typeParameters.get(i).toString(), typeParameters.get(i).getBounds().get(0).toString());
            }
            String defaultStrategy = parentDefaultStrategy != null ? parentDefaultStrategy : this.getStateStrategyType(anInterface);
            this.getMethods(totalInterfaceTypes, anInterface, defaultStrategy, rootMethods, superinterfacesMethods);
            this.iterateInterfaces(level + 1, anInterface, defaultStrategy, types, rootMethods, superinterfacesMethods);
        }
        return superinterfacesMethods;
    }

    private List<Method> getMethods(Map<String, String> types, TypeElement typeElement, String defaultStrategy, List<Method> rootMethods, List<Method> superinterfacesMethods) {
        for (Element element : typeElement.getEnclosedElements()) {
            Object upperBound;
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement methodElement = (ExecutableElement)element;
            if (!methodElement.getReturnType().toString().equals("void")) {
                MvpCompiler.getMessager().printMessage(Diagnostic.Kind.ERROR, "You are trying generate ViewState for " + typeElement.getSimpleName() + ". But " + typeElement.getSimpleName() + " contains non-void method \"" + methodElement.getSimpleName() + "\" that return type is " + methodElement.getReturnType() + ". See more here: https://github.com/Arello-Mobile/Moxy/issues/2");
            }
            String strategyClass = defaultStrategy != null ? defaultStrategy : this.getDefaultStateStrategy();
            String methodTag = "\"" + methodElement.getSimpleName() + "\"";
            for (AnnotationMirror annotationMirror : methodElement.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().toString().equals(STATE_STRATEGY_TYPE_ANNOTATION)) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                Set<? extends ExecutableElement> keySet = elementValues.keySet();
                Iterator<? extends ExecutableElement> iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    ExecutableElement executableElement = iterator.next();
                    String key = executableElement.getSimpleName().toString();
                    if ("value".equals(key)) {
                        strategyClass = elementValues.get(executableElement).toString();
                        continue;
                    }
                    if (!"tag".equals(key)) continue;
                    methodTag = elementValues.get(executableElement).toString();
                }
            }
            HashMap<String, String> methodTypes = new HashMap<String, String>(types);
            ExecutableType executableType = (ExecutableType)methodElement.asType();
            List<? extends TypeVariable> typeVariables = executableType.getTypeVariables();
            if (!typeVariables.isEmpty()) {
                for (TypeVariable typeVariable : typeVariables) {
                    methodTypes.put(typeVariable.asElement().toString(), typeVariable.asElement().toString());
                }
            }
            String generics = "";
            if (!typeVariables.isEmpty()) {
                generics = generics + "<";
                for (TypeVariable typeVariable2 : typeVariables) {
                    if (generics.length() > 1) {
                        generics = generics + ", ";
                    }
                    if ((upperBound = typeVariable2.getUpperBound()).toString().equals(Object.class.getCanonicalName())) {
                        generics = generics + typeVariable2.asElement();
                        continue;
                    }
                    String filledGeneric = Util.fillGenerics(methodTypes, (TypeMirror)upperBound);
                    if (filledGeneric.startsWith("?")) {
                        generics = generics + filledGeneric.replaceFirst("\\?", typeVariable2.asElement().toString());
                        continue;
                    }
                    generics = generics + typeVariable2.asElement() + " extends " + filledGeneric;
                }
                generics = generics + "> ";
            }
            List<? extends VariableElement> list = methodElement.getParameters();
            ArrayList<Argument> arguments = new ArrayList<Argument>();
            upperBound = list.iterator();
            while (upperBound.hasNext()) {
                VariableElement parameter = upperBound.next();
                arguments.add(new Argument(Util.fillGenerics(methodTypes, parameter.asType()), parameter.toString(), parameter.getAnnotationMirrors()));
            }
            ArrayList<String> throwTypes = new ArrayList<String>();
            for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
                throwTypes.add(Util.fillGenerics(methodTypes, typeMirror));
            }
            this.mStrategyClasses.add(strategyClass);
            Method method = new Method(generics, methodElement.getSimpleName().toString(), arguments, throwTypes, strategyClass, methodTag, this.getClassName(typeElement));
            if (rootMethods.contains(method)) continue;
            if (superinterfacesMethods.contains(method)) {
                Method method2 = superinterfacesMethods.get(superinterfacesMethods.indexOf(method));
                if (!method2.stateStrategy.equals(method.stateStrategy)) {
                    throw new IllegalStateException("Both " + method2.enclosedClass + " and " + method.enclosedClass + " has method " + method.name + "(" + method.arguments.toString().substring(1, method.arguments.toString().length() - 1) + ") with difference strategies. Override this method in " + this.mViewClassName + " or make strategies equals");
                }
                if (method2.tag.equals(method.tag)) continue;
                throw new IllegalStateException("Both " + method2.enclosedClass + " and " + method.enclosedClass + " has method " + method.name + "(" + method.arguments.toString().substring(1, method.arguments.toString().length() - 1) + ") with difference tags. Override this method in " + this.mViewClassName + " or make tags equals");
            }
            superinterfacesMethods.add(method);
        }
        return superinterfacesMethods;
    }

    private String getClassName(TypeElement typeElement) {
        return typeElement.getQualifiedName().toString();
    }

    private String generateLocalViewCommand(String viewClassName, String builder, List<Method> methods) {
        for (Method method : methods) {
            String argumentsString = "";
            for (Argument argument : method.arguments) {
                if (argumentsString.length() > 0) {
                    argumentsString = argumentsString + ", ";
                }
                argumentsString = argumentsString + argument.name;
            }
            String argumentsInit = "";
            String argumentsBind = "";
            for (Argument argument : method.arguments) {
                argumentsInit = argumentsInit + "\t\tpublic final " + argument.type + " " + argument.name + ";\n";
                argumentsBind = argumentsBind + "\t\t\tthis." + argument.name + " = " + argument.name + ";\n";
            }
            if (!argumentsInit.isEmpty()) {
                argumentsInit = argumentsInit + "\n";
            }
            builder = builder + "\n\tpublic class " + method.commandClassName + method.genericType + " extends ViewCommand<" + viewClassName + "> {\n" + argumentsInit + "\t\t" + method.commandClassName + "(" + ViewStateClassGenerator.join(", ", method.arguments) + ") {\n" + "\t\t\tsuper(" + method.tag + ", " + method.stateStrategy + ");\n" + argumentsBind + "\t\t}\n" + "\n" + "\t\t@Override\n" + "\t\tpublic void apply(" + viewClassName + " mvpView) {\n" + "\t\t\tmvpView." + method.name + "(" + argumentsString + ");\n" + "\t\t}\n" + "\t}\n";
        }
        return builder;
    }

    private String getDefaultStateStrategy() {
        return DEFAULT_STATE_STRATEGY;
    }

    public String getStateStrategyType(TypeElement typeElement) {
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().toString().equals(STATE_STRATEGY_TYPE_ANNOTATION)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            Set<? extends ExecutableElement> keySet = elementValues.keySet();
            for (ExecutableElement executableElement : keySet) {
                if (!"value".equals(executableElement.getSimpleName().toString())) continue;
                return elementValues.get(executableElement).toString();
            }
        }
        return null;
    }

    public static String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String decapitalizeString(String string) {
        return string == null || string.isEmpty() ? "" : (string.length() == 1 ? string.toLowerCase() : Character.toLowerCase(string.charAt(0)) + string.substring(1));
    }

    public Set<String> getStrategyClasses() {
        return this.mStrategyClasses;
    }

    private static class Argument {
        String type;
        String name;
        List<? extends AnnotationMirror> annotations;

        public Argument(String type, String name, List<? extends AnnotationMirror> annotations) {
            this.type = type;
            this.name = name;
            this.annotations = annotations;
        }

        public String toString() {
            return ViewStateClassGenerator.join(" ", this.annotations) + " " + this.type + " " + this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Argument argument = (Argument)o;
            return !(this.type == null ? argument.type != null : !this.type.equals(argument.type));
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }
    }

    private static class Method {
        String genericType;
        String name;
        String uniqueName;
        String commandClassName;
        List<Argument> arguments;
        List<String> thrownTypes;
        String stateStrategy;
        String tag;
        String enclosedClass;

        Method(String genericType, String name, List<Argument> arguments, List<String> thrownTypes, String stateStrategy, String methodTag, String enclosedClass) {
            this.genericType = genericType;
            this.name = name;
            this.arguments = arguments;
            this.thrownTypes = thrownTypes;
            this.stateStrategy = stateStrategy;
            this.tag = methodTag;
            this.enclosedClass = enclosedClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Method method = (Method)o;
            if (this.name != null ? !this.name.equals(method.name) : method.name != null) {
                return false;
            }
            return !(this.arguments == null ? method.arguments != null : !this.arguments.equals(method.arguments));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Method { " + this.genericType + " void " + this.name + '(' + this.arguments + ") throws " + this.thrownTypes + '}';
        }
    }
}

