/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler;

import com.arellomobile.mvp.compiler.MvpCompiler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

final class Util {
    Util() {
    }

    public static String fillGenerics(Map<String, String> types, TypeMirror param) {
        return Util.fillGenerics(types, Collections.singletonList(param));
    }

    public static String fillGenerics(Map<String, String> types, List<? extends TypeMirror> params) {
        return Util.fillGenerics(types, params, ", ");
    }

    public static String fillGenerics(Map<String, String> types, List<? extends TypeMirror> params, String separator) {
        String result = "";
        for (TypeMirror typeMirror : params) {
            if (result.length() > 0) {
                result = result + separator;
            }
            if (typeMirror instanceof WildcardType) {
                TypeMirror superBound;
                result = result + "?";
                TypeMirror extendsBound = ((WildcardType)typeMirror).getExtendsBound();
                if (extendsBound != null) {
                    result = result + " extends " + Util.fillGenerics(types, extendsBound);
                }
                if ((superBound = ((WildcardType)typeMirror).getSuperBound()) == null) continue;
                result = result + " super " + Util.fillGenerics(types, superBound);
                continue;
            }
            if (typeMirror instanceof IntersectionType) {
                result = result + "?";
                List<? extends TypeMirror> bounds = ((IntersectionType)typeMirror).getBounds();
                if (bounds.isEmpty()) continue;
                result = result + " extends " + Util.fillGenerics(types, bounds, " & ");
                continue;
            }
            if (typeMirror instanceof DeclaredType) {
                result = result + ((DeclaredType)typeMirror).asElement();
                List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
                if (typeArguments.isEmpty()) continue;
                String s = Util.fillGenerics(types, typeArguments);
                result = result + "<" + s + ">";
                continue;
            }
            if (typeMirror instanceof TypeVariable) {
                String type = types.get(typeMirror.toString());
                if (type == null) {
                    type = typeMirror.toString();
                }
                result = result + type;
                continue;
            }
            result = result + typeMirror;
        }
        return result;
    }

    public static String getFullClassName(TypeMirror typeMirror) {
        if (!(typeMirror instanceof DeclaredType)) {
            return "";
        }
        TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
        return Util.getFullClassName(typeElement);
    }

    public static String getFullClassName(TypeElement typeElement) {
        String packageName = MvpCompiler.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        String className = typeElement.toString().substring(packageName.length());
        return packageName + className.replaceAll("\\.", "\\$");
    }

    public static String getClassGenerics(TypeElement typeElement) {
        String generic = "";
        if (!typeElement.getTypeParameters().isEmpty()) {
            generic = "<";
            boolean isFirstType = true;
            for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                if (!isFirstType) {
                    generic = generic + ", ";
                }
                isFirstType = false;
                generic = generic + typeParameterElement;
                List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
                if (bounds.isEmpty() || bounds.size() == 1 && bounds.get(0).toString().equals(Object.class.getCanonicalName())) continue;
                generic = generic + " extends " + Util.join((CharSequence)" & ", bounds);
            }
            generic = generic + ">";
        }
        return generic;
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }
}

