/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler;

import com.arellomobile.mvp.GenerateViewState;
import com.arellomobile.mvp.InjectViewState;
import com.arellomobile.mvp.RegisterMoxyReflectorPackages;
import com.arellomobile.mvp.compiler.AnnotationRule;
import com.arellomobile.mvp.compiler.ClassGeneratingParams;
import com.arellomobile.mvp.compiler.ClassGenerator;
import com.arellomobile.mvp.compiler.MoxyReflectorGenerator;
import com.arellomobile.mvp.compiler.PresenterBinderClassGenerator;
import com.arellomobile.mvp.compiler.PresenterInjectorRules;
import com.arellomobile.mvp.compiler.ViewStateClassGenerator;
import com.arellomobile.mvp.compiler.ViewStateProviderClassGenerator;
import com.arellomobile.mvp.presenter.InjectPresenter;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@AutoService(value=Processor.class)
public class MvpCompiler
extends AbstractProcessor {
    private static Messager sMessager;
    private static Types sTypeUtils;
    private static Elements sElementUtils;
    private static Map<String, String> sOptions;

    public static Messager getMessager() {
        return sMessager;
    }

    public static Types getTypeUtils() {
        return sTypeUtils;
    }

    public static Elements getElementUtils() {
        return sElementUtils;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        sMessager = processingEnv.getMessager();
        sTypeUtils = processingEnv.getTypeUtils();
        sElementUtils = processingEnv.getElementUtils();
        sOptions = processingEnv.getOptions();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        Collections.addAll(supportedAnnotationTypes, InjectPresenter.class.getCanonicalName(), InjectViewState.class.getCanonicalName(), RegisterMoxyReflectorPackages.class.getCanonicalName(), GenerateViewState.class.getCanonicalName());
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return false;
        }
        try {
            return this.throwableProcess(roundEnv);
        }
        catch (RuntimeException e) {
            MvpCompiler.getMessager().printMessage(Diagnostic.Kind.OTHER, "Moxy compilation failed. Could you copy stack trace above and write us (or make issue on Githhub)?");
            e.printStackTrace();
            MvpCompiler.getMessager().printMessage(Diagnostic.Kind.ERROR, "Moxy compilation failed; see the compiler error output for details (" + e + ")");
            return true;
        }
    }

    private boolean throwableProcess(RoundEnvironment roundEnv) {
        this.checkInjectors(roundEnv, InjectPresenter.class, new PresenterInjectorRules(ElementKind.FIELD, Modifier.PUBLIC, Modifier.DEFAULT));
        ViewStateProviderClassGenerator viewStateProviderClassGenerator = new ViewStateProviderClassGenerator();
        PresenterBinderClassGenerator presenterBinderClassGenerator = new PresenterBinderClassGenerator();
        this.processInjectors(roundEnv, InjectViewState.class, ElementKind.CLASS, viewStateProviderClassGenerator);
        this.processInjectors(roundEnv, InjectPresenter.class, ElementKind.FIELD, presenterBinderClassGenerator);
        ViewStateClassGenerator viewStateClassGenerator = new ViewStateClassGenerator();
        Set<TypeElement> usedViews = viewStateProviderClassGenerator.getUsedViews();
        for (TypeElement usedView : usedViews) {
            this.generateCode(ElementKind.INTERFACE, viewStateClassGenerator, usedView);
        }
        String moxyReflectorPackage = sOptions.get("moxyReflectorPackage");
        if (moxyReflectorPackage == null) {
            moxyReflectorPackage = "com.arellomobile.mvp";
        }
        List<String> additionalMoxyReflectorPackages = this.getAdditionalMoxyReflectorPackages(roundEnv);
        String moxyReflector = MoxyReflectorGenerator.generate(moxyReflectorPackage, viewStateProviderClassGenerator.getPresenterClassNames(), presenterBinderClassGenerator.getPresentersContainers(), viewStateClassGenerator.getStrategyClasses(), additionalMoxyReflectorPackages);
        ClassGeneratingParams classGeneratingParams = new ClassGeneratingParams();
        classGeneratingParams.setName(moxyReflectorPackage + ".MoxyReflector");
        classGeneratingParams.setBody(moxyReflector);
        this.createSourceFile(classGeneratingParams);
        return true;
    }

    private List<String> getAdditionalMoxyReflectorPackages(RoundEnvironment roundEnv) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : roundEnv.getElementsAnnotatedWith(RegisterMoxyReflectorPackages.class)) {
            if (element.getKind() != ElementKind.CLASS) {
                MvpCompiler.getMessager().printMessage(Diagnostic.Kind.ERROR, element + " must be " + ElementKind.CLASS.name() + ", or not mark it as @" + RegisterMoxyReflectorPackages.class.getSimpleName());
            }
            String[] packages = element.getAnnotation(RegisterMoxyReflectorPackages.class).value();
            Collections.addAll(result, packages);
        }
        return result;
    }

    private void checkInjectors(RoundEnvironment roundEnv, Class<? extends Annotation> clazz, AnnotationRule annotationRule) {
        for (Element element : roundEnv.getElementsAnnotatedWith(clazz)) {
            annotationRule.checkAnnotation(element);
        }
        String errorStack = annotationRule.getErrorStack();
        if (errorStack != null && errorStack.length() > 0) {
            MvpCompiler.getMessager().printMessage(Diagnostic.Kind.ERROR, errorStack);
        }
    }

    private void processInjectors(RoundEnvironment roundEnv, Class<? extends Annotation> clazz, ElementKind kind, ClassGenerator classGenerator) {
        for (Element element : roundEnv.getElementsAnnotatedWith(clazz)) {
            if (element.getKind() != kind) {
                MvpCompiler.getMessager().printMessage(Diagnostic.Kind.ERROR, element + " must be " + kind.name() + ", or not mark it as @" + clazz.getSimpleName());
            }
            this.generateCode(kind, classGenerator, element);
        }
    }

    private void generateCode(ElementKind kind, ClassGenerator classGenerator, Element element) {
        ArrayList<ClassGeneratingParams> classGeneratingParamsList;
        boolean generated;
        if (element.getKind() != kind) {
            MvpCompiler.getMessager().printMessage(Diagnostic.Kind.ERROR, element + " must be " + kind.name());
        }
        if (!(generated = classGenerator.generate(element, classGeneratingParamsList = new ArrayList<ClassGeneratingParams>()))) {
            return;
        }
        for (ClassGeneratingParams classGeneratingParams : classGeneratingParamsList) {
            this.createSourceFile(classGeneratingParams);
        }
    }

    private void createSourceFile(ClassGeneratingParams classGeneratingParams) {
        try {
            JavaFileObject f = this.processingEnv.getFiler().createSourceFile(classGeneratingParams.getName(), new Element[0]);
            Writer w = f.openWriter();
            w.write(classGeneratingParams.getBody());
            w.flush();
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

