/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerProperties;
import java.security.MessageDigest;
import java.util.Formatter;
import java.util.Map;

public class HashUtils {
    public static String toSHA1(String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
            messageDigest.update(string.getBytes("UTF-8"));
            string2 = HashUtils.AFDateFormat(messageDigest.digest());
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning " + string.substring(0, 6) + ".. to SHA1", exception);
        }
        return string2;
    }

    public static String toMD5(String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(string.getBytes("UTF-8"));
            string2 = HashUtils.AFDateFormat(messageDigest.digest());
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning " + string.substring(0, 6) + ".. to MD5", exception);
        }
        return string2;
    }

    public static String toSha256(String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes());
            string2 = HashUtils.bytesToHex(messageDigest.digest());
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning " + string.substring(0, 6) + ".. to SHA-256", exception);
        }
        return string2;
    }

    public static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray2 = byArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray2[i];
            stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
        }
        return ((Object)stringBuilder).toString();
    }

    private static String AFDateFormat(byte[] byArray) {
        Formatter formatter = new Formatter();
        Object object = byArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = object[i];
            formatter.format("%02x", by);
        }
        object = ((Object)formatter).toString();
        formatter.close();
        return object;
    }

    public static String getOneLinkAuthorization(long l2) {
        return HashUtils.toSHA1(AppsFlyerProperties.getInstance().getString("AppsFlyerKey") + l2);
    }

    public String getHashCode(Map<String, Object> map) {
        String string = (String)map.get("appsflyerKey");
        String string2 = (String)map.get("af_timestamp");
        String string3 = (String)map.get("uid");
        String string4 = string2;
        return HashUtils.toSHA1(string.substring(0, 7) + string3.substring(0, 7) + string4.substring(string4.length() - 7));
    }

    public String getHashCodeV2(Map<String, Object> map) {
        String string = (String)map.get("appsflyerKey");
        string = string + map.get("af_timestamp");
        string = string + map.get("uid");
        string = string + map.get("installDate");
        string = string + map.get("counter");
        return HashUtils.toSHA1(HashUtils.toMD5(string + map.get("iaecounter")));
    }
}

