/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1cSDK;
import com.appsflyer.internal.AFi1zSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1wSDK {
    private final boolean AFAdRevenueData;
    @NonNull
    public final String getCurrencyIso4217Code;
    @NonNull
    public final String getRevenue;
    @NonNull
    public final AFh1cSDK getMediationNetwork;
    @Nullable
    public final AFi1zSDK getMonetizationNetwork;

    public AFi1wSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.getCurrencyIso4217Code = jSONObject.getString("ver");
            this.AFAdRevenueData = jSONObject.optBoolean("test_mode");
            this.getRevenue = object;
            this.getMediationNetwork = this.getCurrencyIso4217Code.startsWith("default") ? AFh1cSDK.getMediationNetwork : AFh1cSDK.getCurrencyIso4217Code;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFi1zSDK(jSONObject);
            }
            this.getMonetizationNetwork = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1wSDK aFi1wSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1wSDK = aFi1wSDK;
        if (this.AFAdRevenueData != aFi1wSDK.AFAdRevenueData) {
            return false;
        }
        if (!this.getCurrencyIso4217Code.equals(aFi1wSDK.getCurrencyIso4217Code)) {
            return false;
        }
        return this.getRevenue.equals(aFi1wSDK.getRevenue);
    }

    public final int hashCode() {
        int n = this.AFAdRevenueData ? 1 : 0;
        n = n * 31 + this.getCurrencyIso4217Code.hashCode();
        n = n * 31 + this.getRevenue.hashCode();
        if (this.getMonetizationNetwork != null) {
            n = n * 31 + ((Object)this.getMonetizationNetwork).hashCode();
        }
        return n;
    }
}

