/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1uSDK;
import com.appsflyer.internal.AFd1sSDK;
import com.appsflyer.internal.AFg1aSDK;
import com.appsflyer.internal.AFi1hSDK;
import com.appsflyer.internal.AFi1rSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1lSDK
extends AFi1rSDK {
    public final Map<String, Object> valueOf = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFInAppEventType;

    public AFi1lSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1sSDK aFd1sSDK) {
        super("store", "google", aFd1sSDK, runnable);
        this.AFInAppEventType = executorService;
    }

    private boolean valueOf(@NonNull Context context) {
        if (!this.valueOf()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1uSDK.AFInAppEventParameterName(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFg1aSDK.registerClient, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFg1aSDK.registerClient, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1aSDK.registerClient, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFg1aSDK.registerClient, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void values(Context context) {
        if (!this.valueOf(context)) {
            return;
        }
        AFi1lSDK aFi1lSDK = this;
        this.e = System.currentTimeMillis();
        aFi1lSDK.unregisterClient = AFi1hSDK.AFa1ySDK.AFInAppEventType;
        aFi1lSDK.addObserver(new Observer(aFi1lSDK){
            private /* synthetic */ AFi1hSDK AFInAppEventParameterName;
            {
                this.AFInAppEventParameterName = aFi1hSDK;
            }

            public final void update(Observable o, Object arg) {
                this.AFInAppEventParameterName.AFKeystoreWrapper.run();
            }
        });
        try {
            aFi1lSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFg1aSDK.registerClient, "Connecting to Install Referrer Library...");
            aFi1lSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFi1lSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1lSDK.this.AFInAppEventType.execute(() -> AFi1lSDK.this.valueOf(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFg1aSDK.registerClient, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1aSDK.registerClient, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void valueOf(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.valueOf.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.AFInAppEventParameterName.put("api_ver", AFb1uSDK.values(context, string));
        this.AFInAppEventParameterName.put("api_ver_name", AFb1uSDK.AFInAppEventType(context, string));
        switch (n) {
            case 0: {
                this.AFInAppEventParameterName.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFg1aSDK.registerClient, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.valueOf.put("val", object);
                            this.AFInAppEventParameterName.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.valueOf.put("clk", Long.toString(l));
                        this.AFInAppEventParameterName.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.valueOf.put("install", Long.toString(l2));
                        this.AFInAppEventParameterName.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.valueOf.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFg1aSDK.registerClient, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.AFInAppEventParameterName.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFg1aSDK.registerClient, "ReferrerClient: InstallReferrer is not ready");
                    this.valueOf.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFg1aSDK.registerClient, "Failed to get install referrer: " + throwable.getMessage());
                    this.valueOf.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFg1aSDK.registerClient, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFg1aSDK.registerClient, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.AFInAppEventParameterName.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.AFInAppEventParameterName.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFg1aSDK.registerClient, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFg1aSDK.registerClient, "InstallReferrer DEVELOPER_ERROR");
                this.AFInAppEventParameterName.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFg1aSDK.registerClient, "InstallReferrer SERVICE_DISCONNECTED");
                this.AFInAppEventParameterName.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFg1aSDK.registerClient, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFg1aSDK.registerClient, "Install Referrer collected locally");
        this.values();
    }
}

