/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1rSDK;
import com.appsflyer.internal.AFd1vSDK;
import com.appsflyer.internal.AFh1mSDK;
import com.appsflyer.internal.AFh1qSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFh1pSDK
extends AFh1qSDK {
    public final Map<String, Object> AFInAppEventParameterName = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFInAppEventType;

    public AFh1pSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1vSDK aFd1vSDK) {
        super("store", "google", aFd1vSDK, runnable);
        this.AFInAppEventType = executorService;
    }

    private boolean AFInAppEventParameterName(@NonNull Context context) {
        if (!this.AFKeystoreWrapper()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1rSDK.AFInAppEventParameterName(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(Context context) {
        if (!this.AFInAppEventParameterName(context)) {
            return;
        }
        AFh1pSDK aFh1pSDK = this;
        this.afRDLog = System.currentTimeMillis();
        aFh1pSDK.afDebugLog = AFh1mSDK.AFa1ySDK.valueOf;
        aFh1pSDK.addObserver(new Observer(aFh1pSDK){
            private /* synthetic */ AFh1mSDK values;
            {
                this.values = aFh1mSDK;
            }

            public final void update(Observable observable, Object object) {
                this.values.valueOf.run();
            }
        });
        try {
            aFh1pSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFh1pSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFh1pSDK.this.AFInAppEventType.execute(() -> AFh1pSDK.AFInAppEventParameterName(AFh1pSDK.this, this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void AFInAppEventParameterName(AFh1pSDK aFh1pSDK, InstallReferrerClient installReferrerClient, Context context, int n) {
        aFh1pSDK.AFInAppEventParameterName.put("code", String.valueOf(n));
        String string = "com.android.vending";
        aFh1pSDK.AFKeystoreWrapper.put("api_ver", AFb1rSDK.AFKeystoreWrapper(context, string));
        aFh1pSDK.AFKeystoreWrapper.put("api_ver_name", AFb1rSDK.values(context, string));
        switch (n) {
            case 0: {
                aFh1pSDK.AFKeystoreWrapper.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFh1pSDK.AFInAppEventParameterName.put("val", object);
                            aFh1pSDK.AFKeystoreWrapper.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFh1pSDK.AFInAppEventParameterName.put("clk", Long.toString(l));
                        aFh1pSDK.AFKeystoreWrapper.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFh1pSDK.AFInAppEventParameterName.put("install", Long.toString(l2));
                        aFh1pSDK.AFKeystoreWrapper.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFh1pSDK.AFInAppEventParameterName.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            aFh1pSDK.AFKeystoreWrapper.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFh1pSDK.AFInAppEventParameterName.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFh1pSDK.AFInAppEventParameterName.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFh1pSDK.AFKeystoreWrapper.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFh1pSDK.AFKeystoreWrapper.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFh1pSDK.AFKeystoreWrapper.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFh1pSDK.AFKeystoreWrapper.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
        aFh1pSDK.AFInAppEventParameterName();
    }
}

