/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1fSDK;
import com.appsflyer.internal.AFf1jSDK;
import com.appsflyer.internal.AFf1nSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFf1lSDK
extends AFf1nSDK {
    public final Map<String, Object> AFInAppEventType = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFKeystoreWrapper;

    public AFf1lSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService) {
        super("store", "google", runnable);
        this.AFKeystoreWrapper = executorService;
    }

    private static boolean AFKeystoreWrapper(@NonNull Context context) {
        if (!AFf1lSDK.AFInAppEventType()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1fSDK.AFInAppEventType(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(Context context) {
        if (!AFf1lSDK.AFKeystoreWrapper(context)) {
            return;
        }
        AFf1lSDK aFf1lSDK = this;
        this.AFLogger = System.currentTimeMillis();
        aFf1lSDK.afDebugLog = AFf1jSDK.AFa1vSDK.AFInAppEventType;
        aFf1lSDK.addObserver(new Observer(aFf1lSDK){
            private /* synthetic */ AFf1jSDK AFInAppEventParameterName;
            {
                this.AFInAppEventParameterName = aFf1jSDK;
            }

            public final void update(Observable observable, Object object) {
                this.AFInAppEventParameterName.AFInAppEventParameterName.run();
            }
        });
        try {
            aFf1lSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFf1lSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFf1lSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFf1lSDK.this.AFKeystoreWrapper.execute(() -> AFf1lSDK.AFInAppEventParameterName(AFf1lSDK.this, this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void AFInAppEventParameterName(AFf1lSDK aFf1lSDK, InstallReferrerClient installReferrerClient, Context context, int n) {
        aFf1lSDK.AFInAppEventType.put("code", String.valueOf(n));
        String string = "com.android.vending";
        aFf1lSDK.valueOf.put("api_ver", AFa1fSDK.AFInAppEventParameterName(context, string));
        aFf1lSDK.valueOf.put("api_ver_name", AFa1fSDK.AFKeystoreWrapper(context, string));
        switch (n) {
            case 0: {
                aFf1lSDK.valueOf.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFf1lSDK.AFInAppEventType.put("val", object);
                            aFf1lSDK.valueOf.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFf1lSDK.AFInAppEventType.put("clk", Long.toString(l));
                        aFf1lSDK.valueOf.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFf1lSDK.AFInAppEventType.put("install", Long.toString(l2));
                        aFf1lSDK.valueOf.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFf1lSDK.AFInAppEventType.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            aFf1lSDK.valueOf.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFf1lSDK.AFInAppEventType.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFf1lSDK.AFInAppEventType.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFf1lSDK.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFf1lSDK.valueOf.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFf1lSDK.valueOf.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFf1lSDK.valueOf.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
        aFf1lSDK.AFKeystoreWrapper();
    }
}

