/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1aSDK;
import com.appsflyer.internal.AFb1gSDK;
import com.appsflyer.internal.AFc1pSDK;
import com.appsflyer.internal.AFc1tSDK;
import com.appsflyer.internal.AFc1uSDK;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@WorkerThread
public final class AFc1rSDK
implements AFc1tSDK {
    @NotNull
    private final AFc1uSDK AFInAppEventParameterName;

    @NotNull
    public static final List<StackTraceElement> values(@NotNull Throwable objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        StackTraceElement[] stackTraceElementArray = objectArray.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"");
        objectArray = stackTraceElementArray;
        Collection collection = new ArrayList();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement = (StackTraceElement)objectArray[i];
            String string = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            StackTraceElement stackTraceElement2 = StringsKt.startsWith$default((String)string, (String)"com.appsflyer", (boolean)false, (int)2, null) ? stackTraceElement : null;
            if (stackTraceElement2 == null) continue;
            stackTraceElement = stackTraceElement2;
            collection.add(stackTraceElement);
        }
        return (List)collection;
    }

    public AFc1rSDK() {
    }

    public static String values(String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(Charset.defaultCharset()));
            string2 = AFc1rSDK.AFInAppEventType(messageDigest.digest());
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning data to SHA-256 string", exception);
        }
        return string2;
    }

    private static String AFInAppEventType(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
        }
        return ((Object)stringBuilder).toString();
    }

    @Nullable
    public static byte[] AFKeystoreWrapper(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(Charset.defaultCharset()));
            return messageDigest.digest();
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning string to SHA-256 byte array", exception);
            return null;
        }
    }

    public static String AFInAppEventParameterName(String string, String string2) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(string2.getBytes(Charset.defaultCharset()), "HmacSHA256"));
            return AFc1rSDK.AFInAppEventType(mac.doFinal(string.getBytes(Charset.defaultCharset()))).toLowerCase(Locale.getDefault());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            GeneralSecurityException generalSecurityException2 = generalSecurityException;
            AFLogger.afErrorLog(generalSecurityException.getMessage(), generalSecurityException2, true);
            return generalSecurityException2.getMessage();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean AFInAppEventType(Map<String, Object> object, String[] object2, AFb1gSDK aFb1gSDK) throws IllegalStateException {
        void var2_3;
        Object object32;
        if (object == null || object.isEmpty()) {
            return false;
        }
        for (Object object32 : object2) {
            if (object.containsKey(object32)) continue;
            return false;
        }
        String string = (String)object.remove("sig");
        if (string == null) {
            return false;
        }
        String string2 = AFb1gSDK.valueOf();
        String string3 = new JSONObject((Map)object) + string2;
        object = var2_3;
        object32 = AFa1aSDK.valueOf(((AFb1gSDK)object).values, ((AFb1gSDK)object).valueOf);
        return AFc1rSDK.AFInAppEventParameterName(string3, (String)object32).equals(string);
    }

    public AFc1rSDK(AFc1uSDK aFc1uSDK) {
        Intrinsics.checkNotNullParameter((Object)aFc1uSDK, (String)"");
        this.AFInAppEventParameterName = aFc1uSDK;
    }

    @Override
    public final void valueOf(byte[] object, Map<String, String> object2, int n) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        int n2 = 2000;
        Map<String, String> map = object2;
        object2 = object;
        object = this;
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        if (new AFc1pSDK((byte[])object2, map, n2).valueOf()) {
            object.AFInAppEventParameterName.AFInAppEventType();
        }
    }
}

