/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal.referrer;

import android.content.Context;
import android.support.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.appsflyer.AFLogger;
import com.appsflyer.AndroidUtils;
import com.appsflyer.AppsFlyerLibCore;
import com.appsflyer.internal.referrer.Referrer;
import java.util.HashMap;
import java.util.Map;

public class GoogleReferrer
extends Referrer {
    public final Map<String, Object> oldMap = new HashMap<String, Object>();

    public GoogleReferrer(Runnable runnable) {
        super("google", runnable);
    }

    private static boolean $$a(@NonNull Context context) {
        if (AppsFlyerLibCore.getInstance().getLaunchCounter(AppsFlyerLibCore.getSharedPreferences(context), false) > 2) {
            AFLogger.afRDLog("Install referrer will not load, the counter > 2, ");
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AndroidUtils.isPermissionAvailable(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public void start(final Context context) {
        if (!GoogleReferrer.$$a(context)) {
            return;
        }
        this.start();
        try {
            final InstallReferrerClient installReferrerClient = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            installReferrerClient.startConnection(new InstallReferrerStateListener(){

                public final void onInstallReferrerSetupFinished(int n) {
                    GoogleReferrer.this.oldMap.put("code", String.valueOf(n));
                    String string = "com.android.vending";
                    GoogleReferrer.this.map.put("api_ver", AndroidUtils.getVersionCode(context, string));
                    GoogleReferrer.this.map.put("api_ver_name", AndroidUtils.getVersionName(context, string));
                    switch (n) {
                        case 0: {
                            GoogleReferrer.this.map.put("response", "OK");
                            try {
                                AFLogger.afDebugLog("InstallReferrer connected");
                                if (installReferrerClient.isReady()) {
                                    ReferrerDetails referrerDetails = installReferrerClient.getInstallReferrer();
                                    String string2 = referrerDetails.getInstallReferrer();
                                    if (string2 != null) {
                                        GoogleReferrer.this.oldMap.put("val", string2);
                                        GoogleReferrer.this.map.put("referrer", string2);
                                    }
                                    long l2 = referrerDetails.getReferrerClickTimestampSeconds();
                                    GoogleReferrer.this.oldMap.put("clk", Long.toString(l2));
                                    GoogleReferrer.this.map.put("click_ts", l2);
                                    long l3 = referrerDetails.getInstallBeginTimestampSeconds();
                                    GoogleReferrer.this.oldMap.put("install", Long.toString(l3));
                                    GoogleReferrer.this.map.put("install_begin_ts", l3);
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    try {
                                        boolean bl = referrerDetails.getGooglePlayInstantParam();
                                        GoogleReferrer.this.oldMap.put("instant", bl);
                                        hashMap.put("instant", bl);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        // empty catch block
                                    }
                                    try {
                                        hashMap.put("click_server_ts", referrerDetails.getReferrerClickTimestampServerSeconds());
                                        hashMap.put("install_begin_server_ts", referrerDetails.getInstallBeginTimestampServerSeconds());
                                        hashMap.put("install_version", referrerDetails.getInstallVersion());
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        // empty catch block
                                    }
                                    if (hashMap.isEmpty()) break;
                                    GoogleReferrer.this.map.put("google_custom", hashMap);
                                    break;
                                }
                                String string3 = "ReferrerClient: InstallReferrer is not ready";
                                AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                                GoogleReferrer.this.oldMap.put("err", "ReferrerClient: InstallReferrer is not ready");
                            }
                            catch (Throwable throwable) {
                                AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                                GoogleReferrer.this.oldMap.put("err", throwable.getMessage());
                            }
                            break;
                        }
                        case 2: {
                            AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                            GoogleReferrer.this.map.put("response", "FEATURE_NOT_SUPPORTED");
                            break;
                        }
                        case 1: {
                            GoogleReferrer.this.map.put("response", "SERVICE_UNAVAILABLE");
                            AFLogger.afWarnLog("InstallReferrer not supported");
                            break;
                        }
                        case 3: {
                            AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                            GoogleReferrer.this.map.put("response", "DEVELOPER_ERROR");
                            break;
                        }
                        case -1: {
                            AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                            GoogleReferrer.this.map.put("response", "SERVICE_DISCONNECTED");
                            break;
                        }
                        default: {
                            AFLogger.afWarnLog("responseCode not found.");
                        }
                    }
                    AFLogger.afDebugLog("Install Referrer collected locally");
                    GoogleReferrer.this.finish();
                    installReferrerClient.endConnection();
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }
}

