/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.AdvertisingIdObject;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.t;
import com.appsflyer.oaid.OaidClient;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.Map;

public class AdvertisingIdUtil {
    public static final String AMAZON_MANUFACTURER = "Amazon";
    static String \u0131;

    @Nullable
    static AdvertisingIdObject \u03b9(ContentResolver contentResolver) {
        if (contentResolver == null) {
            return null;
        }
        String string = AppsFlyerProperties.getInstance().getString("amazon_aid");
        AdvertisingIdObject advertisingIdObject = null;
        if (string == null && AMAZON_MANUFACTURER.equals(Build.MANUFACTURER)) {
            int n2 = Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking", (int)2);
            if (n2 == 0) {
                String string2 = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
                advertisingIdObject = new AdvertisingIdObject(string2, Boolean.FALSE);
            } else if (n2 == 2) {
                advertisingIdObject = null;
            } else {
                String string3 = "";
                try {
                    string3 = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Couldn't fetch Amazon Advertising ID (Ad-Tracking is limited!)", throwable);
                }
                advertisingIdObject = new AdvertisingIdObject(string3, Boolean.TRUE);
            }
        }
        return advertisingIdObject;
    }

    @Nullable
    public static AdvertisingIdObject getOaid(Context context) {
        AdvertisingIdObject advertisingIdObject;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        AppsFlyerProperties appsFlyerProperties = AppsFlyerProperties.getInstance();
        String string = null;
        Boolean bl = null;
        boolean bl2 = \u0131 != null;
        if (bl2) {
            string = \u0131;
        } else if (appsFlyerProperties.getBoolean("collectOAID", true)) {
            try {
                advertisingIdObject = new OaidClient(context);
                advertisingIdObject.setLogging(appsFlyerProperties.isEnableLog());
                OaidClient.Info info = advertisingIdObject.fetch();
                if (info != null) {
                    string = info.getId();
                    bl = info.getLat();
                }
            }
            catch (Throwable throwable) {
                AFLogger.afDebugLog("No OAID library");
            }
        }
        if (string != null) {
            advertisingIdObject = new AdvertisingIdObject(string, bl);
            advertisingIdObject.setManual(bl2);
            return advertisingIdObject;
        }
        return null;
    }

    public static AdvertisingIdObject getGaid(Context context, Map<String, Object> map) {
        int n2;
        StringBuilder stringBuilder;
        boolean bl;
        Boolean bl2;
        String string;
        block13: {
            Throwable throwable;
            AFLogger.afInfoLog("Trying to fetch GAID..");
            string = null;
            bl2 = null;
            bl = false;
            stringBuilder = new StringBuilder();
            n2 = -1;
            try {
                n2 = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                AFLogger.afErrorLog(throwable2.getMessage(), throwable);
            }
            try {
                Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                if (info != null) {
                    string = info.getId();
                    bl2 = info.isLimitAdTrackingEnabled();
                    bl = true;
                    if (string == null || string.length() == 0) {
                        stringBuilder.append("emptyOrNull |");
                    }
                    break block13;
                }
                stringBuilder.append("gpsAdInfo-null |");
                throw new IllegalStateException("GpsAdIndo is null");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                AFLogger.afErrorLog(throwable3.getMessage(), throwable);
                stringBuilder.append(throwable.getClass().getSimpleName()).append(" |");
                AFLogger.afInfoLog("WARNING: Google Play Services is missing.");
                if (!AppsFlyerProperties.getInstance().getBoolean("enableGpsFallback", true)) break block13;
                try {
                    t.a a2 = t.\u0269(context);
                    string = a2.\u01c3;
                    bl2 = a2.\u01c3();
                    if (string == null || string.length() == 0) {
                        stringBuilder.append("emptyOrNull (bypass) |");
                    }
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    AFLogger.afErrorLog(throwable4.getMessage(), throwable5);
                    stringBuilder.append(throwable5.getClass().getSimpleName()).append(" |");
                    string = AppsFlyerProperties.getInstance().getString("advertiserId");
                    bl2 = !Boolean.parseBoolean(AppsFlyerProperties.getInstance().getString("advertiserIdEnabled"));
                    if (throwable5.getLocalizedMessage() != null) {
                        AFLogger.afInfoLog(throwable5.getLocalizedMessage());
                        break block13;
                    }
                    AFLogger.afInfoLog(((Object)throwable5).toString());
                }
            }
        }
        if (context.getClass().getName().equals("android.app.ReceiverRestrictedContext")) {
            string = AppsFlyerProperties.getInstance().getString("advertiserId");
            bl2 = !Boolean.parseBoolean(AppsFlyerProperties.getInstance().getString("advertiserIdEnabled"));
            stringBuilder.append("context = android.app.ReceiverRestrictedContext |");
        }
        if (stringBuilder.length() > 0) {
            map.put("gaidError", n2 + ": " + stringBuilder);
        }
        if (string != null && bl2 != null) {
            map.put("advertiserId", string);
            map.put("advertiserIdEnabled", String.valueOf(bl2 == false));
            AppsFlyerProperties.getInstance().set("advertiserId", string);
            AppsFlyerProperties.getInstance().set("advertiserIdEnabled", String.valueOf(bl2 == false));
            map.put("isGaidWithGps", String.valueOf(bl));
        }
        return new AdvertisingIdObject(string, bl2);
    }
}

