/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.appsflyer.AFExecutor;
import com.appsflyer.AFHelper;
import com.appsflyer.AFKeystoreWrapper;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.ConversionDataListener;
import com.appsflyer.DebugLogQueue;
import com.appsflyer.OneLinkHttpTask;
import com.appsflyer.ServerConfigHandler;
import com.appsflyer.a;
import com.appsflyer.cache.CacheManager;
import com.appsflyer.cache.RequestCacheData;
import com.appsflyer.e;
import com.appsflyer.g;
import com.appsflyer.h;
import com.appsflyer.i;
import com.appsflyer.m;
import com.appsflyer.n;
import com.appsflyer.o;
import com.appsflyer.p;
import com.appsflyer.q;
import com.appsflyer.r;
import com.appsflyer.s;
import com.appsflyer.t;
import com.appsflyer.u;
import com.google.android.gms.common.GoogleApiAvailability;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppsFlyerLib
implements com.appsflyer.c {
    static final String SERVER_BUILD_NUMBER = "4.8.6".substring(0, "4.8.6".indexOf("."));
    public static final String LOG_TAG = "AppsFlyer_4.8.6";
    private String host = "appsflyer.com";
    private static final String BUILD_URL_SUFFIX = SERVER_BUILD_NUMBER + "/androidevent?buildnumber=4.8.6" + "&app_id=";
    static final String REFERRER_TRACKING_URL = "https://attr.%s/api/v" + BUILD_URL_SUFFIX;
    static final String APPS_TRACKING_URL = "https://t.%s/api/v" + BUILD_URL_SUFFIX;
    static final String EVENTS_TRACKING_URL = "https://events.%s/api/v" + BUILD_URL_SUFFIX;
    static final String REGISTER_URL = "https://register.%s/api/v" + BUILD_URL_SUFFIX;
    private long lastLaunchAttemptTimestamp = -1L;
    private long lastSuccessfulLaunchTimestamp = -1L;
    public static final String ATTRIBUTION_ID_CONTENT_URI = "content://com.facebook.katana.provider.AttributionIdProvider";
    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final List<String> IGNORABLE_KEYS = Arrays.asList("is_cache");
    private static final List<String> IGNORABLE_CHANNELS = Arrays.asList("googleplay", "playstore", "googleplaystore");
    public static final String PRE_INSTALL_SYSTEM_RO_PROP = "ro.appsflyer.preinstall.path";
    public static final String PRE_INSTALL_SYSTEM_DEFAULT = "/data/local/tmp/pre_install.appsflyer";
    public static final String PRE_INSTALL_SYSTEM_DEFAULT_ETC = "/etc/pre_install.appsflyer";
    public static final String AF_PRE_INSTALL_PATH = "AF_PRE_INSTALL_PATH";
    private long launchBlockingTimeWindow = TimeUnit.SECONDS.toMillis(5L);
    private static AppsFlyerConversionListener conversionDataListener = null;
    static AppsFlyerInAppPurchaseValidatorListener validatorListener = null;
    private com.appsflyer.b afInstallReferrer = null;
    private Map<String, String> installReferrerMap;
    private boolean isDuringCheckCache = false;
    private long lastCacheCheck;
    private ScheduledExecutorService cacheScheduler = null;
    private long timeEnteredForeground;
    private long timeWentToBackground;
    private static AppsFlyerLib instance = new AppsFlyerLib();
    private p.b listener;
    String userCustomImei;
    String userCustomAndroidId;
    private Uri latestDeepLink = null;
    private long testModeStartTime;
    private boolean isCollectLocation = false;
    private boolean isRetargetingTestMode = false;
    private String pushPayload;
    private Map<Long, String> pushPayloadHistory;
    private boolean isTokenRefreshServiceConfigured;
    private boolean didUseApplicationInit;
    private t platformExtension = new t();
    private boolean isSendBackground = false;

    void resetTimeEnteredForeground() {
        this.timeEnteredForeground = System.currentTimeMillis();
    }

    void resetTimeWentToBackground() {
        this.timeWentToBackground = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    void onReceive(Context context, Intent intent) {
        String string = intent.getStringExtra("shouldMonitor");
        if (string != null) {
            AFLogger.afInfoLog("Turning on monitoring.");
            AppsFlyerProperties.getInstance().set("shouldMonitor", string.equals("true"));
            this.monitor(context, null, "START_TRACKING", context.getPackageName());
            return;
        }
        AFLogger.afInfoLog("****** onReceive called *******");
        this.debugAction("******* onReceive: ", "", context);
        AppsFlyerProperties.getInstance().setOnReceiveCalled();
        string = intent.getStringExtra("referrer");
        AFLogger.afInfoLog("Play store referrer: " + string);
        if (string != null) {
            String string2;
            if ("AppsFlyer_Test".equals(string2 = string2.getStringExtra("TestIntegrationMode"))) {
                string2 = this.getSharedPreferences(context);
                string2 = string2.edit();
                string2.clear();
                this.editorCommit((SharedPreferences.Editor)string2);
                AppsFlyerProperties.getInstance().setFirstLaunchCalled(false);
                this.startTestMode();
            }
            this.debugAction("onReceive called. referrer: ", string, context);
            this.saveDataToSharedPreferences(context, "referrer", string);
            AppsFlyerProperties.getInstance().setReferrer(string);
            if (AppsFlyerProperties.getInstance().isFirstLaunchCalled()) {
                void var1_1;
                AFLogger.afInfoLog("onReceive: isLaunchCalled");
                this.backgroundReferrerLaunch((Context)var1_1, string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void addReferrer(Context context, String referrer) {
        AFLogger.afDebugLog("received a new (extra) referrer: " + referrer);
        try {
            void var1_1;
            JSONArray jSONArray;
            long l2 = System.currentTimeMillis();
            Object object = context.getSharedPreferences("appsflyer-data", 0);
            object = object.getString("extraReferrers", null);
            if (object == null) {
                object = new JSONObject();
                jSONArray = new JSONArray();
            } else {
                jSONArray = (object = new JSONObject((String)object)).has(referrer) ? new JSONArray((String)object.get(referrer)) : new JSONArray();
            }
            if (jSONArray.length() <= 4) {
                jSONArray.put(l2);
            }
            object.put(referrer, (Object)jSONArray.toString());
            this.saveDataToSharedPreferences((Context)var1_1, "extraReferrers", object.toString());
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
        catch (Throwable throwable) {
            void var2_2;
            AFLogger.afErrorLog("Couldn't save referrer - " + (String)var2_2 + ": ", throwable);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"CommitPrefEdits"})
    void editorCommit(SharedPreferences.Editor editor) {
        void var1_1;
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
            return;
        }
        var1_1.commit();
    }

    private void startTestMode() {
        AFLogger.afInfoLog("Test mode started..");
        this.testModeStartTime = System.currentTimeMillis();
    }

    private void endTestMode() {
        AFLogger.afInfoLog("Test mode ended!");
        this.testModeStartTime = 0L;
    }

    private boolean isInTestMode(Context context) {
        String string;
        long l2 = System.currentTimeMillis() - this.testModeStartTime;
        string = AppsFlyerProperties.getInstance().getReferrer((Context)string);
        return l2 <= 30000L && string != null && string.contains("AppsFlyer_Test");
    }

    private AppsFlyerLib() {
    }

    public static AppsFlyerLib getInstance() {
        return instance;
    }

    public String getSdkVersion() {
        u.getInstance().addApiEvent("getSdkVersion", new String[0]);
        return "version: 4.8.6 (build 355)";
    }

    /*
     * WARNING - void declaration
     */
    private void registerForAppEvents(Application application) {
        AppsFlyerProperties.getInstance().loadProperties(application.getApplicationContext());
        if (Build.VERSION.SDK_INT >= 14) {
            if (Build.VERSION.SDK_INT >= 14 && this.listener == null) {
                p.init();
                this.listener = new p.b(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void onBecameForeground(Activity currentActivity) {
                        void var1_1;
                        if (2 > AppsFlyerLib.this.getLaunchCounter(AppsFlyerLib.this.getSharedPreferences((Context)currentActivity), false)) {
                            g.getInstance((Context)currentActivity).startNewTracking();
                        }
                        com.appsflyer.a.doOnResume((Context)var1_1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void onBecameBackground(WeakReference<Activity> currentActivity) {
                        void var1_1;
                        com.appsflyer.a.doOnPause((Context)currentActivity.get());
                        g.getInstance((Context)var1_1.get()).stopStartedTracking();
                    }
                };
                p.getInstance().registerListener(application, this.listener);
                return;
            }
        } else {
            void var1_1;
            AFLogger.afInfoLog("SDK<14 call trackEvent manually");
            com.appsflyer.a.doOnResume((Context)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setGCMProjectID(String projectNumber) {
        void var1_1;
        u.getInstance().addApiEvent("setGCMProjectID", projectNumber);
        AFLogger.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please follow the documentation.");
        this.enableUninstallTracking((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setGCMProjectNumber(String projectNumber) {
        void var1_1;
        u.getInstance().addApiEvent("setGCMProjectNumber", projectNumber);
        AFLogger.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please follow the documentation.");
        this.enableUninstallTracking((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setGCMProjectNumber(Context context, String projectNumber) {
        void var2_2;
        u.getInstance().addApiEvent("setGCMProjectNumber", projectNumber);
        AFLogger.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please use 'enableUninstallTracking'.");
        this.enableUninstallTracking((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void enableUninstallTracking(String senderId) {
        void var1_1;
        u.getInstance().addApiEvent("enableUninstallTracking", senderId);
        this.setProperty("gcmProjectNumber", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void updateServerUninstallToken(Context context, String token) {
        if (token != null) {
            void var1_1;
            h h2;
            h2 = new h((String)((Object)h2));
            com.appsflyer.a.updateServerUninstallToken((Context)var1_1, h2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDebugLog(boolean shouldEnable) {
        void var1_1;
        u.getInstance().addApiEvent("setDebugLog", String.valueOf(shouldEnable));
        AppsFlyerProperties.getInstance().enableLogOutput(shouldEnable);
        AppsFlyerProperties.getInstance().setLogLevel(var1_1 != false ? AFLogger.LogLevel.DEBUG : AFLogger.LogLevel.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public void setImeiData(String aImei) {
        void var1_1;
        u.getInstance().addApiEvent("setImeiData", aImei);
        this.userCustomImei = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAndroidIdData(String aAndroidId) {
        void var1_1;
        u.getInstance().addApiEvent("setAndroidIdData", aAndroidId);
        this.userCustomAndroidId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AppsFlyerLib enableLocationCollection(boolean flag) {
        void var1_1;
        this.isCollectLocation = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void debugAction(String actionMsg, String parameter, Context context) {
        try {
            void var3_4;
            if (this.isAppsFlyerPackage((Context)var3_4)) {
                void var2_3;
                void var1_1;
                DebugLogQueue.getInstance().push((String)var1_1 + (String)var2_3);
            }
            return;
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Exception in AppsFlyerLib.debugAction(...):", exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAppsFlyerPackage(Context context) {
        void var1_1;
        return context != null && context.getPackageName().length() > 12 && "com.appsflyer".equals(var1_1.getPackageName().toLowerCase().substring(0, 13));
    }

    /*
     * WARNING - void declaration
     */
    private void saveDataToSharedPreferences(Context context, String key, String value) {
        void var3_3;
        void var2_2;
        SharedPreferences sharedPreferences;
        sharedPreferences = this.getSharedPreferences((Context)sharedPreferences);
        sharedPreferences = sharedPreferences.edit();
        sharedPreferences.putString((String)var2_2, (String)var3_3);
        this.editorCommit((SharedPreferences.Editor)sharedPreferences);
    }

    /*
     * WARNING - void declaration
     */
    private void saveIntegerToSharedPreferences(Context context, String key, int value) {
        void var3_3;
        void var2_2;
        SharedPreferences sharedPreferences;
        sharedPreferences = this.getSharedPreferences((Context)sharedPreferences);
        sharedPreferences = sharedPreferences.edit();
        sharedPreferences.putInt((String)var2_2, (int)var3_3);
        this.editorCommit((SharedPreferences.Editor)sharedPreferences);
    }

    /*
     * WARNING - void declaration
     */
    private void saveLongToSharedPreferences(Context context, String key, long value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.saveLongToSharedPreferences(this.getSharedPreferences((Context)var1_1), (String)var2_2, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void saveLongToSharedPreferences(SharedPreferences sharedPreferences, String key, long value) {
        void var3_3;
        void var2_2;
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong((String)var2_2, (long)var3_3);
        this.editorCommit(editor);
    }

    /*
     * WARNING - void declaration
     */
    private void setProperty(String key, String value) {
        void var2_2;
        void var1_1;
        AppsFlyerProperties.getInstance().set((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String getProperty(String key) {
        void var1_1;
        return AppsFlyerProperties.getInstance().getString((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setAppUserId(String id) {
        void var1_1;
        u.getInstance().addApiEvent("setAppUserId", id);
        this.setCustomerUserId((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomerUserId(String id) {
        void var1_1;
        u.getInstance().addApiEvent("setCustomerUserId", id);
        AFLogger.afInfoLog("setCustomerUserId = " + id);
        this.setProperty("AppUserId", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppInviteOneLink(String oneLinkId) {
        void var1_1;
        u.getInstance().addApiEvent("setAppInviteOneLink", oneLinkId);
        AFLogger.afInfoLog("setAppInviteOneLink = " + oneLinkId);
        if (oneLinkId == null || !oneLinkId.equals(AppsFlyerProperties.getInstance().getString("oneLinkSlug"))) {
            AppsFlyerProperties.getInstance().remove("onelinkDomain");
            AppsFlyerProperties.getInstance().remove("onelinkVersion");
            AppsFlyerProperties.getInstance().remove("onelinkScheme");
        }
        this.setProperty("oneLinkSlug", (String)var1_1);
    }

    public void setAdditionalData(HashMap<String, Object> customData) {
        if (customData != null) {
            JSONObject jSONObject;
            u.getInstance().addApiEvent("setAdditionalData", customData.toString());
            jSONObject = new JSONObject((Map)jSONObject);
            AppsFlyerProperties.getInstance().setCustomData(jSONObject.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendDeepLinkData(Activity activity) {
        void var1_1;
        if (activity != null && activity.getIntent() != null) {
            u.getInstance().addApiEvent("sendDeepLinkData", activity.getLocalClassName(), "activity_intent_" + activity.getIntent().toString());
        } else if (activity != null) {
            u.getInstance().addApiEvent("sendDeepLinkData", activity.getLocalClassName(), "activity_intent_null");
        } else {
            u.getInstance().addApiEvent("sendDeepLinkData", "activity_null");
        }
        AFLogger.afInfoLog("getDeepLinkData with activity " + activity.getIntent().getDataString());
        this.registerForAppEvents(var1_1.getApplication());
    }

    /*
     * WARNING - void declaration
     */
    public void sendPushNotificationData(Activity activity) {
        if (activity != null && activity.getIntent() != null) {
            u.getInstance().addApiEvent("sendPushNotificationData", activity.getLocalClassName(), "activity_intent_" + activity.getIntent().toString());
        } else if (activity != null) {
            u.getInstance().addApiEvent("sendPushNotificationData", activity.getLocalClassName(), "activity_intent_null");
        } else {
            u.getInstance().addApiEvent("sendPushNotificationData", "activity_null");
        }
        this.pushPayload = this.getPushPayloadFromIntent((Context)activity);
        if (this.pushPayload != null) {
            void var1_1;
            long l2;
            long l3 = l2 = System.currentTimeMillis();
            if (this.pushPayloadHistory == null) {
                AFLogger.afInfoLog("pushes: initializing pushes history..");
                this.pushPayloadHistory = new ConcurrentHashMap<Long, String>();
            } else {
                try {
                    long l4 = AppsFlyerProperties.getInstance().getLong("pushPayloadMaxAging", 1800000L);
                    for (Long l5 : this.pushPayloadHistory.keySet()) {
                        JSONObject jSONObject = new JSONObject(this.pushPayload);
                        JSONObject jSONObject2 = new JSONObject(this.pushPayloadHistory.get(l5));
                        if (jSONObject.get("pid").equals(jSONObject2.get("pid"))) {
                            AFLogger.afInfoLog("PushNotificationMeasurement: A previous payload with same PID was already acknowledged! (old: " + jSONObject2 + ", new: " + jSONObject + ")");
                            this.pushPayload = null;
                            return;
                        }
                        if (l2 - l5 > l4) {
                            this.pushPayloadHistory.remove(l5);
                        }
                        if (l5 > l3) continue;
                        l3 = l5;
                    }
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Error while handling push notification measurement: " + throwable.getClass().getSimpleName(), throwable);
                }
            }
            int n2 = AppsFlyerProperties.getInstance().getInt("pushPayloadHistorySize", 2);
            if (this.pushPayloadHistory.size() == n2) {
                AFLogger.afInfoLog("pushes: removing oldest overflowing push (oldest push:" + l3 + ")");
                this.pushPayloadHistory.remove(l3);
            }
            this.pushPayloadHistory.put(l2, this.pushPayload);
            this.registerForAppEvents(var1_1.getApplication());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setUserEmail(String email) {
        void var1_1;
        u.getInstance().addApiEvent("setUserEmail", email);
        this.setProperty("userEmail", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserEmails(String ... emails) {
        void var1_1;
        u.getInstance().addApiEvent("setUserEmails", emails);
        this.setUserEmails(AppsFlyerProperties.EmailsCryptType.NONE, (String[])var1_1);
    }

    public void setUserEmails(AppsFlyerProperties.EmailsCryptType cryptMethod, String ... emails) {
        JSONObject jSONObject;
        Cloneable cloneable = new ArrayList<String>(emails.length + 1);
        cloneable.add(cryptMethod.toString());
        cloneable.addAll(Arrays.asList(emails));
        u.getInstance().addApiEvent("setUserEmails", cloneable.toArray(new String[emails.length + 1]));
        AppsFlyerProperties.getInstance().set("userEmailsCryptType", cryptMethod.getValue());
        cloneable = new HashMap();
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block5: for (void var8_8 : jSONObject) {
            switch (cryptMethod) {
                default: {
                    string = "sha1_el_arr";
                    arrayList.add(r.toSHA1((String)var8_8));
                    continue block5;
                }
                case MD5: {
                    string = "md5_el_arr";
                    arrayList.add(r.toMD5((String)var8_8));
                    continue block5;
                }
                case SHA256: {
                    string = "sha256_el_arr";
                    arrayList.add(r.toSha256((String)var8_8));
                    continue block5;
                }
                case NONE: {
                    string = "plain_el_arr";
                    arrayList.add(var8_8);
                }
            }
        }
        cloneable.put(string, arrayList);
        jSONObject = new JSONObject((Map)((Object)cloneable));
        AppsFlyerProperties.getInstance().setUserEmails(jSONObject.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void setCollectAndroidID(boolean isCollect) {
        void var1_1;
        u.getInstance().addApiEvent("setCollectAndroidID", String.valueOf(isCollect));
        this.setProperty("collectAndroidId", Boolean.toString((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setCollectIMEI(boolean isCollect) {
        void var1_1;
        u.getInstance().addApiEvent("setCollectIMEI", String.valueOf(isCollect));
        this.setProperty("collectIMEI", Boolean.toString((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setCollectFingerPrint(boolean isCollect) {
        void var1_1;
        u.getInstance().addApiEvent("setCollectFingerPrint", String.valueOf(isCollect));
        this.setProperty("collectFingerPrint", Boolean.toString((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public AppsFlyerLib init(String key, AppsFlyerConversionListener conversionDataListener) {
        void var2_2;
        void var1_1;
        u.getInstance().addApiEvent("init", key, conversionDataListener == null ? "null" : "conversionDataListener");
        AFLogger.afLogForce(String.format("Initializing AppsFlyer SDK: (v%s.%s)", "4.8.6", "355"));
        this.didUseApplicationInit = true;
        this.setProperty("AppsFlyerKey", key);
        com.appsflyer.a.setDevKey((String)var1_1);
        AppsFlyerLib.conversionDataListener = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AppsFlyerLib init(String key, AppsFlyerConversionListener conversionDataListener, Context context) {
        void var2_2;
        void var1_1;
        if (context != null && this.allowInstallReferrer(context)) {
            AppsFlyerLib appsFlyerLib = this;
            if (this.afInstallReferrer == null) {
                void var3_3;
                this.afInstallReferrer = new com.appsflyer.b();
                this.afInstallReferrer.start((Context)var3_3, appsFlyerLib);
            } else {
                AFLogger.afWarnLog("AFInstallReferrer instance already created");
            }
        }
        return this.init((String)var1_1, (AppsFlyerConversionListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean allowInstallReferrer(@NonNull Context context) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        if (this.getLaunchCounter(sharedPreferences, false) > 2) {
            AFLogger.afRDLog("Install referrer will not load, the counter > 2, ");
            return false;
        }
        try {
            void var1_1;
            Class.forName("com.android.installreferrer.api.InstallReferrerClient");
            if (com.appsflyer.a.isPermissionAvailable((Context)var1_1, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afRDLog("Class com.android.installreferrer.api.InstallReferrerClient not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("An error occurred while trying to verify manifest : com.android.installreferrer.api.InstallReferrerClient", throwable);
            return false;
        }
        AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void startTracking(Application application) {
        void var1_1;
        if (!this.didUseApplicationInit) {
            AFLogger.afWarnLog("ERROR: AppsFlyer SDK is not initialized! The API call 'startTracking(Application)' must be called after the 'init(String, AppsFlyerConversionListener)' API method, which should be called on the Application's onCreate.");
            return;
        }
        this.startTracking((Application)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void startTracking(Application application, String key) {
        void var1_1;
        u.getInstance().addApiEvent("startTracking", key);
        AFLogger.afInfoLog(String.format("Starting AppsFlyer Tracking: (v%s.%s)", "4.8.6", "355"));
        AFLogger.afInfoLog("Build Number: 355");
        AppsFlyerProperties.getInstance().loadProperties(application.getApplicationContext());
        if (!TextUtils.isEmpty((CharSequence)key)) {
            void var2_2;
            this.setProperty("AppsFlyerKey", key);
            com.appsflyer.a.setDevKey((String)var2_2);
        } else if (TextUtils.isEmpty((CharSequence)this.getProperty("AppsFlyerKey"))) {
            AFLogger.afWarnLog("ERROR: AppsFlyer SDK is not initialized! You must provide AppsFlyer Dev-Key either in the 'init' API method (should be called on Application's onCreate),or in the startTracking API method (should be called on Activity's onCreate).");
            return;
        }
        this.registerForAppEvents((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void getReInstallData(Context context) {
        int n2 = 18;
        if (com.appsflyer.a.isOPPODevice()) {
            n2 = 23;
            AFLogger.afRDLog("OPPO device found");
        }
        if (Build.VERSION.SDK_INT < n2) {
            AFLogger.afRDLog("OS SDK is=" + Build.VERSION.SDK_INT + "; no KeyStore usage");
            return;
        }
        AFLogger.afRDLog("OS SDK is=" + Build.VERSION.SDK_INT + "; use KeyStore");
        AFKeystoreWrapper aFKeystoreWrapper = new AFKeystoreWrapper(context);
        if (!aFKeystoreWrapper.loadData()) {
            void var1_1;
            aFKeystoreWrapper.createFirstInstallData(s.id(new WeakReference<void>(var1_1)));
            this.setProperty("KSAppsFlyerId", aFKeystoreWrapper.getUid());
            this.setProperty("KSAppsFlyerRICounter", String.valueOf(aFKeystoreWrapper.getReInstallCounter()));
            return;
        }
        aFKeystoreWrapper.incrementReInstallCounter();
        this.setProperty("KSAppsFlyerId", aFKeystoreWrapper.getUid());
        this.setProperty("KSAppsFlyerRICounter", String.valueOf(aFKeystoreWrapper.getReInstallCounter()));
    }

    private String getCustomerUserId() {
        return this.getProperty("AppUserId");
    }

    /*
     * WARNING - void declaration
     */
    public void setAppId(String id) {
        void var1_1;
        u.getInstance().addApiEvent("setAppId", id);
        this.setProperty("appid", (String)var1_1);
    }

    private String getAppId() {
        return this.getProperty("appid");
    }

    /*
     * WARNING - void declaration
     */
    public void setExtension(String extension) {
        void var1_1;
        u.getInstance().addApiEvent("setExtension", extension);
        AppsFlyerProperties.getInstance().set("sdkExtension", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIsUpdate(boolean isUpdate) {
        void var1_1;
        u.getInstance().addApiEvent("setIsUpdate", String.valueOf(isUpdate));
        AppsFlyerProperties.getInstance().set("IS_UPDATE", (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrencyCode(String currencyCode) {
        void var1_1;
        u.getInstance().addApiEvent("setCurrencyCode", currencyCode);
        AppsFlyerProperties.getInstance().set("currencyCode", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void trackLocation(Context context, double latitude, double longitude) {
        void var1_1;
        void var2_2;
        u.getInstance().addApiEvent("trackLocation", String.valueOf(latitude), String.valueOf(longitude));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("af_long", Double.toString(longitude));
        hashMap.put("af_lat", Double.toString((double)var2_2));
        this.trackEventInternal((Context)var1_1, "af_location_coordinates", hashMap);
    }

    void callStatsBackground(WeakReference<Context> context) {
        o o2;
        Object object;
        if (context.get() == null) {
            return;
        }
        AFLogger.afInfoLog("app went to background");
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences("appsflyer-data", 0);
        AppsFlyerProperties.getInstance().saveProperties(sharedPreferences);
        long l2 = this.timeWentToBackground - this.timeEnteredForeground;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.getProperty("AppsFlyerKey");
        if (string == null) {
            AFLogger.afWarnLog("[callStats] AppsFlyer's SDK cannot send any event without providing DevKey.");
            return;
        }
        String string2 = this.getProperty("KSAppsFlyerId");
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (bl) {
            hashMap.put("deviceTrackingDisabled", "true");
        }
        if ((object = com.appsflyer.a.getAmazonAID(((Context)context.get()).getContentResolver())) != null) {
            hashMap.put("amazon_aid", ((m)object).getAdvertisingId());
            hashMap.put("amazon_aid_limit", String.valueOf(((m)object).isLimitAdTracking()));
        }
        if ((object = AppsFlyerProperties.getInstance().getString("advertiserId")) != null) {
            hashMap.put("advertiserId", (String)object);
        }
        hashMap.put("app_id", ((Context)context.get()).getPackageName());
        hashMap.put("devkey", string);
        hashMap.put("uid", s.id(context));
        hashMap.put("time_in_app", String.valueOf(l2 / 1000L));
        hashMap.put("statType", "user_closed_app");
        hashMap.put("platform", "Android");
        hashMap.put("launch_counter", Integer.toString(this.getLaunchCounter(sharedPreferences, false)));
        hashMap.put("gcd_conversion_data_timing", Long.toString(sharedPreferences.getLong("appsflyerGetConversionDataTiming", 0L)));
        hashMap.put("channel", this.getConfiguredChannel((WeakReference<Context>)((Object)o2)));
        hashMap.put("originalAppsflyerId", string2 != null ? string2 : "");
        if (this.isSendBackground) {
            try {
                o2 = new o(null);
                new o(null).bodyParameters = hashMap;
                if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
                    AFLogger.afDebugLog("Running callStats task (on current thread: " + Thread.currentThread().toString() + " )");
                    o2.onPreExecute();
                    o2.onPostExecute(o2.doInBackground(ServerConfigHandler.getUrl("https://stats.%s/stats")));
                    return;
                }
                AFLogger.afDebugLog("Main thread detected. Running callStats task in a new thread.");
                o2.execute(new String[]{ServerConfigHandler.getUrl("https://stats.%s/stats")});
            }
            catch (Throwable throwable) {
                AFLogger.afErrorLog("Could not send callStats request", throwable);
                return;
            }
        } else {
            AFLogger.afDebugLog("Stats call is disabled, ignore ...");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void trackAppLaunch(Context ctx, String devKey) {
        void var2_2;
        void var1_1;
        this.runInBackground((Context)var1_1, (String)var2_2, null, null, "", true);
    }

    /*
     * WARNING - void declaration
     */
    protected void setDeepLinkData(Intent intent) {
        try {
            if (intent != null && "android.intent.action.VIEW".equals(intent.getAction())) {
                void var1_1;
                this.latestDeepLink = var1_1.getData();
                AFLogger.afDebugLog("Unity setDeepLinkData = " + this.latestDeepLink);
            }
            return;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception while setting deeplink data (unity). ", throwable);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reportTrackSession(Context ctx) {
        void var1_1;
        u.getInstance().addApiEvent("reportTrackSession", new String[0]);
        u.getInstance().disableRemoteDebuggingForThisApp();
        this.trackEventInternal((Context)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        void var3_3;
        void var2_2;
        void var1_1;
        JSONObject jSONObject = new JSONObject((Map)(eventValues == null ? new HashMap() : eventValues));
        u.getInstance().addApiEvent("trackEvent", eventName, jSONObject.toString());
        this.trackEventInternal((Context)var1_1, (String)var2_2, (Map<String, Object>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    void trackEventInternal(Context context, String eventName, Map<String, Object> eventValues) {
        void var2_2;
        void var1_1;
        JSONObject jSONObject;
        String string = this.getProperty("AppsFlyerKey");
        if (string == null) {
            AFLogger.afWarnLog("[TrackEvent/Launch] AppsFlyer's SDK cannot send any event without providing DevKey.");
            return;
        }
        jSONObject = new JSONObject((Map)(eventValues == null ? new HashMap() : jSONObject));
        string = AppsFlyerProperties.getInstance().getReferrer(context);
        this.runInBackground((Context)var1_1, null, (String)var2_2, jSONObject.toString(), string == null ? "" : string, true);
    }

    /*
     * WARNING - void declaration
     */
    private void monitor(Context context, String eventIdentifier, String message, String value) {
        if (AppsFlyerProperties.getInstance().getBoolean("shouldMonitor", false)) {
            void var1_1;
            void var2_2;
            void var3_3;
            Intent intent = new Intent("com.appsflyer.MonitorBroadcast");
            intent.setPackage("com.appsflyer.nightvision");
            intent.putExtra("message", (String)var3_3);
            intent.putExtra("value", value);
            intent.putExtra("packageName", "true");
            intent.putExtra("pid", (Serializable)new Integer(Process.myPid()));
            intent.putExtra("eventIdentifier", (String)var2_2);
            intent.putExtra("sdk", "4.8.6");
            var1_1.sendBroadcast(intent);
        }
    }

    void callRegisterBackground(Context context, String token) {
        Object object;
        String string;
        String string2;
        m m2;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = this.getProperty("AppsFlyerKey");
        if (string3 == null) {
            AFLogger.afWarnLog("[registerUninstall] AppsFlyer's SDK cannot send any event without providing DevKey.");
            return;
        }
        Object object3 = context.getPackageManager();
        String string4 = context.getPackageName();
        try {
            object2 = object3.getPackageInfo(string4, 0);
            hashMap.put("app_version_code", Integer.toString(object2.versionCode));
            hashMap.put("app_version_name", object2.versionName);
            object3 = object3.getApplicationLabel(object2.applicationInfo).toString();
            hashMap.put("app_name", (String)object3);
            long l2 = object2.firstInstallTime;
            object3 = this.getDataFormatter("yyyy-MM-dd_HHmmssZ");
            hashMap.put("installDate", this.dateFormatUTC((SimpleDateFormat)object3, l2));
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception while collecting application version info.", throwable);
        }
        this.addNetworkData(context, hashMap);
        object2 = this.getCustomerUserId();
        if (object2 != null) {
            hashMap.put("appUserId", (String)object2);
        }
        try {
            hashMap.put("model", Build.MODEL);
            hashMap.put("brand", Build.BRAND);
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception while collecting device brand and model.", throwable);
        }
        int n2 = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (n2 != 0) {
            hashMap.put("deviceTrackingDisabled", "true");
        }
        if ((m2 = com.appsflyer.a.getAmazonAID(context.getContentResolver())) != null) {
            hashMap.put("amazon_aid", m2.getAdvertisingId());
            hashMap.put("amazon_aid_limit", String.valueOf(m2.isLimitAdTracking()));
        }
        if ((string2 = AppsFlyerProperties.getInstance().getString("advertiserId")) != null) {
            hashMap.put("advertiserId", string2);
        }
        hashMap.put("devkey", string3);
        hashMap.put("uid", s.id(new WeakReference<Context>(context)));
        hashMap.put("af_gcm_token", string);
        n2 = this.getLaunchCounter(this.getSharedPreferences(context), false);
        hashMap.put("launch_counter", Integer.toString(n2));
        hashMap.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
        string = this.getConfiguredChannel(new WeakReference<Context>(context));
        if (string != null) {
            hashMap.put("channel", string);
        }
        try {
            object = new o((Context)object);
            v0.bodyParameters = hashMap;
            string = ServerConfigHandler.getUrl(REGISTER_URL) + string4;
            object.execute(new String[]{string});
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            AFLogger.afErrorLog(throwable.getMessage(), object);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void broadcastBacktoTestApp(Context context, String paramsString) {
        Context context2;
        void var1_1;
        Intent intent = new Intent("com.appsflyer.testIntgrationBroadcast");
        intent.putExtra("params", (String)var1_1);
        context2.sendBroadcast(intent);
    }

    /*
     * WARNING - void declaration
     */
    public void setDeviceTrackingDisabled(boolean isDisabled) {
        void var1_1;
        u.getInstance().addApiEvent("setDeviceTrackingDisabled", String.valueOf(isDisabled));
        AppsFlyerProperties.getInstance().set("deviceTrackingDisabled", (boolean)var1_1);
    }

    private Map<String, String> getConversionData(Context context) throws n {
        Object object = context.getSharedPreferences("appsflyer-data", 0);
        if ((object = object.getString("attributionId", null)) != null && ((String)object).length() > 0) {
            return this.attributionStringToMap((String)object);
        }
        throw new n();
    }

    /*
     * WARNING - void declaration
     */
    public void registerConversionListener(Context context, AppsFlyerConversionListener conversionDataListener) {
        void var2_2;
        void var1_1;
        u.getInstance().addApiEvent("registerConversionListener", new String[0]);
        this.registerConversionListenerInternal((Context)var1_1, (AppsFlyerConversionListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void registerConversionListenerInternal(Context context, AppsFlyerConversionListener conversionDataListener) {
        void var2_2;
        if (conversionDataListener == null) {
            return;
        }
        AppsFlyerLib.conversionDataListener = var2_2;
    }

    public void unregisterConversionListener() {
        u.getInstance().addApiEvent("unregisterConversionListener", new String[0]);
        conversionDataListener = null;
    }

    /*
     * WARNING - void declaration
     */
    public void registerValidatorListener(Context context, AppsFlyerInAppPurchaseValidatorListener validationListener) {
        void var2_2;
        u.getInstance().addApiEvent("registerValidatorListener", new String[0]);
        AFLogger.afDebugLog("registerValidatorListener called");
        if (validationListener == null) {
            AFLogger.afDebugLog("registerValidatorListener null listener");
            return;
        }
        validatorListener = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void getConversionData(Context context, ConversionDataListener conversionDataListener) {
        void var2_2;
        void var1_1;
        this.registerConversionListenerInternal((Context)var1_1, new AppsFlyerConversionListener((ConversionDataListener)var2_2){
            final /* synthetic */ ConversionDataListener val$conversionDataListener;
            {
                this.val$conversionDataListener = conversionDataListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                void var1_1;
                this.val$conversionDataListener.onConversionDataLoaded((Map<String, String>)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onInstallConversionFailure(String errorMessage) {
                void var1_1;
                this.val$conversionDataListener.onConversionFailure((String)var1_1);
            }

            @Override
            public final void onAppOpenAttribution(Map<String, String> attributionData) {
            }

            @Override
            public final void onAttributionFailure(String errorMessage) {
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> referrerStringToMap(Context context, String referrer) {
        PackageInfo packageInfo;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        packageInfo = packageInfo.split("&");
        boolean bl = false;
        for (String string : packageInfo) {
            String string2;
            int n2 = string.indexOf("=");
            String string3 = string2 = n2 > 0 ? string.substring(0, n2) : string;
            if (!linkedHashMap.containsKey(string2)) {
                if (string2.equals("c")) {
                    string2 = "campaign";
                } else if (string2.equals("pid")) {
                    string2 = "media_source";
                } else if (string2.equals("af_prt")) {
                    bl = true;
                    string2 = "agency";
                }
                linkedHashMap.put(string2, "");
            }
            string = n2 > 0 && string.length() > n2 + 1 ? string.substring(n2 + 1) : null;
            linkedHashMap.put(string2, string);
        }
        try {
            if (!linkedHashMap.containsKey("install_time")) {
                void var1_1;
                packageInfo = context.getPackageManager().getPackageInfo(var1_1.getPackageName(), 0);
                linkedHashMap.put("install_time", this.dateFormatUTC(this.getDataFormatter("yyyy-MM-dd HH:mm:ss"), packageInfo.firstInstallTime));
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Could not fetch install time. ", exception);
        }
        if (!linkedHashMap.containsKey("af_status")) {
            linkedHashMap.put("af_status", "Non-organic");
        }
        if (bl) {
            linkedHashMap.remove("media_source");
        }
        return linkedHashMap;
    }

    /*
     * WARNING - void declaration
     */
    private String dateFormatUTC(SimpleDateFormat dateFormat, long time) {
        void var2_2;
        void var1_1;
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return var1_1.format(new Date((long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private SimpleDateFormat getDataFormatter(String pattern) {
        void var1_1;
        return new SimpleDateFormat((String)var1_1, Locale.US);
    }

    private Map<String, String> attributionStringToMap(String inputString) {
        JSONException jSONException;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            jSONException = new JSONObject((String)((Object)jSONException));
            Iterator iterator = jSONException.keys();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                if (IGNORABLE_KEYS.contains(string2) || TextUtils.isEmpty((CharSequence)(string = jSONException.getString(string2))) || "null".equals(string)) continue;
                hashMap.put(string2, string);
            }
        }
        catch (JSONException jSONException2) {
            jSONException = jSONException2;
            AFLogger.afErrorLog(jSONException2.getMessage(), jSONException);
            return null;
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    void runInBackground(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isNewAPI) {
        void var3_3;
        void var2_2;
        c c2;
        boolean bl = eventName == null;
        if (bl) {
            bl = AppsFlyerProperties.getInstance().getBoolean("launchProtectEnabled", true);
            if (bl) {
                if (this.isLaunchWithinBlockingTimeWindow()) {
                    return;
                }
            } else {
                AFLogger.afInfoLog("Allowing multiple launches within a 5 second time window.");
            }
            this.lastLaunchAttemptTimestamp = System.currentTimeMillis();
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
        c2 = new c(new WeakReference<void>((void)c2), (String)var2_2, (String)var3_3, eventValue, referrer, isNewAPI, scheduledThreadPoolExecutor, false);
        this.scheduleJob(scheduledThreadPoolExecutor, c2, 150L, TimeUnit.MILLISECONDS);
    }

    boolean isLaunchWithinBlockingTimeWindow() {
        if (this.lastLaunchAttemptTimestamp > 0L) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - this.lastLaunchAttemptTimestamp;
            Object object = this.getDataFormatter("yyyy/MM/dd HH:mm:ss.SSS Z");
            String string = this.dateFormatUTC((SimpleDateFormat)object, this.lastLaunchAttemptTimestamp);
            object = this.dateFormatUTC((SimpleDateFormat)object, this.lastSuccessfulLaunchTimestamp);
            if (l3 < this.launchBlockingTimeWindow) {
                String string2 = "Last Launch attempt: %s;\nLast successful Launch event: %s;\nThis launch is blocked: %s ms < %s ms";
                AFLogger.afInfoLog(String.format(Locale.US, string2, string, object, l3, this.launchBlockingTimeWindow));
                return true;
            }
            String string3 = "Last Launch attempt: %s;\nLast successful Launch event: %s;\nSending launch (+%s ms)";
            AFLogger.afInfoLog(String.format(Locale.US, string3, string, object, l3));
        } else {
            AFLogger.afInfoLog("Sending first launch for this session!");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void backgroundReferrerLaunch(Context context, String referrer) {
        if (referrer != null && referrer.length() > 5) {
            void var2_2;
            c c2;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
            c2 = new c(new WeakReference<void>((void)c2), null, null, null, (String)var2_2, true, scheduledThreadPoolExecutor, true);
            this.scheduleJob(scheduledThreadPoolExecutor, c2, 5L, TimeUnit.MILLISECONDS);
        }
    }

    private void sendTrackingWithEvent(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isUseNewAPI, boolean isBackgroundReferrerLaunch) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        String string;
        Object object;
        if (context == null) {
            AFLogger.afDebugLog("sendTrackingWithEvent - got null context. skipping event/launch.");
            return;
        }
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        AppsFlyerProperties.getInstance().saveProperties(sharedPreferences);
        AFLogger.afInfoLog("sendTrackingWithEvent from activity: " + context.getClass().getName());
        boolean bl = eventName == null;
        object = this.getEventParameters(context, (String)object, string, eventValue, referrer, isUseNewAPI, sharedPreferences, bl);
        string = (String)object.get("appsflyerKey");
        if (string == null || string.length() == 0) {
            AFLogger.afDebugLog("Not sending data yet, waiting for dev key");
            return;
        }
        AFLogger.afInfoLog("AppsFlyerLib.sendTrackingWithEvent");
        string = bl ? (isBackgroundReferrerLaunch ? ServerConfigHandler.getUrl(REFERRER_TRACKING_URL) : ServerConfigHandler.getUrl(APPS_TRACKING_URL)) : ServerConfigHandler.getUrl(EVENTS_TRACKING_URL);
        string = string + context.getPackageName();
        int n2 = this.getLaunchCounter(sharedPreferences, false);
        object = new e(string, (Map)object, context.getApplicationContext(), bl, n2);
        if (bl && this.allowInstallReferrer((Context)scheduledThreadPoolExecutor) && !this.isInstallReferrerAvailable()) {
            AFLogger.afDebugLog("Failed to get new referrer, wait ...");
            scheduledThreadPoolExecutor = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
            this.scheduleJob(scheduledThreadPoolExecutor, (Runnable)object, 500L, TimeUnit.MILLISECONDS);
            return;
        }
        object.run();
    }

    private boolean isInstallReferrerAvailable() {
        return this.installReferrerMap != null && this.installReferrerMap.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    Map<String, Object> getEventParameters(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isUseNewAPI, SharedPreferences sharedPreferences, boolean isLaunchEvent) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        com.appsflyer.a.addGoogleAID(context, hashMap);
        hashMap.put("af_timestamp", Long.toString(new Date().getTime()));
        try {
            String string;
            void var3_11;
            String string2;
            Object object;
            String string3;
            String string4;
            Object object2;
            Object object3;
            String string5;
            String string6;
            Object object4;
            this.debugAction("collect data for server", "", context);
            AFLogger.afInfoLog("******* sendTrackingWithEvent: " + (isLaunchEvent ? "Launch" : eventName));
            this.debugAction("********* sendTrackingWithEvent: ", isLaunchEvent ? "Launch" : eventName, context);
            this.monitor(context, LOG_TAG, "EVENT_CREATED_WITH_NAME", isLaunchEvent ? "Launch" : eventName);
            CacheManager.getInstance().init(context);
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                object4 = Arrays.asList(packageInfo.requestedPermissions);
                if (!object4.contains("android.permission.INTERNET")) {
                    AFLogger.afWarnLog("Permission android.permission.INTERNET is missing in the AndroidManifest.xml");
                    this.monitor(context, null, "PERMISSION_INTERNET_MISSING", null);
                }
                if (!object4.contains("android.permission.ACCESS_NETWORK_STATE")) {
                    AFLogger.afWarnLog("Permission android.permission.ACCESS_NETWORK_STATE is missing in the AndroidManifest.xml");
                }
                if (!object4.contains("android.permission.ACCESS_WIFI_STATE")) {
                    AFLogger.afWarnLog("Permission android.permission.ACCESS_WIFI_STATE is missing in the AndroidManifest.xml");
                }
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while validation permissions. ", exception);
            }
            if (isUseNewAPI) {
                hashMap.put("af_events_api", "1");
            }
            hashMap.put("brand", Build.BRAND);
            hashMap.put("device", Build.DEVICE);
            hashMap.put("product", Build.PRODUCT);
            hashMap.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
            hashMap.put("model", Build.MODEL);
            hashMap.put("deviceType", Build.TYPE);
            if (isLaunchEvent) {
                if (this.isAppsFlyerFirstLaunch(context)) {
                    if (!AppsFlyerProperties.getInstance().isOtherSdkStringDisabled()) {
                        hashMap.put("af_sdks", this.generateOtherSDKsString());
                        float f2 = this.getBatteryLevel(context);
                        hashMap.put("batteryLevel", String.valueOf(f2));
                    }
                    this.getReInstallData(context);
                }
                hashMap.put("timepassedsincelastlaunch", Long.toString(this.getTimePassedSinceLastLaunch(context, true)));
                this.addOneLinkData(hashMap);
            } else {
                this.lastEventsProcessing(context, hashMap, eventName, eventValue);
            }
            String string7 = this.getProperty("KSAppsFlyerId");
            object4 = this.getProperty("KSAppsFlyerRICounter");
            if (string7 != null && object4 != null && Integer.valueOf((String)object4) > 0) {
                hashMap.put("reinstallCounter", object4);
                hashMap.put("originalAppsflyerId", string7);
            }
            if ((string6 = this.getProperty("additionalCustomData")) != null) {
                hashMap.put("customData", string6);
            }
            try {
                string6 = context.getPackageManager().getInstallerPackageName(context.getPackageName());
                if (string6 != null) {
                    hashMap.put("installer_package", string6);
                }
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while getting the app's installer package. ", exception);
            }
            string6 = AppsFlyerProperties.getInstance().getString("sdkExtension");
            if (string6 != null && string6.length() > 0) {
                hashMap.put("sdkExtension", string6);
            }
            if ((string7 = this.getCachedChannel(context, string6 = this.getConfiguredChannel(new WeakReference<Context>(context)))) != null) {
                hashMap.put("channel", string7);
            }
            if (string7 != null && !string7.equals(string6) || string7 == null && string6 != null) {
                hashMap.put("af_latestchannel", string6);
            }
            if ((string6 = this.getCachedStore(context)) != null) {
                hashMap.put("af_installstore", string6.toLowerCase());
            }
            if ((string6 = this.getPreInstallName(context)) != null) {
                hashMap.put("af_preinstall_name", string6.toLowerCase());
            }
            if ((string6 = this.getCurrentStore(context)) != null) {
                hashMap.put("af_currentstore", string6.toLowerCase());
            }
            if (appsFlyerKey != null && appsFlyerKey.length() >= 0) {
                hashMap.put("appsflyerKey", string5);
            } else {
                string5 = this.getProperty("AppsFlyerKey");
                if (string5 != null && string5.length() >= 0) {
                    hashMap.put("appsflyerKey", string5);
                } else {
                    AFLogger.afInfoLog("AppsFlyer dev key is missing!!! Please use  AppsFlyerLib.getInstance().setAppsFlyerKey(...) to set it. ");
                    this.monitor(context, LOG_TAG, "DEV_KEY_MISSING", null);
                    AFLogger.afInfoLog("AppsFlyer will not track this event.");
                    return null;
                }
            }
            string5 = this.getCustomerUserId();
            if (string5 != null) {
                hashMap.put("appUserId", string5);
            }
            if ((string5 = AppsFlyerProperties.getInstance().getString("userEmails")) != null) {
                hashMap.put("user_emails", string5);
            } else {
                string5 = this.getProperty("userEmail");
                if (string5 != null) {
                    hashMap.put("sha1_el", r.toSHA1(string5));
                }
            }
            if (eventName != null) {
                hashMap.put("eventName", eventName);
                if (eventValue != null) {
                    hashMap.put("eventValue", eventValue);
                }
            }
            if (this.getAppId() != null) {
                hashMap.put("appid", this.getProperty("appid"));
            }
            if ((string5 = this.getProperty("currencyCode")) != null) {
                if (string5.length() != 3) {
                    AFLogger.afWarnLog("WARNING: currency code should be 3 characters!!! '" + string5 + "' is not a legal value.");
                }
                hashMap.put("currency", string5);
            }
            if ((string5 = this.getProperty("IS_UPDATE")) != null) {
                hashMap.put("isUpdate", string5);
            }
            boolean bl = this.isPreInstalledApp(context);
            hashMap.put("af_preinstalled", Boolean.toString(bl));
            bl = AppsFlyerProperties.getInstance().getBoolean("collectFacebookAttrId", true);
            if (bl) {
                String string8;
                try {
                    context.getPackageManager().getApplicationInfo("com.facebook.katana", 0);
                    string8 = this.getAttributionId(context.getContentResolver());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    string8 = null;
                    AFLogger.afWarnLog("Exception while collecting facebook's attribution ID. ");
                }
                catch (Throwable throwable) {
                    string8 = null;
                    AFLogger.afErrorLog("Exception while collecting facebook's attribution ID. ", throwable);
                }
                if (string8 != null) {
                    hashMap.put("fb", string8);
                }
            }
            this.addDeviceTracking(context, hashMap);
            try {
                object3 = s.id(new WeakReference<Context>(context));
                if (object3 != null) {
                    hashMap.put("uid", object3);
                }
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("ERROR: " + "could not get uid " + exception.getMessage(), exception);
            }
            try {
                hashMap.put("lang", Locale.getDefault().getDisplayLanguage());
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while collecting display language name. ", exception);
            }
            try {
                hashMap.put("lang_code", Locale.getDefault().getLanguage());
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while collecting display language code. ", exception);
            }
            try {
                hashMap.put("country", Locale.getDefault().getCountry());
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while collecting country name. ", exception);
            }
            hashMap.put("platformextension", this.platformExtension.getAvailablePlatformExtension());
            this.addNetworkData(context, hashMap);
            object3 = this.getDataFormatter("yyyy-MM-dd_HHmmssZ");
            if (Build.VERSION.SDK_INT >= 9) {
                try {
                    long l2 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
                    hashMap.put("installDate", this.dateFormatUTC((SimpleDateFormat)object3, l2));
                }
                catch (Exception exception) {
                    AFLogger.afErrorLog("Exception while collecting install date. ", exception);
                }
            }
            try {
                object2 = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                int n2 = sharedPreferences.getInt("versionCode", 0);
                if (((PackageInfo)object2).versionCode > n2) {
                    this.saveIntegerToSharedPreferences(context, "appsflyerConversionDataRequestRetries", 0);
                    this.saveIntegerToSharedPreferences(context, "versionCode", ((PackageInfo)object2).versionCode);
                }
                hashMap.put("app_version_code", Integer.toString(((PackageInfo)object2).versionCode));
                hashMap.put("app_version_name", ((PackageInfo)object2).versionName);
                if (Build.VERSION.SDK_INT >= 9) {
                    long l3 = ((PackageInfo)object2).firstInstallTime;
                    long l4 = ((PackageInfo)object2).lastUpdateTime;
                    hashMap.put("date1", this.dateFormatUTC((SimpleDateFormat)object3, l3));
                    hashMap.put("date2", this.dateFormatUTC((SimpleDateFormat)object3, l4));
                    object3 = this.getFirstInstallDate((SimpleDateFormat)object3, context);
                    hashMap.put("firstLaunchDate", object3);
                }
            }
            catch (Throwable throwable) {
                AFLogger.afErrorLog("Exception while collecting app version data ", throwable);
            }
            if (referrer.length() > 0) {
                hashMap.put("referrer", referrer);
            }
            if ((object2 = sharedPreferences.getString("attributionId", null)) != null && ((String)object2).length() > 0) {
                hashMap.put("installAttribution", object2);
            }
            if ((string4 = sharedPreferences.getString("extraReferrers", null)) != null) {
                hashMap.put("extraReferrers", string4);
            }
            if ((string3 = this.getProperty("afUninstallToken")) != null && (object = h.parse(string3)) != null) {
                hashMap.put("af_gcm_token", ((h)object).getToken());
            }
            this.isTokenRefreshServiceConfigured = com.appsflyer.a.didConfigureTokenRefreshService(context);
            AFLogger.afDebugLog("didConfigureTokenRefreshService=" + this.isTokenRefreshServiceConfigured);
            if (!this.isTokenRefreshServiceConfigured) {
                hashMap.put("tokenRefreshConfigured", false);
            }
            if (isLaunchEvent) {
                if (this.pushPayload != null) {
                    object = new JSONObject(this.pushPayload);
                    object.put("isPush", (Object)"true");
                    hashMap.put("af_deeplink", object.toString());
                }
                this.pushPayload = null;
            }
            if (isLaunchEvent && context instanceof Activity) {
                object = this.getDeepLinkUri(context);
                if (object != null) {
                    this.handleDeepLinkCallback(context, hashMap, (Uri)object);
                } else if (this.latestDeepLink != null) {
                    this.handleDeepLinkCallback(context, hashMap, this.latestDeepLink);
                }
            }
            if (this.isRetargetingTestMode) {
                hashMap.put("testAppMode_retargeting", "true");
                object = new JSONObject(hashMap);
                AppsFlyerLib.broadcastBacktoTestApp(context, object.toString());
                AFLogger.afInfoLog("Sent retargeting params to test app");
            }
            if (this.isInTestMode(context)) {
                hashMap.put("testAppMode", "true");
                object = new JSONObject(hashMap);
                AppsFlyerLib.broadcastBacktoTestApp(context, object.toString());
                AFLogger.afInfoLog("Sent params to test app");
                this.endTestMode();
            }
            if (this.getProperty("advertiserId") == null) {
                com.appsflyer.a.addGoogleAID(context, hashMap);
                if (this.getProperty("advertiserId") != null) {
                    hashMap.put("GAID_retry", "true");
                } else {
                    hashMap.put("GAID_retry", "false");
                }
            }
            if ((object = com.appsflyer.a.getAmazonAID(context.getContentResolver())) != null) {
                hashMap.put("amazon_aid", ((m)object).getAdvertisingId());
                hashMap.put("amazon_aid_limit", String.valueOf(((m)object).isLimitAdTracking()));
            }
            if ((string2 = AppsFlyerProperties.getInstance().getReferrer(context)) != null && string2.length() > 0 && hashMap.get("referrer") == null) {
                hashMap.put("referrer", string2);
            }
            boolean bl2 = "true".equals(sharedPreferences.getString("sentSuccessfully", ""));
            int n3 = sharedPreferences.getBoolean("sentRegisterRequestToAF", false);
            hashMap.put("registeredUninstall", n3 != 0);
            n3 = this.getLaunchCounter(sharedPreferences, isLaunchEvent);
            hashMap.put("counter", Integer.toString(n3));
            hashMap.put("iaecounter", Integer.toString(this.getNonlaunchCounter(sharedPreferences, var3_11 != null)));
            if (isLaunchEvent && n3 == 1) {
                AppsFlyerProperties.getInstance().setFirstLaunchCalled();
            }
            hashMap.put("isFirstCall", Boolean.toString(!bl2));
            this.updateDeviceData((Context)string, isLaunchEvent, hashMap, n3);
            string = new r().getHashCode(hashMap);
            hashMap.put("af_v", string);
            string = new r().getHashCodeV2(hashMap);
            hashMap.put("af_v2", string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            AFLogger.afErrorLog(throwable.getLocalizedMessage(), throwable2);
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private void updateDeviceData(Context context, boolean isLaunchEvent, Map<String, Object> params, int launchCounter) {
        void var3_5;
        void var2_2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("cpu_abi", this.getSystemProperty("ro.product.cpu.abi"));
        hashMap.put("cpu_abi2", this.getSystemProperty("ro.product.cpu.abi2"));
        hashMap.put("arch", this.getSystemProperty("os.arch"));
        hashMap.put("build_display_id", this.getSystemProperty("ro.build.display.id"));
        if (var2_2 != false) {
            void var1_1;
            List<Map<String, Object>> list;
            Map<String, Object> map;
            if (this.isCollectLocation && !(map = this.getLocationData(context)).isEmpty()) {
                hashMap.put("loc", map);
            }
            this.addBatteryData(context, hashMap);
            if (2 >= launchCounter && !(list = g.getInstance((Context)var1_1).getData()).isEmpty()) {
                hashMap.put("sensors", list);
            }
        }
        var3_5.put("deviceData", hashMap);
    }

    /*
     * WARNING - void declaration
     */
    private void addNetworkData(Context context, Map<String, ? super String> registerParams) {
        e.b b2;
        b2 = com.appsflyer.e.getInstance().getData((Context)b2);
        registerParams.put("network", b2.getNetworkType());
        if (null != b2.getSimOperator()) {
            registerParams.put("operator", b2.getSimOperator());
        }
        if (null != b2.getCarrierName()) {
            void var2_2;
            var2_2.put("carrier", b2.getCarrierName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addBatteryData(Context context, Map<String, Object> deviceData) {
        a.a a2;
        a2 = com.appsflyer.a.getInstance().getData((Context)a2);
        deviceData.put("btl", Float.toString(a2.getLevel()));
        if (a2.getCharging() != null) {
            void var2_2;
            var2_2.put("btch", a2.getCharging());
        }
    }

    @Nullable
    private Map<String, Object> getLocationData(Context context) {
        Location location;
        location = com.appsflyer.d.getInstance().getData((Context)location);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        if (location != null) {
            hashMap.put("lat", String.valueOf(location.getLatitude()));
            hashMap.put("lon", String.valueOf(location.getLongitude()));
            hashMap.put("ts", String.valueOf(location.getTime()));
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private void addOneLinkData(Map<String, Object> params) {
        String string = AppsFlyerProperties.getInstance().getString("oneLinkSlug");
        if (string != null) {
            void var1_1;
            params.put("onelink_id", string);
            var1_1.put("ol_ver", AppsFlyerProperties.getInstance().getString("onelinkVersion"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getPushPayloadFromIntent(Context context) {
        Bundle bundle;
        Intent intent;
        String string = null;
        if (context instanceof Activity && (intent = ((Activity)context).getIntent()) != null && (bundle = intent.getExtras()) != null && (string = bundle.getString("af")) != null) {
            void var1_1;
            AFLogger.afInfoLog("Push Notification received af payload = " + string);
            bundle.remove("af");
            ((Activity)var1_1).setIntent(intent.putExtras(bundle));
        }
        return string;
    }

    @Nullable
    private Uri getDeepLinkUri(Context context) {
        Intent intent;
        Uri uri = null;
        if ((intent = ((Activity)intent).getIntent()) != null && "android.intent.action.VIEW".equals(intent.getAction())) {
            uri = intent.getData();
        }
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    private void handleDeepLinkCallback(Context context, Map<String, Object> params, Uri uri) {
        void var3_3;
        q.a a2;
        HashMap<String, String> hashMap;
        Object object;
        Object object2;
        params.put("af_deeplink", uri.toString());
        if (uri.getQueryParameter("af_deeplink") != null) {
            object2 = uri.getQueryParameter("media_source");
            object = uri.getQueryParameter("is_retargeting");
            this.isRetargetingTestMode = "AppsFlyer_Test".equals(object2) && Boolean.parseBoolean((String)object);
            hashMap = this.referrerStringToMap(context, uri.getQuery());
            this.addValueIfNotNull(hashMap, "path", uri.getPath());
            this.addValueIfNotNull(hashMap, "scheme", uri.getScheme());
            this.addValueIfNotNull(hashMap, "host", uri.getHost());
        } else {
            hashMap = new HashMap<String, String>();
            hashMap.put("link", uri.toString());
        }
        object2 = new WeakReference<void>((void)a2);
        object = new q((Uri)var3_3, this);
        ((OneLinkHttpTask)object).setConnProvider(new OneLinkHttpTask.HttpsUrlConnectionProvider());
        if (((q)object).isShortLinkValid()) {
            a2 = this.getDateListener(hashMap, (WeakReference<Context>)object2);
            ((q)object).setListener(a2);
            AFExecutor.getInstance().getThreadPoolExecutor().execute((Runnable)object);
            return;
        }
        this.onAppOpenAttribution(hashMap);
    }

    private void onAppOpenAttribution(Map<String, String> data) {
        if (conversionDataListener != null) {
            Throwable throwable;
            try {
                conversionDataListener.onAppOpenAttribution((Map<String, String>)((Object)throwable));
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                AFLogger.afErrorLog(throwable2.getLocalizedMessage(), throwable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private q.a getDateListener(Map<String, String> attributionMap, WeakReference<Context> contextRef) {
        void var2_2;
        void var1_1;
        return new q.a((Map)var1_1, (WeakReference)var2_2){
            final /* synthetic */ Map val$attributionMap;
            final /* synthetic */ WeakReference val$contextRef;
            {
                this.val$attributionMap = map;
                this.val$contextRef = weakReference;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onGetOneLinkParameters(Map<String, String> data) {
                void var1_1;
                this.mergeDataToAttributionMap((Map<String, String>)var1_1);
                this.saveToSharedPref(this.val$attributionMap);
                AppsFlyerLib.access$200(AppsFlyerLib.this, this.val$attributionMap);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onGetOneLinkParametersError(String message) {
                if (conversionDataListener != null) {
                    void var1_1;
                    this.saveToSharedPref(this.val$attributionMap);
                    conversionDataListener.onAttributionFailure((String)var1_1);
                }
            }

            private void mergeDataToAttributionMap(Map<String, String> data) {
                for (String string : data.keySet()) {
                    this.val$attributionMap.put(string, data.get(string));
                }
            }

            private void saveToSharedPref(Map<String, String> data) {
                if (this.val$contextRef.get() != null) {
                    String string;
                    string = new JSONObject((Map)((Object)string)).toString();
                    AppsFlyerLib.access$400(AppsFlyerLib.this, (Context)this.val$contextRef.get(), "deeplinkAttribution", string);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void addValueIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            var1_1.put(var2_2, var3_3);
        }
    }

    private String generateOtherSDKsString() {
        return "" + this.numericBooleanIsClassExist("com.tune.Tune") + this.numericBooleanIsClassExist("com.adjust.sdk.Adjust") + this.numericBooleanIsClassExist("com.kochava.android.tracker.Feature") + this.numericBooleanIsClassExist("io.branch.referral.Branch") + this.numericBooleanIsClassExist("com.apsalar.sdk.Apsalar") + this.numericBooleanIsClassExist("com.localytics.android.Localytics") + this.numericBooleanIsClassExist("com.tenjin.android.TenjinSDK") + this.numericBooleanIsClassExist("place holder for TD") + this.numericBooleanIsClassExist("it.partytrack.sdk.Track") + this.numericBooleanIsClassExist("jp.appAdForce.android.LtvManager");
    }

    /*
     * WARNING - void declaration
     */
    private int numericBooleanIsClassExist(String className) {
        void var1_1;
        if (this.platformExtension.isClassExist((String)var1_1)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void lastEventsProcessing(Context context, Map<String, Object> params, String newEventName, String newEventValue) {
        SharedPreferences sharedPreferences;
        sharedPreferences = this.getSharedPreferences((Context)sharedPreferences);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            void var3_3;
            String string = sharedPreferences.getString("prev_event_name", null);
            if (string != null) {
                void var2_2;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("prev_event_timestamp", (Object)("" + sharedPreferences.getLong("prev_event_timestamp", -1L)));
                jSONObject.put("prev_event_value", (Object)sharedPreferences.getString("prev_event_value", null));
                jSONObject.put("prev_event_name", (Object)string);
                var2_2.put("prev_event", jSONObject.toString());
            }
            editor.putString("prev_event_name", (String)var3_3);
            editor.putString("prev_event_value", newEventValue);
            editor.putLong("prev_event_timestamp", System.currentTimeMillis());
            this.editorCommit(editor);
            return;
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error while processing previous event.", exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isGooglePlayServicesAvailable(Context context) {
        boolean bl = false;
        try {
            void var1_1;
            int n2 = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)var1_1);
            if (n2 == 0) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("WARNING:  Google play services is unavailable. ", throwable);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void addDeviceTracking(Context context, Map<String, Object> params) {
        String string;
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (bl) {
            params.put("deviceTrackingDisabled", "true");
            return;
        }
        Object object = this.getSharedPreferences(context);
        boolean bl2 = AppsFlyerProperties.getInstance().getBoolean("collectIMEI", true);
        String string2 = object.getString("imeiCached", null);
        String string3 = null;
        if (bl2) {
            if (this.isIdCollectionAllowed(context)) {
                try {
                    TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                    string = (String)telephonyManager.getClass().getMethod("getDeviceId", new Class[0]).invoke((Object)telephonyManager, new Object[0]);
                    if (string != null) {
                        string3 = string;
                    } else if (this.userCustomImei != null) {
                        string3 = this.userCustomImei;
                    } else if (string2 != null) {
                        string3 = string2;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    AFLogger.afWarnLog("WARNING: READ_PHONE_STATE is missing.");
                }
                catch (Exception exception) {
                    AFLogger.afErrorLog("WARNING: READ_PHONE_STATE is missing. ", exception);
                }
            } else if (this.userCustomImei != null) {
                string3 = this.userCustomImei;
            }
        } else if (this.userCustomImei != null) {
            string3 = this.userCustomImei;
        }
        if (string3 != null) {
            this.saveDataToSharedPreferences(context, "imeiCached", string3);
            params.put("imei", string3);
        } else {
            AFLogger.afInfoLog("IMEI was not collected.");
        }
        boolean bl3 = AppsFlyerProperties.getInstance().getBoolean("collectAndroidId", true);
        string = object.getString("androidIdCached", null);
        object = null;
        if (bl3) {
            if (this.isIdCollectionAllowed(context)) {
                try {
                    String string4 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                    if (string4 != null) {
                        object = string4;
                    } else if (this.userCustomAndroidId != null) {
                        object = this.userCustomAndroidId;
                    } else if (string != null) {
                        object = string;
                    }
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    AFLogger.afErrorLog(exception.getMessage(), exception2);
                }
            } else if (this.userCustomAndroidId != null) {
                object = this.userCustomAndroidId;
            }
        } else if (this.userCustomAndroidId != null) {
            object = this.userCustomAndroidId;
        }
        if (object != null) {
            void var2_2;
            void var1_1;
            this.saveDataToSharedPreferences((Context)var1_1, "androidIdCached", (String)object);
            var2_2.put("android_id", object);
            return;
        }
        AFLogger.afInfoLog("Android ID was not collected.");
    }

    /*
     * WARNING - void declaration
     */
    private boolean isIdCollectionAllowed(Context context) {
        void var1_1;
        return Build.VERSION.SDK_INT < 19 || !this.isGooglePlayServicesAvailable((Context)var1_1);
    }

    private boolean isAppsFlyerFirstLaunch(Context context) {
        SharedPreferences sharedPreferences;
        return !(sharedPreferences = this.getSharedPreferences((Context)sharedPreferences)).contains("appsFlyerCount");
    }

    /*
     * WARNING - void declaration
     */
    private String getCachedStore(Context context) {
        void var1_1;
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        if (sharedPreferences.contains("INSTALL_STORE")) {
            return sharedPreferences.getString("INSTALL_STORE", null);
        }
        boolean bl = this.isAppsFlyerFirstLaunch(context);
        String string = bl ? this.getCurrentStore(context) : null;
        this.saveDataToSharedPreferences((Context)var1_1, "INSTALL_STORE", string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String getCurrentStore(Context context) {
        void var1_1;
        return this.getManifestMetaData(new WeakReference<void>(var1_1), "AF_STORE");
    }

    String getSystemProperty(String key) {
        Throwable throwable;
        String string = null;
        try {
            string = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class).invoke(null, throwable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            AFLogger.afErrorLog(throwable2.getMessage(), throwable);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String getManifestMetaData(WeakReference<Context> context, String key) {
        void var1_1;
        void var2_2;
        if (context.get() == null) {
            return null;
        }
        return this.getManifestMetaData((String)var2_2, ((Context)context.get()).getPackageManager(), ((Context)var1_1.get()).getPackageName());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String getManifestMetaData(String key, PackageManager packageManager, String packageName) {
        String string = null;
        try {
            void var3_4;
            Object object;
            object = object.getApplicationInfo((String)var3_4, 128);
            object = ((ApplicationInfo)object).metaData;
            if (object != null && (object = object.get(key)) != null) {
                string = object.toString();
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            AFLogger.afErrorLog("Could not find " + (String)var1_1 + " value in the manifest", throwable);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String preInstallValueFromFile(Context context) {
        void var1_1;
        Object object = this.getSystemProperty(PRE_INSTALL_SYSTEM_RO_PROP);
        if (this.isPreInstallFileInvalid((File)(object = this.getFileFromString((String)object)))) {
            object = this.getManifestMetaData(AF_PRE_INSTALL_PATH, context.getPackageManager(), context.getPackageName());
            object = this.getFileFromString((String)object);
        }
        if (this.isPreInstallFileInvalid((File)object)) {
            object = this.getFileFromString(PRE_INSTALL_SYSTEM_DEFAULT);
        }
        if (this.isPreInstallFileInvalid((File)object)) {
            object = this.getFileFromString(PRE_INSTALL_SYSTEM_DEFAULT_ETC);
        }
        if (this.isPreInstallFileInvalid((File)object)) {
            return null;
        }
        if ((object = this.extractPropertyFromFile((File)object, var1_1.getPackageName())) != null) {
            return object;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private String extractPropertyFromFile(File preInstallFile, String propertyKey) {
        Throwable throwable;
        Object object;
        InputStreamReader inputStreamReader = null;
        Properties properties = new Properties();
        inputStreamReader = new FileReader(preInstallFile);
        properties.load(inputStreamReader);
        AFLogger.afInfoLog("Found PreInstall property!");
        object = properties.getProperty((String)object);
        try {
            inputStreamReader.close();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            AFLogger.afErrorLog(throwable2.getMessage(), throwable);
        }
        return object;
        catch (FileNotFoundException fileNotFoundException) {
            AFLogger.afDebugLog("PreInstall file wasn't found: " + ((File)((Object)throwable)).getAbsolutePath());
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable42 = throwable3;
                AFLogger.afErrorLog(throwable3.getMessage(), throwable42);
            }
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            AFLogger.afErrorLog(throwable5.getMessage(), throwable6);
            {
                catch (Throwable throwable7) {
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        object = throwable8;
                        AFLogger.afErrorLog(throwable8.getMessage(), (Throwable)object);
                    }
                    throw throwable7;
                }
            }
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Throwable throwable9) {
                throwable6 = throwable9;
                AFLogger.afErrorLog(throwable9.getMessage(), throwable6);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPreInstallFileInvalid(File preInstallFile) {
        void var1_1;
        return preInstallFile == null || !var1_1.exists();
    }

    private File getFileFromString(String filePath) {
        Throwable throwable;
        try {
            if (filePath != null && filePath.trim().length() > 0) {
                return new File(((String)((Object)throwable)).trim());
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            AFLogger.afErrorLog(throwable2.getMessage(), throwable);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getPreInstallName(Context context) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        String string = this.getProperty("preInstallName");
        if (string != null) {
            return string;
        }
        if (sharedPreferences.contains("preInstallName")) {
            string = sharedPreferences.getString("preInstallName", null);
        } else {
            boolean bl = this.isAppsFlyerFirstLaunch(context);
            if (bl) {
                String string2 = this.preInstallValueFromFile(context);
                string = string2 != null ? string2 : this.getManifestMetaData(new WeakReference<Context>(context), "AF_PRE_INSTALL_NAME");
            }
            if (string != null) {
                void var1_1;
                this.saveDataToSharedPreferences((Context)var1_1, "preInstallName", string);
            }
        }
        if (string != null) {
            this.setProperty("preInstallName", string);
        }
        return string;
    }

    private void checkCache(Context context) {
        b b2;
        if (this.isDuringCheckCache || System.currentTimeMillis() - this.lastCacheCheck < 15000L) {
            return;
        }
        if (this.cacheScheduler != null) {
            return;
        }
        this.cacheScheduler = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
        b2 = new b((Context)b2);
        this.scheduleJob(this.cacheScheduler, b2, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String getConfiguredChannel(WeakReference<Context> context) {
        String string = AppsFlyerProperties.getInstance().getString("channel");
        if (string == null) {
            void var1_1;
            string = this.getManifestMetaData((WeakReference<Context>)var1_1, "CHANNEL");
        }
        return string;
    }

    public boolean isPreInstalledApp(Context context) {
        try {
            ApplicationInfo applicationInfo;
            applicationInfo = context.getPackageManager().getApplicationInfo(applicationInfo.getPackageName(), 0);
            if ((applicationInfo.flags & 1) != 0) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AFLogger.afErrorLog("Could not check if app is pre installed", nameNotFoundException);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private String getCachedChannel(Context context, String currentChannel) throws PackageManager.NameNotFoundException {
        void var2_2;
        void var1_1;
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        if (sharedPreferences.contains("CACHED_CHANNEL")) {
            return sharedPreferences.getString("CACHED_CHANNEL", null);
        }
        this.saveDataToSharedPreferences((Context)var1_1, "CACHED_CHANNEL", currentChannel);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String getFirstInstallDate(SimpleDateFormat dateFormat, Context context) {
        Object object = this.getSharedPreferences(context);
        if ((object = object.getString("appsFlyerFirstInstall", null)) == null) {
            void var2_2;
            if (this.isAppsFlyerFirstLaunch(context)) {
                void var1_1;
                AFLogger.afDebugLog("AppsFlyer: first launch detected");
                object = var1_1.format(new Date());
            } else {
                object = "";
            }
            this.saveDataToSharedPreferences((Context)var2_2, "appsFlyerFirstInstall", (String)object);
        }
        AFLogger.afInfoLog("AppsFlyer: first launch date: " + (String)object);
        return object;
    }

    /*
     * Loose catch block
     */
    public String getAttributionId(ContentResolver contentResolver) {
        Object object;
        block18: {
            Object object2;
            block17: {
                object = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
                object2 = object2.query(Uri.parse((String)ATTRIBUTION_ID_CONTENT_URI), object, null, null, null);
                object = null;
                if (object2 != null && object2.moveToFirst()) break block17;
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception) {
                    object2 = exception;
                    AFLogger.afErrorLog(exception.getMessage(), (Throwable)object2);
                }
                return null;
            }
            object = object2.getString(object2.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
            try {
                if (object2 != null) {
                    object2.close();
                }
                break block18;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                AFLogger.afErrorLog(exception.getMessage(), exception2);
            }
            break block18;
            catch (Exception exception) {
                try {
                    AFLogger.afErrorLog("Could not collect cursor attribution. ", exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                    catch (Exception exception3) {
                        object2 = exception3;
                        AFLogger.afErrorLog(exception3.getMessage(), (Throwable)object2);
                    }
                    throw throwable;
                }
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception4) {
                    Exception exception5 = exception4;
                    AFLogger.afErrorLog(exception4.getMessage(), exception5);
                }
            }
        }
        return object;
    }

    final SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences("appsflyer-data", 0);
    }

    /*
     * WARNING - void declaration
     */
    final int getLaunchCounter(SharedPreferences sharedPreferences, boolean isIncrease) {
        void var2_2;
        void var1_1;
        return this.getCounter((SharedPreferences)var1_1, "appsFlyerCount", (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final int getNonlaunchCounter(SharedPreferences sharedPreferences, boolean isIncrease) {
        void var2_2;
        void var1_1;
        return this.getCounter((SharedPreferences)var1_1, "appsFlyerInAppEventCount", (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int getCounter(SharedPreferences sharedPreferences, String parameterName, boolean isIncrease) {
        void var3_3;
        int n2 = sharedPreferences.getInt(parameterName, 0);
        if (var3_3 != false) {
            void var2_2;
            SharedPreferences.Editor editor;
            editor = editor.edit();
            editor.putInt((String)var2_2, ++n2);
            this.editorCommit(editor);
        }
        if (u.getInstance().isProxyEnabledFromServer()) {
            u.getInstance().setLauncCounter(String.valueOf(n2));
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    private long getTimePassedSinceLastLaunch(Context context, boolean shouldSave) {
        void var2_2;
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        long l2 = sharedPreferences.getLong("AppsFlyerTimePassedSincePrevLaunch", 0L);
        long l3 = System.currentTimeMillis();
        if (var2_2 != false) {
            void var1_1;
            this.saveLongToSharedPreferences((Context)var1_1, "AppsFlyerTimePassedSincePrevLaunch", l3);
        }
        if (l2 <= 0L) {
            return -1L;
        }
        long l4 = l3 - l2;
        return l4 / 1000L;
    }

    /*
     * WARNING - void declaration
     */
    public String getAppsFlyerUID(Context context) {
        void var1_1;
        u.getInstance().addApiEvent("getAppsFlyerUID", new String[0]);
        return s.id(new WeakReference<void>(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void sendRequestToServer(String urlString, String postDataString, String afDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean isLaunch) throws IOException {
        URL uRL = new URL(urlString);
        AFLogger.afInfoLog("url: " + uRL.toString());
        this.debugAction("call server.", "\n" + uRL.toString() + "\nPOST:" + postDataString, (Context)ctxReference.get());
        com.appsflyer.a.logMessageMaskKey("data: " + postDataString);
        this.monitor((Context)ctxReference.get(), LOG_TAG, "EVENT_DATA", postDataString);
        try {
            this.callServer(uRL, postDataString, afDevKey, ctxReference, cacheKey, isLaunch);
            return;
        }
        catch (IOException iOException) {
            AFLogger.afErrorLog("Exception in sendRequestToServer. ", iOException);
            boolean bl = AppsFlyerProperties.getInstance().getBoolean("useHttpFallback", false);
            if (bl) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.debugAction("https failed: " + iOException.getLocalizedMessage(), "", (Context)ctxReference.get());
                this.callServer(new URL(var1_1.replace("https:", "http:")), (String)var2_2, (String)var3_3, ctxReference, cacheKey, isLaunch);
                return;
            }
            AFLogger.afInfoLog("failed to send requeset to server. " + iOException.getLocalizedMessage());
            this.monitor((Context)ctxReference.get(), LOG_TAG, "ERROR", iOException.getLocalizedMessage());
            throw iOException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callServer(URL url, String postData, String appsFlyerDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean isLaunch) throws IOException {
        Context context = (Context)ctxReference.get();
        boolean bl = isLaunch && conversionDataListener != null;
        HttpURLConnection httpURLConnection = null;
        try {
            void var3_11;
            Object object;
            u.getInstance().addServerRequestEvent(url.toString(), postData);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            int n2 = postData.getBytes().length;
            httpURLConnection.setRequestProperty("Content-Length", "" + n2);
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setDoOutput(true);
            Object object2 = null;
            try {
                void var2_3;
                object2 = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
                ((Writer)object2).write((String)var2_3);
            }
            catch (Throwable throwable) {
                if (object2 != null) {
                    ((OutputStreamWriter)object2).close();
                }
                throw throwable;
            }
            ((OutputStreamWriter)object2).close();
            int n3 = httpURLConnection.getResponseCode();
            object2 = this.readServerResponse(httpURLConnection);
            u.getInstance().addServerResponseEvent(((URL)object).toString(), n3, (String)object2);
            AFLogger.afInfoLog("response code: " + n3);
            this.monitor(context, LOG_TAG, "SERVER_RESPONSE_CODE", Integer.toString(n3));
            this.debugAction("response from server. status=", Integer.toString(n3), context);
            object = this.getSharedPreferences(context);
            if (n3 == 200) {
                String string;
                if (ctxReference.get() != null && isLaunch) {
                    this.lastSuccessfulLaunchTimestamp = System.currentTimeMillis();
                }
                if ((string = this.getProperty("afUninstallToken")) != null) {
                    AFLogger.afDebugLog("Uninstall Token exists: " + string);
                    boolean bl2 = object.getBoolean("sentRegisterRequestToAF", false);
                    if (!bl2) {
                        AFLogger.afDebugLog("Resending Uninstall token to AF servers: " + string);
                        h h2 = new h(string);
                        com.appsflyer.a.updateServerUninstallToken(context, h2);
                    }
                } else if (this.getProperty("gcmProjectNumber") != null) {
                    AFLogger.afDebugLog("GCM Project number exists. Fetching token and sending to AF servers");
                    com.appsflyer.a.registerDeviceForUninstalls(new WeakReference<Context>(context));
                }
                if (this.latestDeepLink != null) {
                    this.latestDeepLink = null;
                }
                if (cacheKey != null) {
                    CacheManager.getInstance().deleteRequest(cacheKey, context);
                }
                if (ctxReference.get() != null && cacheKey == null) {
                    this.saveDataToSharedPreferences(context, "sentSuccessfully", "true");
                    this.checkCache(context);
                }
                JSONObject jSONObject = ServerConfigHandler.handleResponse((String)object2);
                this.isSendBackground = jSONObject.optBoolean("send_background", false);
            }
            int n4 = object.getInt("appsflyerConversionDataRequestRetries", 0);
            long l2 = object.getLong("appsflyerConversionDataCacheExpiration", 0L);
            if (l2 != 0L && System.currentTimeMillis() - l2 > 5184000000L) {
                this.saveDataToSharedPreferences(context, "attributionId", null);
                this.saveLongToSharedPreferences(context, "appsflyerConversionDataCacheExpiration", 0L);
            }
            if (object.getString("attributionId", null) == null && appsFlyerDevKey != null && bl && conversionDataListener != null && n4 <= 5) {
                object = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
                d d2 = new d(context.getApplicationContext(), appsFlyerDevKey, (ScheduledExecutorService)object);
                this.scheduleJob((ScheduledExecutorService)object, d2, 10L, TimeUnit.MILLISECONDS);
            } else if (var3_11 == null) {
                AFLogger.afWarnLog("AppsFlyer dev key is missing.");
            } else if (bl && conversionDataListener != null && object.getString("attributionId", null) != null && this.getLaunchCounter((SharedPreferences)object, false) > 1) {
                try {
                    object = this.getConversionData(context);
                    if (object != null) {
                        try {
                            if (!object.containsKey("is_first_launch")) {
                                object.put("is_first_launch", Boolean.toString(false));
                            }
                            conversionDataListener.onInstallConversionDataLoaded((Map<String, String>)object);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            AFLogger.afErrorLog(throwable.getLocalizedMessage(), throwable2);
                        }
                    }
                }
                catch (n n5) {
                    n n6 = n5;
                    AFLogger.afErrorLog(n5.getMessage(), n6);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                return;
            }
        }
        catch (Throwable throwable) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void validateAndTrackInAppPurchase(Context context, String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters) {
        u.getInstance().addApiEvent("validateAndTrackInAppPurchase", publicKey, signature, purchaseData, price, currency, additionalParameters == null ? "" : additionalParameters.toString());
        AFLogger.afInfoLog("Validate in app called with parameters: " + purchaseData + " " + price + " " + currency);
        if (publicKey == null || price == null || signature == null || currency == null || purchaseData == null) {
            if (validatorListener != null) {
                validatorListener.onValidateInAppFailure("Please provide purchase parameters");
                return;
            }
        } else {
            void var3_3;
            void var2_2;
            i i2;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
            i2 = new i(i2.getApplicationContext(), this.getProperty("AppsFlyerKey"), (String)var2_2, (String)var3_3, purchaseData, price, currency, additionalParameters, scheduledThreadPoolExecutor);
            this.scheduleJob(scheduledThreadPoolExecutor, i2, 10L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleJob(ScheduledExecutorService scheduler, Runnable job, long delay, TimeUnit timeUnits) {
        try {
            void var3_5;
            void var2_4;
            void var1_1;
            if (scheduler == null || scheduler.isShutdown() || scheduler.isTerminated()) {
                AFLogger.afWarnLog("scheduler is null, shut downed or terminated");
                return;
            }
            var1_1.schedule((Runnable)var2_4, (long)var3_5, timeUnits);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            AFLogger.afErrorLog("scheduleJob failed with RejectedExecutionException Exception", rejectedExecutionException);
            return;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("scheduleJob failed with Exception", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onHandleReferrer(Map<String, String> referrer) {
        void var1_1;
        this.installReferrerMap = var1_1;
    }

    /*
     * Loose catch block
     */
    @NonNull
    String readServerResponse(HttpURLConnection connection) {
        JSONObject jSONObject;
        Object object;
        StringBuilder stringBuilder;
        block20: {
            BufferedReader bufferedReader = null;
            stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader = null;
            object = connection.getErrorStream();
            if (object == null) {
                object = connection.getInputStream();
            }
            inputStreamReader = new InputStreamReader((InputStream)object);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((object = bufferedReader.readLine()) != null) {
                stringBuilder.append((String)object).append('\n');
            }
            try {
                bufferedReader.close();
                inputStreamReader.close();
            }
            catch (Throwable throwable) {}
            break block20;
            catch (Throwable throwable) {
                try {
                    AFLogger.afErrorLog("Could not read connection response from: " + jSONObject.getURL().toString(), throwable);
                }
                catch (Throwable throwable2) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (Throwable throwable3) {}
                    throw throwable2;
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Throwable throwable4) {}
            }
        }
        object = stringBuilder.toString();
        try {
            new JSONObject((String)object);
            return object;
        }
        catch (JSONException jSONException) {
            jSONObject = new JSONObject();
            try {
                jSONObject.put("string_response", object);
                return jSONObject.toString();
            }
            catch (JSONException jSONException2) {
                return new JSONObject().toString();
            }
        }
    }

    float getBatteryLevel(Context context) {
        int n2;
        int n3;
        float f2;
        block2: {
            Throwable throwable;
            f2 = 1.0f;
            try {
                throwable = throwable.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
                n3 = throwable.getIntExtra("level", -1);
                n2 = throwable.getIntExtra("scale", -1);
                if (n3 != -1 && n2 != -1) break block2;
                return 50.0f;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                AFLogger.afErrorLog(throwable2.getMessage(), throwable);
            }
        }
        f2 = (float)n3 / (float)n2 * 100.0f;
        return f2;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogLevel(AFLogger.LogLevel logLevel) {
        void var1_1;
        AppsFlyerProperties.getInstance().setLogLevel((AFLogger.LogLevel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setHostName(String hostname) {
        void var1_1;
        this.host = var1_1;
    }

    public String getHost() {
        return this.host;
    }

    /*
     * WARNING - void declaration
     */
    public void setMinTimeBetweenSessions(int seconds) {
        void var1_1;
        this.launchBlockingTimeWindow = TimeUnit.SECONDS.toMillis((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(AppsFlyerLib x0, Map x1) {
        void var1_1;
        x0.onAppOpenAttribution((Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(AppsFlyerLib x0, Context x1, String x2, String x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.saveDataToSharedPreferences((Context)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(AppsFlyerLib x0, Context x1, String x2, String x3, String x4, String x5, boolean x6, boolean x7) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.sendTrackingWithEvent((Context)var1_1, (String)var2_2, (String)var3_3, x4, x5, x6, x7);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(AppsFlyerLib x0, String x1, String x2, String x3, WeakReference x4, String x5, boolean x6) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.sendRequestToServer((String)var1_1, (String)var2_2, (String)var3_3, x4, x5, x6);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(AppsFlyerLib x0, Context x1, String x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.saveIntegerToSharedPreferences((Context)var1_1, (String)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1000(AppsFlyerLib x0, WeakReference x1) {
        void var1_1;
        return x0.getConfiguredChannel((WeakReference<Context>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1100(AppsFlyerLib x0, Context x1, String x2) throws PackageManager.NameNotFoundException {
        void var2_2;
        void var1_1;
        return x0.getCachedChannel((Context)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1300(AppsFlyerLib x0, Context x1, String x2, long x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.saveLongToSharedPreferences((Context)var1_1, (String)var2_2, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$1400(AppsFlyerLib x0, String x1) {
        void var1_1;
        return x0.attributionStringToMap((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$1500(AppsFlyerLib x0, Context x1) throws n {
        void var1_1;
        return x0.getConversionData((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$1702(AppsFlyerLib x0, long x1) {
        void var1_1;
        x0.lastCacheCheck = var1_1;
        return x0.lastCacheCheck;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1602(AppsFlyerLib x0, boolean x1) {
        void var1_1;
        x0.isDuringCheckCache = var1_1;
        return x0.isDuringCheckCache;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1800(AppsFlyerLib x0, String x1) {
        void var1_1;
        return x0.getProperty((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ScheduledExecutorService access$1902(AppsFlyerLib x0, ScheduledExecutorService x1) {
        void var1_1;
        x0.cacheScheduler = var1_1;
        return x0.cacheScheduler;
    }

    final class b
    implements Runnable {
        private WeakReference<Context> ctxReference = null;

        public b(Context context) {
            this.ctxReference = new WeakReference<Context>(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            if (AppsFlyerLib.this.isDuringCheckCache) {
                return;
            }
            AppsFlyerLib.access$1702(AppsFlyerLib.this, System.currentTimeMillis());
            if (this.ctxReference == null) {
                return;
            }
            AppsFlyerLib.access$1602(AppsFlyerLib.this, true);
            try {
                String string = AppsFlyerLib.access$1800(AppsFlyerLib.this, "AppsFlyerKey");
                WeakReference<Context> weakReference = this.ctxReference;
                synchronized (weakReference) {
                    for (RequestCacheData requestCacheData : CacheManager.getInstance().getCachedRequests((Context)this.ctxReference.get())) {
                        AFLogger.afInfoLog("resending request: " + requestCacheData.getRequestURL());
                        try {
                            long l2 = System.currentTimeMillis();
                            String string2 = requestCacheData.getCacheKey();
                            long l3 = Long.parseLong(string2, 10);
                            AppsFlyerLib.access$800(AppsFlyerLib.this, requestCacheData.getRequestURL() + "&isCachedRequest=true&timeincache=" + Long.toString((l2 - l3) / 1000L), requestCacheData.getPostData(), string, this.ctxReference, requestCacheData.getCacheKey(), false);
                        }
                        catch (Exception exception) {
                            AFLogger.afErrorLog("Failed to resend cached request", exception);
                        }
                    }
                }
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("failed to check cache. ", exception);
            }
            finally {
                AppsFlyerLib.access$1602(AppsFlyerLib.this, false);
            }
            AppsFlyerLib.this.cacheScheduler.shutdown();
            AppsFlyerLib.access$1902(AppsFlyerLib.this, null);
        }
    }

    abstract class a
    implements Runnable {
        WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey;
        private ScheduledExecutorService executorService;
        private AtomicInteger currentRequestsCounter = new AtomicInteger(0);

        protected abstract void attributionCallback(Map<String, String> var1);

        public abstract String getUrl();

        protected abstract void attributionCallbackFailure(String var1, int var2);

        a(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = string;
            if (scheduledExecutorService == null) {
                this.executorService = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
                return;
            }
            this.executorService = scheduledExecutorService;
        }

        @Override
        public void run() {
            block24: {
                Object object;
                HttpURLConnection httpURLConnection;
                block23: {
                    if (this.appsFlyerDevKey == null || this.appsFlyerDevKey.length() == 0) {
                        return;
                    }
                    this.currentRequestsCounter.incrementAndGet();
                    httpURLConnection = null;
                    object = (Context)this.ctxReference.get();
                    if (object != null) break block23;
                    this.currentRequestsCounter.decrementAndGet();
                    return;
                }
                try {
                    long l2 = System.currentTimeMillis();
                    CharSequence charSequence = AppsFlyerLib.access$1100(AppsFlyerLib.this, object, AppsFlyerLib.access$1000(AppsFlyerLib.this, new WeakReference<Context>((Context)object)));
                    String string = "";
                    if (charSequence != null) {
                        if (!IGNORABLE_CHANNELS.contains(((String)charSequence).toLowerCase())) {
                            string = "-" + (String)charSequence;
                        } else {
                            AFLogger.afWarnLog(String.format("AF detected using redundant Google-Play channel for attribution - %s. Using without channel postfix.", charSequence));
                        }
                    }
                    charSequence = new StringBuilder().append(this.getUrl()).append(object.getPackageName()).append(string).append("?devkey=").append(this.appsFlyerDevKey).append("&device_id=").append(s.id(new WeakReference<Context>((Context)object)));
                    u.getInstance().addServerRequestEvent(((StringBuilder)charSequence).toString(), "");
                    com.appsflyer.a.logMessageMaskKey("Calling server for attribution url: " + ((StringBuilder)charSequence).toString());
                    httpURLConnection = (HttpURLConnection)new URL(((StringBuilder)charSequence).toString()).openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setConnectTimeout(10000);
                    httpURLConnection.setRequestProperty("Connection", "close");
                    httpURLConnection.connect();
                    int n2 = httpURLConnection.getResponseCode();
                    String string2 = AppsFlyerLib.this.readServerResponse(httpURLConnection);
                    u.getInstance().addServerResponseEvent(((StringBuilder)charSequence).toString(), n2, string2);
                    if (n2 == 200) {
                        long l3 = System.currentTimeMillis();
                        AppsFlyerLib.access$1300(AppsFlyerLib.this, object, "appsflyerGetConversionDataTiming", (l3 - l2) / 1000L);
                        com.appsflyer.a.logMessageMaskKey("Attribution data: " + string2);
                        if (string2.length() <= 0 || object == null) break block24;
                        Map map = AppsFlyerLib.access$1400(AppsFlyerLib.this, string2);
                        String string3 = (String)map.get("iscache");
                        if (string3 != null && Boolean.toString(false).equals(string3)) {
                            AppsFlyerLib.access$1300(AppsFlyerLib.this, object, "appsflyerConversionDataCacheExpiration", System.currentTimeMillis());
                        }
                        if (map.containsKey("af_siteid")) {
                            if (map.containsKey("af_channel")) {
                                AFLogger.afDebugLog("[Invite] Detected App-Invite via channel: " + (String)map.get("af_channel"));
                            } else {
                                AFLogger.afDebugLog(String.format("[CrossPromotion] App was installed via %s's Cross Promotion", map.get("af_siteid")));
                            }
                        }
                        if (map.containsKey("af_siteid")) {
                            AFLogger.afDebugLog("[Invite] Detected App-Invite via channel: " + (String)map.get("af_channel"));
                        }
                        map.put("is_first_launch", Boolean.toString(false));
                        charSequence = new JSONObject(map).toString();
                        if (charSequence != null) {
                            AppsFlyerLib.access$400(AppsFlyerLib.this, object, "attributionId", (String)charSequence);
                        } else {
                            AppsFlyerLib.access$400(AppsFlyerLib.this, object, "attributionId", string2);
                        }
                        AFLogger.afDebugLog("iscache=" + string3 + " caching conversion data");
                        if (conversionDataListener == null || this.currentRequestsCounter.intValue() > 1) break block24;
                        try {
                            object = AppsFlyerLib.access$1500(AppsFlyerLib.this, object);
                        }
                        catch (n n3) {
                            AFLogger.afErrorLog("Exception while trying to fetch attribution data. ", n3);
                            object = map;
                        }
                        this.attributionCallback((Map<String, String>)object);
                        break block24;
                    }
                    if (conversionDataListener != null) {
                        this.attributionCallbackFailure("Error connection to server: " + n2, n2);
                    }
                    com.appsflyer.a.logMessageMaskKey("AttributionIdFetcher response code: " + n2 + "  url: " + charSequence);
                }
                catch (Throwable throwable) {
                    if (conversionDataListener != null) {
                        this.attributionCallbackFailure(throwable.getMessage(), 0);
                    }
                    AFLogger.afErrorLog(throwable.getMessage(), throwable);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.currentRequestsCounter.decrementAndGet();
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
            this.executorService.shutdown();
        }
    }

    final class d
    extends a {
        public d(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
            super(context, string, scheduledExecutorService);
        }

        @Override
        public final String getUrl() {
            return ServerConfigHandler.getUrl("https://api.%s/install_data/v3/");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void attributionCallback(Map<String, String> conversionData) {
            void var1_1;
            conversionData.put("is_first_launch", Boolean.toString(true));
            conversionDataListener.onInstallConversionDataLoaded((Map<String, String>)var1_1);
            AppsFlyerLib.access$900(AppsFlyerLib.this, (Context)this.ctxReference.get(), "appsflyerConversionDataRequestRetries", 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void attributionCallbackFailure(String error, int responseCode) {
            void var2_3;
            SharedPreferences sharedPreferences;
            conversionDataListener.onInstallConversionFailure((String)sharedPreferences);
            if (responseCode >= 400 && var2_3 < 500) {
                sharedPreferences = AppsFlyerLib.this.getSharedPreferences((Context)this.ctxReference.get());
                int n2 = sharedPreferences.getInt("appsflyerConversionDataRequestRetries", 0);
                AppsFlyerLib.access$900(AppsFlyerLib.this, (Context)this.ctxReference.get(), "appsflyerConversionDataRequestRetries", ++n2);
            }
        }
    }

    final class e
    implements Runnable {
        private String urlString;
        private WeakReference<Context> ctxReference = null;
        Map<String, Object> params;
        boolean isLaunch;
        private int launchCounter;

        private e(String string, Map<String, Object> map, Context context, boolean bl, int n2) {
            this.urlString = string;
            this.params = map;
            this.ctxReference = new WeakReference<Context>(context);
            this.isLaunch = bl;
            this.launchCounter = n2;
        }

        @Override
        public final void run() {
            String string = null;
            if (this.isLaunch && this.launchCounter <= 2 && AppsFlyerLib.this.isInstallReferrerAvailable()) {
                this.params.put("rfr", AppsFlyerLib.this.installReferrerMap);
            }
            try {
                String string2 = (String)this.params.get("appsflyerKey");
                string = AFHelper.convertToJsonObject(this.params).toString();
                AppsFlyerLib.access$800(AppsFlyerLib.this, this.urlString, string, string2, this.ctxReference, null, this.isLaunch);
                return;
            }
            catch (IOException iOException) {
                AFLogger.afErrorLog("Exception while sending request to server. ", iOException);
                if (string != null && this.ctxReference != null && !this.urlString.contains("&isCachedRequest=true&timeincache=")) {
                    CacheManager.getInstance().cacheRequest(new RequestCacheData(this.urlString, string, "4.8.6"), (Context)this.ctxReference.get());
                    AFLogger.afErrorLog(iOException.getMessage(), iOException);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AFLogger.afErrorLog(throwable.getMessage(), throwable2);
                return;
            }
        }
    }

    final class c
    implements Runnable {
        private WeakReference<Context> context;
        private String appsFlyerKey;
        private String eventName;
        private String eventValue;
        private String referrer;
        private ExecutorService executor;
        private boolean isNewAPI;
        private boolean isBackgroundReferrerLaunch;

        private c(WeakReference<Context> weakReference, String string, String string2, String string3, String string4, boolean bl, ExecutorService executorService, boolean bl2) {
            this.context = weakReference;
            this.appsFlyerKey = string;
            this.eventName = string2;
            this.eventValue = string3;
            this.referrer = string4;
            this.isNewAPI = bl;
            this.executor = executorService;
            this.isBackgroundReferrerLaunch = bl2;
        }

        @Override
        public final void run() {
            AppsFlyerLib.access$500(AppsFlyerLib.this, (Context)this.context.get(), this.appsFlyerKey, this.eventName, this.eventValue, this.referrer, this.isNewAPI, this.isBackgroundReferrerLaunch);
        }
    }
}

