/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.cache;

import android.content.Context;
import android.util.Log;
import com.appsflyer.cache.RequestCacheData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final int CACHE_MAX_SIZE = 40;
    public static final String AF_CACHE_DIR = "AFRequestCache";
    private static CacheManager \u02cb = new CacheManager();

    public static CacheManager getInstance() {
        return \u02cb;
    }

    private CacheManager() {
    }

    public void init(Context context) {
        try {
            Context context2 = context;
            if (!new File(context2.getFilesDir(), AF_CACHE_DIR).exists()) {
                context2 = context;
                new File(context2.getFilesDir(), AF_CACHE_DIR).mkdir();
            }
            return;
        }
        catch (Exception exception) {
            Log.i((String)"AppsFlyer_4.8.17", (String)"Could not create cache directory");
            return;
        }
    }

    /*
     * Loose catch block
     */
    public void cacheRequest(RequestCacheData requestCacheData, Context object) {
        Writer writer = null;
        Object object2 = object;
        object2 = new File(object2.getFilesDir(), AF_CACHE_DIR);
        if (!((File)object2).exists()) {
            ((File)object2).mkdir();
            return;
        }
        if ((object2 = ((File)object2).listFiles()) != null && ((Object)object2).length > 40) {
            Log.i((String)"AppsFlyer_4.8.17", (String)"reached cache limit, not caching request");
            return;
        }
        Log.i((String)"AppsFlyer_4.8.17", (String)"caching request...");
        object2 = object;
        object = new File(new File(object2.getFilesDir(), AF_CACHE_DIR), Long.toString(System.currentTimeMillis()));
        ((File)object).createNewFile();
        writer = new OutputStreamWriter(new FileOutputStream(((File)object).getPath(), true));
        writer.write("version=");
        writer.write(requestCacheData.getVersion());
        writer.write(10);
        writer.write("url=");
        writer.write(requestCacheData.getRequestURL());
        writer.write(10);
        writer.write("data=");
        writer.write(requestCacheData.getPostData());
        writer.write(10);
        writer.flush();
        try {
            writer.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            try {
                Log.i((String)"AppsFlyer_4.8.17", (String)"Could not cache request");
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public List<RequestCacheData> getCachedRequests(Context object) {
        ArrayList<RequestCacheData> arrayList = new ArrayList<RequestCacheData>();
        try {
            object = new File(object.getFilesDir(), AF_CACHE_DIR);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            } else {
                for (File file : ((File)object).listFiles()) {
                    Log.i((String)"AppsFlyer_4.8.17", (String)("Found cached request" + file.getName()));
                    arrayList.add(CacheManager.\u02cb(file));
                }
            }
        }
        catch (Exception exception) {
            Log.i((String)"AppsFlyer_4.8.17", (String)"Could not cache request");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RequestCacheData \u02cb(File object) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader((File)object);
            Object object2 = new char[(int)((File)object).length()];
            fileReader.read((char[])object2);
            RequestCacheData requestCacheData = new RequestCacheData((char[])object2);
            object2 = requestCacheData;
            requestCacheData.setCacheKey(((File)object).getName());
            object = object2;
        }
        catch (Exception exception) {
            try {
                if (fileReader == null) return null;
                ((Reader)fileReader).close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (Throwable throwable) {
            try {
                if (fileReader == null) throw throwable;
                ((Reader)fileReader).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)fileReader).close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
    }

    public void deleteRequest(String string, Context object) {
        object = new File(object.getFilesDir(), AF_CACHE_DIR);
        object = new File((File)object, string);
        Log.i((String)"AppsFlyer_4.8.17", (String)("Deleting " + string + " from cache"));
        if (((File)object).exists()) {
            try {
                ((File)object).delete();
                return;
            }
            catch (Exception exception) {
                Log.i((String)"AppsFlyer_4.8.17", (String)("Could not delete " + string + " from cache"), (Throwable)exception);
            }
        }
    }

    public void clearCache(Context context) {
        try {
            Object object = context;
            object = new File(object.getFilesDir(), AF_CACHE_DIR);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
                return;
            }
            for (File file : ((File)object).listFiles()) {
                Log.i((String)"AppsFlyer_4.8.17", (String)("Found cached request" + file.getName()));
                this.deleteRequest(CacheManager.\u02cb(file).getCacheKey(), context);
            }
            return;
        }
        catch (Exception exception) {
            Log.i((String)"AppsFlyer_4.8.17", (String)"Could not cache request");
            return;
        }
    }
}

