/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.UUID;

class Installation {
    private static String sID = null;
    private static final String INSTALLATION = "AF_INSTALLATION";

    Installation() {
    }

    public static synchronized String id(WeakReference<Context> context) {
        if (context.get() == null) {
            return sID;
        }
        if (sID == null) {
            String tmpSId = Installation.readInstallationSP(context);
            if (tmpSId != null) {
                sID = tmpSId;
            } else {
                try {
                    File installation = new File(((Context)context.get()).getFilesDir(), INSTALLATION);
                    if (!installation.exists()) {
                        sID = Installation.generateId(context);
                    } else {
                        sID = Installation.readInstallationFile(installation);
                        installation.delete();
                    }
                    Installation.writeInstallationSP(context, sID);
                }
                catch (Exception e) {
                    AFLogger.afLogE("Error getting AF unique ID", e);
                }
            }
            if (sID != null) {
                AppsFlyerProperties.getInstance().set("uid", sID);
            }
        }
        return sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInstallationFile(File installation) {
        RandomAccessFile f = null;
        byte[] bytes = null;
        try {
            f = new RandomAccessFile(installation, "r");
            bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            f.close();
        }
        catch (IOException e) {
            AFLogger.afLogE("Exception while reading InstallationFile: ", e);
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (IOException e) {
                AFLogger.afLogE("Exception while trying to close the InstallationFile", e);
            }
        }
        return new String(bytes != null ? bytes : new byte[]{});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInstallationFile(File installation, WeakReference<Context> context) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(installation);
            String id = Installation.generateId(context);
            out.write(id.getBytes());
            out.close();
        }
        catch (PackageManager.NameNotFoundException | IOException e) {
            AFLogger.afLogE("Exception while writing InstallationFile", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                AFLogger.afLogE("Exception while trying to close InstallationFile", e);
            }
        }
    }

    private static String generateId(WeakReference<Context> context) throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = ((Context)context.get()).getPackageManager().getPackageInfo(((Context)context.get()).getPackageName(), 0);
        String id = Build.VERSION.SDK_INT >= 9 ? packageInfo.firstInstallTime + "-" + Math.abs(new Random().nextLong()) : UUID.randomUUID().toString();
        return id;
    }

    private static String readInstallationSP(WeakReference<Context> context) {
        if (context.get() == null) {
            return null;
        }
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences("appsflyer-data", 0);
        return sharedPreferences.getString(INSTALLATION, null);
    }

    private static void writeInstallationSP(WeakReference<Context> context) throws PackageManager.NameNotFoundException {
        Installation.writeInstallationSP(context, Installation.generateId(context));
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void writeInstallationSP(WeakReference<Context> context, String sId) throws PackageManager.NameNotFoundException {
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences("appsflyer-data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(INSTALLATION, sId);
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }
}

