/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.appsflyer.AFKeystoreWrapper;
import com.appsflyer.AdvertisingIdClient;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.DebugLogQueue;
import com.appsflyer.cache.CacheManager;
import com.appsflyer.cache.RequestCacheData;
import com.appsflyer.d;
import com.appsflyer.h;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.iid.InstanceID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppsFlyerLib {
    public static final String JENKINS_BUILD_NUMBER = "284";
    public static final String BUILD_NUMBER = "4.6.1";
    public static final String SERVER_BUILD_NUMBER = "4.6.1".substring(0, "4.6.1".indexOf("."));
    public static final String SDK_BUILD_NUMBER = "4.6.1".substring("4.6.1".indexOf(".") + 1);
    public static final String LOG_TAG = "AppsFlyer_" + SDK_BUILD_NUMBER;
    public static final String APPS_TRACKING_URL = "https://t.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + SDK_BUILD_NUMBER + "&app_id=";
    public static final String EVENTS_TRACKING_URL = "https://events.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + SDK_BUILD_NUMBER + "&app_id=";
    private static final String REGISTER_URL = "https://register.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + SDK_BUILD_NUMBER + "&app_id=";
    public static final String ATTRIBUTION_ID_CONTENT_URI = "content://com.facebook.katana.provider.AttributionIdProvider";
    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final List<String> IGNORABLE_KEYS = Arrays.asList("is_cache");
    private static String userCustomImei;
    private static String userCustomAndroidId;
    public static final String PRE_INSTALL_SYSTEM_RO_PROP = "ro.appsflyer.preinstall.path";
    public static final String PRE_INSTALL_SYSTEM_DEFAULT = "/data/local/tmp/pre_install.appsflyer";
    public static final String PRE_INSTALL_SYSTEM_DEFAULT_ETC = "/etc/pre_install.appsflyer";
    private static AppsFlyerConversionListener conversionDataListener;
    private static AppsFlyerInAppPurchaseValidatorListener validatorListener;
    private static boolean isDuringCheckCache;
    private static long lastCacheCheck;
    private static ScheduledExecutorService cacheScheduler;
    private static long timeInApp;
    private static AppsFlyerLib instance;
    Uri latestDeepLink = null;
    private d.a listener;
    private long testModeStartTime;
    private boolean isRetargetingTestMode = false;
    private String pushPayload;
    private Map<Long, String> pushPayloadHistory;

    void onReceive(Context context, Intent intent) {
        String string = intent.getStringExtra("shouldMonitor");
        if (string != null) {
            com.appsflyer.a.afLog("Turning on monitoring.");
            AppsFlyerProperties.getInstance().set("shouldMonitor", string.equals("true"));
            this.monitor(context, null, "START_TRACKING", context.getPackageName());
            return;
        }
        com.appsflyer.a.afLog("****** onReceive called *******");
        this.debugAction("******* onReceive: ", "", context);
        AppsFlyerProperties.getInstance().setOnReceiveCalled();
        String string2 = intent.getStringExtra("referrer");
        com.appsflyer.a.afLog("Play store referrer: " + string2);
        if (string2 != null) {
            String string3 = intent.getStringExtra("TestIntegrationMode");
            if (string3 != null && string3.equals("AppsFlyer_Test")) {
                SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.clear();
                this.editorCommit(editor);
                AppsFlyerProperties.getInstance().setFirstLaunchCalled(false);
                this.startTestMode();
            }
            this.debugAction("onReceive called. referrer: ", string2, context);
            this.saveDataToSharedPreferences(context, "referrer", string2);
            AppsFlyerProperties.getInstance().setReferrer(string2);
            if (AppsFlyerProperties.getInstance().isFirstLaunchCalled()) {
                com.appsflyer.a.afLog("onReceive: isLaunchCalled");
                this.runInBackground(context, null, null, null, string2, false);
            }
        }
    }

    void addReferrer(Context context, String referrer) {
        com.appsflyer.a.afDebugLog("received a new (extra) referrer: " + referrer);
        try {
            JSONArray jSONArray;
            JSONObject jSONObject;
            long l = System.currentTimeMillis();
            SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
            String string = sharedPreferences.getString("extraReferrers", null);
            if (string == null) {
                jSONObject = new JSONObject();
                jSONArray = new JSONArray();
            } else {
                jSONObject = new JSONObject(string);
                jSONArray = jSONObject.has(referrer) ? new JSONArray((String)jSONObject.get(referrer)) : new JSONArray();
            }
            jSONArray.put(l);
            jSONObject.put(referrer, (Object)jSONArray.toString());
            this.saveDataToSharedPreferences(context, "extraReferrers", jSONObject.toString());
        }
        catch (JSONException jSONException) {
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLogE("Couldn't save referrer - " + referrer + ": ", throwable);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void editorCommit(SharedPreferences.Editor editor) {
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    private void startTestMode() {
        com.appsflyer.a.afLog("Test mode started..");
        this.testModeStartTime = System.currentTimeMillis();
    }

    private void endTestMode() {
        com.appsflyer.a.afLog("Test mode ended!");
        this.testModeStartTime = 0L;
    }

    private boolean isInTestMode(String referrer) {
        long l = System.currentTimeMillis() - this.testModeStartTime;
        return l <= 30000L && referrer != null && referrer.contains("AppsFlyer_Test");
    }

    private AppsFlyerLib() {
    }

    public static AppsFlyerLib getInstance() {
        return instance;
    }

    public String getSdkVersion() {
        return "version: 4.6.1 (build 284)";
    }

    private void registerForAppEvents(Application application) {
        if (this.listener == null) {
            AppsFlyerProperties.getInstance().loadProperties(application.getApplicationContext());
            if (Build.VERSION.SDK_INT >= 14) {
                com.appsflyer.d.init(application);
                this.listener = new d.a(){

                    @Override
                    public void onBecameForeground(Activity currentActivity) {
                        com.appsflyer.a.afLog("onBecameForeground");
                        timeInApp = System.currentTimeMillis();
                        AppsFlyerLib.this.trackEvent((Context)currentActivity, null, null);
                    }

                    @Override
                    public void onBecameBackground(WeakReference<Activity> currentActivity) {
                        com.appsflyer.a.afLog("onBecameBackground");
                        com.appsflyer.a.afLog("callStatsBackground background call");
                        WeakReference<Context> weakReference = new WeakReference<Context>(((Activity)currentActivity.get()).getApplicationContext());
                        AppsFlyerLib.this.callStatsBackground(weakReference);
                    }
                };
                com.appsflyer.d.getInstance().registerListener(this.listener);
            } else {
                com.appsflyer.a.afLog("SDK<14 call trackAppLaunch manually");
                this.trackEvent(application.getApplicationContext(), null, null);
            }
        }
    }

    private synchronized void registerOnGCM(final Context context) {
        final String string = this.getProperty("gcmProjectNumber");
        if (string != null && this.getProperty("gcmToken") == null) {
            new AsyncTask<Void, Void, com.appsflyer.e>(){

                protected com.appsflyer.e doInBackground(Void ... params) {
                    try {
                        Class.forName("com.google.android.gms.iid.InstanceID");
                        Class.forName("com.google.android.gms.gcm.GcmReceiver");
                        InstanceID instanceID = InstanceID.getInstance((Context)context);
                        String string3 = instanceID.getToken(string, "GCM", null);
                        String string2 = instanceID.getId();
                        return new com.appsflyer.e(System.currentTimeMillis(), string3, string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        com.appsflyer.a.afLog("Please integrate Google Play Services in order to support uninstall feature");
                    }
                    catch (IOException iOException) {
                        com.appsflyer.a.afLog("Could not load registration ID");
                    }
                    catch (Throwable throwable) {
                        com.appsflyer.a.afLog("Error registering for uninstall feature");
                    }
                    return null;
                }

                protected void onPostExecute(com.appsflyer.e newGcmToken) {
                    if (newGcmToken != null) {
                        String string4 = AppsFlyerLib.this.getProperty("gcmToken");
                        String string2 = AppsFlyerLib.this.getProperty("gcmInstanceId");
                        String string3 = AppsFlyerLib.this.getProperty("gcmTokenTimestamp");
                        com.appsflyer.e e2 = new com.appsflyer.e(string3, string4, string2);
                        if (e2.update(newGcmToken)) {
                            com.appsflyer.a.afLog("token=" + e2.getToken());
                            com.appsflyer.a.afLog("instance id=" + e2.getInstanceId());
                            AppsFlyerLib.this.updateServerGcmToken(e2, context);
                        }
                    }
                }
            }.execute((Object[])new Void[0]);
        }
    }

    void updateServerGcmToken(com.appsflyer.e existingGcmToken, Context context) {
        com.appsflyer.a.afLog("updateServerGcmToken called");
        AppsFlyerProperties.getInstance().set("gcmToken", existingGcmToken.getToken());
        AppsFlyerProperties.getInstance().set("gcmInstanceId", existingGcmToken.getInstanceId());
        AppsFlyerProperties.getInstance().set("gcmTokenTimestamp", String.valueOf(existingGcmToken.getTokenTimestamp()));
        this.callRegisterBackground(context);
    }

    @Deprecated
    public void setGCMProjectID(String id) {
        this.setGCMProjectNumber(id);
    }

    @Deprecated
    public void setGCMProjectNumber(String id) {
        AppsFlyerProperties.getInstance().set("gcmProjectNumber", id);
    }

    public void setGCMProjectNumber(Context context, String id) {
        this.setProperty("gcmProjectNumber", id);
        AppsFlyerProperties.getInstance().loadProperties(context);
        this.registerOnGCM(context);
    }

    public void setDebugLog(boolean shouldEnable) {
        AppsFlyerProperties.getInstance().enableLogOutput(shouldEnable);
    }

    public void setImeiData(String aImei) {
        userCustomImei = aImei;
    }

    public void setAndroidIdData(String aAndroidId) {
        userCustomAndroidId = aAndroidId;
    }

    private void debugAction(String actionMsg, String parameter, Context context) {
        try {
            if (this.isAppsFlyerPackage(context)) {
                DebugLogQueue.getInstance().push(actionMsg + parameter);
            }
        }
        catch (Exception exception) {
            com.appsflyer.a.afLog(exception.toString());
        }
    }

    private boolean isAppsFlyerPackage(Context context) {
        return context != null && context.getPackageName().length() > 12 && "com.appsflyer".equals(context.getPackageName().toLowerCase().substring(0, 13));
    }

    private void saveDataToSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        this.editorCommit(editor);
    }

    private void saveIntegerToSharedPreferences(Context context, String key, int value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        this.editorCommit(editor);
    }

    private void saveLongToSharedPreferences(Context context, String key, long value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(key, value);
        this.editorCommit(editor);
    }

    private void setProperty(String key, String value) {
        AppsFlyerProperties.getInstance().set(key, value);
    }

    private String getProperty(String key) {
        return AppsFlyerProperties.getInstance().getString(key);
    }

    @Deprecated
    public void setAppUserId(String id) {
        this.setCustomerUserId(id);
    }

    public void setCustomerUserId(String id) {
        com.appsflyer.a.afLog("setCustomerUserId = " + id);
        this.setProperty("AppUserId", id);
    }

    public void setAdditionalData(HashMap<String, Object> customData) {
        JSONObject jSONObject = new JSONObject(customData);
        AppsFlyerProperties.getInstance().setCustomData(jSONObject.toString());
    }

    public void sendDeepLinkData(Activity activity) {
        com.appsflyer.a.afLog("getDeepLinkData with activity " + activity.getIntent().getDataString());
        this.registerForAppEvents(activity.getApplication());
    }

    public void sendPushNotificationData(Activity activity) {
        this.pushPayload = this.getPushPayloadFromIntent((Context)activity);
        if (this.pushPayload != null) {
            long l;
            long l2 = l = System.currentTimeMillis();
            if (this.pushPayloadHistory == null) {
                com.appsflyer.a.afLog("pushes: initializing pushes history..");
                this.pushPayloadHistory = new ConcurrentHashMap<Long, String>();
            } else {
                try {
                    long l3 = AppsFlyerProperties.getInstance().getLong("pushPayloadMaxAging", 1800000L);
                    for (Long l4 : this.pushPayloadHistory.keySet()) {
                        JSONObject jSONObject = new JSONObject(this.pushPayload);
                        JSONObject jSONObject2 = new JSONObject(this.pushPayloadHistory.get(l4));
                        if (jSONObject.get("pid").equals(jSONObject2.get("pid"))) {
                            com.appsflyer.a.afLog("PushNotificationMeasurement: A previous payload with same PID was already acknowledged! (old: " + jSONObject2 + ", new: " + jSONObject + ")");
                            this.pushPayload = null;
                            return;
                        }
                        if (l - l4 > l3) {
                            this.pushPayloadHistory.remove(l4);
                        }
                        if (l4 > l2) continue;
                        l2 = l4;
                    }
                }
                catch (Throwable throwable) {
                    com.appsflyer.a.afLog("Error while handling push notification measurement: " + throwable.getClass().getSimpleName());
                }
            }
            int n = AppsFlyerProperties.getInstance().getInt("pushPayloadHistorySize", 2);
            if (this.pushPayloadHistory.size() == n) {
                com.appsflyer.a.afLog("pushes: removing oldest overflowing push (oldest push:" + l2 + ")");
                this.pushPayloadHistory.remove(l2);
            }
            this.pushPayloadHistory.put(l, this.pushPayload);
            this.registerForAppEvents(activity.getApplication());
        }
    }

    @Deprecated
    public void setUserEmail(String email) {
        this.setProperty("userEmail", email);
    }

    public void setUserEmails(String ... emails) {
        this.setUserEmails(AppsFlyerProperties.EmailsCryptType.NONE, emails);
    }

    public void setUserEmails(AppsFlyerProperties.EmailsCryptType cryptMethod, String ... emails) {
        AppsFlyerProperties.getInstance().set("userEmailsCryptType", cryptMethod.getValue());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : emails) {
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        switch (cryptMethod) {
            default: {
                hashMap.put("sha1_el_arr", com.appsflyer.f.toSHA1(stringBuilder.toString()));
                break;
            }
            case MD5: {
                hashMap.put("md5_el_arr", com.appsflyer.f.toMD5(stringBuilder.toString()));
                break;
            }
            case NONE: {
                hashMap.put("plain_el_arr", stringBuilder.toString());
            }
        }
        JSONObject jSONObject = new JSONObject(hashMap);
        AppsFlyerProperties.getInstance().setUserEmails(jSONObject.toString());
    }

    public void setCollectAndroidID(boolean isCollect) {
        this.setProperty("collectAndroidId", Boolean.toString(isCollect));
    }

    public void setCollectIMEI(boolean isCollect) {
        this.setProperty("collectIMEI", Boolean.toString(isCollect));
    }

    public void setCollectFingerPrint(boolean isCollect) {
        this.setProperty("collectFingerPrint", Boolean.toString(isCollect));
    }

    public void startTracking(Application application, String key) {
        com.appsflyer.a.afLogM("Build Number: 284");
        this.setProperty("AppsFlyerKey", key);
        h.setDevKey(key);
        this.registerForAppEvents(application);
        if (AppsFlyerProperties.getInstance().getString("gcmToken") == null && AppsFlyerProperties.getInstance().getString("gcmProjectNumber") != null) {
            com.appsflyer.a.afLog("Found a 'Google Project Number' without token. Registering on GCM to get token..");
            this.registerOnGCM(application.getApplicationContext());
        }
    }

    private void getReInstallData(Context context) {
        if (Build.VERSION.SDK_INT >= 18) {
            AFKeystoreWrapper aFKeystoreWrapper = new AFKeystoreWrapper(context);
            if (!aFKeystoreWrapper.loadData()) {
                aFKeystoreWrapper.createFirstInstallData(com.appsflyer.g.id(new WeakReference<Context>(context)));
                this.setProperty("KSAppsFlyerId", aFKeystoreWrapper.getUid());
                this.setProperty("KSAppsFlyerRICounter", String.valueOf(aFKeystoreWrapper.getReInstallCounter()));
            } else {
                aFKeystoreWrapper.incrementReInstallCounter();
                this.setProperty("KSAppsFlyerId", aFKeystoreWrapper.getUid());
                this.setProperty("KSAppsFlyerRICounter", String.valueOf(aFKeystoreWrapper.getReInstallCounter()));
            }
        }
    }

    public String getAppUserId() {
        return this.getProperty("AppUserId");
    }

    public void setAppId(String id) {
        this.setProperty("appid", id);
    }

    public String getAppId() {
        return this.getProperty("appid");
    }

    public void setExtension(String extension) {
        AppsFlyerProperties.getInstance().set("sdkExtension", extension);
    }

    public void setIsUpdate(boolean isUpdate) {
        AppsFlyerProperties.getInstance().set("IS_UPDATE", isUpdate);
    }

    public void setCurrencyCode(String currencyCode) {
        AppsFlyerProperties.getInstance().set("currencyCode", currencyCode);
    }

    public void trackLocation(Context context, double latitude, double longitude) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("af_long", Double.toString(longitude));
        hashMap.put("af_lat", Double.toString(latitude));
        this.trackEvent(context, "af_location_coordinates", hashMap);
    }

    private void callStatsBackground(WeakReference<Context> context) {
        Object object;
        if (context.get() == null) {
            return;
        }
        com.appsflyer.a.afLog("app went to background");
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences("appsflyer-data", 0);
        AppsFlyerProperties.getInstance().saveProperties(sharedPreferences);
        long l = System.currentTimeMillis() - timeInApp;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.getProperty("AppsFlyerKey");
        String string2 = this.getProperty("KSAppsFlyerId");
        hashMap.put("app_id", ((Context)context.get()).getPackageName());
        hashMap.put("devkey", string);
        hashMap.put("uid", com.appsflyer.g.id(context));
        hashMap.put("time_in_app", String.valueOf(l / 1000L));
        hashMap.put("statType", "user_closed_app");
        hashMap.put("platform", "Android");
        hashMap.put("launch_counter", Integer.toString(this.getCounter(sharedPreferences, "appsFlyerCount", false)));
        hashMap.put("gcd_conversion_data_timing", Long.toString(sharedPreferences.getLong("appsflyerGetConversionDataTiming", 0L)));
        hashMap.put("channel", this.getConfiguredChannel(context));
        hashMap.put("originalAppsflyerId", string2 != null ? string2 : "");
        String string3 = AppsFlyerProperties.getInstance().getString("advertiserId");
        hashMap.put("advertiserId", string3 != null ? string3 : "");
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
        if (bl && (object = this.getUniquePsuedoID()) != null) {
            hashMap.put("deviceFingerPrintId", (String)object);
        }
        try {
            object = new com.appsflyer.c(null);
            ((com.appsflyer.c)((Object)object)).bodyParameters = hashMap;
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                com.appsflyer.a.afDebugLog("Main thread detected. Running callStats task in a new thread.");
                object.execute((Object[])new String[]{"https://stats.appsflyer.com/stats"});
            } else {
                com.appsflyer.a.afDebugLog("Running callStats task (on current thread: " + Thread.currentThread().toString() + " )");
                ((com.appsflyer.c)((Object)object)).onPreExecute();
                ((com.appsflyer.c)((Object)object)).onPostExecute(((com.appsflyer.c)((Object)object)).doInBackground("https://stats.appsflyer.com/stats"));
            }
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLogE("Could not send callStats request", throwable);
        }
    }

    public void trackAppLaunch(Context ctx, String devKey) {
        this.runInBackground(ctx, devKey, null, null, "", true);
    }

    public void reportTrackSession(Context ctx) {
        this.trackEvent(ctx, null, null);
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        JSONObject jSONObject = new JSONObject((Map)(eventValues == null ? new HashMap() : eventValues));
        String string = AppsFlyerProperties.getInstance().getReferrer(context);
        this.runInBackground(context, null, eventName, jSONObject.toString(), string == null ? "" : string, true);
    }

    private void monitor(Context context, String eventIdentifier, String message, String value) {
        if (AppsFlyerProperties.getInstance().getBoolean("shouldMonitor", false)) {
            Intent intent = new Intent("com.appsflyer.MonitorBroadcast");
            intent.setPackage("com.appsflyer.nightvision");
            intent.putExtra("message", message);
            intent.putExtra("value", value);
            intent.putExtra("packageName", "true");
            intent.putExtra("pid", (Serializable)new Integer(Process.myPid()));
            intent.putExtra("eventIdentifier", eventIdentifier);
            intent.putExtra("sdk", SERVER_BUILD_NUMBER + '.' + SDK_BUILD_NUMBER);
            context.sendBroadcast(intent);
        }
    }

    private void callRegisterBackground(Context context) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getProperty("AppsFlyerKey");
        hashMap.put("devkey", string2);
        hashMap.put("uid", com.appsflyer.g.id(new WeakReference<Context>(context)));
        hashMap.put("af_gcm_token", AppsFlyerProperties.getInstance().getString("gcmToken"));
        hashMap.put("advertiserId", AppsFlyerProperties.getInstance().getString("advertiserId"));
        hashMap.put("af_google_instance_id", AppsFlyerProperties.getInstance().getString("gcmInstanceId"));
        hashMap.put("launch_counter", Integer.toString(this.getCounter(context.getSharedPreferences("appsflyer-data", 0), "appsFlyerCount", false)));
        hashMap.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
        hashMap.put("channel", this.getConfiguredChannel(new WeakReference<Context>(context)));
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            long l = packageInfo.firstInstallTime;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmssZ", Locale.US);
            hashMap.put("install_date", simpleDateFormat.format(new Date(l)));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
        if (bl && (string = this.getUniquePsuedoID()) != null) {
            hashMap.put("deviceFingerPrintId", string);
        }
        try {
            com.appsflyer.c c2 = new com.appsflyer.c(context);
            c2.bodyParameters = hashMap;
            String string3 = REGISTER_URL + context.getPackageName();
            c2.execute(new String[]{string3});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void broadcastBacktoTestApp(Context context, HashMap<String, String> params) {
        Intent intent = new Intent("com.appsflyer.testIntgrationBroadcast");
        intent.putExtra("params", params);
        context.sendBroadcast(intent);
    }

    public void setDeviceTrackingDisabled(boolean isDisabled) {
        AppsFlyerProperties.getInstance().set("deviceTrackingDisabled", isDisabled);
    }

    private Map<String, String> getConversionData(Context context) throws com.appsflyer.b {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        String string = AppsFlyerProperties.getInstance().getReferrer(context);
        if (string != null && string.length() > 0 && string.contains("af_tranid")) {
            return this.referrerStringToMap(context, string);
        }
        String string2 = sharedPreferences.getString("attributionId", null);
        if (string2 != null && string2.length() > 0) {
            return this.attributionStringToMap(string2);
        }
        throw new com.appsflyer.b();
    }

    public void registerConversionListener(Context context, AppsFlyerConversionListener conversionDataListener) {
        if (conversionDataListener == null) {
            return;
        }
        AppsFlyerLib.conversionDataListener = conversionDataListener;
    }

    public void unregisterConversionListener() {
        conversionDataListener = null;
    }

    public void registerValidatorListener(Context context, AppsFlyerInAppPurchaseValidatorListener validationListener) {
        com.appsflyer.a.afDebugLog("registerValidatorListener called");
        if (validationListener == null) {
            com.appsflyer.a.afDebugLog("registerValidatorListener null listener");
            return;
        }
        validatorListener = validationListener;
    }

    private Map<String, String> referrerStringToMap(Context context, String referrer) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        PackageInfo packageInfo = referrer.split("&");
        boolean bl = false;
        for (Object object : packageInfo) {
            String string;
            int n = ((String)object).indexOf("=");
            String string2 = string = n > 0 ? ((String)object).substring(0, n) : object;
            if (!linkedHashMap.containsKey(string)) {
                if (string.equals("c")) {
                    string = "campaign";
                } else if (string.equals("pid")) {
                    string = "media_source";
                } else if (string.equals("af_prt")) {
                    bl = true;
                    string = "agency";
                }
                linkedHashMap.put(string, new String());
            }
            String string3 = n > 0 && ((String)object).length() > n + 1 ? ((String)object).substring(n + 1) : null;
            linkedHashMap.put(string, string3);
        }
        try {
            if (!linkedHashMap.containsKey("install_time")) {
                Object object;
                PackageInfo packageInfo2 = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                long l = packageInfo2.firstInstallTime;
                object = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                linkedHashMap.put("install_time", ((DateFormat)object).format(new Date(l)));
            }
        }
        catch (Exception exception) {
            com.appsflyer.a.afWarnLog("Could not fetch install time");
        }
        if (!linkedHashMap.containsKey("af_status")) {
            linkedHashMap.put("af_status", "Non-organic");
        }
        if (bl) {
            linkedHashMap.remove("media_source");
        }
        return linkedHashMap;
    }

    private Map<String, String> attributionStringToMap(String inputString) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JSONObject jSONObject = new JSONObject(inputString);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (IGNORABLE_KEYS.contains(string)) continue;
                hashMap.put(string, jSONObject.getString(string));
            }
        }
        catch (JSONException jSONException) {
            com.appsflyer.a.afWarnLog(jSONException.getMessage());
            return null;
        }
        return hashMap;
    }

    private void runInBackground(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isNewAPI) {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.schedule(new d(new WeakReference<Context>(context), appsFlyerKey, eventName, eventValue, referrer, isNewAPI, scheduledExecutorService), 5L, TimeUnit.MILLISECONDS);
    }

    private void sendTrackingWithEvent(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isUseNewAPI) {
        if (context == null) {
            return;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        AppsFlyerProperties.getInstance().saveProperties(sharedPreferences);
        com.appsflyer.a.afLog("sendTrackingWithEvent from activity: " + context.getClass().getName().toString());
        boolean bl = eventName == null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.addAdvertiserIDData(context, hashMap);
        hashMap.put("af_timestamp", Long.toString(new Date().getTime()));
        try {
            JSONObject jSONObject;
            String string;
            String string2;
            Object object;
            Object object2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            Object object3;
            StringBuilder stringBuilder;
            this.debugAction("collect data for server", "", context);
            com.appsflyer.a.afLog("******* sendTrackingWithEvent: " + (bl ? "Launch" : eventName));
            this.debugAction("********* sendTrackingWithEvent: ", bl ? "Launch" : eventName, context);
            this.monitor(context, LOG_TAG, "EVENT_CREATED_WITH_NAME", bl ? "Launch" : eventName);
            CacheManager.getInstance().init(context);
            try {
                stringBuilder = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                object3 = Arrays.asList(((PackageInfo)stringBuilder).requestedPermissions);
                if (!object3.contains("android.permission.INTERNET")) {
                    com.appsflyer.a.afWarnLog("Permission android.permission.INTERNET is missing in the AndroidManifest.xml");
                    this.monitor(context, null, "PERMISSION_INTERNET_MISSING", null);
                }
                if (!object3.contains("android.permission.ACCESS_NETWORK_STATE")) {
                    com.appsflyer.a.afWarnLog("Permission android.permission.ACCESS_NETWORK_STATE is missing in the AndroidManifest.xml");
                }
                if (!object3.contains("android.permission.ACCESS_WIFI_STATE")) {
                    com.appsflyer.a.afWarnLog("Permission android.permission.ACCESS_WIFI_STATE is missing in the AndroidManifest.xml");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append(bl ? APPS_TRACKING_URL : EVENTS_TRACKING_URL).append(context.getPackageName());
            if (isUseNewAPI) {
                hashMap.put("af_events_api", "1");
            }
            hashMap.put("brand", Build.BRAND);
            hashMap.put("device", Build.DEVICE);
            hashMap.put("product", Build.PRODUCT);
            hashMap.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
            hashMap.put("model", Build.MODEL);
            hashMap.put("deviceType", Build.TYPE);
            if (bl) {
                if (this.isAppsFlyerFirstLaunch(context)) {
                    if (!AppsFlyerProperties.getInstance().isOtherSdkStringDisabled()) {
                        hashMap.put("af_sdks", this.generateOtherSDKsString());
                        float f2 = this.getBatteryLevel(context);
                        hashMap.put("batteryLevel", String.valueOf(f2));
                    }
                    this.getReInstallData(context);
                }
            } else {
                this.lastEventsProcessing(context, hashMap, eventName, eventValue);
            }
            object3 = this.getProperty("KSAppsFlyerId");
            String string15 = this.getProperty("KSAppsFlyerRICounter");
            if (object3 != null && string15 != null && Integer.valueOf(string15) > 0) {
                hashMap.put("reinstallCounter", string15);
                hashMap.put("originalAppsflyerId", (String)object3);
            }
            if ((string14 = this.getProperty("additionalCustomData")) != null) {
                hashMap.put("customData", string14);
            }
            try {
                string13 = context.getPackageManager().getInstallerPackageName(context.getPackageName());
                if (string13 != null) {
                    hashMap.put("installer_package", string13);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string13 = AppsFlyerProperties.getInstance().getString("sdkExtension");
            if (string13 != null && string13.length() > 0) {
                hashMap.put("sdkExtension", string13);
            }
            if ((string12 = this.getCachedChannel(context, string11 = this.getConfiguredChannel(new WeakReference<Context>(context)))) != null) {
                hashMap.put("channel", string12);
            }
            if (string12 != null && !string12.equals(string11) || string12 == null && string11 != null) {
                hashMap.put("af_latestchannel", string11);
            }
            if ((string10 = this.getCachedStore(context)) != null) {
                hashMap.put("af_installstore", string10.toLowerCase());
            }
            if ((string9 = this.getPreInstallName(context)) != null) {
                hashMap.put("af_preinstall_name", string9.toLowerCase());
            }
            if ((string8 = this.getCurrentStore(context)) != null) {
                hashMap.put("af_currentstore", string8.toLowerCase());
            }
            if (appsFlyerKey != null && appsFlyerKey.length() >= 0) {
                hashMap.put("appsflyerKey", appsFlyerKey);
            } else {
                string7 = this.getProperty("AppsFlyerKey");
                if (string7 != null && string7.length() >= 0) {
                    hashMap.put("appsflyerKey", string7);
                } else {
                    com.appsflyer.a.afLog("AppsFlyer dev key is missing!!! Please use  AppsFlyerLib.getInstance().setAppsFlyerKey(...) to set it. ");
                    this.monitor(context, LOG_TAG, "DEV_KEY_MISSING", null);
                    com.appsflyer.a.afLog("AppsFlyer will not track this event.");
                    return;
                }
            }
            string7 = this.getAppUserId();
            if (string7 != null) {
                hashMap.put("appUserId", string7);
            }
            if ((string6 = AppsFlyerProperties.getInstance().getString("userEmails")) != null) {
                hashMap.put("user_emails", string6);
            } else {
                string5 = this.getProperty("userEmail");
                if (string5 != null) {
                    hashMap.put("sha1_el", com.appsflyer.f.toSHA1(string5));
                }
            }
            if (eventName != null) {
                hashMap.put("eventName", eventName);
                if (eventValue != null) {
                    hashMap.put("eventValue", eventValue);
                }
            }
            if (this.getProperty("appid") != null) {
                hashMap.put("appid", this.getProperty("appid"));
            }
            if ((string5 = this.getProperty("currencyCode")) != null) {
                if (string5.length() != 3) {
                    com.appsflyer.a.afWarnLog("WARNING: currency code should be 3 characters!!! '" + string5 + "' is not a legal value.");
                }
                hashMap.put("currency", string5);
            }
            if ((string4 = this.getProperty("IS_UPDATE")) != null) {
                hashMap.put("isUpdate", string4);
            }
            boolean bl2 = this.isPreInstalledApp(context);
            hashMap.put("af_preinstalled", Boolean.toString(bl2));
            boolean bl3 = AppsFlyerProperties.getInstance().getBoolean("collectFacebookAttrId", true);
            if (bl3 && (string3 = this.getAttributionId(context.getContentResolver())) != null) {
                hashMap.put("fb", string3);
            }
            this.addDeviceTracking(context, hashMap);
            try {
                string3 = com.appsflyer.g.id(new WeakReference<Context>(context));
                if (string3 != null) {
                    hashMap.put("uid", string3);
                }
            }
            catch (Exception exception) {
                com.appsflyer.a.afLog("ERROR: " + "ERROR: " + "could not get uid " + exception.getMessage());
            }
            try {
                hashMap.put("lang", Locale.getDefault().getDisplayLanguage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hashMap.put("lang_code", Locale.getDefault().getLanguage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hashMap.put("country", Locale.getDefault().getCountry());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string3 = (TelephonyManager)context.getSystemService("phone");
                hashMap.put("operator", string3.getSimOperatorName());
                hashMap.put("carrier", string3.getNetworkOperatorName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hashMap.put("network", this.getNetwork(context));
            }
            catch (Throwable throwable) {
                com.appsflyer.a.afLog("checking network error " + throwable.getMessage());
            }
            boolean bl4 = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
            if (bl4 && (object2 = this.getUniquePsuedoID()) != null) {
                hashMap.put("deviceFingerPrintId", (String)object2);
            }
            this.checkPlatform(context, hashMap);
            object2 = new SimpleDateFormat("yyyy-MM-dd_HHmmssZ", Locale.US);
            if (Build.VERSION.SDK_INT >= 9) {
                try {
                    long l = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
                    hashMap.put("installDate", ((DateFormat)object2).format(new Date(l)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                object = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                int n = sharedPreferences.getInt("versionCode", 0);
                if (((PackageInfo)object).versionCode > n) {
                    this.saveIntegerToSharedPreferences(context, "appsflyerConversionDataRequestRetries", 0);
                    this.saveIntegerToSharedPreferences(context, "versionCode", ((PackageInfo)object).versionCode);
                }
                hashMap.put("app_version_code", Integer.toString(((PackageInfo)object).versionCode));
                hashMap.put("app_version_name", ((PackageInfo)object).versionName);
                if (Build.VERSION.SDK_INT >= 9) {
                    long l = ((PackageInfo)object).firstInstallTime;
                    long l2 = ((PackageInfo)object).lastUpdateTime;
                    hashMap.put("date1", ((DateFormat)object2).format(new Date(l)));
                    hashMap.put("date2", ((DateFormat)object2).format(new Date(l2)));
                    String string16 = this.getFirstInstallDate((SimpleDateFormat)object2, context);
                    hashMap.put("firstLaunchDate", string16);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (referrer.length() > 0) {
                hashMap.put("referrer", referrer);
            }
            if ((object = sharedPreferences.getString("attributionId", null)) != null && ((String)object).length() > 0) {
                hashMap.put("installAttribution", (String)object);
            }
            if ((string2 = sharedPreferences.getString("extraReferrers", null)) != null) {
                hashMap.put("extraReferrers", string2);
            }
            if ((string = AppsFlyerProperties.getInstance().getString("gcmInstanceId")) != null) {
                hashMap.put("af_google_instance_id", string);
            }
            if (bl) {
                if (this.pushPayload != null) {
                    jSONObject = new JSONObject(this.pushPayload);
                    jSONObject.put("isPush", (Object)"true");
                    hashMap.put("af_deeplink", jSONObject.toString());
                }
                this.pushPayload = null;
            }
            if (bl && context instanceof Activity) {
                jSONObject = this.getDeepLinkUri(context);
                if (jSONObject != null) {
                    this.handleDeepLinkCallback(context, hashMap, (Uri)jSONObject);
                } else if (this.latestDeepLink != null) {
                    this.handleDeepLinkCallback(context, hashMap, this.latestDeepLink);
                }
            }
            if (this.isRetargetingTestMode) {
                hashMap.put("testAppMode_retargeting", "true");
                AppsFlyerLib.broadcastBacktoTestApp(context, hashMap);
                com.appsflyer.a.afLog("Sent retargeting params to test app");
            }
            if (this.isInTestMode(referrer)) {
                hashMap.put("testAppMode", "true");
                AppsFlyerLib.broadcastBacktoTestApp(context, hashMap);
                com.appsflyer.a.afLog("Sent params to test app");
                this.endTestMode();
            }
            if (this.getProperty("advertiserId") == null) {
                this.addAdvertiserIDData(context, hashMap);
                if (this.getProperty("advertiserId") != null) {
                    hashMap.put("GAID_retry", "true");
                } else {
                    hashMap.put("GAID_retry", "false");
                }
            }
            com.appsflyer.a.afLog("AppsFlyerLib.sendTrackingWithEvent");
            new f(stringBuilder.toString(), hashMap, context.getApplicationContext(), bl).run();
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLogE(throwable.getLocalizedMessage(), throwable);
        }
    }

    private String getPushPayloadFromIntent(Context context) {
        Bundle bundle;
        Intent intent;
        String string = null;
        if (context instanceof Activity && (intent = ((Activity)context).getIntent()) != null && (bundle = intent.getExtras()) != null && (string = bundle.getString("af")) != null) {
            com.appsflyer.a.afLog("Push Notification received af payload = " + string);
            bundle.remove("af");
            ((Activity)context).setIntent(intent.putExtras(bundle));
        }
        return string;
    }

    private Uri getDeepLinkUri(Context context) {
        Uri uri = null;
        Intent intent = ((Activity)context).getIntent();
        if (intent != null && "android.intent.action.VIEW".equals(intent.getAction())) {
            uri = intent.getData();
        }
        return uri;
    }

    private void handleDeepLinkCallback(Context context, Map<String, String> params, Uri uri) {
        Map<Object, Object> map;
        String string;
        params.put("af_deeplink", uri.toString());
        if (uri.getQueryParameter("af_deeplink") != null) {
            string = uri.getQueryParameter("media_source");
            String string2 = uri.getQueryParameter("is_retargeting");
            if (string != null && string2 != null && string.equals("AppsFlyer_Test") && string2.equals("true")) {
                this.isRetargetingTestMode = true;
            }
            map = this.referrerStringToMap(context, uri.getQuery().toString());
            if (uri.getPath() != null) {
                map.put("path", uri.getPath());
            }
            if (uri.getScheme() != null) {
                map.put("scheme", uri.getScheme());
            }
            if (uri.getHost() != null) {
                map.put("host", uri.getHost());
            }
        } else {
            map = new HashMap<String, String>();
            map.put("link", uri.toString());
        }
        string = new JSONObject(map).toString();
        this.saveDataToSharedPreferences(context, "deeplinkAttribution", string);
        if (conversionDataListener != null) {
            conversionDataListener.onAppOpenAttribution(map);
        }
    }

    private String generateOtherSDKsString() {
        return "" + this.numricBooleanIsClassExist("com.tune.Tune") + this.numricBooleanIsClassExist("com.adjust.sdk.Adjust") + this.numricBooleanIsClassExist("com.kochava.android.tracker.Feature") + this.numricBooleanIsClassExist("io.branch.referral.Branch") + this.numricBooleanIsClassExist("com.apsalar.sdk.Apsalar") + this.numricBooleanIsClassExist("com.localytics.android.Localytics") + this.numricBooleanIsClassExist("com.tenjin.android.TenjinSDK") + this.numricBooleanIsClassExist("com.talkingdata.sdk.TalkingDataSDK") + this.numricBooleanIsClassExist("it.partytrack.sdk.Track") + this.numricBooleanIsClassExist("jp.appAdForce.android.LtvManager");
    }

    private int numricBooleanIsClassExist(String className) {
        try {
            Class.forName(className);
            return 1;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private void lastEventsProcessing(Context context, Map<String, String> params, String newEventName, String newEventValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            String string = sharedPreferences.getString("prev_event_name", null);
            if (string != null) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("prev_event_timestamp", (Object)(sharedPreferences.getLong("prev_event_timestamp", -1L) + ""));
                jSONObject.put("prev_event_value", (Object)sharedPreferences.getString("prev_event_value", null));
                jSONObject.put("prev_event_name", (Object)string);
                params.put("prev_event", jSONObject.toString());
            }
            editor.putString("prev_event_name", newEventName);
            editor.putString("prev_event_value", newEventValue);
            editor.putLong("prev_event_timestamp", System.currentTimeMillis());
            this.editorCommit(editor);
        }
        catch (Exception exception) {
            com.appsflyer.a.afLogE("Error while processing previous event.", exception);
        }
    }

    private boolean isGooglePlayServicesAvailable(Context context) {
        boolean bl = false;
        try {
            int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            if (n == 0) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLog("WARNING: Google play services is unavailable.");
        }
        return bl;
    }

    private void addDeviceTracking(Context context, Map<String, String> params) {
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (bl) {
            params.put("deviceTrackingDisabled", "true");
        } else {
            String string;
            SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
            boolean bl2 = AppsFlyerProperties.getInstance().getBoolean("collectIMEI", true);
            String string2 = sharedPreferences.getString("imeiCached", null);
            String string3 = null;
            if (bl2) {
                if (this.isIdCollectionAllowed(context)) {
                    try {
                        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                        string = (String)telephonyManager.getClass().getMethod("getDeviceId", new Class[0]).invoke((Object)telephonyManager, new Object[0]);
                        if (string != null) {
                            string3 = string;
                        } else if (userCustomImei != null) {
                            string3 = userCustomImei;
                        } else if (string2 != null) {
                            string3 = string2;
                        }
                    }
                    catch (Exception exception) {
                        com.appsflyer.a.afLog("WARNING: READ_PHONE_STATE is missing");
                    }
                } else if (userCustomImei != null) {
                    string3 = userCustomImei;
                }
            } else if (userCustomImei != null) {
                string3 = userCustomImei;
            }
            if (string3 != null) {
                this.saveDataToSharedPreferences(context, "imeiCached", string3);
                params.put("imei", string3);
            } else {
                com.appsflyer.a.afLog("IMEI was not collected.");
            }
            boolean bl3 = AppsFlyerProperties.getInstance().getBoolean("collectAndroidId", true);
            string = sharedPreferences.getString("androidIdCached", null);
            String string4 = null;
            if (bl3) {
                if (this.isIdCollectionAllowed(context)) {
                    try {
                        String string5 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                        if (string5 != null) {
                            string4 = string5;
                        } else if (userCustomAndroidId != null) {
                            string4 = userCustomAndroidId;
                        } else if (string != null) {
                            string4 = string;
                        }
                    }
                    catch (Exception exception) {}
                } else if (userCustomAndroidId != null) {
                    string4 = userCustomAndroidId;
                }
            } else if (userCustomAndroidId != null) {
                string4 = userCustomAndroidId;
            }
            if (string4 != null) {
                this.saveDataToSharedPreferences(context, "androidIdCached", string4);
                params.put("android_id", string4);
            } else {
                com.appsflyer.a.afLog("Android ID was not collected.");
            }
        }
    }

    private boolean isIdCollectionAllowed(Context context) {
        return Build.VERSION.SDK_INT < 19 || !this.isGooglePlayServicesAvailable(context);
    }

    private boolean isAppsFlyerFirstLaunch(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        return !sharedPreferences.contains("appsFlyerCount");
    }

    private String getCachedStore(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        if (sharedPreferences.contains("INSTALL_STORE")) {
            return sharedPreferences.getString("INSTALL_STORE", null);
        }
        boolean bl = this.isAppsFlyerFirstLaunch(context);
        String string = bl ? this.getCurrentStore(context) : null;
        this.saveDataToSharedPreferences(context, "INSTALL_STORE", string);
        return string;
    }

    private String getCurrentStore(Context context) {
        return this.getManifestMetaData(new WeakReference<Context>(context), "AF_STORE");
    }

    public String getSystemProperty(String key) {
        String string = null;
        try {
            string = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class).invoke(null, key);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private String getManifestMetaData(WeakReference<Context> context, String key) {
        if (context.get() == null) {
            return null;
        }
        return this.getManifestMetaData(key, ((Context)context.get()).getPackageManager(), ((Context)context.get()).getPackageName());
    }

    private String getManifestMetaData(String key, PackageManager packageManager, String packageName) {
        String string = null;
        try {
            Object object;
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 128);
            Bundle bundle = applicationInfo.metaData;
            if (bundle != null && (object = bundle.get(key)) != null) {
                string = object.toString();
            }
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLogE("Could not find " + key + " value in the manifest", throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String preInstallValueFromFile(Context context) {
        InputStreamReader inputStreamReader = null;
        String string = this.getSystemProperty(PRE_INSTALL_SYSTEM_RO_PROP);
        if (string == null) {
            string = this.getManifestMetaData(new WeakReference<Context>(context), "AF_PRE_INSTALL_PATH");
        }
        if (string == null) {
            string = PRE_INSTALL_SYSTEM_DEFAULT;
        }
        try {
            File file = new File(string);
            if (!file.exists()) {
                string = PRE_INSTALL_SYSTEM_DEFAULT_ETC;
            }
            Properties properties = new Properties();
            inputStreamReader = new FileReader(string);
            properties.load(inputStreamReader);
            com.appsflyer.a.afLog("Found pre_install definition");
            String string2 = properties.getProperty(context.getPackageName());
            return string2;
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private String getPreInstallName(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        String string = null;
        if (sharedPreferences.contains("preInstallName")) {
            string = sharedPreferences.getString("preInstallName", null);
        } else {
            boolean bl = this.isAppsFlyerFirstLaunch(context);
            if (bl) {
                String string2 = this.preInstallValueFromFile(context);
                string = string2 != null ? string2 : this.getManifestMetaData(new WeakReference<Context>(context), "AF_PRE_INSTALL_NAME");
            }
            if (string != null) {
                this.saveDataToSharedPreferences(context, "preInstallName", string);
            }
        }
        return string;
    }

    private void checkCache(Context context) {
        if (isDuringCheckCache || System.currentTimeMillis() - lastCacheCheck < 15000L) {
            return;
        }
        if (cacheScheduler != null) {
            return;
        }
        cacheScheduler = Executors.newSingleThreadScheduledExecutor();
        cacheScheduler.schedule(new c(context), 1L, TimeUnit.SECONDS);
    }

    private String getConfiguredChannel(WeakReference<Context> context) {
        String string = AppsFlyerProperties.getInstance().getString("channel");
        if (string == null) {
            string = this.getManifestMetaData(context, "CHANNEL");
        }
        return string;
    }

    public boolean isPreInstalledApp(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            if ((applicationInfo.flags & 1) != 0) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            com.appsflyer.a.afLogE("Could not check if app is pre installed", nameNotFoundException);
        }
        return false;
    }

    private String getCachedChannel(Context context, String currentChannel) throws PackageManager.NameNotFoundException {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        if (sharedPreferences.contains("CACHED_CHANNEL")) {
            return sharedPreferences.getString("CACHED_CHANNEL", null);
        }
        this.saveDataToSharedPreferences(context, "CACHED_CHANNEL", currentChannel);
        return currentChannel;
    }

    private String getFirstInstallDate(SimpleDateFormat dateFormat, Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        String string = sharedPreferences.getString("appsFlyerFirstInstall", null);
        if (string == null) {
            if (this.isAppsFlyerFirstLaunch(context)) {
                com.appsflyer.a.afDebugLog("AppsFlyer: first launch detected");
                string = dateFormat.format(new Date());
            } else {
                string = "";
            }
            this.saveDataToSharedPreferences(context, "appsFlyerFirstInstall", string);
        }
        com.appsflyer.a.afLog("AppsFlyer: first launch date: " + string);
        return string;
    }

    private void addAdvertiserIDData(Context context, Map<String, String> params) {
        int n;
        String string;
        boolean bl;
        String string2;
        String string3;
        block16: {
            com.appsflyer.a.afLog("Trying to fetch GAID..");
            string3 = null;
            string2 = null;
            bl = false;
            string = null;
            n = -1;
            try {
                Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                AdvertisingIdClient.Info info = com.google.android.gms.ads.identifier.AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                if (info != null) {
                    string3 = info.getId();
                    string2 = Boolean.toString(!info.isLimitAdTrackingEnabled());
                    bl = true;
                    if (string3 == null || string3.length() == 0) {
                        string = "emptyOrNull";
                    }
                } else {
                    string = "gpsAdInfo-null";
                }
            }
            catch (Throwable throwable) {
                try {
                    n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                string = throwable.getClass().getSimpleName();
                com.appsflyer.a.afLog("WARNING: Google Play Services is missing.");
                if (!AppsFlyerProperties.getInstance().getBoolean("enableGpsFallback", true)) break block16;
                try {
                    AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                    if (adInfo != null) {
                        string3 = adInfo.getId();
                        string2 = Boolean.toString(!adInfo.isLimitAdTrackingEnabled());
                        if (string3 == null || string3.length() == 0) {
                            string = "emptyOrNull (bypass)";
                        }
                    } else {
                        string = "gpsAdInfo-null (bypass)";
                    }
                }
                catch (Throwable throwable3) {
                    string = string + "/" + throwable3.getClass().getSimpleName();
                    this.debugAction("GAID", "\tgot error: " + throwable3.getMessage(), context);
                    string3 = AppsFlyerProperties.getInstance().getString("advertiserId");
                    string2 = AppsFlyerProperties.getInstance().getString("advertiserIdEnabled");
                    if (throwable3.getLocalizedMessage() != null) {
                        com.appsflyer.a.afLog(throwable3.getLocalizedMessage());
                    } else {
                        com.appsflyer.a.afLog(throwable3.toString());
                    }
                    this.debugAction("Could not fetch advertiser id: ", throwable3.getLocalizedMessage(), context);
                }
            }
        }
        if (string != null) {
            params.put("gaidError", n + ": " + string);
        }
        if (string3 != null && string2 != null) {
            params.put("advertiserId", string3);
            params.put("advertiserIdEnabled", string2);
            AppsFlyerProperties.getInstance().set("advertiserId", string3);
            AppsFlyerProperties.getInstance().set("advertiserIdEnabled", string2);
            params.put("isGaidWithGps", String.valueOf(bl));
        }
    }

    private void checkPlatform(Context context, Map<String, String> params) {
        String string = "com.unity3d.player.UnityPlayer";
        try {
            Class<?> clazz = Class.forName(string);
            params.put("platformextension", "android_unity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            params.put("platformextension", "android_native");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributionId(ContentResolver contentResolver) {
        String[] stringArray = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
        Cursor cursor = contentResolver.query(Uri.parse((String)ATTRIBUTION_ID_CONTENT_URI), stringArray, null, null, null);
        String string = null;
        try {
            if (cursor == null || !cursor.moveToFirst()) {
                String string2 = null;
                return string2;
            }
            string = cursor.getString(cursor.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
        }
        catch (Exception exception) {
            com.appsflyer.a.afWarnLog("Could not collect cursor attribution" + exception);
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    private int getCounter(SharedPreferences sharedPreferences, String parameterName, boolean isIncrease) {
        int n = sharedPreferences.getInt(parameterName, 0);
        if (isIncrease) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(parameterName, ++n);
            this.editorCommit(editor);
        }
        return n;
    }

    private long getTimePassedSinceLastLaunch(Context context, boolean shouldSave) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        long l = sharedPreferences.getLong("AppsFlyerTimePassedSincePrevLaunch", 0L);
        long l2 = System.currentTimeMillis();
        long l3 = l > 0L ? l2 - l : -1L;
        if (shouldSave) {
            this.saveLongToSharedPreferences(context, "AppsFlyerTimePassedSincePrevLaunch", l2);
        }
        return l3 / 1000L;
    }

    public String getUniquePsuedoID() {
        String string = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
        String string2 = null;
        try {
            string2 = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(string.hashCode(), string2.hashCode()).toString();
        }
        catch (Exception exception) {
            string2 = "serial";
            return new UUID(string.hashCode(), string2.hashCode()).toString();
        }
    }

    private String getNetwork(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            if (networkInfo.getType() == 1) {
                return "WIFI";
            }
            if (networkInfo.getType() == 0) {
                return "MOBILE";
            }
        }
        return "unknown";
    }

    public String getAppsFlyerUID(Context context) {
        return com.appsflyer.g.id(new WeakReference<Context>(context));
    }

    private void sendRequestToServer(String urlString, String postDataString, String afDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean shouldRequestConversion) throws IOException {
        URL uRL = new URL(urlString);
        com.appsflyer.a.afLog("url: " + uRL.toString());
        this.debugAction("call server.", "\n" + uRL.toString() + "\nPOST:" + postDataString, (Context)ctxReference.get());
        h.logMessageMaskKey("data: " + postDataString);
        this.monitor((Context)ctxReference.get(), LOG_TAG, "EVENT_DATA", postDataString);
        try {
            this.callServer(uRL, postDataString, afDevKey, ctxReference, cacheKey, shouldRequestConversion);
        }
        catch (IOException iOException) {
            boolean bl = AppsFlyerProperties.getInstance().getBoolean("useHttpFallback", false);
            if (bl) {
                this.debugAction("https failed: " + iOException.getLocalizedMessage(), "", (Context)ctxReference.get());
                this.callServer(new URL(urlString.replace("https:", "http:")), postDataString, afDevKey, ctxReference, cacheKey, shouldRequestConversion);
            }
            com.appsflyer.a.afLog("failed to send requeset to server. " + iOException.getLocalizedMessage());
            this.monitor((Context)ctxReference.get(), LOG_TAG, "ERROR", iOException.getLocalizedMessage());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callServer(URL url, String postData, String appsFlyerDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean shouldRequestConversion) throws IOException {
        block19: {
            Context context = (Context)ctxReference.get();
            HttpURLConnection httpURLConnection = null;
            try {
                httpURLConnection = (HttpURLConnection)url.openConnection();
                httpURLConnection.setRequestMethod("POST");
                int n = postData.getBytes().length;
                httpURLConnection.setRequestProperty("Content-Length", n + "");
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                httpURLConnection.setConnectTimeout(10000);
                httpURLConnection.setDoOutput(true);
                try (OutputStreamWriter outputStreamWriter = null;){
                    outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
                    outputStreamWriter.write(postData);
                }
                int n2 = httpURLConnection.getResponseCode();
                com.appsflyer.a.afLogM("response code: " + n2);
                this.monitor(context, LOG_TAG, "SERVER_RESPONSE_CODE", Integer.toString(n2));
                this.debugAction("response from server. status=", Integer.toString(n2), context);
                SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
                if (n2 == 200) {
                    if (this.latestDeepLink != null) {
                        this.latestDeepLink = null;
                    }
                    if (cacheKey != null) {
                        CacheManager.getInstance().deleteRequest(cacheKey, context);
                    }
                    if (ctxReference.get() != null && cacheKey == null) {
                        this.saveDataToSharedPreferences(context, "sentSuccessfully", "true");
                        this.checkCache(context);
                    }
                }
                int n3 = sharedPreferences.getInt("appsflyerConversionDataRequestRetries", 0);
                long l = sharedPreferences.getLong("appsflyerConversionDataCacheExpiration", 0L);
                if (l != 0L && System.currentTimeMillis() - l > 5184000000L) {
                    this.saveDataToSharedPreferences(context, "attributionId", null);
                    this.saveLongToSharedPreferences(context, "appsflyerConversionDataCacheExpiration", 0L);
                }
                if (sharedPreferences.getString("attributionId", null) == null && appsFlyerDevKey != null && shouldRequestConversion && conversionDataListener != null && n3 <= 5) {
                    ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
                    scheduledExecutorService.schedule(new e(context.getApplicationContext(), appsFlyerDevKey, scheduledExecutorService), 10L, TimeUnit.MILLISECONDS);
                    break block19;
                }
                if (appsFlyerDevKey == null) {
                    com.appsflyer.a.afWarnLog("AppsFlyer dev key is missing.");
                    break block19;
                }
                if (!shouldRequestConversion || conversionDataListener == null || sharedPreferences.getString("attributionId", null) == null || this.getCounter(sharedPreferences, "appsFlyerCount", false) <= 1) break block19;
                try {
                    Map<String, String> map = this.getConversionData(context);
                    if (map != null) {
                        conversionDataListener.onInstallConversionDataLoaded(map);
                    }
                }
                catch (com.appsflyer.b b2) {
                    // empty catch block
                }
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
    }

    public void validateAndTrackInAppPurchase(Context context, String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters) {
        com.appsflyer.a.afLog("Validate in app called with parameters: " + purchaseData + " " + price + " " + currency);
        if (publicKey == null || price == null || signature == null || currency == null || purchaseData == null) {
            if (validatorListener != null) {
                validatorListener.onValidateInAppFailure("Please provide purchase parameters");
            }
        } else {
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutorService.schedule(new a(context.getApplicationContext(), this.getProperty("AppsFlyerKey"), publicKey, signature, purchaseData, price, currency, additionalParameters, scheduledExecutorService), 10L, TimeUnit.MILLISECONDS);
        }
    }

    public String mapToString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : params.keySet()) {
            String string2 = params.get(string);
            String string3 = string2 = string2 == null ? "" : URLEncoder.encode(string2, "UTF-8");
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string).append('=').append(string2);
        }
        return stringBuilder.toString();
    }

    public float getBatteryLevel(Context context) {
        float f2 = 1.0f;
        try {
            Intent intent = context.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            int n = intent.getIntExtra("level", -1);
            int n2 = intent.getIntExtra("scale", -1);
            if (n == -1 || n2 == -1) {
                return 50.0f;
            }
            f2 = (float)n / (float)n2 * 100.0f;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return f2;
    }

    static {
        conversionDataListener = null;
        validatorListener = null;
        isDuringCheckCache = false;
        cacheScheduler = null;
        instance = new AppsFlyerLib();
    }

    private abstract class g
    implements Runnable {
        protected WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey;
        private String googlePublicKey;
        private String signature;
        private String purchaseData;
        private String price;
        private String currency;
        private HashMap<String, String> additionalParams;
        private ScheduledExecutorService executorService;

        protected abstract void validateCallback(boolean var1, String var2, String var3, String var4, HashMap<String, String> var5, String var6);

        public abstract String getUrl();

        public g(Context context, String string, String string2, String string3, String string4, String string5, String string6, HashMap<String, String> hashMap, ScheduledExecutorService scheduledExecutorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = string;
            this.googlePublicKey = string2;
            this.purchaseData = string4;
            this.price = string5;
            this.currency = string6;
            this.additionalParams = hashMap;
            this.signature = string3;
            this.executorService = scheduledExecutorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.appsFlyerDevKey == null || this.appsFlyerDevKey.length() == 0) {
                return;
            }
            HttpURLConnection httpURLConnection = null;
            try {
                String string;
                Context context = (Context)this.ctxReference.get();
                if (context == null) {
                    return;
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("app_id", context.getPackageName());
                hashMap.put("dev_key", this.appsFlyerDevKey);
                hashMap.put("public-key", this.googlePublicKey);
                hashMap.put("sig-data", this.purchaseData);
                hashMap.put("signature", this.signature);
                JSONObject jSONObject = new JSONObject(hashMap);
                String string2 = jSONObject.toString();
                URL uRL = new URL(this.getUrl());
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("POST");
                int n = string2.getBytes().length;
                httpURLConnection.setRequestProperty("Content-Length", n + "");
                httpURLConnection.setRequestProperty("Connection", "close");
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                httpURLConnection.setConnectTimeout(10000);
                httpURLConnection.setDoOutput(true);
                try (OutputStreamWriter outputStreamWriter = null;){
                    outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
                    outputStreamWriter.write(string2);
                }
                int n2 = httpURLConnection.getResponseCode();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
                String string3 = stringBuilder.toString();
                JSONObject jSONObject2 = new JSONObject(string3);
                if (n2 == 200) {
                    com.appsflyer.a.afLog("Validate response 200 ok: " + jSONObject2.toString());
                    boolean bl = jSONObject2.getBoolean("result");
                    this.validateCallback(bl, this.purchaseData, this.price, this.currency, this.additionalParams, null);
                } else {
                    com.appsflyer.a.afLog("Failed Validate request");
                    this.validateCallback(false, this.purchaseData, this.price, this.currency, this.additionalParams, string3);
                }
            }
            catch (Throwable throwable) {
                if (validatorListener != null) {
                    com.appsflyer.a.afLog("Failed Validate request + ex = " + throwable.getMessage());
                    this.validateCallback(false, this.purchaseData, this.price, this.currency, this.additionalParams, throwable.getMessage());
                }
                com.appsflyer.a.afLogE(throwable.getMessage(), throwable);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            this.executorService.shutdown();
        }
    }

    private class a
    extends g {
        public a(Context context, String string, String string2, String string3, String string4, String string5, String string6, HashMap<String, String> hashMap, ScheduledExecutorService scheduledExecutorService) {
            super(context, string, string2, string3, string4, string5, string6, hashMap, scheduledExecutorService);
        }

        @Override
        public String getUrl() {
            return "https://sdk-services.appsflyer.com/validate-android-signature";
        }

        @Override
        protected void validateCallback(boolean validated, String purchaseData, String price, String currency, HashMap<String, String> additionalParams, String error) {
            if (validatorListener != null) {
                com.appsflyer.a.afLog("Validate callback parameters: " + purchaseData + " " + price + " " + currency);
                if (error == null) {
                    if (validated) {
                        com.appsflyer.a.afLog("Validate in app purchase success");
                        validatorListener.onValidateInApp();
                    } else {
                        com.appsflyer.a.afLog("Validate in app purchase failed");
                        validatorListener.onValidateInAppFailure("Failed validating");
                    }
                } else {
                    validatorListener.onValidateInAppFailure(error);
                    com.appsflyer.a.afLog("Validate in app purchase failed: error : " + error);
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("af_validated", validated);
                hashMap.put("af_param_2", purchaseData);
                hashMap.put("af_revenue", price);
                hashMap.put("af_currency", currency);
                if (additionalParams != null) {
                    hashMap.put("af_param_1", additionalParams);
                }
                AppsFlyerLib.this.trackEvent((Context)this.ctxReference.get(), "af_purchase", hashMap);
            }
        }
    }

    private class c
    implements Runnable {
        private WeakReference<Context> ctxReference = null;

        public c(Context context) {
            this.ctxReference = new WeakReference<Context>(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (isDuringCheckCache) {
                return;
            }
            lastCacheCheck = System.currentTimeMillis();
            if (this.ctxReference == null) {
                return;
            }
            isDuringCheckCache = true;
            try {
                String string = AppsFlyerLib.this.getProperty("AppsFlyerKey");
                WeakReference<Context> weakReference = this.ctxReference;
                synchronized (weakReference) {
                    for (RequestCacheData requestCacheData : CacheManager.getInstance().getCachedRequests((Context)this.ctxReference.get())) {
                        com.appsflyer.a.afLog("resending request: " + requestCacheData.getRequestURL());
                        try {
                            long l = System.currentTimeMillis();
                            String string2 = requestCacheData.getCacheKey();
                            long l2 = Long.parseLong(string2, 10);
                            AppsFlyerLib.this.sendRequestToServer(requestCacheData.getRequestURL() + "&isCachedRequest=true&timeincache=" + Long.toString((l - l2) / 1000L), requestCacheData.getPostData(), string, this.ctxReference, requestCacheData.getCacheKey(), false);
                        }
                        catch (Exception exception) {
                            com.appsflyer.a.afLog("Failed to resend cached request");
                        }
                    }
                }
            }
            catch (Exception exception) {
                com.appsflyer.a.afLog("failed to check cache.");
            }
            finally {
                isDuringCheckCache = false;
            }
            cacheScheduler.shutdown();
            cacheScheduler = null;
        }
    }

    private abstract class b
    implements Runnable {
        protected WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey;
        private ScheduledExecutorService executorService;
        private AtomicInteger currentRequestsCounter = new AtomicInteger(0);

        protected abstract void attributionCallback(Map<String, String> var1);

        public abstract String getUrl();

        protected abstract void attributionCallbackFailure(String var1, int var2);

        public b(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = string;
            this.executorService = scheduledExecutorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block25: {
                if (this.appsFlyerDevKey == null || this.appsFlyerDevKey.length() == 0) {
                    return;
                }
                this.currentRequestsCounter.incrementAndGet();
                HttpURLConnection httpURLConnection = null;
                try {
                    Context context = (Context)this.ctxReference.get();
                    if (context == null) {
                        return;
                    }
                    long l = System.currentTimeMillis();
                    String string = AppsFlyerLib.this.getCachedChannel(context, AppsFlyerLib.this.getConfiguredChannel(new WeakReference<Context>(context)));
                    String string2 = "";
                    if (string != null) {
                        string2 = "-" + string;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append(this.getUrl()).append(context.getPackageName()).append(string2).append("?devkey=").append(this.appsFlyerDevKey).append("&device_id=").append(com.appsflyer.g.id(new WeakReference<Context>(context)));
                    h.logMessageMaskKey("Calling server for attribution url: " + stringBuilder.toString());
                    httpURLConnection = (HttpURLConnection)new URL(stringBuilder.toString()).openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setConnectTimeout(10000);
                    httpURLConnection.setRequestProperty("Connection", "close");
                    httpURLConnection.connect();
                    if (httpURLConnection.getResponseCode() == 200) {
                        Object object;
                        String string3;
                        Object object2;
                        long l2 = System.currentTimeMillis();
                        AppsFlyerLib.this.saveLongToSharedPreferences(context, "appsflyerGetConversionDataTiming", (l2 - l) / 1000L);
                        BufferedReader bufferedReader = null;
                        StringBuilder stringBuilder2 = new StringBuilder();
                        InputStreamReader inputStreamReader = null;
                        try {
                            inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
                            bufferedReader = new BufferedReader(inputStreamReader);
                            object2 = null;
                            while ((object2 = bufferedReader.readLine()) != null) {
                                stringBuilder2.append((String)object2).append('\n');
                            }
                        }
                        finally {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            if (inputStreamReader != null) {
                                inputStreamReader.close();
                            }
                        }
                        h.logMessageMaskKey("Attribution data: " + stringBuilder2.toString());
                        if (stringBuilder2.length() <= 0 || context == null) break block25;
                        object2 = AppsFlyerLib.this.attributionStringToMap(stringBuilder2.toString());
                        String string4 = (String)object2.get("iscache");
                        if (string4 != null && "false".equals(string4)) {
                            AppsFlyerLib.this.saveLongToSharedPreferences(context, "appsflyerConversionDataCacheExpiration", System.currentTimeMillis());
                        }
                        if ((string3 = new JSONObject((Map)object2).toString()) != null) {
                            AppsFlyerLib.this.saveDataToSharedPreferences(context, "attributionId", string3);
                        } else {
                            AppsFlyerLib.this.saveDataToSharedPreferences(context, "attributionId", stringBuilder2.toString());
                        }
                        com.appsflyer.a.afDebugLog("iscache=" + string4 + " caching conversion data");
                        if (conversionDataListener == null || this.currentRequestsCounter.intValue() > 1) break block25;
                        try {
                            object = AppsFlyerLib.this.getConversionData(context);
                        }
                        catch (com.appsflyer.b b2) {
                            object = object2;
                        }
                        this.attributionCallback((Map<String, String>)object);
                        break block25;
                    }
                    if (conversionDataListener != null) {
                        this.attributionCallbackFailure("Error connection to server: " + httpURLConnection.getResponseCode(), httpURLConnection.getResponseCode());
                    }
                    h.logMessageMaskKey("AttributionIdFetcher response code: " + httpURLConnection.getResponseCode() + "  url: " + stringBuilder);
                }
                catch (Throwable throwable) {
                    if (conversionDataListener != null) {
                        this.attributionCallbackFailure(throwable.getMessage(), 0);
                    }
                    com.appsflyer.a.afLogE(throwable.getMessage(), throwable);
                }
                finally {
                    this.currentRequestsCounter.decrementAndGet();
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
            this.executorService.shutdown();
        }
    }

    private class e
    extends b {
        public e(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
            super(context, string, scheduledExecutorService);
        }

        @Override
        public String getUrl() {
            return "https://api.appsflyer.com/install_data/v3/";
        }

        @Override
        protected void attributionCallback(Map<String, String> conversionData) {
            conversionDataListener.onInstallConversionDataLoaded(conversionData);
            SharedPreferences sharedPreferences = ((Context)this.ctxReference.get()).getSharedPreferences("appsflyer-data", 0);
            AppsFlyerLib.this.saveIntegerToSharedPreferences((Context)this.ctxReference.get(), "appsflyerConversionDataRequestRetries", 0);
        }

        @Override
        protected void attributionCallbackFailure(String error, int responseCode) {
            conversionDataListener.onInstallConversionFailure(error);
            if (responseCode >= 400 && responseCode < 500) {
                SharedPreferences sharedPreferences = ((Context)this.ctxReference.get()).getSharedPreferences("appsflyer-data", 0);
                int n = sharedPreferences.getInt("appsflyerConversionDataRequestRetries", 0);
                AppsFlyerLib.this.saveIntegerToSharedPreferences((Context)this.ctxReference.get(), "appsflyerConversionDataRequestRetries", ++n);
            }
        }
    }

    private class f
    implements Runnable {
        private String urlString;
        private WeakReference<Context> ctxReference = null;
        Map<String, String> params;
        boolean isLaunch;

        private f(String string, Map<String, String> map, Context context, boolean bl) {
            this.urlString = string;
            this.params = map;
            this.ctxReference = new WeakReference<Context>(context);
            this.isLaunch = bl;
        }

        @Override
        public void run() {
            String string = null;
            try {
                String string2;
                Object object;
                String string3;
                Context context = (Context)this.ctxReference.get();
                boolean bl = false;
                if (context != null) {
                    string3 = AppsFlyerProperties.getInstance().getReferrer(context);
                    if (string3 != null && string3.length() > 0 && this.params.get("referrer") == null) {
                        this.params.put("referrer", string3);
                    }
                    object = context.getSharedPreferences("appsflyer-data", 0);
                    bl = "true".equals(object.getString("sentSuccessfully", ""));
                    string2 = this.params.get("eventName");
                    int n = AppsFlyerLib.this.getCounter(object, "appsFlyerCount", string2 == null);
                    this.params.put("counter", Integer.toString(n));
                    this.params.put("iaecounter", Integer.toString(AppsFlyerLib.this.getCounter(object, "appsFlyerInAppEventCount", string2 != null)));
                    this.params.put("timepassedsincelastlaunch", Long.toString(AppsFlyerLib.this.getTimePassedSinceLastLaunch(context, true)));
                    if (this.isLaunch && n == 1) {
                        AppsFlyerProperties.getInstance().setFirstLaunchCalled();
                    }
                }
                this.params.put("isFirstCall", Boolean.toString(!bl));
                string3 = this.params.get("appsflyerKey");
                if (string3 == null || string3.length() == 0) {
                    com.appsflyer.a.afDebugLog("Not sending data yet, waiting for dev key");
                    return;
                }
                object = new com.appsflyer.f().getHashCode(this.params);
                this.params.put("af_v", (String)object);
                string2 = new com.appsflyer.f().getHashCodeV2(this.params);
                this.params.put("af_v2", string2);
                string = new JSONObject(this.params).toString();
                AppsFlyerLib.this.sendRequestToServer(this.urlString, string, string3, this.ctxReference, null, this.isLaunch && conversionDataListener != null);
            }
            catch (IOException iOException) {
                if (string != null && this.ctxReference != null && !this.urlString.contains("&isCachedRequest=true&timeincache=")) {
                    CacheManager.getInstance().cacheRequest(new RequestCacheData(this.urlString, string, SDK_BUILD_NUMBER), (Context)this.ctxReference.get());
                    com.appsflyer.a.afLogE(iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                com.appsflyer.a.afLogE(throwable.getMessage(), throwable);
            }
        }
    }

    private class d
    implements Runnable {
        private WeakReference<Context> context;
        private String appsFlyerKey;
        private String eventName;
        private String eventValue;
        private String referrer;
        private ExecutorService executor;
        private boolean isNewAPI;

        private d(WeakReference<Context> weakReference, String string, String string2, String string3, String string4, boolean bl, ExecutorService executorService) {
            this.context = weakReference;
            this.appsFlyerKey = string;
            this.eventName = string2;
            this.eventValue = string3;
            this.referrer = string4;
            this.isNewAPI = bl;
            this.executor = executorService;
        }

        @Override
        public void run() {
            AppsFlyerLib.this.sendTrackingWithEvent((Context)this.context.get(), this.appsFlyerKey, this.eventName, this.eventValue, this.referrer, this.isNewAPI);
            this.executor.shutdown();
        }
    }
}

