/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.Map;

public class HashUtils {
    public native String getNativeCode(String var1, String var2, String var3);

    public String getHashCode(Map<String, String> params) {
        String afDevKey = params.get("appsflyerKey");
        String timestamp = params.get("af_timestamp");
        String uid = params.get("uid");
        String nativeSha1 = null;
        nativeSha1 = HashUtils.toSHA1(afDevKey.substring(0, 7) + uid.substring(0, 7) + timestamp.substring(timestamp.length() - 7));
        return nativeSha1;
    }

    public static String toSHA1(String input) {
        String nativeSha1 = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(input.getBytes("UTF-8"));
            nativeSha1 = HashUtils.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return nativeSha1;
    }

    public static String toMD5(String input) {
        String nativeMd5 = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("MD5");
            crypt.reset();
            crypt.update(input.getBytes("UTF-8"));
            nativeMd5 = HashUtils.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return nativeMd5;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

