/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.span.impl;

import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.TraceDecision;
import com.tracelytics.joboe.XTraceOptions;
import com.tracelytics.joboe.span.impl.LogEntry;
import com.tracelytics.joboe.span.impl.SpanContext;
import com.tracelytics.joboe.span.impl.SpanReporter;
import com.tracelytics.joboe.span.impl.TraceDecisionParameters;
import com.tracelytics.joboe.span.impl.TracePropertyDictionary;
import com.tracelytics.joboe.span.impl.Tracer;
import com.tracelytics.joboe.span.impl.TransactionNameManager;
import com.tracelytics.joboe.span.tag.Tag;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Span
implements com.tracelytics.joboe.span.Span {
    private static final Logger a = LoggerFactory.getLogger();
    private final long b;
    private String c;
    private SpanContext d;
    private final Map<String, Object> e = new HashMap<String, Object>();
    private final Map<SpanProperty<?>, Object> f = new HashMap();
    private final Map<TraceProperty<?>, Object> g;
    private final List<SpanReporter> h;

    public Span(Tracer tracer, String string, SpanContext spanContext, long l2, Map<String, Object> map, List<SpanReporter> list) {
        this.c = string;
        this.d = spanContext;
        this.b = l2;
        if (map != null) {
            this.e.putAll(map);
        }
        this.h = new ArrayList<SpanReporter>(list);
        long l3 = spanContext.getTraceId();
        this.g = TracePropertyDictionary.getTracePropertiesByTraceId(l3);
    }

    public long getStart() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Map<String, Object> map = this.e;
        synchronized (map) {
            return Collections.unmodifiableMap(this.e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTag(String string) {
        Map<String, Object> map = this.e;
        synchronized (map) {
            return this.e.get(string);
        }
    }

    @Override
    public Span setOperationName(String string) {
        this.c = string;
        return this;
    }

    public String getOperationName() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span setBaggageItem(String string, String string2) {
        Span span = this;
        synchronized (span) {
            this.d = this.d.withBaggageItem(string, string2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBaggageItem(String string) {
        Span span = this;
        synchronized (span) {
            return this.d.getBaggageItem(string);
        }
    }

    public String toString() {
        return this.d.contextAsString() + " - " + this.c;
    }

    @Override
    public SpanContext context() {
        return this.d;
    }

    public void start() {
        for (SpanReporter spanReporter : this.h) {
            spanReporter.reportOnStart(this);
        }
    }

    @Override
    public void finish() {
        this.finish(TimeUtils.getTimestampMicroSeconds());
    }

    @Override
    public void finish(long l2) {
        if (this.isRoot()) {
            this.setTracePropertyValue(TraceProperty.TRANSACTION_NAME, TransactionNameManager.getTransactionName(this));
        }
        for (SpanReporter spanReporter : this.h) {
            spanReporter.reportOnFinish(this, l2);
        }
        Metadata metadata = this.context().getMetadata();
        if (metadata.isValid()) {
            this.setSpanPropertyValue(SpanProperty.EXIT_XID, metadata.toHexString());
            metadata.invalidate();
        }
        if (this.isRoot()) {
            TracePropertyDictionary.removeTracePropertiesByTraceId(this.d.getTraceId());
        }
    }

    @Override
    public Span setTag(String string, String string2) {
        return this.setTagAsObject(string, string2);
    }

    @Override
    public Span setTag(String string, boolean bl) {
        return this.setTagAsObject(string, bl);
    }

    @Override
    public Span setTag(String string, Number number) {
        return this.setTagAsObject(string, number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span setTagAsObject(String string, Object object) {
        Map<String, Object> map = this.e;
        synchronized (map) {
            this.e.put(string, object);
        }
        return this;
    }

    @Override
    public <T> Span setTag(Tag<T> tag, T t2) {
        return this.setTagAsObject(tag.getKey(), t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void setSpanPropertyValue(SpanProperty<V> spanProperty, V v2) {
        Map<SpanProperty<?>, Object> map = this.f;
        synchronized (map) {
            this.f.put(spanProperty, v2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V getSpanPropertyValue(SpanProperty<V> spanProperty) {
        Map<SpanProperty<?>, Object> map = this.f;
        synchronized (map) {
            if (!this.f.containsKey(spanProperty)) {
                SpanProperty<V> spanProperty2 = spanProperty;
                this.f.put(spanProperty2, spanProperty2.getDefaultValue());
            }
            return (V)this.f.get(spanProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSpanProperty(SpanProperty<?> spanProperty) {
        Map<SpanProperty<?>, Object> map = this.f;
        synchronized (map) {
            return this.f.containsKey(spanProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void setTracePropertyValue(TraceProperty<V> traceProperty, V v2) {
        Map<TraceProperty<?>, Object> map = this.g;
        synchronized (map) {
            this.g.put(traceProperty, v2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V getTracePropertyValue(TraceProperty<V> traceProperty) {
        Map<TraceProperty<?>, Object> map = this.g;
        synchronized (map) {
            if (!this.g.containsKey(traceProperty)) {
                TraceProperty<V> traceProperty2 = traceProperty;
                this.g.put(traceProperty2, traceProperty2.getDefaultValue());
            }
            return (V)this.g.get(traceProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTraceProperty(TraceProperty<?> traceProperty) {
        Map<TraceProperty<?>, Object> map = this.g;
        synchronized (map) {
            return this.g.containsKey(traceProperty);
        }
    }

    public Span error(Map<String, ?> map) {
        long l2 = TimeUtils.getTimestampMicroSeconds();
        return this.a(new LogEntry(l2, map, true));
    }

    private Span a(LogEntry logEntry) {
        for (SpanReporter spanReporter : this.h) {
            spanReporter.reportOnLog(this, logEntry);
        }
        return this;
    }

    @Override
    public Span log(long l2, Map<String, ?> map) {
        this.a(new LogEntry(l2, map));
        return this;
    }

    @Override
    public Span log(Map<String, ?> map) {
        return this.log(TimeUtils.getTimestampMicroSeconds(), (Map)map);
    }

    @Override
    public Span log(String string) {
        return this.log((Map)Collections.singletonMap("event", string));
    }

    @Override
    public Span log(long l2, String string) {
        return this.log(l2, (Map)Collections.singletonMap("event", string));
    }

    public Span log(String string, Object object) {
        return this.log(TimeUtils.getTimestampMicroSeconds(), string, object);
    }

    public Span log(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            a.warn("log to current span but object array size is not even");
            return this;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object;
            if (!((object = objectArray[n2++]) instanceof String)) {
                a.warn("log to current span but object with index [" + n2 + "] is not a string");
                return this;
            }
            hashMap.put((String)object, objectArray[n2++]);
        }
        return this.log(hashMap);
    }

    public Span log(long l2, String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", string);
        hashMap.put("payload", object);
        return this.log(l2, hashMap);
    }

    public boolean isRoot() {
        return this.d.getParentId() == null && this.d.getPreviousMetadata() == null;
    }

    public void addSpanReporter(SpanReporter spanReporter) {
        this.h.add(spanReporter);
    }

    public boolean removeSpanRepoter(SpanReporter spanReporter) {
        return this.h.remove(spanReporter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TraceProperty<V>
    extends Property<V> {
        public static final TraceProperty<String> ACTION = new TraceProperty<Object>(null);
        public static final TraceProperty<String> CONTROLLER = new TraceProperty<Object>(null);
        public static final TraceProperty<Boolean> HAS_ERROR = new TraceProperty<Boolean>(Boolean.FALSE);
        public static final TraceProperty<String> TRANSACTION_NAME = new TraceProperty<Object>(null);
        public static final TraceProperty<String> CUSTOM_TRANSACTION_NAME = new TraceProperty<Object>(null);
        public static final TraceProperty<Map<Long, String>> PROFILE_IDS = new TraceProperty(new ConcurrentHashMap());
        private V a;

        private TraceProperty() {
            this(null);
        }

        private TraceProperty(V v2) {
            this.a = v2;
        }

        public V getDefaultValue() {
            return this.a;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpanProperty<V> {
        public static final SpanProperty<String> EXIT_XID = new SpanProperty();
        public static final SpanProperty<String> ENTRY_XID = new SpanProperty();
        public static final SpanProperty<Boolean> IS_PROFILE = new SpanProperty<Boolean>(Boolean.FALSE);
        public static final SpanProperty<Boolean> IS_ASYNC = new SpanProperty<Boolean>(Boolean.FALSE);
        public static final SpanProperty<AtomicInteger> PROFILE_SPAN_COUNT = new SpanProperty<AtomicInteger>(new a<AtomicInteger>(){

            @Override
            public final /* synthetic */ Object a() {
                return new AtomicInteger(0);
            }
        });
        public static final SpanProperty<Set<String>> CHILD_EDGES = new SpanProperty();
        public static final SpanProperty<Set<String>> REPORTED_TAG_KEYS = new SpanProperty();
        public static final SpanProperty<TraceDecisionParameters> TRACE_DECISION_PARAMETERS = new SpanProperty();
        public static final SpanProperty<Boolean> IS_SDK = new SpanProperty<Boolean>(Boolean.FALSE);
        public static final SpanProperty<Long> THREAD_ID = new SpanProperty();
        public static final SpanProperty<Boolean> IS_ENTRY_SERVICE_ROOT = new SpanProperty<Boolean>(Boolean.FALSE);
        public static final SpanProperty<TraceDecision> TRACE_DECISION = new SpanProperty<Object>(null);
        public static final SpanProperty<XTraceOptions> X_TRACE_OPTIONS = new SpanProperty();
        public static final SpanProperty<Long> ORIG_TRACE_ID = new SpanProperty();
        private V a;
        private a<V> b;

        private SpanProperty() {
            this(null);
        }

        private SpanProperty(V v2) {
            this.a = v2;
        }

        private SpanProperty(a<V> a2) {
            this.b = a2;
        }

        public V getDefaultValue() {
            if (this.a != null) {
                return this.a;
            }
            if (this.b != null) {
                return this.b.a();
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static interface a<V> {
            public V a();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Property<V> {
    }
}

