/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.span.impl;

import com.tracelytics.c.a;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.ProfilerSetting;
import com.tracelytics.joboe.span.impl.LogEntry;
import com.tracelytics.joboe.span.impl.Span;
import com.tracelytics.joboe.span.impl.SpanReporter;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ProfilingSpanReporter
implements SpanReporter {
    private final Logger a = LoggerFactory.getLogger();
    public static final ProfilingSpanReporter REPORTER = new ProfilingSpanReporter();
    private static final ProfilerSetting b = (ProfilerSetting)ConfigManager.getConfig(ConfigProperty.PROFILER);
    private static final boolean c = b != null && b.isEnabled();
    public static final AtomicLong profilingReportOnStart = new AtomicLong();
    public static final AtomicLong addProfileCalledOnStart = new AtomicLong();
    public static final AtomicLong profilingReportOnFinish = new AtomicLong();
    public static final AtomicLong traceIdChanged = new AtomicLong();

    private ProfilingSpanReporter() {
    }

    public void reportOnStart(Span span) {
        profilingReportOnStart.incrementAndGet();
        span.setSpanPropertyValue(Span.SpanProperty.ORIG_TRACE_ID, span.context().getTraceId());
        if (c && span.context().getMetadata().isSampled()) {
            boolean bl = com.tracelytics.c.a.a(Thread.currentThread(), span.context().getMetadata(), span.context().getTraceId());
            addProfileCalledOnStart.incrementAndGet();
            span.setTag("ProfilerStatus", com.tracelytics.c.a.b().toString());
            if (bl) {
                span.getSpanPropertyValue(Span.SpanProperty.PROFILE_SPAN_COUNT).incrementAndGet();
            }
        }
    }

    public void reportOnFinish(Span span, long l2) {
        profilingReportOnFinish.incrementAndGet();
        Long l3 = span.getSpanPropertyValue(Span.SpanProperty.ORIG_TRACE_ID);
        if (l3 != null && l3.longValue() != span.context().getTraceId()) {
            traceIdChanged.incrementAndGet();
            this.a.debug("Inconsistent traceId found: " + l3 + "->" + span.context().getTraceId());
        }
        if (c) {
            com.tracelytics.c.a.a(span.context().getTraceId());
        }
    }

    public void reportOnLog(Span span, LogEntry logEntry) {
    }
}

