/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.config;

import com.tracelytics.joboe.config.ConfigContainer;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.ConfigReader;
import com.tracelytics.joboe.config.ConfigSourceType;
import com.tracelytics.joboe.config.InvalidConfigException;
import java.util.ArrayList;

public class JavaAgentArgumentConfigReader
extends ConfigReader {
    private String b;

    public JavaAgentArgumentConfigReader(String string) {
        super(ConfigSourceType.JVM_ARG);
        this.b = string;
    }

    public void read(ConfigContainer configContainer) throws InvalidConfigException {
        if (this.b == null) {
            return;
        }
        String[] stringArray = this.b.split(",");
        ArrayList<InvalidConfigException> arrayList = new ArrayList<InvalidConfigException>();
        for (String string : stringArray) {
            String[] stringArray2 = string.split("=");
            String string2 = stringArray2[0].toLowerCase();
            String object = stringArray2.length > 1 ? stringArray2[1] : "";
            ConfigProperty configProperty = ConfigProperty.fromAgentArgumentKey(string2);
            if (configProperty != null) {
                try {
                    configContainer.putByStringValue(configProperty, object);
                }
                catch (InvalidConfigException invalidConfigException) {
                    this.a.warn("Invalid java agent param [" + string2 + "] value [" + object + "]");
                    arrayList.add(invalidConfigException);
                }
                continue;
            }
            arrayList.add(new InvalidConfigException("Unexpected argument [" + string2 + "]"));
        }
        if (!arrayList.isEmpty()) {
            this.a.warn("Found " + arrayList.size() + " exception(s) while reading config from java argument");
            throw (InvalidConfigException)arrayList.get(0);
        }
    }
}

