/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.joboe.XTraceOption;
import com.tracelytics.joboe.XTraceOptionsResponse;
import com.tracelytics.joboe.settings.SettingsArg;
import com.tracelytics.joboe.settings.SettingsArgChangeListener;
import com.tracelytics.joboe.settings.SettingsManager;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.HexUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XTraceOptions {
    private static final Logger a = LoggerFactory.getLogger();
    private static d b;
    private final Map<XTraceOption<?>, ?> c;
    private final List<XTraceOptionException> d;
    private final AuthenticationStatus e;

    private XTraceOptions(Map<XTraceOption<?>, ?> map, List<XTraceOptionException> list, AuthenticationStatus authenticationStatus) {
        this.c = map;
        this.d = list;
        this.e = authenticationStatus;
    }

    public static XTraceOptions getXTraceOptions(String string, String string2) {
        return XTraceOptions.a(string, string2, b);
    }

    private static XTraceOptions a(String string, String object, d object2) {
        long l2;
        long l3;
        if (string == null) {
            return null;
        }
        ArrayList<XTraceOptionException> arrayList = new ArrayList<XTraceOptionException>();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string2 : string.split(";")) {
            int n2 = (string2 = string2.trim()).indexOf("=");
            String string3 = n2 >= 0 ? string2.substring(0, n2) : string2;
            if ("".equals(string3 = string3.trim())) {
                if ("".equals(string2)) continue;
                a.debug("Skipped entry [" + string2 + "] in X-Trace-Options as the key is empty");
                continue;
            }
            XTraceOption<?> xTraceOption = XTraceOption.fromKey(string3);
            if (xTraceOption != null) {
                if (xTraceOption.isKeyOnlyOption()) {
                    if (n2 > 0) {
                        arrayList.add(new b(xTraceOption, string2));
                        continue;
                    }
                    if (!linkedHashMap.containsKey(xTraceOption)) {
                        linkedHashMap.put(xTraceOption, Boolean.TRUE);
                        continue;
                    }
                    a.debug("Duplicated option [" + xTraceOption.getKey() + "] found in X-Trace-Options, ignoring...");
                    continue;
                }
                if (n2 < 0) {
                    arrayList.add(new b(xTraceOption, string2));
                }
                string2 = string2.substring(n2 + 1).trim();
                try {
                    if (!linkedHashMap.containsKey(xTraceOption)) {
                        XTraceOption<?> xTraceOption2 = xTraceOption;
                        linkedHashMap.put(xTraceOption2, (Boolean)xTraceOption2.parseValueFromString(string2));
                        continue;
                    }
                    a.debug("Duplicated option [" + xTraceOption.getKey() + "] with value [" + string2 + "] found in X-Trace-Options, ignoring...");
                }
                catch (c c2) {
                    arrayList.add(c2);
                }
                continue;
            }
            arrayList.add(new e(string3));
        }
        Object object3 = object2;
        object2 = object;
        object = (Long)linkedHashMap.get(XTraceOption.TS);
        if (((AuthenticationStatus)(object2 == null ? AuthenticationStatus.NOT_AUTHENTICATED : (object == null ? AuthenticationStatus.failure("bad-timestamp") : (!((l3 = ((Long)object).longValue()) >= (l2 = System.currentTimeMillis() / 1000L) - 300L && l3 <= l2 + 300L) ? AuthenticationStatus.failure("bad-timestamp") : (object3 == null ? AuthenticationStatus.failure("authenticator-unavailable") : (object3 = object3.a(string, (String)object2) ? AuthenticationStatus.OK : AuthenticationStatus.failure("bad-signature"))))))).isFailure()) {
            return new XTraceOptions(Collections.EMPTY_MAP, Collections.EMPTY_LIST, (AuthenticationStatus)object3);
        }
        for (XTraceOptionException xTraceOptionException : arrayList) {
            a.debug(xTraceOptionException.getMessage());
        }
        return new XTraceOptions(linkedHashMap, arrayList, (AuthenticationStatus)object3);
    }

    public <T> T getOptionValue(XTraceOption<T> xTraceOption) {
        if (this.c.containsKey(xTraceOption)) {
            return (T)this.c.get(xTraceOption);
        }
        return xTraceOption.getDefaultValue();
    }

    public Map<XTraceOption<String>, String> getCustomKvs() {
        LinkedHashMap<XTraceOption<String>, String> linkedHashMap = new LinkedHashMap<XTraceOption<String>, String>();
        for (Map.Entry<XTraceOption<?>, ?> entry : this.c.entrySet()) {
            XTraceOption<?> xTraceOption = entry.getKey();
            if (!xTraceOption.isCustomKv()) continue;
            linkedHashMap.put(xTraceOption, (String)entry.getValue());
        }
        return linkedHashMap;
    }

    public List<XTraceOptionException> getExceptions() {
        return this.d;
    }

    public AuthenticationStatus getAuthenticationStatus() {
        return this.e;
    }

    static {
        SettingsManager.registerListener(new SettingsArgChangeListener<byte[]>(SettingsArg.TRACE_OPTIONS_SECRET){

            @Override
            public final /* synthetic */ void a(Object object) {
                byte[] byArray = (byte[])object;
                object = byArray;
                if (byArray != null) {
                    b = new a((byte[])object);
                    return;
                }
                b = null;
            }
        });
    }

    static final class a
    implements d {
        private final Mac a;

        a(byte[] byArray) {
            this.a = com.tracelytics.joboe.XTraceOptions$a.a(byArray);
        }

        private static Mac a(byte[] object) {
            object = new SecretKeySpec((byte[])object, "HMACSHA1");
            try {
                Mac mac = Mac.getInstance("HMACSHA1");
                mac.init((Key)object);
                return mac;
            }
            catch (GeneralSecurityException generalSecurityException) {
                a.warn("Failed to initialize HMAC for x-trace options: " + generalSecurityException.getMessage(), generalSecurityException);
                return null;
            }
        }

        public final boolean a(String object, String string) {
            byte[] byArray = this.a.doFinal(((String)object).getBytes());
            object = byArray;
            object = HexUtils.bytesToHex(byArray).toLowerCase();
            return ((String)object).equals(string);
        }
    }

    static interface d {
        public boolean a(String var1, String var2);
    }

    public static class AuthenticationStatus {
        public static final AuthenticationStatus OK = new AuthenticationStatus(false, true, null);
        public static final AuthenticationStatus NOT_AUTHENTICATED = new AuthenticationStatus(false, false, null);
        private final String a;
        private final boolean b;
        private final boolean c;

        private AuthenticationStatus(boolean bl, boolean bl2, String string) {
            this.b = bl;
            this.c = bl2;
            this.a = string;
        }

        public static AuthenticationStatus failure(String string) {
            return new AuthenticationStatus(true, false, string);
        }

        public boolean isAuthenticated() {
            return this.c;
        }

        public boolean isFailure() {
            return this.b;
        }

        public String getReason() {
            return this.a;
        }

        public String toString() {
            return "AuthenticationStatus{reason='" + this.a + '\'' + ", failure=" + this.b + ", authenticated=" + this.c + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (AuthenticationStatus)object;
            if (this.b != ((AuthenticationStatus)object).b) {
                return false;
            }
            if (this.c != ((AuthenticationStatus)object).c) {
                return false;
            }
            if (this.a != null) {
                return this.a.equals(((AuthenticationStatus)object).a);
            }
            return ((AuthenticationStatus)object).a == null;
        }

        public int hashCode() {
            int n2 = this.a != null ? this.a.hashCode() : 0;
            n2 = n2 * 31 + (this.b ? 1 : 0);
            n2 = n2 * 31 + (this.c ? 1 : 0);
            return n2;
        }
    }

    static final class b
    extends InvalidXTraceOptionException {
        b(XTraceOption xTraceOption, String string) {
            super(xTraceOption.getKey(), "Invalid format for option entry [" + string + "] in X-Trace-Options header");
        }
    }

    static final class c
    extends InvalidXTraceOptionException {
        c(XTraceOption xTraceOption, String string) {
            super(xTraceOption.getKey(), "Invalid value [" + string + "] for option [" + xTraceOption.getKey() + "] in X-Trace-Options header");
        }
    }

    static final class e
    extends InvalidXTraceOptionException {
        e(String string) {
            super(string, "Unknown key " + string + " in X-Trace-Options header");
        }
    }

    public static abstract class InvalidXTraceOptionException
    extends XTraceOptionException {
        private String a;

        protected InvalidXTraceOptionException(String string, String string2) {
            super(string2);
            this.a = string;
        }

        public String getInvalidOptionKey() {
            return this.a;
        }

        final void a(XTraceOptionsResponse xTraceOptionsResponse) {
            String string = xTraceOptionsResponse.getValue("ignored");
            string = string == null ? this.a : string + "," + this.a;
            xTraceOptionsResponse.setValue("ignored", string);
        }
    }

    public static abstract class XTraceOptionException
    extends Exception {
        XTraceOptionException(String string) {
            super(string);
        }

        abstract void a(XTraceOptionsResponse var1);
    }
}

