/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.SampleRateSource;
import com.tracelytics.joboe.TokenBucket;
import com.tracelytics.joboe.TokenBucketType;
import com.tracelytics.joboe.TraceConfig;
import com.tracelytics.joboe.TraceDecision;
import com.tracelytics.joboe.TracingMode;
import com.tracelytics.joboe.XTraceOption;
import com.tracelytics.joboe.XTraceOptions;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.TraceConfigs;
import com.tracelytics.joboe.settings.Settings;
import com.tracelytics.joboe.settings.SettingsArg;
import com.tracelytics.joboe.settings.SettingsManager;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceDecisionUtil {
    public static final int SAMPLE_RESOLUTION = 1000000;
    private static final Logger a = LoggerFactory.getLogger();
    private static final ConcurrentHashMap<TokenBucketType, TokenBucket> b = new ConcurrentHashMap();
    private static final Random c = new Random();
    private static final Map<MetricType, AtomicInteger> d = new HashMap<MetricType, AtomicInteger>();
    private static final Map<String, TraceConfig> e = new ConcurrentHashMap<String, TraceConfig>();
    private static final ConcurrentHashMap<String, Boolean> f = new ConcurrentHashMap();
    private static final boolean g = ConfigManager.getConfigOptional(ConfigProperty.AGENT_TRIGGER_TRACE_ENABLED, Boolean.TRUE);
    private static volatile TraceConfig h = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static TraceDecision shouldTraceRequest(String var0, String var1_2, XTraceOptions var2_4, String var3_6) {
        try {
            block37: {
                block36: {
                    var16_7 = var2_4;
                    var8_9 /* !! */  = var1_2;
                    if (var16_7 == null || var8_9 /* !! */  != null) {
                        v0 = RequestType.REGULAR;
                    } else {
                        var18_10 = var16_7.getAuthenticationStatus();
                        var17_14 = var18_10.isFailure() != false ? RequestType.BAD_SIGNATURE : (var16_7.getOptionValue(XTraceOption.TRIGGER_TRACE) == false ? RequestType.REGULAR : (var18_10.isAuthenticated() != false ? RequestType.AUTHENTICATED_TRIGGER_TRACE : RequestType.UNAUTHENTICATED_TRIGGER_TRACE));
                        v0 = var17_14;
                    }
                    var5_18 = v0;
                    var4_19 = v0.isTriggerTrace();
                    var6_22 = TraceDecisionUtil.getRemoteTraceConfig();
                    if (var6_22 == null) {
                        TraceDecisionUtil.a.debug("Failed to fetch settings records, not tracing");
                        var3_6 = new TraceDecision(false, false, null, var5_18);
                        return var3_6;
                    }
                    var3_6 = TraceDecisionUtil.getLocalTraceConfig((String)var3_6);
                    var17_15 = TraceDecisionUtil.g;
                    var16_7 = var3_6;
                    var8_9 /* !! */  = var6_22;
                    var18_11 = var8_9 /* !! */  != null && var8_9 /* !! */ .hasOverrideFlag() != false;
                    var19_23 = var18_11 != false && var16_7.isSampleRateConfigured() != false ? (var8_9 /* !! */ .getSampleRate() <= var16_7.getSampleRate() ? var8_9 /* !! */  : var16_7) : (var16_7.isSampleRateConfigured() != false ? var16_7 : var8_9 /* !! */ );
                    var9_24 = var19_23.getSampleRate();
                    var3_6 = var19_23.getSampleRateSource();
                    var7_25 = var18_11 != false && var16_7.isFlagsConfigured() != false ? Short.valueOf((short)(var8_9 /* !! */ .a() & var16_7.a())) : (var16_7.isFlagsConfigured() != false ? Short.valueOf(var16_7.a()) : Short.valueOf(var8_9 /* !! */ .a()));
                    if (!var17_15) {
                        var7_25 = (short)(var7_25.shortValue() & -33);
                    }
                    if (!(var3_6 = new TraceConfig((Integer)var9_24, (SampleRateSource)var3_6, (Short)var7_25, var8_9 /* !! */ .getBucketCapacities(), var8_9 /* !! */ .getBucketRates())).isSampleRateConfigured()) {
                        TraceDecisionUtil.a.debug("Cannot trace request as sample rate is undefined");
                        var7_25 = new TraceDecision(false, false, (TraceConfig)var3_6, var5_18);
                        return var7_25;
                    }
                    if (!var3_6.isFlagsConfigured()) {
                        TraceDecisionUtil.a.debug("Cannot trace request as flags are undefined");
                        var7_25 = new TraceDecision(false, false, (TraceConfig)var3_6, var5_18);
                        return var7_25;
                    }
                    var8_9 /* !! */  = var3_6;
                    var7_26 = var8_9 /* !! */ .isMetricsEnabled();
                    if (var2_4 != null && var2_4.getAuthenticationStatus().isFailure()) {
                        TraceDecisionUtil.a.debug("Bad x-tv-options-signature, not tracing");
                        var0 = new TraceDecision(false, var7_26, null, var5_18);
                        return var0;
                    }
                    if (var3_6.hasSampleStartFlag()) {
                        var16_7 = var0;
                        var8_9 /* !! */  = var3_6;
                        var17_16 = TraceDecisionUtil.e;
                        synchronized (var17_16) {
                            TraceDecisionUtil.e.put((String)var16_7, (TraceConfig)var8_9 /* !! */ );
                        }
                    }
                    var0 = null;
                    if (var1_2 != null) {
                        var0 = TraceDecisionUtil.a(var1_2);
                    }
                    var17_17 = var4_19;
                    var16_7 = var3_6;
                    var8_9 /* !! */  = var0;
                    if (var8_9 /* !! */  != null) break block36;
                    if (var17_17) {
                        v1 = var16_7.hasSampleTriggerTraceFlag();
                    } else if (var16_7.hasSampleStartFlag()) {
                        TraceDecisionUtil.a(MetricType.SAMPLE_COUNT);
                        v1 = TraceDecisionUtil.a(var16_7.getSampleRate());
                    } else {
                        if (var16_7.hasSampleThroughAlwaysFlag()) {
                            TraceDecisionUtil.a(MetricType.THROUGH_IGNORED_COUNT);
                        }
                        v1 = false;
                    }
                    break block37;
                }
                var19_23 = var8_9 /* !! */ ;
                if (!var19_23.isSampled()) ** GOTO lbl-1000
                if (var16_7.hasSampleThroughAlwaysFlag()) {
                    TraceDecisionUtil.a(MetricType.THROUGH_TRACE_COUNT);
                    v1 = true;
                } else if (var16_7.hasSampleThroughFlag() && TraceDecisionUtil.a(var16_7.getSampleRate())) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
            }
            var1_3 = v1;
            var2_5 = false;
            if (var1_3) {
                if (var0 == null) {
                    var18_13 = var6_22.getBucketRate(RequestType.a(var5_18));
                    var16_8 = var6_22.getBucketCapacity(RequestType.a(var5_18));
                    var8_9 /* !! */  = RequestType.a(var5_18);
                    var9_24 = TraceDecisionUtil.b.get(var8_9 /* !! */ );
                    if (var9_24 == null) {
                        var9_24 = new TokenBucket(var16_8, var18_13);
                        TraceDecisionUtil.b.put((TokenBucketType)var8_9 /* !! */ , (TokenBucket)var9_24);
                    } else {
                        var9_24.b(var16_8);
                        var9_24.a(var18_13);
                    }
                    var4_20 = var9_24;
                    if (var4_20.consume()) {
                        TraceDecisionUtil.a(MetricType.TRACE_COUNT);
                        if (var5_18.isTriggerTrace()) {
                            TraceDecisionUtil.a(MetricType.TRIGGERED_TRACE_COUNT);
                        }
                    } else {
                        TraceDecisionUtil.a.trace("No Tokens available in the Token Bucket. Not tracing this request");
                        TraceDecisionUtil.a(MetricType.TOKEN_BUCKET_EXHAUSTION);
                        var1_3 = false;
                        var2_5 = true;
                    }
                } else {
                    TraceDecisionUtil.a(MetricType.TRACE_COUNT);
                }
            }
            var4_21 = new TraceDecision(var1_3, var7_26, var2_5, (TraceConfig)var3_6, var5_18, (Metadata)var0);
            return var4_21;
        }
        finally {
            TraceDecisionUtil.a(MetricType.THROUGHPUT);
        }
    }

    private static Metadata a(String string) {
        if (!Metadata.isCompatible(string)) {
            a.debug("Not accepting X-Trace ID [" + string + "] for trace continuation");
            return null;
        }
        try {
            Metadata metadata = new Metadata(string);
            if (!metadata.isValid()) {
                a.debug("Invalid incoming x-trace ID [" + string + "]");
                return null;
            }
            return metadata;
        }
        catch (OboeException oboeException) {
            a.warn("Failed to parse x-trace ID [" + string + "] " + oboeException.getMessage());
            return null;
        }
    }

    public static TraceConfig getRemoteTraceConfig() {
        Object object = null;
        Settings settings = SettingsManager.getSettings();
        if (settings != null) {
            object = TraceDecisionUtil.a(settings, SettingsArg.BUCKET_CAPACITY, SettingsArg.RELAXED_BUCKET_CAPACITY, SettingsArg.STRICT_BUCKET_CAPACITY);
            Map<TokenBucketType, Double> map = TraceDecisionUtil.a(settings, SettingsArg.BUCKET_RATE, SettingsArg.RELAXED_BUCKET_RATE, SettingsArg.STRICT_BUCKET_RATE);
            object = new TraceConfig((int)settings.getValue(), settings.isDefault() ? SampleRateSource.OBOE_DEFAULT : SampleRateSource.OBOE, settings.getFlags(), (Map<TokenBucketType, Double>)object, map);
        }
        return object;
    }

    private static Map<TokenBucketType, Double> a(Settings settings, SettingsArg<Double> settingsArg, SettingsArg<Double> settingsArg2, SettingsArg<Double> settingsArg3) {
        HashMap<TokenBucketType, Double> hashMap = new HashMap<TokenBucketType, Double>();
        hashMap.put(TokenBucketType.REGULAR, TraceDecisionUtil.a(settings, settingsArg));
        hashMap.put(TokenBucketType.RELAXED, TraceDecisionUtil.a(settings, settingsArg2));
        hashMap.put(TokenBucketType.STRICT, TraceDecisionUtil.a(settings, settingsArg3));
        return hashMap;
    }

    private static double a(Settings object, SettingsArg<Double> settingsArg) {
        if ((object = ((Settings)object).getArgValue(settingsArg)) == null) {
            a.debug("Cannot read settings arg " + settingsArg);
            return 0.0;
        }
        if ((Double)object < 0.0) {
            a.warn("Invalid negative value in settings arg " + settingsArg);
            return 0.0;
        }
        return (Double)object;
    }

    public static TraceConfig getLocalTraceConfig(String object) {
        if ((object = object != null && ConfigManager.getConfig(ConfigProperty.AGENT_INTERNAL_TRANSACTION_SETTINGS) != null ? ((TraceConfigs)ConfigManager.getConfig(ConfigProperty.AGENT_INTERNAL_TRANSACTION_SETTINGS)).getTraceConfig((String)object) : null) == null) {
            if (h == null) {
                object = (Integer)ConfigManager.getConfig(ConfigProperty.AGENT_SAMPLE_RATE);
                TracingMode tracingMode = (TracingMode)((Object)ConfigManager.getConfig(ConfigProperty.AGENT_TRACING_MODE));
                Object object2 = object;
                h = new TraceConfig((Integer)object2, object2 != null ? SampleRateSource.FILE : SampleRateSource.DEFAULT, tracingMode != null ? Short.valueOf(tracingMode.toFlags()) : null);
            }
            object = h;
        }
        return object;
    }

    private static boolean a(int n2) {
        return n2 == 1000000 || n2 < 1000000 && c.nextInt(1000000) <= n2;
    }

    private static void a(MetricType metricType) {
        d.get((Object)metricType).incrementAndGet();
    }

    public static int consumeMetricsData(MetricType object) {
        object = d.get(object);
        return ((AtomicInteger)object).getAndSet(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, TraceConfig> consumeLastTraceConfigs() {
        HashMap<String, TraceConfig> hashMap;
        Map<String, TraceConfig> map = e;
        synchronized (map) {
            hashMap = new HashMap<String, TraceConfig>(e);
            e.clear();
        }
        return hashMap;
    }

    public static void reset() {
        b.clear();
        for (AtomicInteger atomicInteger : d.values()) {
            atomicInteger.set(0);
        }
        e.clear();
        f.clear();
        h = null;
    }

    static {
        for (MetricType metricType : MetricType.values()) {
            d.put(metricType, new AtomicInteger(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        REGULAR(false, TokenBucketType.REGULAR),
        AUTHENTICATED_TRIGGER_TRACE(true, TokenBucketType.RELAXED),
        UNAUTHENTICATED_TRIGGER_TRACE(true, TokenBucketType.STRICT),
        BAD_SIGNATURE(false, TokenBucketType.REGULAR);

        private final boolean a;
        private final TokenBucketType b;

        private RequestType(boolean bl, TokenBucketType tokenBucketType) {
            this.a = bl;
            this.b = tokenBucketType;
        }

        public final boolean isTriggerTrace() {
            return this.a;
        }

        public final TokenBucketType getBucketType() {
            return this.b;
        }

        static /* synthetic */ TokenBucketType a(RequestType requestType) {
            return requestType.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetricType {
        THROUGHPUT,
        TOKEN_BUCKET_EXHAUSTION,
        TRACE_COUNT,
        SAMPLE_COUNT,
        THROUGH_TRACE_COUNT,
        THROUGH_IGNORED_COUNT,
        TRIGGERED_TRACE_COUNT;

    }
}

