/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.a.i.a.b.d;
import com.tracelytics.a.i.a.b.e;
import com.tracelytics.a.i.a.b.g;
import com.tracelytics.joboe.DevURandomSeedGenerator;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.settings.SettingsArg;
import com.tracelytics.joboe.settings.SettingsArgChangeListener;
import com.tracelytics.joboe.settings.SettingsManager;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class Metadata {
    private static final Logger a = LoggerFactory.getLogger();
    private byte[] b;
    private byte[] c;
    private int d;
    private int e;
    private byte f;
    private boolean g;
    public static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final byte[] unsetTaskID = new byte[20];
    public static final byte[] unsetOpID = new byte[8];
    private static int h;
    public static final int DEFAULT_TTL = 1200000;
    private static int i;
    private static int j;
    public static final int DEFAULT_MAX_EVENTS = 100000;
    public static final int DEFAULT_MAX_BACKTRACES = 1000;
    public static final int CURRENT_VERSION = 2;
    private long k;
    private Long l;
    private AtomicInteger m = new AtomicInteger();
    private AtomicInteger n = new AtomicInteger();
    private boolean o = false;
    private int p = 0;
    private static Random q;

    public Metadata() {
        this.initialize();
    }

    public Metadata(String string) throws OboeException {
        this.initialize();
        this.fromHexString(string);
    }

    public Metadata(Metadata metadata) {
        if (metadata.isExpired(System.currentTimeMillis())) {
            metadata.invalidate();
        }
        this.initialize();
        this.d = metadata.d;
        this.e = metadata.e;
        this.g = metadata.g;
        this.k = metadata.k;
        this.m = metadata.m;
        this.n = metadata.n;
        System.arraycopy(metadata.b, 0, this.b, 0, 20);
        System.arraycopy(metadata.c, 0, this.c, 0, 8);
        this.f = metadata.f;
        this.l = metadata.l;
        this.o = metadata.o;
    }

    public void initialize() {
        this.b = new byte[20];
        this.d = 20;
        this.c = new byte[8];
        this.e = 8;
        this.f = 0;
        this.g = false;
        this.l = null;
        this.m.set(0);
        this.n.set(0);
        this.k = System.currentTimeMillis();
        this.o = false;
    }

    public void invalidate() {
        this.initialize();
    }

    public void randomize() {
        this.randomize(true);
    }

    public void randomize(boolean bl) {
        this.initialize();
        this.randomizeTaskID();
        if (bl) {
            this.randomizeOpID();
        }
        this.setSampled(bl);
    }

    public void randomizeTaskID() {
        q.nextBytes(this.b);
        if (!this.isValid()) {
            this.b[this.d - 1] = 1;
        }
    }

    public void randomizeOpID() {
        q.nextBytes(this.c);
    }

    public void setOpID(Metadata metadata) {
        this.e = metadata.e;
        System.arraycopy(metadata.c, 0, this.c, 0, 8);
    }

    public boolean isValid() {
        return !Arrays.equals(this.b, unsetTaskID);
    }

    public boolean isSampled() {
        return this.getFlag(com.tracelytics.joboe.Metadata$a.a);
    }

    public boolean getFlag(a a2) {
        return (this.f & a2.b) == a2.b;
    }

    public void setSampled(boolean bl) {
        this.setFlag(com.tracelytics.joboe.Metadata$a.a, bl);
    }

    public void setFlag(a a2, boolean bl) {
        if (bl) {
            this.f = (byte)(this.f | a2.b);
            return;
        }
        this.f = (byte)(this.f & ~a2.b);
    }

    public boolean incrNumEvents() {
        int n2 = this.m.incrementAndGet();
        if (n2 == i + 1) {
            a.info("Exceeded maximum number of events allowed per trace [" + i + "] for task ID [" + this.taskHexString() + "]");
        }
        return n2 <= i;
    }

    public boolean incrNumBacktraces() {
        int n2 = this.n.incrementAndGet();
        if (n2 == j + 1) {
            a.info("Exceeded maximum number of backtraces allowed per trace [" + j + "] for task ID [" + this.taskHexString() + "]");
        }
        return n2 <= j;
    }

    public boolean isExpired(long l2) {
        if (this.isValid()) {
            boolean bl = l2 - this.k > (long)h;
            if (bl) {
                a.info("Context of " + this.toHexString() + " has been expired");
            }
            return bl;
        }
        return false;
    }

    public boolean isTaskEqual(Metadata metadata) {
        return Arrays.equals(this.b, metadata.b);
    }

    public boolean isOpEqual(Metadata metadata) {
        return Arrays.equals(this.c, metadata.c);
    }

    public byte[] getPackedMetadata(int n2) {
        int n3 = 1 + this.d + this.e + 1;
        byte[] byArray = new byte[n3];
        int n4 = (this.d >> 2) - 1;
        byArray[0] = (byte)(n2 << 4);
        byArray[0] = (byte)(byArray[0] | (n4 == 4 ? 3 : n4));
        byArray[0] = (byte)(byArray[0] | (this.e >> 2) - 1 << 3);
        System.arraycopy(this.b, 0, byArray, 1, this.d);
        n2 = 1 + this.d;
        System.arraycopy(this.c, 0, byArray, n2, this.e);
        byArray[n2 += this.e] = this.f;
        return byArray;
    }

    public void unpackMetadata(byte[] byArray) throws OboeException {
        if (byArray == null || byArray.length <= 0) {
            throw new OboeException("Byte buffer is not valid");
        }
        int n2 = byArray[0];
        int n3 = (n2 & 0xF0) >> 4;
        if (n3 != 2) {
            throw new OboeException("Unexpected version. Found " + n3 + " but expected 2");
        }
        n3 = (n2 & 3) + 1 << 2;
        n3 = n3 == 16 ? 20 : n3;
        int n4 = n3 + 1 + (n2 = ((n2 & 8) >> 3) + 1 << 2) + 1;
        if (byArray.length < n4) {
            throw new OboeException("Invalid buffer length: expected " + n4);
        }
        this.d = n3;
        this.e = n2;
        System.arraycopy(byArray, 1, this.b, 0, n3);
        System.arraycopy(byArray, ++n3, this.c, 0, n2);
        this.f = byArray[n3 += n2];
        this.k = System.currentTimeMillis();
    }

    public String toHexString() {
        Metadata metadata = this;
        byte[] byArray = metadata.getPackedMetadata(2);
        Metadata metadata2 = metadata;
        return Metadata.a(byArray, byArray.length);
    }

    public String toString() {
        return this.toHexString();
    }

    public String toHexString(int n2) {
        Metadata metadata = this;
        byte[] byArray = metadata.getPackedMetadata(n2);
        Metadata metadata2 = metadata;
        return Metadata.a(byArray, byArray.length);
    }

    public String opHexString() {
        return Metadata.a(this.c, this.e);
    }

    public String taskHexString() {
        return Metadata.a(this.b, this.d);
    }

    public void fromHexString(String string) throws OboeException {
        int n2 = string.length();
        if (n2 % 2 != 0 || n2 > 512) {
            throw new OboeException("Invalid string length");
        }
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            byArray[i2 / 2] = (byte)((Character.digit(string.charAt(i2), 16) << 4) + Character.digit(string.charAt(i2 + 1), 16));
        }
        this.unpackMetadata(byArray);
    }

    public int hashCode() {
        int n2 = 31 + this.f;
        n2 = n2 * 31 + (this.g ? 1231 : 1237);
        n2 = n2 * 31 + Arrays.hashCode(this.c);
        n2 = n2 * 31 + this.e;
        n2 = n2 * 31 + Arrays.hashCode(this.b);
        n2 = n2 * 31 + this.d;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Metadata)object;
        if (this.f != ((Metadata)object).f) {
            return false;
        }
        if (this.g != ((Metadata)object).g) {
            return false;
        }
        if (!Arrays.equals(this.c, ((Metadata)object).c)) {
            return false;
        }
        if (this.e != ((Metadata)object).e) {
            return false;
        }
        if (!Arrays.equals(this.b, ((Metadata)object).b)) {
            return false;
        }
        return this.d == ((Metadata)object).d;
    }

    private static String a(byte[] byArray, int n2) {
        char[] cArray = new char[n2 << 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            cArray[i2 << 1] = hexTable[n3 / 16];
            cArray[(i2 << 1) + 1] = hexTable[n3 % 16];
        }
        return new String(cArray);
    }

    public boolean isAsync() {
        return this.g;
    }

    public void setIsAsync(boolean bl) {
        this.g = bl;
    }

    public void setTraceId(Long l2) {
        this.l = l2;
    }

    public Long getTraceId() {
        return this.l;
    }

    public void setReportMetrics(boolean bl) {
        this.o = bl;
    }

    public boolean isReportMetrics() {
        return this.o;
    }

    public static boolean isCompatible(String string) {
        try {
            new Metadata(string);
            return true;
        }
        catch (OboeException oboeException) {
            a.debug("X-Trace ID [" + string + "] not compatible : " + oboeException.getMessage());
            return false;
        }
    }

    public int incrementAndGetAsyncLayerLevel() {
        return ++this.p;
    }

    public int decrementAndGetAsyncLayerLevel() {
        return --this.p;
    }

    public String getCompactTraceId() {
        return this.taskHexString() + "-" + (this.isSampled() ? "1" : "0");
    }

    static {
        Integer n2 = (Integer)ConfigManager.getConfig(ConfigProperty.AGENT_CONTEXT_TTL);
        h = n2 != null ? n2 * 1000 : 1200000;
        n2 = (Integer)ConfigManager.getConfig(ConfigProperty.AGENT_CONTEXT_MAX_EVENTS);
        i = n2 != null ? n2 : 100000;
        n2 = (Integer)ConfigManager.getConfig(ConfigProperty.AGENT_CONTEXT_MAX_BACKTRACES);
        j = n2 != null ? n2 : 1000;
        SettingsManager.registerListener(new SettingsArgChangeListener<Integer>(SettingsArg.MAX_CONTEXT_AGE){

            @Override
            public final /* synthetic */ void a(Object object) {
                if ((object = (Integer)object) != null) {
                    h = (Integer)object * 1000;
                    return;
                }
                h = 1200000;
            }
        });
        SettingsManager.registerListener(new SettingsArgChangeListener<Integer>(SettingsArg.MAX_CONTEXT_EVENTS){

            @Override
            public final /* synthetic */ void a(Object object) {
                i = (object = (Integer)object) != null ? (Integer)object : 100000;
            }
        });
        SettingsManager.registerListener(new SettingsArgChangeListener<Integer>(SettingsArg.MAX_CONTEXT_BACKTRACES){

            @Override
            public final /* synthetic */ void a(Object object) {
                j = (object = (Integer)object) != null ? (Integer)object : 1000;
            }
        });
        q = null;
        try {
            try {
                q = new g(new DevURandomSeedGenerator());
            }
            catch (e e2) {
                a.debug("Failed to use /dev/urandom as seed generator. Error message : " + e2.getMessage());
                q = new g(new d());
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Exception performing whole class analysis.
     */
    static final class a
    extends Enum<a> {
        private final byte b;

        private a(byte by) {
            this.b = 1;
        }
    }
}

