/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class EventValueConverter {
    protected static final Logger logger = LoggerFactory.getLogger();
    private static final Set<Class<?>> EXPECTED_SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Double.class, Integer.class, Long.class));
    protected final Map<Class<?>, Converter<?, ?>> EXPECTED_SPECIAL_TYPES = new LinkedHashMap();
    private static final Converter<?, ?> DEFAULT_HANDLER = new ClassNameParameterHandler();
    public static final int DEFAULT_MAX_LENGTH = 1024;
    public final int maxValueLength;
    private final Logger.Level logLevel;

    public EventValueConverter() {
        this(1024);
    }

    public EventValueConverter(int n2) {
        this(n2, Logger.Level.INFO);
    }

    public EventValueConverter(int n2, Logger.Level level) {
        this.EXPECTED_SPECIAL_TYPES.put(String.class, new i());
        this.EXPECTED_SPECIAL_TYPES.put(Date.class, new i());
        this.EXPECTED_SPECIAL_TYPES.put(byte[].class, new c());
        this.EXPECTED_SPECIAL_TYPES.put(URL.class, new ToStringParameterHandler());
        this.EXPECTED_SPECIAL_TYPES.put(BigDecimal.class, new a());
        this.EXPECTED_SPECIAL_TYPES.put(BigInteger.class, new b());
        this.EXPECTED_SPECIAL_TYPES.put(Float.class, new f());
        this.EXPECTED_SPECIAL_TYPES.put(Short.class, new h());
        this.EXPECTED_SPECIAL_TYPES.put(Byte.class, new d());
        this.EXPECTED_SPECIAL_TYPES.put(Character.class, new ToStringParameterHandler());
        this.EXPECTED_SPECIAL_TYPES.put(InetAddress.class, new ToStringParameterHandler());
        this.EXPECTED_SPECIAL_TYPES.put(Collection.class, new e());
        this.EXPECTED_SPECIAL_TYPES.put(Map.class, new g());
        this.EXPECTED_SPECIAL_TYPES.put(UUID.class, new ToStringParameterHandler());
        this.maxValueLength = n2;
        this.logLevel = level;
    }

    public Object convertToEventValue(Object object) {
        if (object == null) {
            return null;
        }
        if (EXPECTED_SIMPLE_TYPES.contains(object.getClass())) {
            return object;
        }
        return this.getValueFromSpecialType(object);
    }

    private Object getValueFromSpecialType(Object object) {
        Object object2;
        Iterator<Class<?>> iterator;
        Converter<?, ?> converter = null;
        if (this.EXPECTED_SPECIAL_TYPES.containsKey(object.getClass())) {
            converter = this.EXPECTED_SPECIAL_TYPES.get(object.getClass());
        } else {
            iterator = this.EXPECTED_SPECIAL_TYPES.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (!((Class)object2).isInstance(object)) continue;
                converter = this.EXPECTED_SPECIAL_TYPES.get(object2);
                break;
            }
        }
        if (converter == null) {
            logger.debug("Class [" + object.getClass().getName() + "] is not in the expected list of classes for PreparedStatement parameter. Using the default handler");
            converter = DEFAULT_HANDLER;
        }
        if ((iterator = converter.getValue(object)) instanceof String) {
            object2 = (String)((Object)iterator);
            if (((String)object2).length() > this.maxValueLength) {
                logger.log(this.logLevel, "Parameter truncated as it is too long [" + ((String)object2).length() + "] characters");
                int n2 = ((String)object2).length() - this.maxValueLength;
                object2 = ((String)object2).substring(0, this.maxValueLength) + "...(" + n2 + " characters truncated)";
            }
            return object2;
        }
        return iterator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class i
    extends Converter<Object, Object> {
        private i() {
        }

        @Override
        protected final Object getValue(Object object) {
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class d
    extends Converter<Byte, Integer> {
        private d() {
        }

        @Override
        protected final Integer getValue(Byte by) {
            return (int)by;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class h
    extends Converter<Short, Integer> {
        private h() {
        }

        @Override
        protected final Integer getValue(Short s2) {
            return s2.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class f
    extends Converter<Float, Double> {
        private f() {
        }

        @Override
        protected final Double getValue(Float f2) {
            return f2.doubleValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class b
    extends Converter<BigInteger, Long> {
        private b() {
        }

        @Override
        protected final Long getValue(BigInteger bigInteger) {
            return bigInteger.longValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class a
    extends Converter<BigDecimal, Double> {
        private a() {
        }

        @Override
        protected final Double getValue(BigDecimal bigDecimal) {
            return bigDecimal.doubleValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class g
    extends Converter<Map<?, ?>, String> {
        private g() {
        }

        @Override
        protected final String getValue(Map<?, ?> map) {
            return "(Map of class [" + map.getClass().getName() + "] with " + map.size() + " Elements) id [" + System.identityHashCode(map) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class e
    extends Converter<Collection<?>, String> {
        private e() {
        }

        @Override
        protected final String getValue(Collection<?> collection) {
            return "(Collection of class [" + collection.getClass().getName() + "] with " + collection.size() + " Elements) id [" + System.identityHashCode(collection) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class c
    extends Converter<byte[], String> {
        private c() {
        }

        @Override
        protected final String getValue(byte[] byArray) {
            return "(Byte array " + byArray.length + " Bytes) id [" + System.identityHashCode(byArray) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassNameParameterHandler
    extends Converter<Object, String> {
        @Override
        protected String getValue(Object object) {
            return "(" + object.getClass().getName() + ") id [" + System.identityHashCode(object) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToStringParameterHandler
    extends Converter<Object, String> {
        @Override
        protected String getValue(Object object) {
            return object.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Converter<T, R> {
        protected Converter() {
        }

        protected abstract R getValue(T var1);
    }
}

