/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.a.c.d;
import com.tracelytics.a.c.e;
import com.tracelytics.a.c.j;
import com.tracelytics.a.c.k;
import com.tracelytics.a.c.q;
import com.tracelytics.joboe.BsonBufferException;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.EventReporter;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.a;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.HostInfoUtils;
import com.tracelytics.util.JavaProcessUtils;
import com.tracelytics.util.TimeUtils;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventImpl
extends Event {
    private static final Logger b = LoggerFactory.getLogger();
    private d.a c;
    private q<String> d = new q(1);
    private boolean e = false;
    private boolean f = false;
    private boolean g = false;
    private Long h = null;
    private Long i = null;
    private static EventReporter j;
    private static final Collection<String> k;
    private static final ThreadLocal<ByteBuffer> l;

    EventImpl(Metadata metadata, boolean bl) {
        super(new Metadata(metadata));
        if (metadata.isSampled()) {
            EventImpl eventImpl = this;
            eventImpl.a.randomizeOpID();
            eventImpl.c = com.tracelytics.a.c.e.a();
            eventImpl.c.a("X-Trace", eventImpl.a.toHexString());
            if (bl) {
                this.addEdge(metadata);
            }
        }
    }

    EventImpl(Metadata metadata, String string, boolean bl) throws OboeException {
        super(new Metadata(string));
        this.a();
        this.addEdge(metadata);
    }

    EventImpl(Metadata metadata, Metadata metadata2) {
        super(metadata2);
        this.a();
        if (metadata != null) {
            this.addEdge(metadata);
        }
    }

    public static EventReporter getEventReporter() {
        return j;
    }

    private void a() {
        this.c = com.tracelytics.a.c.e.a();
        this.c.a("X-Trace", this.a.toHexString());
    }

    @Override
    public void addInfo(String string, Object object) {
        if (this.a.isSampled()) {
            this.a(string, object);
        }
    }

    @Override
    public void addInfo(Map<String, ?> object) {
        if (this.a.isSampled()) {
            for (Map.Entry entry : object.entrySet()) {
                this.a((String)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void addInfo(Object ... objectArray) {
        if (this.a.isSampled()) {
            if (objectArray.length % 2 == 1) {
                throw new RuntimeException("Even number of arguments expected");
            }
            for (int i2 = 0; i2 < objectArray.length / 2; ++i2) {
                if (!(objectArray[i2 << 1] instanceof String)) {
                    throw new RuntimeException("String expected.");
                }
                this.a((String)objectArray[i2 << 1], objectArray[(i2 << 1) + 1]);
            }
        }
    }

    private void a(String string, Object object) {
        if ("Label".equals(string) && object instanceof String) {
            if ("entry".equals((String)object)) {
                this.f = true;
            } else if ("exit".equals((String)object)) {
                this.g = true;
            }
        } else if ("Backtrace".equals(string) && !this.a.incrNumBacktraces()) {
            return;
        }
        this.c.a(string, object);
    }

    @Override
    public void addEdge(Metadata metadata) {
        if (this.a.isSampled() && metadata.isSampled() && this.a.isTaskEqual(metadata) && !this.d.contains(metadata.opHexString())) {
            this.d.add(metadata.opHexString());
        }
    }

    @Override
    public void addEdge(String string) {
        try {
            this.addEdge(new Metadata(string));
            return;
        }
        catch (OboeException oboeException) {
            b.debug("Invalid XTrace ID: " + string, oboeException);
            return;
        }
    }

    @Override
    public void setAsync() {
        this.e = true;
    }

    @Override
    public void report(EventReporter eventReporter) {
        this.report(Context.getMetadata(), eventReporter);
    }

    @Override
    public void report() {
        this.report(Context.getMetadata(), j);
    }

    @Override
    public void report(Metadata metadata) {
        this.report(metadata, j);
    }

    @Override
    public void report(Metadata metadata, EventReporter eventReporter) {
        if (eventReporter == null) {
            return;
        }
        if (metadata != null) {
            if (!this.a.isSampled()) {
                return;
            }
            if (!this.a.isTaskEqual(metadata)) {
                return;
            }
            if (this.a.isOpEqual(metadata)) {
                return;
            }
        }
        EventImpl eventImpl = this;
        if (!eventImpl.d.isEmpty()) {
            eventImpl.addInfo("Edge", eventImpl.d);
        }
        eventImpl = this;
        if (eventImpl.i == null) {
            eventImpl.i = TimeUtils.getTimestampMicroSeconds();
        }
        eventImpl.addInfo("Timestamp_u", (Object)eventImpl.i);
        eventImpl = this;
        eventImpl.addInfo("TID", (Object)(eventImpl.h != null ? eventImpl.h.longValue() : Thread.currentThread().getId()));
        eventImpl.addInfo("PID", (Object)JavaProcessUtils.getPid());
        eventImpl = this;
        eventImpl.addInfo("Hostname", (Object)HostInfoUtils.getHostName());
        if (this.e) {
            this.b();
        } else if (metadata != null && metadata.isAsync()) {
            if (this.f) {
                if (metadata.incrementAndGetAsyncLayerLevel() == 1) {
                    this.b();
                }
            } else if (this.g) {
                metadata.decrementAndGetAsyncLayerLevel();
            }
        }
        try {
            eventReporter.send(this);
            if (metadata != null) {
                metadata.setOpID(this.a);
            }
            return;
        }
        catch (a a2) {
            b.trace("Failed to send out event, exception message [" + a2.getMessage() + "]. Please take note that existing code flow should not be affected, this might only impact the instrumentation of current trace");
            return;
        }
        catch (Throwable throwable) {
            b.error("Failed to send out event, exception message [" + throwable.getMessage() + "]. Please take note that existing code flow should not be affected, this might only impact the instrumentation of current trace", throwable);
            return;
        }
    }

    @Override
    public byte[] toBytes() throws BsonBufferException {
        Object object = this.c.a();
        k k2 = com.tracelytics.a.c.j.a.b();
        ByteBuffer byteBuffer = l.get();
        ((Buffer)byteBuffer).clear();
        boolean bl = false;
        try {
            k2.a(byteBuffer, object);
        }
        catch (BufferOverflowException bufferOverflowException) {
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        if (bl) {
            b.warn("The KVs are too big to be converted. Trimming down the KVs...");
            object = EventImpl.a((d)object);
            ((Buffer)byteBuffer).clear();
            if (object != null) {
                RuntimeException runtimeException = null;
                try {
                    k2.a(byteBuffer, object);
                }
                catch (BufferOverflowException bufferOverflowException) {
                    object = bufferOverflowException;
                    runtimeException = bufferOverflowException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    object = illegalArgumentException;
                    runtimeException = illegalArgumentException;
                }
                if (runtimeException != null) {
                    throw new BsonBufferException(runtimeException);
                }
            }
        }
        ((Buffer)byteBuffer).flip();
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public ByteBuffer toByteBuffer() throws BsonBufferException {
        return ByteBuffer.wrap(this.toBytes());
    }

    private static d a(d object) {
        d.a a2 = com.tracelytics.a.c.e.a();
        int n2 = 524288;
        Object object2 = object;
        object2 = new LinkedHashMap<String, Object>((Map<String, Object>)object2);
        object2.keySet().retainAll(k);
        for (Map.Entry entry : object2.entrySet()) {
            n2 -= EventImpl.a(entry.getKey());
            try {
                n2 -= EventImpl.a(entry.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                b.warn("Unknown value type for basic key [" + (String)entry.getKey() + "]. Type [" + entry.getValue().getClass().getName() + "]");
            }
        }
        if (n2 < 0) {
            b.warn("Cannot send an event as the basic key values fail to fit in the event!");
            return null;
        }
        a2.a((Map<String, Object>)object2);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>((Map<String, Object>)object);
        linkedHashMap.keySet().removeAll(k);
        EventImpl.a(linkedHashMap);
        int n3 = n2 / linkedHashMap.size();
        b.debug("Trimming KVs on other key count " + linkedHashMap.size() + " maxBytePerKeyValue " + n3);
        object = ByteBuffer.allocate(524288).order(ByteOrder.LITTLE_ENDIAN);
        k k2 = com.tracelytics.a.c.j.a.b();
        k2.a((ByteBuffer)object, a2.a());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            int n4;
            Object object3;
            if (EventImpl.a(entry.getKey()) >= n3) {
                b.warn("Dropping event entry with key [" + ((String)entry.getKey()).substring(0, 10) + "...] as the key is too long");
                continue;
            }
            int n5 = n3 - EventImpl.a(entry.getKey());
            Object object4 = entry.getValue();
            if (object4 instanceof String) {
                if (EventImpl.a(object4) > n5) {
                    object4 = ((String)object4).substring(0, n5 / 2);
                }
            } else if (object4 instanceof Object[]) {
                Object[] objectArray;
                int n6;
                object3 = (Object[])object4;
                n4 = 0;
                for (n6 = 0; n6 < ((Object[])object3).length; ++n6) {
                    objectArray = object3[n6];
                    try {
                        n4 += EventImpl.a(objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        b.warn("Found unknown type [" + objectArray.getClass().getName() + "] in KV " + (String)entry.getKey() + " while trimming the doc. Trimming the rest of the elements in the array...");
                        break;
                    }
                    if ((n4 += 8) <= n5) continue;
                    b.warn("Found oversized array in KV " + (String)entry.getKey() + " while trimming the doc. Trimming the elements with index from " + n6);
                    break;
                }
                if (n6 < ((Object[])object3).length) {
                    objectArray = new Object[n6];
                    System.arraycopy(object3, 0, objectArray, 0, n6);
                    object4 = objectArray;
                }
            } else {
                try {
                    b.debug("Skip " + (String)entry.getKey() + " for trimming as it is type " + (entry.getValue() != null ? entry.getValue().getClass().getName() : "null ") + ". Estimated size is " + EventImpl.a(entry.getValue()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    b.warn("Skip " + (String)entry.getKey() + " for trimming as it is type " + (entry.getValue() != null ? entry.getValue().getClass().getName() : "null ") + ". Size cannot be estimated: " + illegalArgumentException.getMessage(), illegalArgumentException);
                }
            }
            object3 = com.tracelytics.a.c.e.a();
            object3.a((String)entry.getKey(), object4);
            n4 = ((Buffer)object).position();
            try {
                k2.a((ByteBuffer)object, object3.a());
                a2.a((String)entry.getKey(), object4);
            }
            catch (BufferOverflowException bufferOverflowException) {
                b.warn("Failed to write KV [" + (String)entry.getKey() + "] to event, as adding it does not fit the bytebuffer, skipping this KV!");
                ((Buffer)object).position(n4);
            }
        }
        object2 = a2.a();
        return object2;
    }

    private static int a(Object object) {
        if (object instanceof String) {
            return ((String)object).length() << 1;
        }
        if (object instanceof Boolean) {
            return 1;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return 8;
        }
        if (object.getClass().isArray()) {
            int n2 = 0;
            int n3 = Array.getLength(object);
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object2 = Array.get(object, i2);
                n2 += EventImpl.a(object2);
            }
            return n2;
        }
        if (object instanceof q) {
            q q2 = (q)object;
            int n4 = 0;
            for (Object e2 : q2) {
                n4 += EventImpl.a(e2);
            }
            return n4;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int n5 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                n5 += EventImpl.a(iterator.next());
            }
            return n5;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            int n6 = 0;
            for (Map.Entry entry : map.entrySet()) {
                n6 += EventImpl.a(entry.getKey()) + EventImpl.a(entry.getValue());
            }
            return n6;
        }
        if (object == null) {
            return 1;
        }
        throw new IllegalArgumentException("unknown size for type [" + object.getClass().getName() + "]");
    }

    private static void a(Map<String, Object> map) {
        if (map.size() > 1024) {
            b.warn("Found " + map.size() + " KVs in the event, trimming it down to 1024");
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (hashSet.size() >= 1024) break;
                hashSet.add(entry.getKey());
            }
            map.keySet().retainAll(hashSet);
        }
    }

    private void b() {
        this.addInfo("Async", (Object)Boolean.TRUE);
    }

    @Override
    public void setTimestamp(long l2) {
        this.i = l2;
    }

    @Override
    public void setThreadId(Long l2) {
        this.h = l2;
    }

    public static EventReporter setDefaultReporter(EventReporter eventReporter) {
        EventReporter eventReporter2 = j;
        j = eventReporter;
        return eventReporter2;
    }

    static {
        k = Arrays.asList("Layer", "Label", "Async", "Edge", "TID", "Hostname", "X-Trace", "PID", "Timestamp_u");
        l = new ThreadLocal<ByteBuffer>(){

            @Override
            protected final /* synthetic */ Object initialValue() {
                return ByteBuffer.allocate(524288).order(ByteOrder.LITTLE_ENDIAN);
            }
        };
    }
}

