/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.instrumentation.http;

import com.tracelytics.a.f.f;
import com.tracelytics.a.f.g;
import com.tracelytics.a.f.j;
import com.tracelytics.a.f.o;
import com.tracelytics.instrumentation.ClassInstrumentation;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.instrumentation.config.HideParamsConfig;
import com.tracelytics.instrumentation.http.HttpURLConnection;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.OboeException;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.util.HttpUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class HttpURLConnectionInstrumentation
extends ClassInstrumentation {
    private static final String f = HttpURLConnectionInstrumentation.class.getName();
    private static boolean g = ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS) != null ? ((HideParamsConfig)ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS)).shouldHideParams(Module.URL_CONNECTION) : false;
    private static ThreadLocal<Integer> h = new ThreadLocal<Integer>(){

        @Override
        protected final /* synthetic */ Object initialValue() {
            return 0;
        }
    };
    private static ThreadLocal<Integer> i = new ThreadLocal<Integer>(){

        @Override
        protected final /* synthetic */ Object initialValue() {
            return 0;
        }
    };

    public boolean applyInstrumentation(g g2, String object, byte[] object2) throws Exception {
        if (g2.a(this.d.c("javax.net.ssl.HttpsURLConnection"))) {
            return false;
        }
        object2 = j.a("private boolean tvInputStreamReported;", g2);
        object = g2;
        ((g)object).a((j)object2, (j.c)null);
        object2 = g2;
        object = "public boolean isTvInputStreamReported() { return tvInputStreamReported; }";
        g2.a(o.a("public boolean isTvInputStreamReported() { return tvInputStreamReported; }", (g)object2, null, null));
        object2 = g2;
        object = "public void setTvInputStreamReported(boolean inputStreamReported) { tvInputStreamReported = inputStreamReported; }";
        g2.a(o.a("public void setTvInputStreamReported(boolean inputStreamReported) { tvInputStreamReported = inputStreamReported; }", (g)object2, null, null));
        object2 = j.a("private String tvEntryHttpMethod;", g2);
        object = g2;
        ((g)object).a((j)object2, (j.c)null);
        object2 = g2;
        object = "public String tvGetEntryHttpMethod() { return tvEntryHttpMethod; }";
        g2.a(o.a("public String tvGetEntryHttpMethod() { return tvEntryHttpMethod; }", (g)object2, null, null));
        object2 = g2;
        object = "public void tvSetEntryHttpMethod(String httpMethod) { tvEntryHttpMethod = httpMethod; }";
        g2.a(o.a("public void tvSetEntryHttpMethod(String httpMethod) { tvEntryHttpMethod = httpMethod; }", (g)object2, null, null));
        object2 = j.a("private java.net.URL tvEntryUrl;", g2);
        object = g2;
        ((g)object).a((j)object2, (j.c)null);
        object2 = g2;
        object = "public java.net.URL tvGetEntryUrl() { return tvEntryUrl; }";
        g2.a(o.a("public java.net.URL tvGetEntryUrl() { return tvEntryUrl; }", (g)object2, null, null));
        object2 = g2;
        object = "public void tvSetEntryUrl(java.net.URL entryUrl) { tvEntryUrl = entryUrl; }";
        g2.a(o.a("public void tvSetEntryUrl(java.net.URL entryUrl) { tvEntryUrl = entryUrl; }", (g)object2, null, null));
        object2 = j.a("private String tvEntryXTraceId;", g2);
        object = g2;
        ((g)object).a((j)object2, (j.c)null);
        object2 = g2;
        object = "public String tvGetEntryXTraceId() { return tvEntryXTraceId; }";
        g2.a(o.a("public String tvGetEntryXTraceId() { return tvEntryXTraceId; }", (g)object2, null, null));
        object2 = g2;
        object = "public void tvSetEntryXTraceId(String entryXTraceId) { tvEntryXTraceId = entryXTraceId; }";
        g2.a(o.a("public void tvSetEntryXTraceId(String entryXTraceId) { tvEntryXTraceId = entryXTraceId; }", (g)object2, null, null));
        this.a(g2, HttpURLConnection.class.getName());
        object = g2.a("connect", "()V");
        if (HttpURLConnectionInstrumentation.shouldModify(g2, (f)object)) {
            HttpURLConnectionInstrumentation.insertBefore((f)object, f + ".connectEntry(this, connected);", false);
            HttpURLConnectionInstrumentation.addErrorReporting((f)object, IOException.class.getName(), "http-connect", this.d);
            HttpURLConnectionInstrumentation.insertAfter((f)object, f + ".connectExit();", true);
        }
        if (HttpURLConnectionInstrumentation.shouldModify(g2, (f)(object = g2.a("getInputStream", "()Ljava/io/InputStream;")))) {
            HttpURLConnectionInstrumentation.insertBefore((f)object, f + ".getInputStreamEntry(this, connected);", false);
            HttpURLConnectionInstrumentation.addErrorReporting((f)object, IOException.class.getName(), null, this.d);
            HttpURLConnectionInstrumentation.insertAfter((f)object, f + ".getInputStreamExit(this.responseCode, this);", true);
        }
        if (HttpURLConnectionInstrumentation.shouldModify(g2, (f)(object = g2.a("getOutputStream", "()Ljava/io/OutputStream;")))) {
            HttpURLConnectionInstrumentation.insertBefore((f)object, f + ".getOutputStreamEntry(this, connected);", false);
        }
        return true;
    }

    public static void addXTraceHeader(java.net.HttpURLConnection httpURLConnection, boolean bl) {
        block3: {
            if (bl) {
                return;
            }
            Object object = Context.getMetadata();
            if (!((Metadata)object).isValid()) break block3;
            try {
                block6: {
                    block4: {
                        block5: {
                            if (httpURLConnection.getRequestProperty("X-Trace") != null) break block4;
                            if (!((Metadata)object).isSampled() || httpURLConnection.getDoOutput()) break block5;
                            if (((HttpURLConnection)((Object)httpURLConnection)).tvGetEntryXTraceId() != null) break block4;
                            break block6;
                        }
                        httpURLConnection.addRequestProperty("X-Trace", ((Metadata)object).toHexString());
                    }
                    return;
                }
                object = new Metadata((Metadata)object);
                ((Metadata)object).randomizeOpID();
                object = ((Metadata)object).toHexString();
                httpURLConnection.addRequestProperty("X-Trace", (String)object);
                ((HttpURLConnection)((Object)httpURLConnection)).tvSetEntryXTraceId((String)object);
            }
            catch (IllegalStateException illegalStateException) {
                a.debug("Failed attempt to get/set request property on the connnection. Probably connecting on oracle jdk 8...");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void getInputStreamEntry(java.net.HttpURLConnection httpURLConnection, boolean bl) {
        if (Context.getMetadata().isValid()) {
            HttpURLConnectionInstrumentation.addXTraceHeader(httpURLConnection, bl);
        }
        if (Context.getMetadata().isSampled()) {
            int object = h.get();
            h.set(object + 1);
            if (object == 0 && !((HttpURLConnection)((Object)httpURLConnection)).isTvInputStreamReported()) {
                void var1_6;
                block8: {
                    String string = ((HttpURLConnection)((Object)httpURLConnection)).tvGetEntryXTraceId();
                    if (string != null) {
                        try {
                            Event event = Context.createEventWithID(string);
                            break block8;
                        }
                        catch (OboeException oboeException) {
                            a.warn(oboeException.getMessage(), oboeException);
                        }
                    }
                    Event event = Context.createEvent();
                }
                Object object2 = httpURLConnection.getRequestMethod();
                var1_6.addInfo("Layer", HttpURLConnectionInstrumentation.a((String)object2), "Label", "entry", "IsService", Boolean.TRUE, "Spec", "rsc", "JavaMethod", "getInputStream");
                if (object2 != null) {
                    var1_6.addInfo("HTTPMethod", object2);
                    ((HttpURLConnection)((Object)httpURLConnection)).tvSetEntryHttpMethod((String)object2);
                }
                if ((object2 = httpURLConnection.getURL()) != null) {
                    var1_6.addInfo("RemoteURL", (Object)(g ? HttpUtils.trimQueryParameters(((URL)object2).toString()) : ((URL)object2).toString()));
                    ((HttpURLConnection)((Object)httpURLConnection)).tvSetEntryUrl((URL)object2);
                }
                HttpURLConnectionInstrumentation.addBackTrace((Event)var1_6, 1, Module.URL_CONNECTION);
                var1_6.report();
            }
        }
    }

    public static void getInputStreamExit(int n2, java.net.HttpURLConnection httpURLConnection) {
        int n3 = h.get();
        h.set(n3 - 1);
        if (n3 == 1 && !((HttpURLConnection)((Object)httpURLConnection)).isTvInputStreamReported()) {
            Event event = Context.createEvent();
            event.addInfo("HTTPStatus", n2, "Label", "exit", "Layer", HttpURLConnectionInstrumentation.a(((HttpURLConnection)((Object)httpURLConnection)).tvGetEntryHttpMethod()));
            URL uRL = httpURLConnection.getURL();
            if (uRL != null && !uRL.equals(((HttpURLConnection)((Object)httpURLConnection)).tvGetEntryUrl())) {
                event.addInfo("RedirectRemoteURL", (Object)(g ? HttpUtils.trimQueryParameters(uRL.toString()) : uRL.toString()));
                event.addInfo("RedirectHTTPMethod", (Object)httpURLConnection.getRequestMethod());
            } else if (httpURLConnection.getRequestMethod() != null && !httpURLConnection.getRequestMethod().equals(((HttpURLConnection)((Object)httpURLConnection)).tvGetEntryHttpMethod())) {
                event.addInfo("RedirectHTTPMethod", (Object)httpURLConnection.getRequestMethod());
            }
            event.report();
            ((HttpURLConnection)((Object)httpURLConnection)).setTvInputStreamReported(true);
            ((HttpURLConnection)((Object)httpURLConnection)).tvSetEntryUrl(null);
            ((HttpURLConnection)((Object)httpURLConnection)).tvSetEntryHttpMethod(null);
            ((HttpURLConnection)((Object)httpURLConnection)).tvSetEntryXTraceId(null);
        }
    }

    public static void getOutputStreamEntry(java.net.HttpURLConnection httpURLConnection, boolean bl) {
        if (Context.getMetadata().isValid()) {
            HttpURLConnectionInstrumentation.addXTraceHeader(httpURLConnection, bl);
        }
    }

    private static String a(String string) {
        if (string != null) {
            return "http-" + string.toLowerCase();
        }
        return "http";
    }

    public static void connectEntry(java.net.HttpURLConnection object, boolean bl) {
        if (Context.getMetadata().isValid()) {
            HttpURLConnectionInstrumentation.addXTraceHeader((java.net.HttpURLConnection)object, bl);
        }
        if (Context.getMetadata().isSampled()) {
            int event = i.get();
            i.set(event + 1);
            if (event == 0) {
                Event event2 = Context.createEvent();
                event2.addInfo("Layer", "http-connect", "Label", "entry", "IsService", Boolean.TRUE, "Spec", "rsc", "JavaMethod", "connect");
                object = ((URLConnection)object).getURL();
                if (object != null) {
                    event2.addInfo("RemoteURL", (Object)(g ? HttpUtils.trimQueryParameters(((URL)object).toString()) : ((URL)object).toString()));
                }
                HttpURLConnectionInstrumentation.addBackTrace(event2, 1, Module.URL_CONNECTION);
                event2.report();
            }
        }
    }

    public static void connectExit() {
        int n2 = i.get();
        i.set(n2 - 1);
        if (n2 == 1) {
            Event event = Context.createEvent();
            event.addInfo("Layer", "http-connect", "Label", "exit");
            event.report();
        }
    }
}

