/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.instrumentation.http;

import com.tracelytics.a.f.g;
import com.tracelytics.a.f.l;
import com.tracelytics.instrumentation.ClassInstrumentation;
import com.tracelytics.instrumentation.MethodMatcher;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.instrumentation.config.HideParamsConfig;
import com.tracelytics.instrumentation.http.HttpRequest;
import com.tracelytics.instrumentation.http.HttpResponse;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.span.impl.Span;
import com.tracelytics.joboe.span.impl.TraceEventSpanReporter;
import com.tracelytics.joboe.span.impl.Tracer;
import com.tracelytics.util.HttpUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientInstrumentation
extends ClassInstrumentation {
    private static String f = HttpClientInstrumentation.class.getName();
    private static String g = "java_http_client";
    private static List<MethodMatcher<a>> h = Arrays.asList(new MethodMatcher<a>("send", new String[]{"java.net.http.HttpRequest"}, "java.net.http.HttpResponse", com.tracelytics.instrumentation.http.HttpClientInstrumentation$a.a), new MethodMatcher<a>("sendAsync", new String[]{"java.net.http.HttpRequest", "java.net.http.HttpResponse$BodyHandler", "java.net.http.HttpResponse$PushPromiseHandler", "java.util.concurrent.Executor"}, "java.util.concurrent.CompletableFuture", com.tracelytics.instrumentation.http.HttpClientInstrumentation$a.b, true));
    private static boolean i = ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS) != null ? ((HideParamsConfig)ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS)).shouldHideParams(Module.JAVA_HTTP_CLIENT) : false;
    private static ThreadLocal<Boolean> j = new ThreadLocal<Boolean>(){};
    private static ThreadLocal<Span> k = new ThreadLocal();

    @Override
    public boolean applyInstrumentation(g object, String object2, byte[] object32) throws Exception {
        object2 = this.d.c(Throwable.class.getName());
        for (Object object32 : this.a((g)((Object)object), h).entrySet()) {
            l l2 = object32.getKey();
            object32 = (a)((Object)object32.getValue());
            String string = HttpClientInstrumentation.b(f + ".onThrowable($e);");
            if (object32 == com.tracelytics.instrumentation.http.HttpClientInstrumentation$a.a) {
                HttpClientInstrumentation.insertBefore(l2, f + ".sendEntry($1);", false);
                l2.a("{ " + string + " throw $e; }", (g)object2);
                HttpClientInstrumentation.insertAfter(l2, f + ".sendExit($_, $1);", true, false);
                continue;
            }
            if (object32 != com.tracelytics.instrumentation.http.HttpClientInstrumentation$a.b) continue;
            HttpClientInstrumentation.insertBefore(l2, f + ".sendAsyncEntry($1);", false);
            l2.a("{ " + string + " throw $e; }", (g)object2);
            HttpClientInstrumentation.insertAfter(l2, f + ".sendAsyncExit($_, $1);", true, false);
        }
        return true;
    }

    public static void sendEntry(Object object) {
        j.set(Boolean.TRUE);
        HttpClientInstrumentation.a(object);
    }

    public static void sendExit(Object object, Object object2) {
        if (Context.getMetadata().isValid()) {
            Span span = k.get();
            if (object2 instanceof HttpRequest) {
                ((HttpRequest)object2).setTvContext(null);
            }
            if (span != null) {
                span.setTag("HTTPStatus", ((HttpResponse)object).statusCode());
                object = ((HttpResponse)object).tvGetHeader("X-Trace");
                if (object != null) {
                    span.setSpanPropertyValue(Span.SpanProperty.CHILD_EDGES, Collections.singleton(object));
                }
                span.finish();
            }
        }
        k.remove();
        j.set(Boolean.FALSE);
    }

    public static void sendAsyncEntry(Object object) {
        if (!j.get().booleanValue()) {
            HttpClientInstrumentation.a(object);
        }
    }

    private static void a(Object object) {
        if (Context.getMetadata().isValid() && k.get() == null) {
            if (!(object instanceof HttpRequest)) {
                a.warn(object + " is not tagged with " + HttpRequest.class.getName() + " . Skipping instrumentation.");
                return;
            }
            HttpRequest httpRequest = (HttpRequest)object;
            if (Context.getMetadata().isSampled()) {
                String string;
                object = httpRequest.uri();
                String string2 = ((URI)object).getPath();
                if (string2 == null) {
                    string2 = "/";
                }
                if ((string = ((URI)object).getQuery()) != null && !i) {
                    string2 = string2 + "?" + string;
                }
                string = ((URI)object).getHost();
                String string3 = ((URI)object).getScheme();
                int n2 = ((URI)object).getPort();
                object = string != null && string3 != null ? string3 + "://" + (n2 != -1 ? string + ":" + n2 : string) + string2 : (i ? HttpUtils.trimQueryParameters(((URI)object).toString()) : ((URI)object).toString());
                object = Tracer.INSTANCE.buildSpan(g).withReporters(TraceEventSpanReporter.REPORTER).withTag("Spec", "rsc").withTag("IsService", true).withTag("HTTPMethod", httpRequest.method()).withTag("RemoteURL", (String)object);
                if (!j.get().booleanValue()) {
                    ((Tracer.SpanBuilder)object).withSpanProperty(Span.SpanProperty.IS_ASYNC, Boolean.TRUE);
                }
                object = ((Tracer.SpanBuilder)object).start();
                HttpClientInstrumentation.addBackTrace((Span)object, 1, Module.JAVA_HTTP_CLIENT);
            } else {
                object = Tracer.INSTANCE.buildSpan(g).start();
            }
            httpRequest.setTvContext(((Span)object).context().getMetadata());
            k.set((Span)object);
        }
    }

    public static <T> void sendAsyncExit(CompletableFuture<T> completableFuture, Object object) {
        Span span = k.get();
        if (Context.getMetadata().isValid() && !j.get().booleanValue() && span != null) {
            k.remove();
            if (object instanceof HttpRequest) {
                ((HttpRequest)object).setTvContext(null);
            }
            completableFuture.whenComplete(new BiConsumer<T, Throwable>(span){
                private /* synthetic */ Span a;
                {
                    this.a = span;
                }

                @Override
                public final /* synthetic */ void accept(Object object, Object object2) {
                    Throwable throwable = (Throwable)object2;
                    object2 = object;
                    object = this;
                    if (throwable != null) {
                        ClassInstrumentation.reportError(object.a, throwable);
                    } else {
                        object.a.setTag("HTTPStatus", ((HttpResponse)object2).statusCode());
                        object2 = ((HttpResponse)object2).tvGetHeader("X-Trace");
                        if (object2 != null) {
                            object.a.setSpanPropertyValue(Span.SpanProperty.CHILD_EDGES, Collections.singleton(object2));
                        }
                    }
                    object.a.finish();
                }
            });
        }
    }

    public static void onThrowable(Throwable throwable) {
        Span span;
        if (Context.getMetadata().isValid() && (span = k.get()) != null) {
            HttpClientInstrumentation.reportError(span, throwable);
            span.finish();
            k.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum a {
        a,
        b;

    }
}

