/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.agent;

import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLDecoder;

public class ResourceDirectory {
    private static final Logger a = LoggerFactory.getLogger();
    public static final String JAVA_AGENT_CONFIG_FILE = "javaagent.json";

    private ResourceDirectory() {
    }

    public static String getAgentDirectory() {
        File file = ResourceDirectory.getAgentJarPath();
        if (file != null) {
            return file.getParent();
        }
        return null;
    }

    public static File getAgentJarPath() {
        String string = "/" + ResourceDirectory.class.getName().replace('.', '/') + ".class";
        URL uRL = ResourceDirectory.class.getResource(string);
        String string2 = null;
        if (uRL != null) {
            string = "!" + string;
            string2 = uRL.getPath();
            if (string2 != null && string2.startsWith("file:") && string2.endsWith(string)) {
                string2 = string2.substring(5, string2.indexOf(string));
                try {
                    string2 = URLDecoder.decode(string2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    a.warn(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
            } else {
                a.info("Failed to extract agent jar from classPhysicalUrl: " + uRL + ", try to get it from runtime instead");
                string2 = ResourceDirectory.a();
            }
        }
        if (string2 != null) {
            return new File(string2);
        }
        a.warn("Failed to read jar agent location! classPhysicalUrl : " + uRL);
        return null;
    }

    private static String a() {
        Object object = ManagementFactory.getRuntimeMXBean();
        for (String string : object.getInputArguments()) {
            if (!string.startsWith("-javaagent:")) continue;
            object = string.substring(11);
            int n2 = ((String)object).indexOf(61);
            if (n2 != -1) {
                object = ((String)object).substring(0, n2);
            }
            a.debug("Extracted agent jar location [" + (String)object + "] from runtime");
            return object;
        }
        a.warn("Failed to extract agent jar location from runtime : " + object.getInputArguments());
        return null;
    }

    public static String getJavaAgentConfigLocation() {
        return ResourceDirectory.getAgentDirectory() + File.separator + JAVA_AGENT_CONFIG_FILE;
    }
}

