/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecyclableArrayList
extends ArrayList<Object> {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final ObjectPool<RecyclableArrayList> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<RecyclableArrayList>(){

        @Override
        public final RecyclableArrayList newObject(ObjectPool.Handle<RecyclableArrayList> handle) {
            return new RecyclableArrayList(handle);
        }
    });
    private boolean insertSinceRecycled;
    private final ObjectPool.Handle<RecyclableArrayList> handle;

    public static RecyclableArrayList newInstance(int n2) {
        RecyclableArrayList recyclableArrayList = RECYCLER.get();
        recyclableArrayList.ensureCapacity(n2);
        return recyclableArrayList;
    }

    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle) {
        this(handle, 8);
    }

    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle, int n2) {
        super(n2);
        this.handle = handle;
    }

    @Override
    public final boolean addAll(Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public final boolean addAll(int n2, Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(n2, collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    private static void checkNullElements(Collection<?> object) {
        if (object instanceof RandomAccess && object instanceof List) {
            object = (List)object;
            int n2 = object.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (object.get(i2) != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) continue;
            throw new IllegalArgumentException("c contains null values");
        }
    }

    @Override
    public final boolean add(Object object) {
        if (super.add(ObjectUtil.checkNotNull(object, "element"))) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public final void add(int n2, Object object) {
        super.add(n2, ObjectUtil.checkNotNull(object, "element"));
        this.insertSinceRecycled = true;
    }

    @Override
    public final Object set(int n2, Object object) {
        Object object2 = super.set(n2, ObjectUtil.checkNotNull(object, "element"));
        this.insertSinceRecycled = true;
        return object2;
    }

    public final boolean recycle() {
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle(this);
        return true;
    }
}

