/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.internal.ConstantTimeUtils;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.ReflectionUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlatformDependent0 {
    private static final InternalLogger logger;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_INDEX_SCALE;
    private static final long LONG_ARRAY_BASE_OFFSET;
    private static final long LONG_ARRAY_INDEX_SCALE;
    private static final Constructor<?> DIRECT_BUFFER_CONSTRUCTOR;
    private static final Throwable EXPLICIT_NO_UNSAFE_CAUSE;
    private static final Method ALLOCATE_ARRAY_METHOD;
    private static final int JAVA_VERSION;
    private static final boolean IS_ANDROID;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final Object INTERNAL_UNSAFE;
    private static final boolean IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    static final Unsafe UNSAFE;
    private static final boolean UNALIGNED;

    static boolean isExplicitNoUnsafe() {
        return EXPLICIT_NO_UNSAFE_CAUSE != null;
    }

    private static Throwable explicitNoUnsafeCause0() {
        boolean bl = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)bl);
        if (bl) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
        }
        String string = SystemPropertyUtil.contains("com.appoptics.ext.io.netty.tryUnsafe") ? "com.appoptics.ext.io.netty.tryUnsafe" : "com.appoptics.ext.org.jboss.netty.tryUnsafe";
        if (!SystemPropertyUtil.getBoolean(string, true)) {
            string = "sun.misc.Unsafe: unavailable (" + string + ")";
            logger.debug(string);
            return new UnsupportedOperationException(string);
        }
        return null;
    }

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    static boolean unalignedAccess() {
        return UNALIGNED;
    }

    static void throwException(Throwable throwable) {
        UNSAFE.throwException(ObjectUtil.checkNotNull(throwable, "cause"));
    }

    static boolean hasDirectBufferNoCleanerConstructor() {
        return DIRECT_BUFFER_CONSTRUCTOR != null;
    }

    static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n2) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.reallocateMemory(PlatformDependent0.directBufferAddress(byteBuffer), n2), n2);
    }

    static ByteBuffer allocateDirectNoCleaner(int n2) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.allocateMemory(Math.max(1, n2)), n2);
    }

    static boolean hasAllocateArrayMethod() {
        return ALLOCATE_ARRAY_METHOD != null;
    }

    static byte[] allocateUninitializedArray(int n2) {
        try {
            return (byte[])ALLOCATE_ARRAY_METHOD.invoke(INTERNAL_UNSAFE, Byte.TYPE, n2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException);
        }
    }

    static ByteBuffer newDirectBuffer(long l2, int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "capacity");
        try {
            return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(l2, n2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Error) {
                throw (Error)throwable2;
            }
            throw new Error(throwable2);
        }
    }

    static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.getLong(byteBuffer, ADDRESS_FIELD_OFFSET);
    }

    static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    static Object getObject(Object object, long l2) {
        return UNSAFE.getObject(object, l2);
    }

    static int getInt(Object object, long l2) {
        return UNSAFE.getInt(object, l2);
    }

    private static long getLong(Object object, long l2) {
        return UNSAFE.getLong(object, l2);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long l2) {
        return UNSAFE.getByte(l2);
    }

    static short getShort(long l2) {
        return UNSAFE.getShort(l2);
    }

    static int getInt(long l2) {
        return UNSAFE.getInt(l2);
    }

    static long getLong(long l2) {
        return UNSAFE.getLong(l2);
    }

    static byte getByte(byte[] byArray, int n2) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static short getShort(byte[] byArray, int n2) {
        return UNSAFE.getShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static int getInt(byte[] byArray, int n2) {
        return UNSAFE.getInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static long getLong(byte[] byArray, int n2) {
        return UNSAFE.getLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static void putByte(long l2, byte by) {
        UNSAFE.putByte(l2, by);
    }

    static void putShort(long l2, short s2) {
        UNSAFE.putShort(l2, s2);
    }

    static void putInt(long l2, int n2) {
        UNSAFE.putInt(l2, n2);
    }

    static void putLong(long l2, long l3) {
        UNSAFE.putLong(l2, l3);
    }

    static void putByte(byte[] byArray, int n2, byte by) {
        UNSAFE.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, by);
    }

    static void putShort(byte[] byArray, int n2, short s2) {
        UNSAFE.putShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, s2);
    }

    static void putInt(byte[] byArray, int n2, int n3) {
        UNSAFE.putInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, n3);
    }

    static void putLong(byte[] byArray, int n2, long l2) {
        UNSAFE.putLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, l2);
    }

    static void putObject(Object object, long l2, Object object2) {
        UNSAFE.putObject(object, l2, object2);
    }

    static void copyMemory(long l2, long l3, long l4) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(l2, l3, l4);
            return;
        }
        UNSAFE.copyMemory(l2, l3, l4);
    }

    private static void copyMemoryWithSafePointPolling(long l2, long l3, long l4) {
        while (l4 > 0L) {
            long l5 = Math.min(l4, 0x100000L);
            UNSAFE.copyMemory(l2, l3, l5);
            l4 -= l5;
            l2 += l5;
            l3 += l5;
        }
    }

    static void copyMemory(Object object, long l2, Object object2, long l3, long l4) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(object, l2, object2, l3, l4);
            return;
        }
        UNSAFE.copyMemory(object, l2, object2, l3, l4);
    }

    private static void copyMemoryWithSafePointPolling(Object object, long l2, Object object2, long l3, long l4) {
        while (l4 > 0L) {
            long l5 = Math.min(l4, 0x100000L);
            UNSAFE.copyMemory(object, l2, object2, l3, l5);
            l4 -= l5;
            l2 += l5;
            l3 += l5;
        }
    }

    static void setMemory(long l2, long l3, byte by) {
        UNSAFE.setMemory(l2, l3, by);
    }

    static void setMemory(Object object, long l2, long l3, byte by) {
        UNSAFE.setMemory(object, l2, l3, by);
    }

    static boolean equals(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        long l2;
        int n5 = n4 & 7;
        long l3 = BYTE_ARRAY_BASE_OFFSET + (long)n2;
        long l4 = n3 - n2;
        if (n4 >= 8) {
            l2 = l3 + (long)n5;
            for (long i2 = l3 - 8L + (long)n4; i2 >= l2; i2 -= 8L) {
                if (UNSAFE.getLong(byArray, i2) == UNSAFE.getLong(byArray2, i2 + l4)) continue;
                return false;
            }
        }
        if (n5 >= 4 && UNSAFE.getInt(byArray, l2 = l3 + (long)(n5 -= 4)) != UNSAFE.getInt(byArray2, l2 + l4)) {
            return false;
        }
        l2 = l3 + l4;
        if (n5 >= 2) {
            return UNSAFE.getChar(byArray, l3) == UNSAFE.getChar(byArray2, l2) && (n5 == 2 || UNSAFE.getByte(byArray, l3 + 2L) == UNSAFE.getByte(byArray2, l2 + 2L));
        }
        return n5 == 0 || UNSAFE.getByte(byArray, l3) == UNSAFE.getByte(byArray2, l2);
    }

    static int equalsConstantTime(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        long l2;
        long l3 = 0L;
        long l4 = n4 & 7;
        long l5 = BYTE_ARRAY_BASE_OFFSET + (long)n2;
        long l6 = l5 + l4;
        long l7 = n3 - n2;
        for (l2 = l5 - 8L + (long)n4; l2 >= l6; l2 -= 8L) {
            l3 |= UNSAFE.getLong(byArray, l2) ^ UNSAFE.getLong(byArray2, l2 + l7);
        }
        if (l4 >= 4L) {
            l3 |= (long)(UNSAFE.getInt(byArray, l5) ^ UNSAFE.getInt(byArray2, l5 + l7));
            l4 -= 4L;
        }
        if (l4 >= 2L) {
            l2 = l6 - l4;
            l3 |= (long)(UNSAFE.getChar(byArray, l2) ^ UNSAFE.getChar(byArray2, l2 + l7));
            l4 -= 2L;
        }
        if (l4 == 1L) {
            l2 = l6 - 1L;
            l3 |= (long)(UNSAFE.getByte(byArray, l2) ^ UNSAFE.getByte(byArray2, l2 + l7));
        }
        return ConstantTimeUtils.equalsConstantTime(l3, 0L);
    }

    static int hashCodeAscii(byte[] byArray, int n2, int n3) {
        int n4 = -1028477387;
        long l2 = BYTE_ARRAY_BASE_OFFSET + (long)n2;
        n2 = n3 & 7;
        long l3 = l2 + (long)n2;
        for (long i2 = l2 - 8L + (long)n3; i2 >= l3; i2 -= 8L) {
            n4 = PlatformDependent0.hashCodeAsciiCompute(UNSAFE.getLong(byArray, i2), n4);
        }
        if (n2 == 0) {
            return n4;
        }
        int n5 = -862048943;
        if (n2 != 2 & n2 != 4 & n2 != 6) {
            n4 = n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l2));
            n5 = 461845907;
            ++l2;
        }
        if (n2 != 1 & n2 != 4 & n2 != 5) {
            n4 = n4 * n5 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l2));
            n5 = n5 == -862048943 ? 461845907 : -862048943;
            l2 += 2L;
        }
        if (n2 >= 4) {
            return n4 * n5 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l2));
        }
        return n4;
    }

    static int hashCodeAsciiCompute(long l2, int n2) {
        return n2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize((int)l2) * 461845907 + (int)((l2 & 0x1F1F1F1F00000000L) >>> 32);
    }

    static int hashCodeAsciiSanitize(int n2) {
        return n2 & 0x1F1F1F1F;
    }

    static int hashCodeAsciiSanitize(short s2) {
        return s2 & 0x1F1F;
    }

    static int hashCodeAsciiSanitize(byte by) {
        return by & 0x1F;
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public final ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public final ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static void freeMemory(long l2) {
        UNSAFE.freeMemory(l2);
    }

    static boolean isAndroid() {
        return IS_ANDROID;
    }

    private static boolean isAndroid0() {
        String string = SystemPropertyUtil.get("java.vm.name");
        boolean bl = "Dalvik".equals(string);
        if (bl) {
            logger.debug("Platform: Android");
        }
        return bl;
    }

    private static boolean explicitTryReflectionSetAccessible0() {
        return SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.tryReflectionSetAccessible", PlatformDependent0.javaVersion() < 9);
    }

    static boolean isExplicitTryReflectionSetAccessible() {
        return IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    }

    static int javaVersion() {
        return JAVA_VERSION;
    }

    private static int javaVersion0() {
        int n2 = PlatformDependent0.isAndroid0() ? 6 : PlatformDependent0.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)n2);
        return n2;
    }

    static int majorVersionFromJavaSpecificationVersion() {
        return PlatformDependent0.majorVersion(SystemPropertyUtil.get("java.specification.version", "1.6"));
    }

    static int majorVersion(String stringArray) {
        stringArray = stringArray.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nArray[i2] = Integer.parseInt(stringArray[i2]);
        }
        if (nArray[0] == 1) {
            assert (nArray[1] >= 6);
            return nArray[1];
        }
        return nArray[0];
    }

    private PlatformDependent0() {
    }

    static {
        Object object;
        Unsafe unsafe;
        Object object2;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        EXPLICIT_NO_UNSAFE_CAUSE = PlatformDependent0.explicitNoUnsafeCause0();
        JAVA_VERSION = PlatformDependent0.javaVersion0();
        IS_ANDROID = PlatformDependent0.isAndroid0();
        IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE = PlatformDependent0.explicitTryReflectionSetAccessible0();
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        Object object6 = EXPLICIT_NO_UNSAFE_CAUSE;
        if (object6 != null) {
            object2 = null;
            object3 = null;
            unsafe = null;
            object5 = null;
        } else {
            long l2;
            Object object7;
            Unsafe unsafe2;
            object2 = ByteBuffer.allocateDirect(1);
            object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public final Object run() {
                    try {
                        Field field = Unsafe.class.getDeclaredField("theUnsafe");
                        Throwable throwable = ReflectionUtil.trySetAccessible(field, false);
                        if (throwable != null) {
                            return throwable;
                        }
                        return field.get(null);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                        return noSuchFieldException;
                    }
                    catch (SecurityException securityException) {
                        SecurityException securityException2 = securityException;
                        return securityException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalAccessException illegalAccessException2 = illegalAccessException;
                        return illegalAccessException;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        NoClassDefFoundError noClassDefFoundError2 = noClassDefFoundError;
                        return noClassDefFoundError;
                    }
                }
            });
            if (object instanceof Throwable) {
                unsafe = null;
                object6 = (Throwable)object;
                logger.debug("sun.misc.Unsafe.theUnsafe: unavailable", (Throwable)object);
            } else {
                unsafe = (Unsafe)object;
                logger.debug("sun.misc.Unsafe.theUnsafe: available");
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object7 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public final Object run() {
                        try {
                            unsafe2.getClass().getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                            return null;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (object7 == null) {
                    logger.debug("sun.misc.Unsafe.copyMemory: available");
                } else {
                    unsafe = null;
                    object6 = (Throwable)object7;
                    logger.debug("sun.misc.Unsafe.copyMemory: unavailable", (Throwable)object7);
                }
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object7 = AccessController.doPrivileged(new PrivilegedAction<Object>((ByteBuffer)object2){
                    final /* synthetic */ ByteBuffer val$direct;
                    {
                        this.val$direct = byteBuffer;
                    }

                    @Override
                    public final Object run() {
                        try {
                            Field field = Buffer.class.getDeclaredField("address");
                            long l2 = unsafe2.objectFieldOffset(field);
                            long l3 = unsafe2.getLong(this.val$direct, l2);
                            if (l3 == 0L) {
                                return null;
                            }
                            return field;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                            return noSuchFieldException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (object7 instanceof Field) {
                    object3 = (Field)object7;
                    logger.debug("java.nio.Buffer.address: available");
                } else {
                    object6 = (Throwable)object7;
                    logger.debug("java.nio.Buffer.address: unavailable", (Throwable)object7);
                    unsafe = null;
                }
            }
            if (unsafe != null && (l2 = (long)unsafe.arrayIndexScale(byte[].class)) != 1L) {
                logger.debug("unsafe.arrayIndexScale is {} (expected: 1). Not using unsafe.", (Object)l2);
                object6 = new UnsupportedOperationException("Unexpected unsafe.arrayIndexScale");
                unsafe = null;
            }
        }
        UNSAFE_UNAVAILABILITY_CAUSE = object6;
        UNSAFE = unsafe;
        if (unsafe == null) {
            ADDRESS_FIELD_OFFSET = -1L;
            BYTE_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_INDEX_SCALE = -1L;
            INT_ARRAY_BASE_OFFSET = -1L;
            INT_ARRAY_INDEX_SCALE = -1L;
            UNALIGNED = false;
            DIRECT_BUFFER_CONSTRUCTOR = null;
            ALLOCATE_ARRAY_METHOD = null;
        } else {
            boolean bl;
            long l3 = -1L;
            try {
                object2 = AccessController.doPrivileged(new PrivilegedAction<Object>((ByteBuffer)object2){
                    final /* synthetic */ ByteBuffer val$direct;
                    {
                        this.val$direct = byteBuffer;
                    }

                    @Override
                    public final Object run() {
                        try {
                            Constructor<?> constructor = this.val$direct.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                            Throwable throwable = ReflectionUtil.trySetAccessible(constructor, true);
                            if (throwable != null) {
                                return throwable;
                            }
                            return constructor;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (object2 instanceof Constructor) {
                    l3 = UNSAFE.allocateMemory(1L);
                    try {
                        ((Constructor)object2).newInstance(l3, 1);
                        object = (Constructor)object2;
                        logger.debug("direct buffer constructor: available");
                    }
                    catch (InstantiationException instantiationException) {
                        object = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object = null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object = null;
                    }
                } else {
                    logger.debug("direct buffer constructor: unavailable", (Throwable)object2);
                    object = null;
                }
            }
            finally {
                if (l3 != -1L) {
                    UNSAFE.freeMemory(l3);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = object;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset((Field)object3);
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            INT_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            INT_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);
            LONG_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            LONG_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(long[].class);
            object3 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public final Object run() {
                    try {
                        Method method;
                        Object object;
                        Class<?> clazz = Class.forName("java.nio.Bits", false, PlatformDependent0.getSystemClassLoader());
                        int n2 = PlatformDependent0.javaVersion();
                        if (n2 >= 9) {
                            Object object2 = n2 >= 11 ? "UNALIGNED" : "unaligned";
                            try {
                                object = clazz.getDeclaredField((String)object2);
                                if (((Field)object).getType() == Boolean.TYPE) {
                                    long l2 = UNSAFE.staticFieldOffset((Field)object);
                                    object2 = UNSAFE.staticFieldBase((Field)object);
                                    return UNSAFE.getBoolean(object2, l2);
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {}
                        }
                        if ((object = ReflectionUtil.trySetAccessible(method = clazz.getDeclaredMethod("unaligned", new Class[0]), true)) != null) {
                            return object;
                        }
                        return method.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                        return noSuchMethodException;
                    }
                    catch (SecurityException securityException) {
                        SecurityException securityException2 = securityException;
                        return securityException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalAccessException illegalAccessException2 = illegalAccessException;
                        return illegalAccessException;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassNotFoundException classNotFoundException2 = classNotFoundException;
                        return classNotFoundException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        InvocationTargetException invocationTargetException2 = invocationTargetException;
                        return invocationTargetException;
                    }
                }
            });
            if (object3 instanceof Boolean) {
                bl = (Boolean)object3;
                logger.debug("java.nio.Bits.unaligned: available, {}", (Object)bl);
            } else {
                object2 = SystemPropertyUtil.get("os.arch", "");
                bl = ((String)object2).matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
                object3 = (Throwable)object3;
                logger.debug("java.nio.Bits.unaligned: unavailable {}", (Object)bl, object3);
            }
            UNALIGNED = bl;
            if (PlatformDependent0.javaVersion() >= 9) {
                Object object8 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public final Object run() {
                        try {
                            GenericDeclaration genericDeclaration = PlatformDependent0.getClassLoader(PlatformDependent0.class).loadClass("jdk.internal.misc.Unsafe");
                            genericDeclaration = genericDeclaration.getDeclaredMethod("getUnsafe", new Class[0]);
                            return ((Method)genericDeclaration).invoke(null, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            return throwable;
                        }
                    }
                });
                if (!(object8 instanceof Throwable) && (object8 = AccessController.doPrivileged(new PrivilegedAction<Object>(object3 = (object5 = object8)){
                    final /* synthetic */ Object val$finalInternalUnsafe;
                    {
                        this.val$finalInternalUnsafe = object;
                    }

                    @Override
                    public final Object run() {
                        try {
                            return this.val$finalInternalUnsafe.getClass().getDeclaredMethod("allocateUninitializedArray", Class.class, Integer.TYPE);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                })) instanceof Method) {
                    try {
                        object6 = (Method)object8;
                        object3 = (byte[])((Method)object6).invoke(object3, Byte.TYPE, 8);
                        assert (((Object)object3).length == 8);
                        object4 = object6;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object6 = illegalAccessException;
                        object8 = illegalAccessException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object6 = invocationTargetException;
                        object8 = invocationTargetException;
                    }
                }
                if (object8 instanceof Throwable) {
                    logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable", (Throwable)object8);
                } else {
                    logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): available");
                }
            } else {
                logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable prior to Java9");
            }
            ALLOCATE_ARRAY_METHOD = object4;
        }
        INTERNAL_UNSAFE = object5;
        logger.debug("java.nio.DirectByteBuffer.<init>(long, int): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
    }
}

