/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.NetUtil;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SocketUtils;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MacAddressUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MacAddressUtil.class);

    /*
     * WARNING - void declaration
     */
    public static byte[] bestAvailableMac() {
        InetAddress inetAddress;
        Object object;
        Object object2 = EmptyArrays.EMPTY_BYTES;
        InetAddress inetAddress2 = NetUtil.LOCALHOST4;
        Object object3 = new LinkedHashMap<NetworkInterface, InetAddress>();
        try {
            object = NetworkInterface.getNetworkInterfaces();
            if (object != null) {
                while (object.hasMoreElements()) {
                    NetworkInterface networkInterface = object.nextElement();
                    Enumeration<InetAddress> enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface);
                    if (!enumeration.hasMoreElements() || (inetAddress = enumeration.nextElement()).isLoopbackAddress()) continue;
                    object3.put(networkInterface, inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        for (Map.Entry entry : object3.entrySet()) {
            void var4_12;
            NetworkInterface networkInterface = (NetworkInterface)entry.getKey();
            inetAddress = (InetAddress)entry.getValue();
            if (networkInterface.isVirtual()) continue;
            try {
                object3 = SocketUtils.hardwareAddressFromNetworkInterface(networkInterface);
            }
            catch (SocketException socketException) {
                logger.debug("Failed to get the hardware address of a network interface: {}", (Object)networkInterface, (Object)socketException);
                continue;
            }
            boolean bl = false;
            int n2 = MacAddressUtil.compareAddresses(object2, (byte[])object3);
            if (n2 < 0) {
                boolean bl2 = true;
            } else if (n2 == 0) {
                n2 = MacAddressUtil.compareAddresses(inetAddress2, inetAddress);
                if (n2 < 0) {
                    boolean bl3 = true;
                } else if (n2 == 0 && ((byte[])object2).length < ((Object)object3).length) {
                    boolean bl4 = true;
                }
            }
            if (var4_12 == false) continue;
            object2 = object3;
            inetAddress2 = inetAddress;
        }
        if (object2 == EmptyArrays.EMPTY_BYTES) {
            return null;
        }
        switch (((byte[])object2).length) {
            case 6: {
                object = new byte[8];
                System.arraycopy(object2, 0, object, 0, 3);
                object[3] = -1;
                object[4] = -2;
                System.arraycopy(object2, 3, object, 5, 3);
                object2 = object;
                break;
            }
            default: {
                object2 = Arrays.copyOf(object2, 8);
            }
        }
        return object2;
    }

    public static byte[] defaultMachineId() {
        byte[] byArray = MacAddressUtil.bestAvailableMac();
        if (byArray == null) {
            byArray = new byte[8];
            PlatformDependent.threadLocalRandom().nextBytes(byArray);
            logger.warn("Failed to find a usable hardware address from the network interfaces; using random bytes: {}", (Object)MacAddressUtil.formatAddress(byArray));
        }
        return byArray;
    }

    public static byte[] parseMAC(String string) {
        byte[] byArray;
        char c2;
        switch (string.length()) {
            case 17: {
                c2 = string.charAt(2);
                MacAddressUtil.validateMacSeparator(c2);
                byArray = new byte[6];
                break;
            }
            case 23: {
                c2 = string.charAt(2);
                MacAddressUtil.validateMacSeparator(c2);
                byArray = new byte[8];
                break;
            }
            default: {
                throw new IllegalArgumentException("value is not supported [MAC-48, EUI-48, EUI-64]");
            }
        }
        int n2 = byArray.length - 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n3 + 2;
            byArray[n4] = StringUtil.decodeHexByte(string, n3);
            if (string.charAt(n5) != c2) {
                throw new IllegalArgumentException("expected separator '" + c2 + " but got '" + string.charAt(n5) + "' at index: " + n5);
            }
            ++n4;
            n3 += 3;
        }
        byArray[n2] = StringUtil.decodeHexByte(string, n3);
        return byArray;
    }

    private static void validateMacSeparator(char c2) {
        if (c2 != ':' && c2 != '-') {
            throw new IllegalArgumentException("unsupported separator: " + c2 + " (expected: [:-])");
        }
    }

    public static String formatAddress(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(24);
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x:", by & 0xFF));
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    static int compareAddresses(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null || byArray2.length < 6) {
            return 1;
        }
        boolean bl = true;
        byte[] byArray3 = byArray2;
        int n2 = byArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray3[i2];
            if (by == 0 || by == 1) continue;
            bl = false;
            break;
        }
        if (bl) {
            return 1;
        }
        if ((byArray2[0] & 1) != 0) {
            return 1;
        }
        if ((byArray2[0] & 2) == 0) {
            if (byArray.length != 0 && (byArray[0] & 2) == 0) {
                return 0;
            }
            return -1;
        }
        if (byArray.length != 0 && (byArray[0] & 2) == 0) {
            return 1;
        }
        return 0;
    }

    private static int compareAddresses(InetAddress inetAddress, InetAddress inetAddress2) {
        return MacAddressUtil.scoreAddress(inetAddress) - MacAddressUtil.scoreAddress(inetAddress2);
    }

    private static int scoreAddress(InetAddress inetAddress) {
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return 0;
        }
        if (inetAddress.isMulticastAddress()) {
            return 1;
        }
        if (inetAddress.isLinkLocalAddress()) {
            return 2;
        }
        if (inetAddress.isSiteLocalAddress()) {
            return 3;
        }
        return 4;
    }

    private MacAddressUtil() {
    }
}

