/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.internal.Cleaner;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent0;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class CleanerJava9
implements Cleaner {
    private static final InternalLogger logger;
    private static final Method INVOKE_CLEANER;

    CleanerJava9() {
    }

    static boolean isSupported() {
        return INVOKE_CLEANER != null;
    }

    public final void freeDirectBuffer(ByteBuffer object) {
        if (System.getSecurityManager() == null) {
            try {
                INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, object);
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                PlatformDependent0.throwException(throwable);
                return;
            }
        }
        CleanerJava9.freeDirectBufferPrivileged((ByteBuffer)object);
    }

    private static void freeDirectBufferPrivileged(ByteBuffer object) {
        if ((object = AccessController.doPrivileged(new PrivilegedAction<Exception>((ByteBuffer)object){
            final /* synthetic */ ByteBuffer val$buffer;
            {
                this.val$buffer = byteBuffer;
            }

            @Override
            public final Exception run() {
                try {
                    INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, this.val$buffer);
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    return invocationTargetException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalAccessException illegalAccessException2 = illegalAccessException;
                    return illegalAccessException;
                }
                return null;
            }
        })) != null) {
            PlatformDependent0.throwException((Throwable)object);
        }
    }

    static {
        Object object;
        Object object2;
        logger = InternalLoggerFactory.getInstance(CleanerJava9.class);
        if (PlatformDependent0.hasUnsafe()) {
            object2 = ByteBuffer.allocateDirect(1);
            object = AccessController.doPrivileged(new PrivilegedAction<Object>((ByteBuffer)object2){
                final /* synthetic */ ByteBuffer val$buffer;
                {
                    this.val$buffer = byteBuffer;
                }

                @Override
                public final Object run() {
                    try {
                        Method method = PlatformDependent0.UNSAFE.getClass().getDeclaredMethod("invokeCleaner", ByteBuffer.class);
                        method.invoke((Object)PlatformDependent0.UNSAFE, this.val$buffer);
                        return method;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                        return noSuchMethodException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        InvocationTargetException invocationTargetException2 = invocationTargetException;
                        return invocationTargetException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalAccessException illegalAccessException2 = illegalAccessException;
                        return illegalAccessException;
                    }
                }
            });
            if (object instanceof Throwable) {
                object2 = null;
                object = (Throwable)object;
            } else {
                object2 = (Method)object;
                object = null;
            }
        } else {
            object2 = null;
            object = new UnsupportedOperationException("sun.misc.Unsafe unavailable");
        }
        if (object == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", (Throwable)object);
        }
        INVOKE_CLEANER = object2;
    }
}

