/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.AbstractEventExecutorGroup;
import com.appoptics.ext.io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import com.appoptics.ext.io.netty.util.concurrent.DefaultPromise;
import com.appoptics.ext.io.netty.util.concurrent.DefaultThreadFactory;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutorChooserFactory;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.FutureListener;
import com.appoptics.ext.io.netty.util.concurrent.GlobalEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Promise;
import com.appoptics.ext.io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultithreadEventExecutorGroup
extends AbstractEventExecutorGroup {
    private final EventExecutor[] children;
    private final Set<EventExecutor> readonlyChildren;
    private final AtomicInteger terminatedChildren = new AtomicInteger();
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private final EventExecutorChooserFactory.EventExecutorChooser chooser;

    protected MultithreadEventExecutorGroup(int n2, ThreadFactory threadFactory, Object ... objectArray) {
        this(n2, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor(threadFactory)), objectArray);
    }

    protected MultithreadEventExecutorGroup(int n2, Executor executor, Object ... objectArray) {
        this(n2, executor, DefaultEventExecutorChooserFactory.INSTANCE, objectArray);
    }

    protected MultithreadEventExecutorGroup(int n2, Executor executor, EventExecutorChooserFactory object, Object ... object2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(String.format("nThreads: %d (expected: > 0)", n2));
        }
        if (executor == null) {
            executor = new ThreadPerTaskExecutor(this.newDefaultThreadFactory());
        }
        this.children = new EventExecutor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                try {
                    this.children[i2] = this.newChild(executor, object2);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to create a child event loop", exception);
                }
            }
            catch (Throwable throwable) {
                int n3;
                for (n3 = 0; n3 < i2; ++n3) {
                    this.children[n3].shutdownGracefully();
                }
                for (n3 = 0; n3 < i2; ++n3) {
                    object = this.children[n3];
                    try {
                        while (!object.isTerminated()) {
                            object.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                        }
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                throw throwable;
            }
        }
        this.chooser = object.newChooser(this.children);
        FutureListener<Object> futureListener = new FutureListener<Object>(){

            public void operationComplete(Future<Object> future) throws Exception {
                if (MultithreadEventExecutorGroup.this.terminatedChildren.incrementAndGet() == MultithreadEventExecutorGroup.this.children.length) {
                    MultithreadEventExecutorGroup.this.terminationFuture.setSuccess(null);
                }
            }
        };
        Object object3 = this.children;
        int n4 = this.children.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            object2 = object3[i3];
            object2.terminationFuture().addListener(futureListener);
        }
        object3 = new LinkedHashSet(this.children.length);
        Collections.addAll(object3, this.children);
        this.readonlyChildren = Collections.unmodifiableSet(object3);
    }

    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass());
    }

    @Override
    public EventExecutor next() {
        return this.chooser.next();
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.readonlyChildren.iterator();
    }

    protected abstract EventExecutor newChild(Executor var1, Object ... var2) throws Exception;

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            eventExecutor.shutdownGracefully(l2, l3, timeUnit);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            eventExecutor.shutdown();
        }
    }

    @Override
    public boolean isShutdown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            if (eventExecutor.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            if (eventExecutor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        long l3 = System.nanoTime() + timeUnit.toNanos(l2);
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            long l4;
            EventExecutor eventExecutor = eventExecutorArray[i2];
            while ((l4 = l3 - System.nanoTime()) > 0L) {
                if (!eventExecutor.awaitTermination(l4, TimeUnit.NANOSECONDS)) continue;
                continue block0;
            }
            break block0;
        }
        return this.isTerminated();
    }
}

