/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util;

import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SocketUtils;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final int SOMAXCONN;
    private static final boolean IPV4_PREFERRED;
    private static final boolean IPV6_ADDRESSES_PREFERRED;
    private static final InternalLogger logger;

    private static Integer sysctlGetInt(String object) throws IOException {
        Process process = new ProcessBuilder(new String[]{"sysctl", object}).start();
        try {
            Closeable closeable;
            block9: {
                closeable = process.getInputStream();
                closeable = new InputStreamReader((InputStream)closeable);
                closeable = new BufferedReader((Reader)closeable);
                try {
                    String string = ((BufferedReader)closeable).readLine();
                    if (string == null || !string.startsWith((String)object)) break block9;
                    for (int i2 = string.length() - 1; i2 > ((String)object).length(); --i2) {
                        if (Character.isDigit(string.charAt(i2))) continue;
                        object = Integer.valueOf(string.substring(i2 + 1));
                    }
                }
                catch (Throwable throwable) {
                    ((BufferedReader)closeable).close();
                    throw throwable;
                }
                {
                    ((BufferedReader)closeable).close();
                    return object;
                }
            }
            ((BufferedReader)closeable).close();
            return null;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static boolean isValidIpV6Address(String string) {
        return NetUtil.isValidIpV6Address((CharSequence)string);
    }

    public static boolean isValidIpV6Address(CharSequence charSequence) {
        int n2;
        int n3;
        int n4;
        int n5 = charSequence.length();
        if (n5 < 2) {
            return false;
        }
        int n6 = charSequence.charAt(0);
        if (n6 == 91) {
            if (charSequence.charAt(--n5) != ']') {
                return false;
            }
            n4 = 1;
            n6 = charSequence.charAt(1);
        } else {
            n4 = 0;
        }
        if (n6 == 58) {
            if (charSequence.charAt(n4 + 1) != ':') {
                return false;
            }
            n3 = 2;
            n2 = n4;
            n4 += 2;
        } else {
            n3 = 0;
            n2 = -1;
        }
        int n7 = 0;
        block5: for (int i2 = n4; i2 < n5; ++i2) {
            n6 = charSequence.charAt(i2);
            if (NetUtil.isValidHexChar((char)n6)) {
                if (n7 < 4) {
                    ++n7;
                    continue;
                }
                return false;
            }
            switch (n6) {
                case 58: {
                    if (n3 > 7) {
                        return false;
                    }
                    if (charSequence.charAt(i2 - 1) == ':') {
                        if (n2 >= 0) {
                            return false;
                        }
                        n2 = i2 - 1;
                    } else {
                        n7 = 0;
                    }
                    ++n3;
                    continue block5;
                }
                case 46: {
                    if (n2 < 0 && n3 != 6 || n3 == 7 && n2 >= n4 || n3 > 7) {
                        return false;
                    }
                    n6 = i2 - n7;
                    n3 = n6 - 2;
                    if (NetUtil.isValidIPv4MappedChar(charSequence.charAt(n3))) {
                        if (!(NetUtil.isValidIPv4MappedChar(charSequence.charAt(n3 - 1)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n3 - 2)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n3 - 3)))) {
                            return false;
                        }
                        n3 -= 5;
                    }
                    while (n3 >= n4) {
                        char c2 = charSequence.charAt(n3);
                        n2 = c2;
                        if (c2 != '0' && n2 != 58) {
                            return false;
                        }
                        --n3;
                    }
                    n2 = AsciiString.indexOf(charSequence, '%', n6 + 7);
                    if (n2 < 0) {
                        n2 = n5;
                    }
                    return NetUtil.isValidIpV4Address(charSequence, n6, n2);
                }
                case 37: {
                    n5 = i2;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (n2 < 0) {
            return n3 == 7 && n7 > 0;
        }
        return n2 + 2 == n5 || n7 > 0 && (n3 < 8 || n2 <= n4);
    }

    private static boolean isValidIpV4Word(CharSequence charSequence, int n2, int n3) {
        char c2;
        if ((n3 -= n2) <= 0 || n3 > 3 || (c2 = charSequence.charAt(n2)) < '0') {
            return false;
        }
        if (n3 == 3) {
            char c3;
            char c4 = charSequence.charAt(n2 + 1);
            n3 = c4;
            return c4 >= '0' && (c3 = charSequence.charAt(n2 + 2)) >= '0' && (c2 <= '1' && n3 <= 57 && c3 <= '9' || c2 == '2' && n3 <= 53 && (c3 <= '5' || n3 < 53 && c3 <= '9'));
        }
        return c2 <= '9' && (n3 == 1 || NetUtil.isValidNumericChar(charSequence.charAt(n2 + 1)));
    }

    private static boolean isValidHexChar(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f';
    }

    private static boolean isValidNumericChar(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isValidIPv4MappedChar(char c2) {
        return c2 == 'f' || c2 == 'F';
    }

    public static boolean isValidIpV4Address(String string) {
        return NetUtil.isValidIpV4Address(string, 0, string.length());
    }

    private static boolean isValidIpV4Address(CharSequence charSequence, int n2, int n3) {
        if (charSequence instanceof String) {
            return NetUtil.isValidIpV4Address((String)charSequence, n2, n3);
        }
        if (charSequence instanceof AsciiString) {
            return NetUtil.isValidIpV4Address((AsciiString)charSequence, n2, n3);
        }
        return NetUtil.isValidIpV4Address0(charSequence, n2, n3);
    }

    private static boolean isValidIpV4Address(String string, int n2, int n3) {
        int n4 = n3 - n2;
        return n4 <= 15 && n4 >= 7 && (n4 = string.indexOf(46, n2 + 1)) > 0 && NetUtil.isValidIpV4Word(string, n2, n4) && (n4 = string.indexOf(46, n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n2 - 1, n4) && (n4 = string.indexOf(46, n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n2 - 1, n4) && NetUtil.isValidIpV4Word(string, n4 + 1, n3);
    }

    private static boolean isValidIpV4Address(AsciiString asciiString, int n2, int n3) {
        int n4 = n3 - n2;
        return n4 <= 15 && n4 >= 7 && (n4 = asciiString.indexOf('.', n2 + 1)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2, n4) && (n4 = asciiString.indexOf('.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2 - 1, n4) && (n4 = asciiString.indexOf('.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2 - 1, n4) && NetUtil.isValidIpV4Word(asciiString, n4 + 1, n3);
    }

    private static boolean isValidIpV4Address0(CharSequence charSequence, int n2, int n3) {
        int n4 = n3 - n2;
        return n4 <= 15 && n4 >= 7 && (n4 = AsciiString.indexOf(charSequence, '.', n2 + 1)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2, n4) && (n4 = AsciiString.indexOf(charSequence, '.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2 - 1, n4) && (n4 = AsciiString.indexOf(charSequence, '.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2 - 1, n4) && NetUtil.isValidIpV4Word(charSequence, n4 + 1, n3);
    }

    public static String toAddressString(InetAddress inetAddress) {
        return NetUtil.toAddressString(inetAddress, false);
    }

    public static String toAddressString(InetAddress inetAddress, boolean bl) {
        if (inetAddress instanceof Inet4Address) {
            return inetAddress.getHostAddress();
        }
        if (!(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + inetAddress);
        }
        return NetUtil.toAddressString(inetAddress.getAddress(), 0, bl);
    }

    private static String toAddressString(byte[] byArray, int n2, boolean bl) {
        int[] nArray = new int[8];
        int n3 = n2 + 8;
        while (n2 < n3) {
            nArray[n2] = (byArray[n2 << 1] & 0xFF) << 8 | byArray[(n2 << 1) + 1] & 0xFF;
            ++n2;
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            if (nArray[n2] == 0) {
                if (n4 >= 0) continue;
                n4 = n2;
                continue;
            }
            if (n4 < 0) continue;
            n3 = n2 - n4;
            if (n3 > n6) {
                n5 = n4;
                n6 = n3;
            }
            n4 = -1;
        }
        if (n4 >= 0 && (n3 = n2 - n4) > n6) {
            n5 = n4;
            n6 = n3;
        }
        if (n6 == 1) {
            n6 = 0;
            n5 = -1;
        }
        n4 = n5 + n6;
        StringBuilder stringBuilder = new StringBuilder(39);
        if (n4 < 0) {
            stringBuilder.append(Integer.toHexString(nArray[0]));
            for (n2 = 1; n2 < 8; ++n2) {
                stringBuilder.append(':');
                stringBuilder.append(Integer.toHexString(nArray[n2]));
            }
        } else {
            if (NetUtil.inRangeEndExclusive(0, n5, n4)) {
                stringBuilder.append("::");
                bl = bl && n4 == 5 && nArray[5] == 65535;
            } else {
                stringBuilder.append(Integer.toHexString(nArray[0]));
                bl = false;
            }
            for (n2 = 1; n2 < 8; ++n2) {
                if (!NetUtil.inRangeEndExclusive(n2, n5, n4)) {
                    if (!NetUtil.inRangeEndExclusive(n2 - 1, n5, n4)) {
                        if (!bl || n2 == 6) {
                            stringBuilder.append(':');
                        } else {
                            stringBuilder.append('.');
                        }
                    }
                    if (bl && n2 > 5) {
                        stringBuilder.append(nArray[n2] >> 8);
                        stringBuilder.append('.');
                        stringBuilder.append(nArray[n2] & 0xFF);
                        continue;
                    }
                    stringBuilder.append(Integer.toHexString(nArray[n2]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(n2 - 1, n5, n4)) continue;
                stringBuilder.append("::");
            }
        }
        return stringBuilder.toString();
    }

    public static String getHostname(InetSocketAddress inetSocketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            return inetSocketAddress.getHostString();
        }
        return inetSocketAddress.getHostName();
    }

    private static boolean inRangeEndExclusive(int n2, int n3, int n4) {
        return n2 >= n3 && n2 < n4;
    }

    private NetUtil() {
    }

    static {
        Enumeration<InetAddress> enumeration;
        NetworkInterface networkInterface;
        Object object;
        Object object2;
        IPV4_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv4Stack", false);
        IPV6_ADDRESSES_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv6Addresses", false);
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        logger.debug("-Djava.net.preferIPv4Stack: {}", (Object)IPV4_PREFERRED);
        logger.debug("-Djava.net.preferIPv6Addresses: {}", (Object)IPV6_ADDRESSES_PREFERRED);
        Object object3 = new byte[]{127, 0, 0, 1};
        Object object4 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)InetAddress.getByAddress("localhost", object3);
        }
        catch (Exception exception) {
            object3 = exception;
            PlatformDependent.throwException(exception);
        }
        LOCALHOST4 = inet4Address;
        object3 = null;
        try {
            object3 = (Inet6Address)InetAddress.getByAddress("localhost", (byte[])object4);
        }
        catch (Exception exception) {
            object4 = exception;
            PlatformDependent.throwException(exception);
        }
        LOCALHOST6 = object3;
        object4 = new ArrayList();
        try {
            object2 = NetworkInterface.getNetworkInterfaces();
            if (object2 != null) {
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    if (!SocketUtils.addressesFromNetworkInterface((NetworkInterface)object).hasMoreElements()) continue;
                    object4.add(object);
                }
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        object2 = null;
        object = null;
        Iterator iterator = object4.iterator();
        block12: while (iterator.hasNext()) {
            networkInterface = (NetworkInterface)iterator.next();
            enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface);
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!inetAddress.isLoopbackAddress()) continue;
                object2 = networkInterface;
                object = inetAddress;
                break block12;
            }
        }
        if (object2 == null) {
            try {
                iterator = object4.iterator();
                while (iterator.hasNext()) {
                    networkInterface = (NetworkInterface)iterator.next();
                    if (!networkInterface.isLoopback() || !(enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface)).hasMoreElements()) continue;
                    object2 = networkInterface;
                    object = enumeration.nextElement();
                    break;
                }
                if (object2 == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to find the loopback interface", socketException);
            }
        }
        if (object2 != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)object2).getName(), ((NetworkInterface)object2).getDisplayName(), ((InetAddress)object).getHostAddress());
        } else if (object == null) {
            try {
                if (NetworkInterface.getByInetAddress(LOCALHOST6) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", object3);
                    object = object3;
                }
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object = inet4Address;
                }
            }
            catch (Exception exception) {
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object = inet4Address;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                }
                throw throwable;
            }
        }
        LOOPBACK_IF = object2;
        LOCALHOST = object;
        SOMAXCONN = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final Integer run() {
                int n2 = PlatformDependent.isWindows() ? 200 : 128;
                File file = new File("/proc/sys/net/core/somaxconn");
                BufferedReader bufferedReader = null;
                if (file.exists()) {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    n2 = Integer.parseInt(bufferedReader.readLine());
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: {}", (Object)file, (Object)n2);
                    }
                } else {
                    Integer n3 = null;
                    if (SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.net.somaxconn.trySysctl", false) && ((n3 = NetUtil.sysctlGetInt("kern.ipc.somaxconn")) != null || (n3 = NetUtil.sysctlGetInt("kern.ipc.soacceptqueue")) != null)) {
                        n2 = n3;
                    }
                    if (n3 == null) {
                        logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", (Object)file, (Object)n2);
                    }
                }
                if (bufferedReader == null) return n2;
                try {
                    bufferedReader.close();
                    return n2;
                }
                catch (Exception exception) {}
                return n2;
                catch (Exception exception) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", file, n2, exception);
                        }
                        if (bufferedReader == null) return n2;
                    }
                    catch (Throwable throwable) {
                        if (bufferedReader == null) throw throwable;
                        try {
                            bufferedReader.close();
                            throw throwable;
                        }
                        catch (Exception exception2) {}
                        throw throwable;
                    }
                    try {
                        bufferedReader.close();
                        return n2;
                    }
                    catch (Exception exception3) {}
                    return n2;
                }
            }
        });
    }
}

