/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteFilter;
import com.appoptics.ext.io.netty.handler.ssl.ClientAuth;
import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslEngineMap;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslSessionContext;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslSessionTicketKey;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslTlsv13X509ExtendedTrustManager;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.appoptics.ext.io.netty.internal.tcnative.CertificateCallback;
import com.appoptics.ext.io.netty.internal.tcnative.CertificateVerifier;
import com.appoptics.ext.io.netty.internal.tcnative.SSLContext;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceCountedOpenSslClientContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslClientContext.class);
    private static final Set<String> SUPPORTED_KEY_TYPES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("RSA", "DH_RSA", "EC", "EC_RSA", "EC_EC")));
    private static final boolean ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean("jdk.tls.client.enableSessionTicketExtension", false);
    private final OpenSslSessionContext sessionContext;

    ReferenceCountedOpenSslClientContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, String[] stringArray, long l2, long l3, boolean bl, String string2) throws SSLException {
        super(iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, 0, (Certificate[])x509CertificateArray2, ClientAuth.NONE, stringArray, false, bl, true);
        try {
            this.sessionContext = ReferenceCountedOpenSslClientContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2);
            if (ENABLE_SESSION_TICKET) {
                this.sessionContext.setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    public final OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    static OpenSslSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] object, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2) throws SSLException {
        if (privateKey == null && object != null || privateKey != null && object == null) {
            throw new IllegalArgumentException("Either both keyCertChain and key needs to be null or none of them");
        }
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object2;
            try {
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    if (object != null) {
                        ReferenceCountedOpenSslClientContext.setKeyMaterial(l2, object, privateKey, string);
                    }
                } else {
                    if (keyManagerFactory == null && object != null) {
                        object2 = ReferenceCountedOpenSslClientContext.keyStorePassword(string);
                        keyManagerFactory = (object = ReferenceCountedOpenSslClientContext.buildKeyStore(object, privateKey, object2, string2)).aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init((KeyStore)object, (char[])object2);
                        openSslKeyMaterialProvider = ReferenceCountedOpenSslClientContext.providerFor(keyManagerFactory, string);
                    } else if (keyManagerFactory != null) {
                        openSslKeyMaterialProvider = ReferenceCountedOpenSslClientContext.providerFor(keyManagerFactory, string);
                    }
                    if (openSslKeyMaterialProvider != null) {
                        object2 = new OpenSslKeyMaterialManager(openSslKeyMaterialProvider);
                        SSLContext.setCertificateCallback((long)l2, (CertificateCallback)new OpenSslClientCertificateCallback(openSslEngineMap, (OpenSslKeyMaterialManager)object2));
                    }
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            SSLContext.setVerify((long)l2, (int)1, (int)10);
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslClientContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object2 = ReferenceCountedOpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                ReferenceCountedOpenSslClientContext.setVerifyCallback(l2, openSslEngineMap, (X509TrustManager)object2);
            }
            catch (Exception exception) {
                if (openSslKeyMaterialProvider != null) {
                    openSslKeyMaterialProvider.destroy();
                }
                throw new SSLException("unable to setup trustmanager", exception);
            }
            object2 = new OpenSslClientSessionContext(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
            openSslKeyMaterialProvider = null;
            object = object2;
            return object;
        }
        catch (Throwable throwable) {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
            throw throwable;
        }
    }

    private static void setVerifyCallback(long l2, OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
        if (ReferenceCountedOpenSslClientContext.useExtendedTrustManager(x509TrustManager)) {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)x509TrustManager));
            return;
        }
        SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new TrustManagerVerifyCallback(openSslEngineMap, x509TrustManager));
    }

    private static final class OpenSslClientCertificateCallback
    implements CertificateCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslClientCertificateCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engineMap = openSslEngineMap;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(openSslEngineMap);
            this.manager = OpenSslTlsv13X509ExtendedTrustManager.wrap(x509ExtendedTrustManager);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
            super(openSslEngineMap);
            this.manager = x509TrustManager;
        }
    }

    static final class OpenSslClientSessionContext
    extends OpenSslSessionContext {
        OpenSslClientSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
            super(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
        }

        public final void setSessionTimeout(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
        }

        public final int getSessionTimeout() {
            return 0;
        }

        public final void setSessionCacheSize(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
        }

        public final int getSessionCacheSize() {
            return 0;
        }
    }
}

