/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.handler.ssl.PemEncoded;
import com.appoptics.ext.io.netty.handler.ssl.PemValue;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.IllegalReferenceCountException;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PemX509Certificate
extends X509Certificate
implements PemEncoded {
    private static final byte[] BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
    private static final byte[] END_CERT = "\n-----END CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
    private final ByteBuf content;

    static PemEncoded toPEM(ByteBufAllocator byteBufAllocator, boolean bl, X509Certificate ... x509CertificateArray) throws CertificateEncodingException {
        X509Certificate x509Certificate;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("X.509 certificate chain can't be null or empty");
        }
        if (x509CertificateArray.length == 1 && (x509Certificate = x509CertificateArray[0]) instanceof PemEncoded) {
            return ((PemEncoded)((Object)x509Certificate)).retain();
        }
        boolean bl2 = false;
        ReferenceCounted referenceCounted = null;
        try {
            Object object = x509CertificateArray;
            int n2 = x509CertificateArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                X509Certificate x509Certificate2 = object[i2];
                if (x509Certificate2 == null) {
                    throw new IllegalArgumentException("Null element in chain: " + Arrays.toString(x509CertificateArray));
                }
                referenceCounted = x509Certificate2 instanceof PemEncoded ? PemX509Certificate.append(byteBufAllocator, bl, (PemEncoded)((Object)x509Certificate2), x509CertificateArray.length, (ByteBuf)referenceCounted) : PemX509Certificate.append(byteBufAllocator, bl, x509Certificate2, x509CertificateArray.length, (ByteBuf)referenceCounted);
            }
            object = new PemValue((ByteBuf)referenceCounted, false);
            bl2 = true;
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (!bl2 && referenceCounted != null) {
                referenceCounted.release();
            }
            throw throwable;
        }
    }

    private static ByteBuf append(ByteBufAllocator byteBufAllocator, boolean bl, PemEncoded referenceCounted, int n2, ByteBuf byteBuf) {
        referenceCounted = referenceCounted.content();
        if (byteBuf == null) {
            byteBuf = PemX509Certificate.newBuffer(byteBufAllocator, bl, ((ByteBuf)referenceCounted).readableBytes() * n2);
        }
        byteBuf.writeBytes(((ByteBuf)referenceCounted).slice());
        return byteBuf;
    }

    private static ByteBuf append(ByteBufAllocator byteBufAllocator, boolean bl, X509Certificate object, int n2, ByteBuf byteBuf) throws CertificateEncodingException {
        object = Unpooled.wrappedBuffer(((Certificate)object).getEncoded());
        try {
            ByteBuf byteBuf2 = SslUtils.toBase64(byteBufAllocator, (ByteBuf)object);
            try {
                if (byteBuf == null) {
                    byteBuf = PemX509Certificate.newBuffer(byteBufAllocator, bl, (BEGIN_CERT.length + byteBuf2.readableBytes() + END_CERT.length) * n2);
                }
                byteBuf.writeBytes(BEGIN_CERT);
                byteBuf.writeBytes(byteBuf2);
                byteBuf.writeBytes(END_CERT);
            }
            finally {
                byteBuf2.release();
            }
        }
        finally {
            object.release();
        }
        return byteBuf;
    }

    private static ByteBuf newBuffer(ByteBufAllocator byteBufAllocator, boolean bl, int n2) {
        if (bl) {
            return byteBufAllocator.directBuffer(n2);
        }
        return byteBufAllocator.buffer(n2);
    }

    @Override
    public final boolean isSensitive() {
        return false;
    }

    @Override
    public final int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public final ByteBuf content() {
        int n2 = this.refCnt();
        if (n2 <= 0) {
            throw new IllegalReferenceCountException(n2);
        }
        return this.content;
    }

    @Override
    public final PemX509Certificate retain() {
        this.content.retain();
        return this;
    }

    @Override
    public final PemX509Certificate touch() {
        this.content.touch();
        return this;
    }

    @Override
    public final PemX509Certificate touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.content.release();
    }

    @Override
    public final byte[] getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<String> getCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<String> getNonCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getExtensionValue(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void checkValidity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void checkValidity(Date date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final BigInteger getSerialNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Principal getIssuerDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Principal getSubjectDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Date getNotBefore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Date getNotAfter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getTBSCertificate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getSignature() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getSigAlgName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getSigAlgOID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getSigAlgParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getIssuerUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getSubjectUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getKeyUsage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getBasicConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void verify(PublicKey publicKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void verify(PublicKey publicKey, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final PublicKey getPublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PemX509Certificate)) {
            return false;
        }
        object = (PemX509Certificate)object;
        return this.content.equals(((PemX509Certificate)object).content);
    }

    @Override
    public final int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public final String toString() {
        return this.content.toString(CharsetUtil.UTF_8);
    }
}

