/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolAccessor;
import com.appoptics.ext.io.netty.handler.ssl.ExtendedOpenSslSession;
import com.appoptics.ext.io.netty.handler.ssl.JdkSslEngine;
import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.net.Socket;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.X509ExtendedTrustManager;

final class OpenSslTlsv13X509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager tm;

    private OpenSslTlsv13X509ExtendedTrustManager(X509ExtendedTrustManager x509ExtendedTrustManager) {
        this.tm = x509ExtendedTrustManager;
    }

    static X509ExtendedTrustManager wrap(X509ExtendedTrustManager x509ExtendedTrustManager) {
        if (PlatformDependent.javaVersion() < 11 && OpenSsl.isTlsv13Supported()) {
            return new OpenSslTlsv13X509ExtendedTrustManager(x509ExtendedTrustManager);
        }
        return x509ExtendedTrustManager;
    }

    public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string, socket);
    }

    public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string, socket);
    }

    private static SSLEngine wrapEngine(SSLEngine sSLEngine) {
        final SSLSession sSLSession = sSLEngine.getHandshakeSession();
        if (sSLSession != null && "TLSv1.3".equals(sSLSession.getProtocol())) {
            final SSLEngine sSLEngine2 = sSLEngine;
            return new JdkSslEngine(sSLEngine2){

                public final String getNegotiatedApplicationProtocol() {
                    if (sSLEngine2 instanceof ApplicationProtocolAccessor) {
                        return ((ApplicationProtocolAccessor)((Object)sSLEngine2)).getNegotiatedApplicationProtocol();
                    }
                    return super.getNegotiatedApplicationProtocol();
                }

                public final SSLSession getHandshakeSession() {
                    if (PlatformDependent.javaVersion() >= 7 && sSLSession instanceof ExtendedOpenSslSession) {
                        ExtendedOpenSslSession extendedOpenSslSession;
                        final ExtendedOpenSslSession extendedOpenSslSession2 = extendedOpenSslSession = (ExtendedOpenSslSession)sSLSession;
                        return new ExtendedOpenSslSession(extendedOpenSslSession2){

                            public List getRequestedServerNames() {
                                return extendedOpenSslSession2.getRequestedServerNames();
                            }

                            public String[] getPeerSupportedSignatureAlgorithms() {
                                return extendedOpenSslSession2.getPeerSupportedSignatureAlgorithms();
                            }

                            public String getProtocol() {
                                return "TLSv1.2";
                            }
                        };
                    }
                    return new SSLSession(){

                        public byte[] getId() {
                            return sSLSession.getId();
                        }

                        public SSLSessionContext getSessionContext() {
                            return sSLSession.getSessionContext();
                        }

                        public long getCreationTime() {
                            return sSLSession.getCreationTime();
                        }

                        public long getLastAccessedTime() {
                            return sSLSession.getLastAccessedTime();
                        }

                        public void invalidate() {
                            sSLSession.invalidate();
                        }

                        public boolean isValid() {
                            return sSLSession.isValid();
                        }

                        public void putValue(String string, Object object) {
                            sSLSession.putValue(string, object);
                        }

                        public Object getValue(String string) {
                            return sSLSession.getValue(string);
                        }

                        public void removeValue(String string) {
                            sSLSession.removeValue(string);
                        }

                        public String[] getValueNames() {
                            return sSLSession.getValueNames();
                        }

                        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
                            return sSLSession.getPeerCertificates();
                        }

                        public Certificate[] getLocalCertificates() {
                            return sSLSession.getLocalCertificates();
                        }

                        public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
                            return sSLSession.getPeerCertificateChain();
                        }

                        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
                            return sSLSession.getPeerPrincipal();
                        }

                        public Principal getLocalPrincipal() {
                            return sSLSession.getLocalPrincipal();
                        }

                        public String getCipherSuite() {
                            return sSLSession.getCipherSuite();
                        }

                        public String getProtocol() {
                            return "TLSv1.2";
                        }

                        public String getPeerHost() {
                            return sSLSession.getPeerHost();
                        }

                        public int getPeerPort() {
                            return sSLSession.getPeerPort();
                        }

                        public int getPacketBufferSize() {
                            return sSLSession.getPacketBufferSize();
                        }

                        public int getApplicationBufferSize() {
                            return sSLSession.getApplicationBufferSize();
                        }
                    };
                }
            };
        }
        return sSLEngine;
    }

    public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string, OpenSslTlsv13X509ExtendedTrustManager.wrapEngine(sSLEngine));
    }

    public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string, OpenSslTlsv13X509ExtendedTrustManager.wrapEngine(sSLEngine));
    }

    public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
    }

    public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
    }

    public final X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }
}

