/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterial;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.X509KeyManager;

final class OpenSslCachingKeyMaterialProvider
extends OpenSslKeyMaterialProvider {
    private final int maxCachedEntries;
    private volatile boolean full;
    private final ConcurrentMap<String, OpenSslKeyMaterial> cache = new ConcurrentHashMap<String, OpenSslKeyMaterial>();

    OpenSslCachingKeyMaterialProvider(X509KeyManager x509KeyManager, String string, int n2) {
        super(x509KeyManager, string);
        this.maxCachedEntries = n2;
    }

    final OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator object, String string) throws Exception {
        Object object2 = (OpenSslKeyMaterial)this.cache.get(string);
        if (object2 == null) {
            object2 = super.chooseKeyMaterial((ByteBufAllocator)object, string);
            if (object2 == null) {
                return null;
            }
            if (this.full) {
                return object2;
            }
            if (this.cache.size() > this.maxCachedEntries) {
                this.full = true;
                return object2;
            }
            object = this.cache.putIfAbsent(string, (OpenSslKeyMaterial)object2);
            if (object != null) {
                object2.release();
                object2 = object;
            }
        }
        return object2.retain();
    }

    final void destroy() {
        do {
            Iterator iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                ((OpenSslKeyMaterial)iterator.next()).release();
                iterator.remove();
            }
        } while (!this.cache.isEmpty());
    }
}

