/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.UnpooledByteBufAllocator;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteConverter;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslEngine;
import com.appoptics.ext.io.netty.handler.ssl.PemPrivateKey;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.appoptics.ext.io.netty.handler.ssl.SslContext;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import com.appoptics.ext.io.netty.internal.tcnative.Buffer;
import com.appoptics.ext.io.netty.internal.tcnative.Library;
import com.appoptics.ext.io.netty.internal.tcnative.SSL;
import com.appoptics.ext.io.netty.internal.tcnative.SSLContext;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.NativeLibraryLoader;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenSsl {
    private static final InternalLogger logger;
    private static final Throwable UNAVAILABILITY_CAUSE;
    static final List<String> DEFAULT_CIPHERS;
    static final Set<String> AVAILABLE_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_OPENSSL_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_JAVA_CIPHER_SUITES;
    private static final boolean SUPPORTS_KEYMANAGER_FACTORY;
    private static final boolean USE_KEYMANAGER_FACTORY;
    private static final boolean SUPPORTS_OCSP;
    private static final boolean TLSV13_SUPPORTED;
    private static final boolean IS_BORINGSSL;
    static final Set<String> SUPPORTED_PROTOCOLS_SET;
    static final String[] EXTRA_SUPPORTED_TLS_1_3_CIPHERS;

    static X509Certificate selfSignedCertificate() throws CertificateException {
        return (X509Certificate)SslContext.X509_CERT_FACTORY.generateCertificate(new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICrjCCAZagAwIBAgIIdSvQPv1QAZQwDQYJKoZIhvcNAQELBQAwFjEUMBIGA1UEAxMLZXhhbXBs\nZS5jb20wIBcNMTgwNDA2MjIwNjU5WhgPOTk5OTEyMzEyMzU5NTlaMBYxFDASBgNVBAMTC2V4YW1w\nbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAggbWsmDQ6zNzRZ5AW8E3eoGl\nqWvOBDb5Fs1oBRrVQHuYmVAoaqwDzXYJ0LOwa293AgWEQ1jpcbZ2hpoYQzqEZBTLnFhMrhRFlH6K\nbJND8Y33kZ/iSVBBDuGbdSbJShlM+4WwQ9IAso4MZ4vW3S1iv5fGGpLgbtXRmBf/RU8omN0Gijlv\nWlLWHWijLN8xQtySFuBQ7ssW8RcKAary3pUm6UUQB+Co6lnfti0Tzag8PgjhAJq2Z3wbsGRnP2YS\nvYoaK6qzmHXRYlp/PxrjBAZAmkLJs4YTm/XFF+fkeYx4i9zqHbyone5yerRibsHaXZWLnUL+rFoe\nMdKvr0VS3sGmhQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQADQi441pKmXf9FvUV5EHU4v8nJT9Iq\nyqwsKwXnr7AsUlDGHBD7jGrjAXnG5rGxuNKBQ35wRxJATKrUtyaquFUL6H8O6aGQehiFTk6zmPbe\n12Gu44vqqTgIUxnv3JQJiox8S2hMxsSddpeCmSdvmalvD6WG4NthH6B9ZaBEiep1+0s0RUaBYn73\nI7CCUaAtbjfR6pcJjrFk5ei7uwdQZFSJtkP2z8r7zfeANJddAKFlkaMWn7u+OIVuB4XPooWicObk\nNAHFtP65bocUYnDpTVdiyvn8DdqyZ/EO8n1bBKBzuSLplk2msW4pdgaFgY7Vw/0wzcFXfUXmL1uy\nG8sQD/wx\n-----END CERTIFICATE-----".getBytes(CharsetUtil.US_ASCII)));
    }

    private static boolean doesSupportOcsp() {
        boolean bl = false;
        if ((long)OpenSsl.version() >= 0x10002000L) {
            long l2 = -1L;
            try {
                l2 = SSLContext.make((int)16, (int)1);
                SSLContext.enableOcsp((long)l2, (boolean)false);
                bl = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (l2 != -1L) {
                    SSLContext.free((long)l2);
                }
            }
        }
        return bl;
    }

    private static boolean doesSupportProtocol(int n2, int n3) {
        if (n3 == 0) {
            return false;
        }
        long l2 = -1L;
        try {
            l2 = SSLContext.make((int)n2, (int)2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (l2 != -1L) {
                SSLContext.free((long)l2);
            }
        }
    }

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    @Deprecated
    public static boolean isAlpnSupported() {
        return (long)OpenSsl.version() >= 0x10002000L;
    }

    public static boolean isOcspSupported() {
        return SUPPORTS_OCSP;
    }

    public static int version() {
        if (OpenSsl.isAvailable()) {
            return SSL.version();
        }
        return -1;
    }

    public static String versionString() {
        if (OpenSsl.isAvailable()) {
            return SSL.versionString();
        }
        return null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static Set<String> availableJavaCipherSuites() {
        return AVAILABLE_JAVA_CIPHER_SUITES;
    }

    public static boolean isCipherSuiteAvailable(String string) {
        String string2 = CipherSuiteConverter.toOpenSsl(string, IS_BORINGSSL);
        if (string2 != null) {
            string = string2;
        }
        return AVAILABLE_OPENSSL_CIPHER_SUITES.contains(string);
    }

    static boolean useKeyManagerFactory() {
        return USE_KEYMANAGER_FACTORY;
    }

    static long memoryAddress(ByteBuf byteBuf) {
        assert (byteBuf.isDirect());
        if (byteBuf.hasMemoryAddress()) {
            return byteBuf.memoryAddress();
        }
        return Buffer.address((ByteBuffer)byteBuf.nioBuffer());
    }

    private OpenSsl() {
    }

    private static void loadTcNative() throws Exception {
        String string = PlatformDependent.normalizedOs();
        String string2 = PlatformDependent.normalizedArch();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(5);
        String string3 = "netty_tcnative";
        if ("linux".equalsIgnoreCase(string)) {
            Object object = PlatformDependent.normalizedLinuxClassifiers();
            object = object.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                linkedHashSet.add(string3 + "_" + string + '_' + string2 + "_" + string4);
            }
            linkedHashSet.add(string3 + "_" + string + '_' + string2);
            linkedHashSet.add(string3 + "_" + string + '_' + string2 + "_fedora");
        } else {
            linkedHashSet.add(string3 + "_" + string + '_' + string2);
        }
        linkedHashSet.add(string3 + "_" + string2);
        linkedHashSet.add(string3);
        NativeLibraryLoader.loadFirstAvailable(SSLContext.class.getClassLoader(), linkedHashSet.toArray(new String[0]));
    }

    private static boolean initializeTcNative(String string) throws Exception {
        return Library.initialize((String)"provided", (String)string);
    }

    static void releaseIfNeeded(ReferenceCounted referenceCounted) {
        if (referenceCounted.refCnt() > 0) {
            ReferenceCountUtil.safeRelease(referenceCounted);
        }
    }

    static boolean isTlsv13Supported() {
        return TLSV13_SUPPORTED;
    }

    static boolean isBoringSSL() {
        return IS_BORINGSSL;
    }

    static {
        ArrayList<String> arrayList;
        logger = InternalLoggerFactory.getInstance(OpenSsl.class);
        Serializable serializable = null;
        if (SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.handler.ssl.noOpenSsl", false)) {
            serializable = new UnsupportedOperationException("OpenSSL was explicit disabled with -Dio.netty.handler.ssl.noOpenSsl=true");
            logger.debug("netty-tcnative explicit disabled; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.", (Throwable)serializable);
        } else {
            try {
                Class.forName("com.appoptics.ext.io.netty.internal.tcnative.SSLContext", false, OpenSsl.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                arrayList = classNotFoundException;
                serializable = classNotFoundException;
                logger.debug("netty-tcnative not in the classpath; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.");
            }
            if (serializable == null) {
                try {
                    OpenSsl.loadTcNative();
                }
                catch (Throwable throwable) {
                    arrayList = throwable;
                    serializable = throwable;
                    logger.debug("Failed to load netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable, unless the application has already loaded the symbols by some other means. See https://netty.io/wiki/forked-tomcat-native.html for more information.", (Throwable)((Object)arrayList));
                }
                try {
                    arrayList = SystemPropertyUtil.get("com.appoptics.ext.io.netty.handler.ssl.openssl.engine", null);
                    if (arrayList == null) {
                        logger.debug("Initialize netty-tcnative using engine: 'default'");
                    } else {
                        logger.debug("Initialize netty-tcnative using engine: '{}'", (Object)arrayList);
                    }
                    OpenSsl.initializeTcNative(arrayList);
                    serializable = null;
                }
                catch (Throwable throwable) {
                    if (serializable == null) {
                        serializable = throwable;
                    }
                    logger.debug("Failed to initialize netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable. See https://netty.io/wiki/forked-tomcat-native.html for more information.", throwable);
                }
            }
        }
        UNAVAILABILITY_CAUSE = serializable;
        if (serializable == null) {
            logger.debug("netty-tcnative using native library: {}", (Object)SSL.versionString());
            arrayList = new ArrayList<String>();
            serializable = new LinkedHashSet(128);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            IS_BORINGSSL = "BoringSSL".equals(OpenSsl.versionString());
            EXTRA_SUPPORTED_TLS_1_3_CIPHERS = IS_BORINGSSL ? new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256"} : EmptyArrays.EMPTY_STRINGS;
            try {
                long l2 = SSLContext.make((int)63, (int)1);
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                try {
                    try {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (String object : SslUtils.TLSV13_CIPHERS) {
                            String x509Certificate = CipherSuiteConverter.toOpenSsl(object, IS_BORINGSSL);
                            if (x509Certificate == null) continue;
                            stringBuilder.append(x509Certificate).append(':');
                        }
                        if (stringBuilder.length() == 0) {
                            bl3 = false;
                        } else {
                            StringBuilder stringBuilder2 = stringBuilder;
                            stringBuilder2.setLength(stringBuilder2.length() - 1);
                            SSLContext.setCipherSuite((long)l2, (String)stringBuilder.toString(), (boolean)true);
                            bl3 = true;
                        }
                    }
                    catch (Exception exception) {
                        bl3 = false;
                    }
                    SSLContext.setCipherSuite((long)l2, (String)"ALL", (boolean)false);
                    long l7 = SSL.newSSL((long)l2, (boolean)true);
                    try {
                        for (String string : SSL.getCiphers((long)l7)) {
                            if (string == null || string.isEmpty() || serializable.contains(string) || !bl3 && SslUtils.isTLSv13Cipher(string)) continue;
                            serializable.add(string);
                        }
                        if (IS_BORINGSSL) {
                            Collections.addAll(serializable, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
                            Collections.addAll(serializable, new String[]{"AEAD-AES128-GCM-SHA256", "AEAD-AES256-GCM-SHA384", "AEAD-CHACHA20-POLY1305-SHA256"});
                        }
                        PemPrivateKey pemPrivateKey = PemPrivateKey.valueOf("-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCCBtayYNDrM3NFnkBbwTd6gaWp\na84ENvkWzWgFGtVAe5iZUChqrAPNdgnQs7Brb3cCBYRDWOlxtnaGmhhDOoRkFMucWEyuFEWUfops\nk0PxjfeRn+JJUEEO4Zt1JslKGUz7hbBD0gCyjgxni9bdLWK/l8YakuBu1dGYF/9FTyiY3QaKOW9a\nUtYdaKMs3zFC3JIW4FDuyxbxFwoBqvLelSbpRRAH4KjqWd+2LRPNqDw+COEAmrZnfBuwZGc/ZhK9\nihorqrOYddFiWn8/GuMEBkCaQsmzhhOb9cUX5+R5jHiL3OodvKid7nJ6tGJuwdpdlYudQv6sWh4x\n0q+vRVLewaaFAgMBAAECggEAP8tPJvFtTxhNJAkCloHz0D0vpDHqQBMgntlkgayqmBqLwhyb18pR\ni0qwgh7HHc7wWqOOQuSqlEnrWRrdcI6TSe8R/sErzfTQNoznKWIPYcI/hskk4sdnQ//Yn9/Jvnsv\nU/BBjOTJxtD+sQbhAl80JcA3R+5sArURQkfzzHOL/YMqzAsn5hTzp7HZCxUqBk3KaHRxV7NefeOE\nxlZuWSmxYWfbFIs4kx19/1t7h8CHQWezw+G60G2VBtSBBxDnhBWvqG6R/wpzJ3nEhPLLY9T+XIHe\nipzdMOOOUZorfIg7M+pyYPji+ZIZxIpY5OjrOzXHciAjRtr5Y7l99K1CG1LguQKBgQDrQfIMxxtZ\nvxU/1cRmUV9l7pt5bjV5R6byXq178LxPKVYNjdZ840Q0/OpZEVqaT1xKVi35ohP1QfNjxPLlHD+K\niDAR9z6zkwjIrbwPCnb5kuXy4lpwPcmmmkva25fI7qlpHtbcuQdoBdCfr/KkKaUCMPyY89LCXgEw\n5KTDj64UywKBgQCNfbO+eZLGzhiHhtNJurresCsIGWlInv322gL8CSfBMYl6eNfUTZvUDdFhPISL\nUljKWzXDrjw0ujFSPR0XhUGtiq89H+HUTuPPYv25gVXO+HTgBFZEPl4PpA+BUsSVZy0NddneyqLk\n42Wey9omY9Q8WsdNQS5cbUvy0uG6WFoX7wKBgQDZ1jpW8pa0x2bZsQsm4vo+3G5CRnZlUp+XlWt2\ndDcp5dC0xD1zbs1dc0NcLeGDOTDv9FSl7hok42iHXXq8AygjEm/QcuwwQ1nC2HxmQP5holAiUs4D\nWHM8PWs3wFYPzE459EBoKTxeaeP/uWAn+he8q7d5uWvSZlEcANs/6e77eQKBgD21Ar0hfFfj7mK8\n9E0FeRZBsqK3omkfnhcYgZC11Xa2SgT1yvs2Va2n0RcdM5kncr3eBZav2GYOhhAdwyBM55XuE/sO\neokDVutNeuZ6d5fqV96TRaRBpvgfTvvRwxZ9hvKF4Vz+9wfn/JvCwANaKmegF6ejs7pvmF3whq2k\ndrZVAoGAX5YxQ5XMTD0QbMAl7/6qp6S58xNoVdfCkmkj1ZLKaHKIjS/benkKGlySVQVPexPfnkZx\np/Vv9yyphBoudiTBS9Uog66ueLYZqpgxlM/6OhYg86Gm3U2ycvMxYjBM1NFiyze21AqAhI+HX+Ot\nmraV2/guSgDgZAhukRZzeQ2RucI=\n-----END PRIVATE KEY-----".getBytes(CharsetUtil.US_ASCII));
                        try {
                            SSLContext.setCertificateCallback((long)l2, null);
                            X509Certificate x509Certificate = OpenSsl.selfSignedCertificate();
                            l3 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, x509Certificate);
                            l5 = SSL.parseX509Chain((long)l3);
                            l4 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemPrivateKey.retain());
                            l6 = SSL.parsePrivateKey((long)l4, null);
                            SSL.setKeyMaterial((long)l7, (long)l5, (long)l6);
                            bl = true;
                            try {
                                int n2 = SystemPropertyUtil.contains("com.appoptics.ext.io.netty.handler.ssl.openssl.useKeyManagerFactory") ? 1 : 0;
                                if (!IS_BORINGSSL) {
                                    bl2 = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.handler.ssl.openssl.useKeyManagerFactory", true);
                                    if (n2 != 0) {
                                        logger.info("System property 'io.netty.handler.ssl.openssl.useKeyManagerFactory' is deprecated and so will be ignored in the future");
                                    }
                                } else {
                                    bl2 = true;
                                    if (n2 != 0) {
                                        logger.info("System property 'io.netty.handler.ssl.openssl.useKeyManagerFactory' is deprecated and will be ignored when using BoringSSL");
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                logger.debug("Failed to get useKeyManagerFactory system property.");
                            }
                        }
                        catch (Error error) {
                            logger.debug("KeyManagerFactory not supported.");
                        }
                        finally {
                            pemPrivateKey.release();
                        }
                    }
                    finally {
                        SSL.freeSSL((long)l7);
                        if (l3 != 0L) {
                            SSL.freeBIO((long)l3);
                        }
                        if (l4 != 0L) {
                            SSL.freeBIO((long)l4);
                        }
                        if (l5 != 0L) {
                            SSL.freeX509Chain((long)l5);
                        }
                        if (l6 != 0L) {
                            SSL.freePrivateKey((long)l6);
                        }
                    }
                }
                finally {
                    SSLContext.free((long)l2);
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to get the list of available OpenSSL cipher suites.", exception);
            }
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.unmodifiableSet(serializable);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() << 1);
            for (String string : AVAILABLE_OPENSSL_CIPHER_SUITES) {
                if (!SslUtils.isTLSv13Cipher(string)) {
                    linkedHashSet.add(CipherSuiteConverter.toJava(string, "TLS"));
                    linkedHashSet.add(CipherSuiteConverter.toJava(string, "SSL"));
                    continue;
                }
                linkedHashSet.add(string);
            }
            SslUtils.addIfSupported(linkedHashSet, arrayList, SslUtils.DEFAULT_CIPHER_SUITES);
            SslUtils.addIfSupported(linkedHashSet, arrayList, SslUtils.TLSV13_CIPHER_SUITES);
            SslUtils.useFallbackCiphersIfDefaultIsEmpty(arrayList, linkedHashSet);
            DEFAULT_CIPHERS = Collections.unmodifiableList(arrayList);
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet);
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() + AVAILABLE_JAVA_CIPHER_SUITES.size());
            linkedHashSet2.addAll(AVAILABLE_OPENSSL_CIPHER_SUITES);
            linkedHashSet2.addAll(AVAILABLE_JAVA_CIPHER_SUITES);
            AVAILABLE_CIPHER_SUITES = linkedHashSet2;
            SUPPORTS_KEYMANAGER_FACTORY = bl;
            USE_KEYMANAGER_FACTORY = bl2;
            LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>(6);
            linkedHashSet3.add("SSLv2Hello");
            if (OpenSsl.doesSupportProtocol(1, SSL.SSL_OP_NO_SSLv2)) {
                linkedHashSet3.add("SSLv2");
            }
            if (OpenSsl.doesSupportProtocol(2, SSL.SSL_OP_NO_SSLv3)) {
                linkedHashSet3.add("SSLv3");
            }
            if (OpenSsl.doesSupportProtocol(4, SSL.SSL_OP_NO_TLSv1)) {
                linkedHashSet3.add("TLSv1");
            }
            if (OpenSsl.doesSupportProtocol(8, SSL.SSL_OP_NO_TLSv1_1)) {
                linkedHashSet3.add("TLSv1.1");
            }
            if (OpenSsl.doesSupportProtocol(16, SSL.SSL_OP_NO_TLSv1_2)) {
                linkedHashSet3.add("TLSv1.2");
            }
            if (bl3 && OpenSsl.doesSupportProtocol(32, SSL.SSL_OP_NO_TLSv1_3)) {
                linkedHashSet3.add("TLSv1.3");
                TLSV13_SUPPORTED = true;
            } else {
                TLSV13_SUPPORTED = false;
            }
            SUPPORTED_PROTOCOLS_SET = Collections.unmodifiableSet(linkedHashSet3);
            SUPPORTS_OCSP = OpenSsl.doesSupportOcsp();
            if (logger.isDebugEnabled()) {
                logger.debug("Supported protocols (OpenSSL): {} ", (Object)SUPPORTED_PROTOCOLS_SET);
                logger.debug("Default cipher suites (OpenSSL): {}", (Object)DEFAULT_CIPHERS);
            }
            return;
        }
        DEFAULT_CIPHERS = Collections.emptyList();
        AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.emptySet();
        AVAILABLE_JAVA_CIPHER_SUITES = Collections.emptySet();
        AVAILABLE_CIPHER_SUITES = Collections.emptySet();
        SUPPORTS_KEYMANAGER_FACTORY = false;
        USE_KEYMANAGER_FACTORY = false;
        SUPPORTED_PROTOCOLS_SET = Collections.emptySet();
        SUPPORTS_OCSP = false;
        TLSV13_SUPPORTED = false;
        IS_BORINGSSL = false;
        EXTRA_SUPPORTED_TLS_1_3_CIPHERS = EmptyArrays.EMPTY_STRINGS;
    }
}

