/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Java8SslUtils {
    static List<String> getSniHostNames(SSLParameters iterator) {
        if ((iterator = ((SSLParameters)((Object)iterator)).getServerNames()) == null || iterator.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SNIServerName sNIServerName = (SNIServerName)iterator.next();
            if (sNIServerName instanceof SNIHostName) {
                arrayList.add(((SNIHostName)sNIServerName).getAsciiName());
                continue;
            }
            throw new IllegalArgumentException("Only " + SNIHostName.class.getName() + " instances are supported, but found: " + sNIServerName);
        }
        return arrayList;
    }

    static void setSniHostNames(SSLParameters sSLParameters, List<String> list) {
        sSLParameters.setServerNames(Java8SslUtils.getSniHostNames(list));
    }

    static List getSniHostNames(List<String> object) {
        if (object == null || object.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIHostName> arrayList = new ArrayList<SNIHostName>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            arrayList.add(new SNIHostName(string));
        }
        return arrayList;
    }

    static List getSniHostName(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new SNIHostName(byArray));
    }

    static boolean getUseCipherSuitesOrder(SSLParameters sSLParameters) {
        return sSLParameters.getUseCipherSuitesOrder();
    }

    static void setUseCipherSuitesOrder(SSLParameters sSLParameters, boolean bl) {
        sSLParameters.setUseCipherSuitesOrder(bl);
    }

    static void setSNIMatchers(SSLParameters sSLParameters, Collection<?> collection) {
        sSLParameters.setSNIMatchers(collection);
    }
}

