/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterial;
import com.appoptics.ext.io.netty.internal.tcnative.SSL;
import com.appoptics.ext.io.netty.util.AbstractReferenceCounted;
import com.appoptics.ext.io.netty.util.ResourceLeakDetector;
import com.appoptics.ext.io.netty.util.ResourceLeakDetectorFactory;
import com.appoptics.ext.io.netty.util.ResourceLeakTracker;
import java.security.cert.X509Certificate;

final class DefaultOpenSslKeyMaterial
extends AbstractReferenceCounted
implements OpenSslKeyMaterial {
    private static final ResourceLeakDetector<DefaultOpenSslKeyMaterial> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(DefaultOpenSslKeyMaterial.class);
    private final ResourceLeakTracker<DefaultOpenSslKeyMaterial> leak;
    private final X509Certificate[] x509CertificateChain;
    private long chain;
    private long privateKey;

    DefaultOpenSslKeyMaterial(long l2, long l3, X509Certificate[] x509CertificateArray) {
        this.chain = l2;
        this.privateKey = l3;
        this.x509CertificateChain = x509CertificateArray;
        this.leak = leakDetector.track(this);
    }

    protected final void deallocate() {
        SSL.freeX509Chain((long)this.chain);
        this.chain = 0L;
        SSL.freePrivateKey((long)this.privateKey);
        this.privateKey = 0L;
        if (this.leak != null) {
            boolean bl = this.leak.close(this);
            assert (bl);
        }
    }

    public final DefaultOpenSslKeyMaterial retain() {
        if (this.leak != null) {
            this.leak.record();
        }
        super.retain();
        return this;
    }

    public final DefaultOpenSslKeyMaterial touch() {
        if (this.leak != null) {
            this.leak.record();
        }
        super.touch();
        return this;
    }

    public final DefaultOpenSslKeyMaterial touch(Object object) {
        if (this.leak != null) {
            this.leak.record(object);
        }
        return this;
    }

    public final boolean release() {
        if (this.leak != null) {
            this.leak.record();
        }
        return super.release();
    }

    public final boolean release(int n2) {
        if (this.leak != null) {
            this.leak.record();
        }
        return super.release(n2);
    }
}

