/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CipherSuiteConverter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CipherSuiteConverter.class);
    private static final Pattern JAVA_CIPHERSUITE_PATTERN = Pattern.compile("^(?:TLS|SSL)_((?:(?!_WITH_).)+)_WITH_(.*)_(.*)$");
    private static final Pattern OPENSSL_CIPHERSUITE_PATTERN = Pattern.compile("^(?:((?:(?:EXP-)?(?:(?:DHE|EDH|ECDH|ECDHE|SRP|RSA)-(?:DSS|RSA|ECDSA|PSK)|(?:ADH|AECDH|KRB5|PSK|SRP)))|EXP)-)?(.*)-(.*)$");
    private static final Pattern JAVA_AES_CBC_PATTERN = Pattern.compile("^(AES)_([0-9]+)_CBC$");
    private static final Pattern JAVA_AES_PATTERN = Pattern.compile("^(AES)_([0-9]+)_(.*)$");
    private static final Pattern OPENSSL_AES_CBC_PATTERN = Pattern.compile("^(AES)([0-9]+)$");
    private static final Pattern OPENSSL_AES_PATTERN = Pattern.compile("^(AES)([0-9]+)-(.*)$");
    private static final ConcurrentMap<String, String> j2o = PlatformDependent.newConcurrentHashMap();
    private static final ConcurrentMap<String, Map<String, String>> o2j = PlatformDependent.newConcurrentHashMap();
    private static final Map<String, String> j2oTls13;
    private static final Map<String, Map<String, String>> o2jTls13;

    static String toOpenSsl(String string, boolean bl) {
        String string2 = (String)j2o.get(string);
        if (string2 != null) {
            return string2;
        }
        return CipherSuiteConverter.cacheFromJava(string, bl);
    }

    private static String cacheFromJava(String string, boolean bl) {
        String string2 = j2oTls13.get(string);
        if (string2 != null) {
            if (bl) {
                return string2;
            }
            return string;
        }
        String string3 = CipherSuiteConverter.toOpenSslUncached(string, bl);
        if (string3 == null) {
            return null;
        }
        j2o.putIfAbsent(string, string3);
        string2 = string.substring(4);
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("", string2);
        hashMap.put("SSL", "SSL_" + string2);
        hashMap.put("TLS", "TLS_" + string2);
        o2j.put(string3, hashMap);
        logger.debug("Cipher suite mapping: {} => {}", (Object)string, (Object)string3);
        return string3;
    }

    static String toOpenSslUncached(String object, boolean bl) {
        String string = j2oTls13.get(object);
        if (string != null) {
            if (bl) {
                return string;
            }
            return object;
        }
        if (!((Matcher)(object = JAVA_CIPHERSUITE_PATTERN.matcher((CharSequence)object))).matches()) {
            return null;
        }
        String string2 = CipherSuiteConverter.toOpenSslHandshakeAlgo(((Matcher)object).group(1));
        string = CipherSuiteConverter.toOpenSslBulkCipher(((Matcher)object).group(2));
        object = CipherSuiteConverter.toOpenSslHmacAlgo(((Matcher)object).group(3));
        if (string2.isEmpty()) {
            return string + '-' + (String)object;
        }
        if (string.contains("CHACHA20")) {
            return string2 + '-' + string;
        }
        return string2 + '-' + string + '-' + (String)object;
    }

    private static String toOpenSslHandshakeAlgo(String string) {
        boolean bl = string.endsWith("_EXPORT");
        if (bl) {
            string = string.substring(0, string.length() - 7);
        }
        if ("RSA".equals(string)) {
            string = "";
        } else if (string.endsWith("_anon")) {
            string = "A" + string.substring(0, string.length() - 5);
        }
        if (bl) {
            string = string.isEmpty() ? "EXP" : "EXP-" + string;
        }
        return string.replace('_', '-');
    }

    private static String toOpenSslBulkCipher(String string) {
        if (string.startsWith("AES_")) {
            Matcher matcher = JAVA_AES_CBC_PATTERN.matcher(string);
            if (matcher.matches()) {
                return matcher.replaceFirst("$1$2");
            }
            matcher = JAVA_AES_PATTERN.matcher(string);
            if (matcher.matches()) {
                return matcher.replaceFirst("$1$2-$3");
            }
        }
        if ("3DES_EDE_CBC".equals(string)) {
            return "DES-CBC3";
        }
        if ("RC4_128".equals(string) || "RC4_40".equals(string)) {
            return "RC4";
        }
        if ("DES40_CBC".equals(string) || "DES_CBC_40".equals(string)) {
            return "DES-CBC";
        }
        if ("RC2_CBC_40".equals(string)) {
            return "RC2-CBC";
        }
        return string.replace('_', '-');
    }

    private static String toOpenSslHmacAlgo(String string) {
        return string;
    }

    static String toJava(String string, String string2) {
        Map<String, String> map = (Map<String, String>)o2j.get(string);
        if (map == null && (map = CipherSuiteConverter.cacheFromOpenSsl(string)) == null) {
            return null;
        }
        string = (String)map.get(string2);
        if (string == null) {
            string = map.get("");
            if (string == null) {
                return null;
            }
            string = string2 + '_' + string;
        }
        return string;
    }

    private static Map<String, String> cacheFromOpenSsl(String string) {
        Object object = o2jTls13.get(string);
        if (object != null) {
            return object;
        }
        object = CipherSuiteConverter.toJavaUncached0(string, false);
        if (object == null) {
            return null;
        }
        String string2 = "SSL_" + (String)object;
        String string3 = "TLS_" + (String)object;
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("", (String)object);
        hashMap.put("SSL", string2);
        hashMap.put("TLS", string3);
        o2j.putIfAbsent(string, hashMap);
        j2o.putIfAbsent(string3, string);
        j2o.putIfAbsent(string2, string);
        logger.debug("Cipher suite mapping: {} => {}", (Object)string3, (Object)string);
        logger.debug("Cipher suite mapping: {} => {}", (Object)string2, (Object)string);
        return hashMap;
    }

    /*
     * Unable to fully structure code
     */
    private static String toJavaUncached0(String var0, boolean var1_1) {
        block7: {
            if (var1_1 && (var1_2 = CipherSuiteConverter.o2jTls13.get(var0)) != null) {
                return var1_2.get("TLS");
            }
            var1_3 = CipherSuiteConverter.OPENSSL_CIPHERSUITE_PATTERN.matcher(var0);
            if (!var1_3.matches()) {
                return null;
            }
            var0 = var1_3.group(1);
            if (var0 != null) break block7;
            var0 = "";
            ** GOTO lbl-1000
        }
        if (var0.startsWith("EXP-")) {
            var0 = var0.substring(4);
            var2_4 = true;
        } else if ("EXP".equals(var0)) {
            var0 = "";
            var2_4 = true;
        } else lbl-1000:
        // 2 sources

        {
            var2_4 = false;
        }
        var0 = CipherSuiteConverter.toJavaHandshakeAlgo(var0, var2_4);
        var2_5 = CipherSuiteConverter.toJavaBulkCipher(var1_3.group(2), var2_4);
        var1_3 = CipherSuiteConverter.toJavaHmacAlgo(var1_3.group(3));
        var0 = var0 + "_WITH_" + var2_5 + '_' + (String)var1_3;
        if (var2_5.contains("CHACHA20")) {
            return var0 + "_SHA256";
        }
        return var0;
    }

    private static String toJavaHandshakeAlgo(String string, boolean bl) {
        if (string.isEmpty()) {
            string = "RSA";
        } else if ("ADH".equals(string)) {
            string = "DH_anon";
        } else if ("AECDH".equals(string)) {
            string = "ECDH_anon";
        }
        string = string.replace('-', '_');
        if (bl) {
            return string + "_EXPORT";
        }
        return string;
    }

    private static String toJavaBulkCipher(String string, boolean bl) {
        if (string.startsWith("AES")) {
            Matcher matcher = OPENSSL_AES_CBC_PATTERN.matcher(string);
            if (matcher.matches()) {
                return matcher.replaceFirst("$1_$2_CBC");
            }
            matcher = OPENSSL_AES_PATTERN.matcher(string);
            if (matcher.matches()) {
                return matcher.replaceFirst("$1_$2_$3");
            }
        }
        if ("DES-CBC3".equals(string)) {
            return "3DES_EDE_CBC";
        }
        if ("RC4".equals(string)) {
            if (bl) {
                return "RC4_40";
            }
            return "RC4_128";
        }
        if ("DES-CBC".equals(string)) {
            if (bl) {
                return "DES_CBC_40";
            }
            return "DES_CBC";
        }
        if ("RC2-CBC".equals(string)) {
            if (bl) {
                return "RC2_CBC_40";
            }
            return "RC2_CBC";
        }
        return string.replace('-', '_');
    }

    private static String toJavaHmacAlgo(String string) {
        return string;
    }

    static void convertToCipherStrings(Iterable<String> object, StringBuilder stringBuilder, StringBuilder stringBuilder2, boolean bl) {
        String string;
        object = object.iterator();
        while (object.hasNext() && (string = (String)object.next()) != null) {
            String string2 = CipherSuiteConverter.toOpenSsl(string, bl);
            if (string2 == null) {
                string2 = string;
            }
            if (!OpenSsl.isCipherSuiteAvailable(string2)) {
                throw new IllegalArgumentException("unsupported cipher suite: " + string + '(' + string2 + ')');
            }
            if (SslUtils.isTLSv13Cipher(string2) || SslUtils.isTLSv13Cipher(string)) {
                stringBuilder2.append(string2);
                stringBuilder2.append(':');
                continue;
            }
            stringBuilder.append(string2);
            stringBuilder.append(':');
        }
        if (stringBuilder.length() == 0 && stringBuilder2.length() == 0) {
            throw new IllegalArgumentException("empty cipher suites");
        }
        if (stringBuilder.length() > 0) {
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.setLength(stringBuilder3.length() - 1);
        }
        if (stringBuilder2.length() > 0) {
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.setLength(stringBuilder4.length() - 1);
        }
    }

    private CipherSuiteConverter() {
    }

    static {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("TLS_AES_128_GCM_SHA256", "AEAD-AES128-GCM-SHA256");
        hashMap.put("TLS_AES_256_GCM_SHA384", "AEAD-AES256-GCM-SHA384");
        hashMap.put("TLS_CHACHA20_POLY1305_SHA256", "AEAD-CHACHA20-POLY1305-SHA256");
        j2oTls13 = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap<String, Map<String, String>>();
        hashMap.put("TLS_AES_128_GCM_SHA256", Collections.singletonMap("TLS", "TLS_AES_128_GCM_SHA256"));
        hashMap.put("TLS_AES_256_GCM_SHA384", Collections.singletonMap("TLS", "TLS_AES_256_GCM_SHA384"));
        hashMap.put("TLS_CHACHA20_POLY1305_SHA256", Collections.singletonMap("TLS", "TLS_CHACHA20_POLY1305_SHA256"));
        hashMap.put("AEAD-AES128-GCM-SHA256", Collections.singletonMap("TLS", "TLS_AES_128_GCM_SHA256"));
        hashMap.put("AEAD-AES256-GCM-SHA384", Collections.singletonMap("TLS", "TLS_AES_256_GCM_SHA384"));
        hashMap.put("AEAD-CHACHA20-POLY1305-SHA256", Collections.singletonMap("TLS", "TLS_CHACHA20_POLY1305_SHA256"));
        o2jTls13 = Collections.unmodifiableMap(hashMap);
    }
}

