/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Flags;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameLogger;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameWriter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

public class Http2OutboundFrameLogger
implements Http2FrameWriter {
    private final Http2FrameWriter writer;
    private final Http2FrameLogger logger;

    public Http2OutboundFrameLogger(Http2FrameWriter http2FrameWriter, Http2FrameLogger http2FrameLogger) {
        this.writer = ObjectUtil.checkNotNull(http2FrameWriter, "writer");
        this.logger = ObjectUtil.checkNotNull(http2FrameLogger, "logger");
    }

    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl, ChannelPromise channelPromise) {
        this.logger.logData(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, n2, byteBuf, n3, bl);
        return this.writer.writeData(channelHandlerContext, n2, byteBuf, n3, bl, channelPromise);
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl, ChannelPromise channelPromise) {
        this.logger.logHeaders(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, n2, http2Headers, n3, bl);
        return this.writer.writeHeaders(channelHandlerContext, n2, http2Headers, n3, bl, channelPromise);
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2, ChannelPromise channelPromise) {
        this.logger.logHeaders(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2);
        return this.writer.writeHeaders(channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2, channelPromise);
    }

    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n2, long l2, ChannelPromise channelPromise) {
        this.logger.logRstStream(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, n2, l2);
        return this.writer.writeRstStream(channelHandlerContext, n2, l2, channelPromise);
    }

    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        this.logger.logSettings(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, http2Settings);
        return this.writer.writeSettings(channelHandlerContext, http2Settings, channelPromise);
    }

    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.logger.logSettingsAck(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext);
        return this.writer.writeSettingsAck(channelHandlerContext, channelPromise);
    }

    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl, long l2, ChannelPromise channelPromise) {
        if (bl) {
            this.logger.logPingAck(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, l2);
        } else {
            this.logger.logPing(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, l2);
        }
        return this.writer.writePing(channelHandlerContext, bl, l2, channelPromise);
    }

    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        this.logger.logGoAway(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, n2, l2, byteBuf);
        return this.writer.writeGoAway(channelHandlerContext, n2, l2, byteBuf, channelPromise);
    }

    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n2, int n3, ChannelPromise channelPromise) {
        this.logger.logWindowsUpdate(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, n2, n3);
        return this.writer.writeWindowUpdate(channelHandlerContext, n2, n3, channelPromise);
    }

    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by, int n2, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        this.logger.logUnknownFrame(Http2FrameLogger.Direction.OUTBOUND, channelHandlerContext, by, n2, http2Flags, byteBuf);
        return this.writer.writeFrame(channelHandlerContext, by, n2, http2Flags, byteBuf, channelPromise);
    }

    public void close() {
        this.writer.close();
    }

    public Http2FrameWriter.Configuration configuration() {
        return this.writer.configuration();
    }
}

