/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.handler.codec.UnsupportedValueConverter;
import com.appoptics.ext.io.netty.handler.codec.http2.CharSequenceMap;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackHeaderField;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackUtil;
import com.appoptics.ext.io.netty.util.AsciiString;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HpackStaticTable {
    private static final List<HpackHeaderField> STATIC_TABLE = Arrays.asList(HpackStaticTable.newEmptyHeaderField(":authority"), HpackStaticTable.newHeaderField(":method", "GET"), HpackStaticTable.newHeaderField(":method", "POST"), HpackStaticTable.newHeaderField(":path", "/"), HpackStaticTable.newHeaderField(":path", "/index.html"), HpackStaticTable.newHeaderField(":scheme", "http"), HpackStaticTable.newHeaderField(":scheme", "https"), HpackStaticTable.newHeaderField(":status", "200"), HpackStaticTable.newHeaderField(":status", "204"), HpackStaticTable.newHeaderField(":status", "206"), HpackStaticTable.newHeaderField(":status", "304"), HpackStaticTable.newHeaderField(":status", "400"), HpackStaticTable.newHeaderField(":status", "404"), HpackStaticTable.newHeaderField(":status", "500"), HpackStaticTable.newEmptyHeaderField("accept-charset"), HpackStaticTable.newHeaderField("accept-encoding", "gzip, deflate"), HpackStaticTable.newEmptyHeaderField("accept-language"), HpackStaticTable.newEmptyHeaderField("accept-ranges"), HpackStaticTable.newEmptyHeaderField("accept"), HpackStaticTable.newEmptyHeaderField("access-control-allow-origin"), HpackStaticTable.newEmptyHeaderField("age"), HpackStaticTable.newEmptyHeaderField("allow"), HpackStaticTable.newEmptyHeaderField("authorization"), HpackStaticTable.newEmptyHeaderField("cache-control"), HpackStaticTable.newEmptyHeaderField("content-disposition"), HpackStaticTable.newEmptyHeaderField("content-encoding"), HpackStaticTable.newEmptyHeaderField("content-language"), HpackStaticTable.newEmptyHeaderField("content-length"), HpackStaticTable.newEmptyHeaderField("content-location"), HpackStaticTable.newEmptyHeaderField("content-range"), HpackStaticTable.newEmptyHeaderField("content-type"), HpackStaticTable.newEmptyHeaderField("cookie"), HpackStaticTable.newEmptyHeaderField("date"), HpackStaticTable.newEmptyHeaderField("etag"), HpackStaticTable.newEmptyHeaderField("expect"), HpackStaticTable.newEmptyHeaderField("expires"), HpackStaticTable.newEmptyHeaderField("from"), HpackStaticTable.newEmptyHeaderField("host"), HpackStaticTable.newEmptyHeaderField("if-match"), HpackStaticTable.newEmptyHeaderField("if-modified-since"), HpackStaticTable.newEmptyHeaderField("if-none-match"), HpackStaticTable.newEmptyHeaderField("if-range"), HpackStaticTable.newEmptyHeaderField("if-unmodified-since"), HpackStaticTable.newEmptyHeaderField("last-modified"), HpackStaticTable.newEmptyHeaderField("link"), HpackStaticTable.newEmptyHeaderField("location"), HpackStaticTable.newEmptyHeaderField("max-forwards"), HpackStaticTable.newEmptyHeaderField("proxy-authenticate"), HpackStaticTable.newEmptyHeaderField("proxy-authorization"), HpackStaticTable.newEmptyHeaderField("range"), HpackStaticTable.newEmptyHeaderField("referer"), HpackStaticTable.newEmptyHeaderField("refresh"), HpackStaticTable.newEmptyHeaderField("retry-after"), HpackStaticTable.newEmptyHeaderField("server"), HpackStaticTable.newEmptyHeaderField("set-cookie"), HpackStaticTable.newEmptyHeaderField("strict-transport-security"), HpackStaticTable.newEmptyHeaderField("transfer-encoding"), HpackStaticTable.newEmptyHeaderField("user-agent"), HpackStaticTable.newEmptyHeaderField("vary"), HpackStaticTable.newEmptyHeaderField("via"), HpackStaticTable.newEmptyHeaderField("www-authenticate"));
    private static final CharSequenceMap<Integer> STATIC_INDEX_BY_NAME = HpackStaticTable.createMap();
    static final int length = STATIC_TABLE.size();

    private static HpackHeaderField newEmptyHeaderField(String string) {
        return new HpackHeaderField(AsciiString.cached(string), AsciiString.EMPTY_STRING);
    }

    private static HpackHeaderField newHeaderField(String string, String string2) {
        return new HpackHeaderField(AsciiString.cached(string), AsciiString.cached(string2));
    }

    static HpackHeaderField getEntry(int n2) {
        return STATIC_TABLE.get(n2 - 1);
    }

    static int getIndex(CharSequence object) {
        if ((object = (Integer)STATIC_INDEX_BY_NAME.get(object)) == null) {
            return -1;
        }
        return (Integer)object;
    }

    static int getIndexInsensitive(CharSequence charSequence, CharSequence charSequence2) {
        int n2 = HpackStaticTable.getIndex(charSequence);
        if (n2 == -1) {
            return -1;
        }
        while (n2 <= length) {
            HpackHeaderField hpackHeaderField = HpackStaticTable.getEntry(n2);
            if (HpackUtil.equalsVariableTime(charSequence, hpackHeaderField.name) && HpackUtil.equalsVariableTime(charSequence2, hpackHeaderField.value)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static CharSequenceMap<Integer> createMap() {
        int n2 = STATIC_TABLE.size();
        CharSequenceMap<Integer> charSequenceMap = new CharSequenceMap<Integer>(true, UnsupportedValueConverter.instance(), n2);
        while (n2 > 0) {
            Object object = HpackStaticTable.getEntry(n2);
            object = ((HpackHeaderField)object).name;
            charSequenceMap.set(object, n2);
            --n2;
        }
        return charSequenceMap;
    }
}

