/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.HpackDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersDecoder;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

public class DefaultHttp2HeadersDecoder
implements Http2HeadersDecoder,
Http2HeadersDecoder.Configuration {
    private final HpackDecoder hpackDecoder;
    private final boolean validateHeaders;
    private long maxHeaderListSizeGoAway;
    private float headerArraySizeAccumulator = 8.0f;

    public DefaultHttp2HeadersDecoder() {
        this(true);
    }

    public DefaultHttp2HeadersDecoder(boolean bl) {
        this(bl, 8192L);
    }

    public DefaultHttp2HeadersDecoder(boolean bl, long l2) {
        this(bl, l2, -1);
    }

    public DefaultHttp2HeadersDecoder(boolean bl, long l2, @Deprecated int n2) {
        this(bl, new HpackDecoder(l2));
    }

    DefaultHttp2HeadersDecoder(boolean bl, HpackDecoder hpackDecoder) {
        this.hpackDecoder = ObjectUtil.checkNotNull(hpackDecoder, "hpackDecoder");
        this.validateHeaders = bl;
        this.maxHeaderListSizeGoAway = Http2CodecUtil.calculateMaxHeaderListSizeGoAway(hpackDecoder.getMaxHeaderListSize());
    }

    public void maxHeaderTableSize(long l2) throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(l2);
    }

    public long maxHeaderTableSize() {
        return this.hpackDecoder.getMaxHeaderTableSize();
    }

    public void maxHeaderListSize(long l2, long l3) throws Http2Exception {
        if (l3 < l2 || l3 < 0L) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Header List Size GO_AWAY %d must be non-negative and >= %d", l3, l2);
        }
        this.hpackDecoder.setMaxHeaderListSize(l2);
        this.maxHeaderListSizeGoAway = l3;
    }

    public long maxHeaderListSize() {
        return this.hpackDecoder.getMaxHeaderListSize();
    }

    public long maxHeaderListSizeGoAway() {
        return this.maxHeaderListSizeGoAway;
    }

    public Http2HeadersDecoder.Configuration configuration() {
        return this;
    }

    public Http2Headers decodeHeaders(int n2, ByteBuf byteBuf) throws Http2Exception {
        try {
            Http2Headers http2Headers = this.newHeaders();
            this.hpackDecoder.decode(n2, byteBuf, http2Headers, this.validateHeaders);
            this.headerArraySizeAccumulator = 0.2f * (float)http2Headers.size() + 0.8f * this.headerArraySizeAccumulator;
            return http2Headers;
        }
        catch (Http2Exception http2Exception) {
            Http2Exception http2Exception2 = http2Exception;
            throw http2Exception;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, throwable2, throwable2.getMessage(), new Object[0]);
        }
    }

    protected final int numberOfHeadersGuess() {
        return (int)this.headerArraySizeAccumulator;
    }

    protected Http2Headers newHeaders() {
        return new DefaultHttp2Headers(this.validateHeaders, (int)this.headerArraySizeAccumulator);
    }
}

