/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.DefaultByteBufHolder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2GoAwayFrame;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;

public final class DefaultHttp2GoAwayFrame
extends DefaultByteBufHolder
implements Http2GoAwayFrame {
    private final long errorCode;
    private final int lastStreamId;
    private int extraStreamIds;

    public DefaultHttp2GoAwayFrame(long l2, ByteBuf byteBuf) {
        this(-1, l2, byteBuf);
    }

    DefaultHttp2GoAwayFrame(int n2, long l2, ByteBuf byteBuf) {
        super(byteBuf);
        this.errorCode = l2;
        this.lastStreamId = n2;
    }

    public final String name() {
        return "GOAWAY";
    }

    public final long errorCode() {
        return this.errorCode;
    }

    public final int extraStreamIds() {
        return this.extraStreamIds;
    }

    public final Http2GoAwayFrame setExtraStreamIds(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "extraStreamIds");
        this.extraStreamIds = n2;
        return this;
    }

    public final int lastStreamId() {
        return this.lastStreamId;
    }

    public final Http2GoAwayFrame retainedDuplicate() {
        return (Http2GoAwayFrame)super.retainedDuplicate();
    }

    public final Http2GoAwayFrame replace(ByteBuf byteBuf) {
        return new DefaultHttp2GoAwayFrame(this.errorCode, byteBuf).setExtraStreamIds(this.extraStreamIds);
    }

    public final Http2GoAwayFrame retain() {
        super.retain();
        return this;
    }

    public final Http2GoAwayFrame touch() {
        super.touch();
        return this;
    }

    public final Http2GoAwayFrame touch(Object object) {
        super.touch(object);
        return this;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2GoAwayFrame)) {
            return false;
        }
        object = (DefaultHttp2GoAwayFrame)object;
        return this.errorCode == ((DefaultHttp2GoAwayFrame)object).errorCode && this.extraStreamIds == ((DefaultHttp2GoAwayFrame)object).extraStreamIds && super.equals(object);
    }

    public final int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        n2 = n2 * 31 + this.extraStreamIds;
        return n2;
    }

    public final String toString() {
        return StringUtil.simpleClassName(this) + "(errorCode=" + this.errorCode + ", content=" + this.content() + ", extraStreamIds=" + this.extraStreamIds + ", lastStreamId=" + this.lastStreamId + ')';
    }
}

